/*
 * Decompiled with CFR 0.152.
 */
package org.skr.registry;

import java.util.Optional;
import lombok.NonNull;
import org.skr.SkrProperties;
import org.skr.common.exception.ErrorInfo;
import org.skr.common.exception.RegException;
import org.skr.common.util.Checker;
import org.skr.registry.IRealm;
import org.skr.registry.IRegService;
import org.skr.registry.IRegistryPack;
import org.skr.registry.StartedRealmStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRegHost<RegistryPack extends IRegistryPack>
implements IRegService<RegistryPack> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRegHost.class);
    @Autowired
    private SkrProperties properties;

    protected abstract StartedRealmStatus<RegistryPack> getRealmStatus(@NonNull String var1);

    protected abstract void setRealmStatus(@NonNull String var1, @NonNull IRealm.RealmStatus var2, String var3, RegistryPack var4);

    protected abstract void doRegister(@NonNull String var1, String var2, @NonNull RegistryPack var3);

    protected abstract void doUnregister(@NonNull String var1, RegistryPack var2);

    public void register(@NonNull String realmCode, String realmVersion, @NonNull RegistryPack registryPack) {
        if (realmCode == null) {
            throw new NullPointerException("realmCode is marked non-null but is null");
        }
        if (registryPack == null) {
            throw new NullPointerException("registryPack is marked non-null but is null");
        }
        StartedRealmStatus<RegistryPack> realmStatus = this.getRealmStatus(realmCode);
        if (realmStatus != null && realmStatus.status == IRealm.RealmStatus.STARTED) {
            if (Checker.equalsAndNotNull((Object)realmStatus.realmVersion, (Object)realmVersion) && !this.properties.isForceRegister()) {
                return;
            }
            try {
                this.doUnregister(realmCode, registryPack);
            }
            catch (Exception ex) {
                throw new RegException(ErrorInfo.UNREGISTER_REGISTRY_FAILED.msgArgs(new Object[]{realmCode, ex.getMessage()}), (Throwable)ex);
            }
        }
        try {
            this.doRegister(realmCode, realmVersion, registryPack);
        }
        catch (Exception ex) {
            log.error("[Skr] doRegister failed...{}", (Object)ex.getMessage());
            this.setRealmStatus(realmCode, IRealm.RealmStatus.ERROR, realmVersion, null);
            try {
                this.doUnregister(realmCode, registryPack);
            }
            catch (Exception exx) {
                log.error("[Skr] Release resource for doRegister() failed...{}", (Object)ex.getMessage(), (Object)exx);
            }
            throw new RegException(ErrorInfo.REGISTER_REGISTRY_FAILED.msgArgs(new Object[]{realmCode, ex.getMessage()}), (Throwable)ex);
        }
        this.setRealmStatus(realmCode, IRealm.RealmStatus.STARTED, realmVersion, registryPack);
    }

    public void unregister(@NonNull String realmCode) {
        if (realmCode == null) {
            throw new NullPointerException("realmCode is marked non-null but is null");
        }
        StartedRealmStatus<RegistryPack> realmStatus = this.getRealmStatus(realmCode);
        if (realmStatus == null || realmStatus.status != IRealm.RealmStatus.STARTED) {
            // empty if block
        }
        try {
            this.doUnregister(realmCode, Optional.ofNullable(realmStatus).map(status -> status.registryPack).orElse(null));
        }
        catch (Exception ex) {
            throw new RegException(ErrorInfo.UNREGISTER_REGISTRY_FAILED.msgArgs(new Object[]{realmCode, ex.getMessage()}), (Throwable)ex);
        }
        this.setRealmStatus(realmCode, IRealm.RealmStatus.STOPPED, null, null);
    }
}

