/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.function.Consumer;
import org.laxture.sbp.SpringBootPluginManager;
import org.laxture.sbp.internal.MainAppReadyListener;
import org.laxture.sbp.internal.MainAppStartedListener;
import org.laxture.sbp.internal.SpringBootPluginClassLoader;
import org.laxture.sbp.spring.boot.PluginManagerController;
import org.laxture.sbp.spring.boot.PropertyPluginStatusProvider;
import org.laxture.sbp.spring.boot.SbpPluginProperties;
import org.laxture.sbp.spring.boot.SbpProperties;
import org.pf4j.CompoundPluginLoader;
import org.pf4j.DefaultPluginLoader;
import org.pf4j.JarPluginLoader;
import org.pf4j.PluginClassLoader;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginLoader;
import org.pf4j.PluginManager;
import org.pf4j.PluginStateListener;
import org.pf4j.PluginStatusProvider;
import org.pf4j.RuntimeMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={PluginManager.class, SpringBootPluginManager.class})
@ConditionalOnProperty(prefix="spring.sbp", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SbpProperties.class, SbpPluginProperties.class})
@Import(value={MainAppStartedListener.class, MainAppReadyListener.class})
public class SbpAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SbpAutoConfiguration.class);
    @Autowired
    private WebMvcRegistrations mvcRegistrations;

    @Bean
    @ConditionalOnMissingBean(value={PluginStateListener.class})
    public PluginStateListener pluginStateListener() {
        return event -> {
            PluginDescriptor descriptor = event.getPlugin().getDescriptor();
            if (log.isDebugEnabled()) {
                log.debug("Plugin [{}\uff08{}\uff09]({}) {}", new Object[]{descriptor.getPluginId(), descriptor.getVersion(), descriptor.getPluginDescription(), event.getPluginState().toString()});
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={PluginManagerController.class})
    @ConditionalOnProperty(name={"spring.sbp.controller.base-path"})
    public PluginManagerController pluginManagerController() {
        return new PluginManagerController();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringBootPluginManager pluginManager(final SbpProperties properties, SbpPluginProperties pluginProperties) {
        System.setProperty("pf4j.mode", properties.getRuntimeMode().toString());
        String pluginsRoot = StringUtils.hasText((String)properties.getPluginsRoot()) ? properties.getPluginsRoot() : "plugins";
        System.setProperty("pf4j.pluginsDir", pluginsRoot);
        String appHome = System.getProperty("app.home");
        if (RuntimeMode.DEPLOYMENT == properties.getRuntimeMode() && StringUtils.hasText((String)appHome)) {
            System.setProperty("pf4j.pluginsDir", appHome + File.separator + pluginsRoot);
        }
        SpringBootPluginManager pluginManager = new SpringBootPluginManager(new File(pluginsRoot).toPath()){

            protected PluginLoader createPluginLoader() {
                return new CompoundPluginLoader().add((PluginLoader)new DefaultPluginLoader((PluginManager)this){

                    protected PluginClassLoader createPluginClassLoader(Path pluginPath, PluginDescriptor pluginDescriptor) {
                        if (properties.getClassesDirectories() != null && properties.getClassesDirectories().size() > 0) {
                            for (String classesDirectory : properties.getClassesDirectories()) {
                                this.pluginClasspath.addClassesDirectories(new String[]{classesDirectory});
                            }
                        }
                        if (properties.getLibDirectories() != null && properties.getLibDirectories().size() > 0) {
                            for (String libDirectory : properties.getLibDirectories()) {
                                this.pluginClasspath.addJarsDirectories(new String[]{libDirectory});
                            }
                        }
                        return new SpringBootPluginClassLoader(this.pluginManager, pluginDescriptor, ((Object)((Object)this)).getClass().getClassLoader());
                    }
                }).add((PluginLoader)new JarPluginLoader((PluginManager)this){

                    public ClassLoader loadPlugin(Path pluginPath, PluginDescriptor pluginDescriptor) {
                        SpringBootPluginClassLoader pluginClassLoader = new SpringBootPluginClassLoader(this.pluginManager, pluginDescriptor, ((Object)((Object)this)).getClass().getClassLoader());
                        pluginClassLoader.addFile(pluginPath.toFile());
                        return pluginClassLoader;
                    }
                });
            }

            protected PluginStatusProvider createPluginStatusProvider() {
                if (PropertyPluginStatusProvider.isPropertySet(properties)) {
                    return new PropertyPluginStatusProvider(properties);
                }
                return super.createPluginStatusProvider();
            }
        };
        pluginManager.presetProperties(this.flatProperties(pluginProperties.properties));
        pluginManager.setExactVersionAllowed(properties.isExactVersionAllowed());
        pluginManager.setSystemVersion(properties.getSystemVersion());
        pluginManager.setAutoStartPlugin(properties.isAutoStartPlugin());
        pluginManager.setProfiles(properties.getProfiles());
        return pluginManager;
    }

    private Map<String, Object> flatProperties(Map<String, Object> propertiesMap) {
        Stack pathStack = new Stack();
        HashMap<String, Object> flatMap = new HashMap<String, Object>();
        propertiesMap.entrySet().forEach(mapEntry -> this.recurse((Map.Entry<String, Object>)mapEntry, entry -> {
            pathStack.push((String)entry.getKey());
            if (entry.getValue() instanceof Map) {
                return;
            }
            flatMap.put(String.join((CharSequence)".", pathStack), entry.getValue());
        }, entry -> pathStack.pop()));
        return flatMap;
    }

    private void recurse(Map.Entry<String, Object> entry, Consumer<Map.Entry<String, Object>> preConsumer, Consumer<Map.Entry<String, Object>> postConsumer) {
        preConsumer.accept(entry);
        if (entry.getValue() instanceof Map) {
            Map entryMap = (Map)entry.getValue();
            for (Map.Entry<String, Object> entry2 : entryMap.entrySet()) {
                this.recurse(entry2, preConsumer, postConsumer);
            }
        }
        postConsumer.accept(entry);
    }
}

