/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot;

import org.laxture.sbp.spring.boot.IPluginConfigurer;
import org.laxture.sbp.spring.boot.PluginEntityManagerFactoryBeanRegister;
import org.laxture.sbp.spring.boot.PluginPersistenceManagedTypes;
import org.laxture.sbp.spring.boot.SpringBootstrap;
import org.pf4j.PluginWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class SbpJpaConfigurer
implements IPluginConfigurer {
    private final String[] modelPackages;

    public SbpJpaConfigurer(String[] modelPackages) {
        this.modelPackages = modelPackages;
    }

    public String[] excludeConfigurations() {
        return new String[]{"org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration"};
    }

    public void onBootstrap(SpringBootstrap bootstrap, GenericApplicationContext pluginApplicationContext) {
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "dataSource");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "org.laxture.sbp.spring.boot.SbpJpaAutoConfiguration");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaConfiguration");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "transactionManager");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "jpaVendorAdapter");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "persistenceManagedTypes");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "entityManagerFactoryBuilder");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "entityManagerFactory");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "openEntityManagerInViewInterceptorConfigurer");
        bootstrap.importBeanFromMainContext(pluginApplicationContext, "openEntityManagerInViewInterceptor");
        PluginPersistenceManagedTypes persistenceManagedTypes = (PluginPersistenceManagedTypes)bootstrap.getMainApplicationContext().getBean("persistenceManagedTypes");
        persistenceManagedTypes.registerPackage((ApplicationContext)pluginApplicationContext, this.modelPackages);
        LocalContainerEntityManagerFactoryBean entityManagerFactory = (LocalContainerEntityManagerFactoryBean)bootstrap.getMainApplicationContext().getBean(LocalContainerEntityManagerFactoryBean.class);
        PluginEntityManagerFactoryBeanRegister.registerClassloader(entityManagerFactory, bootstrap.getClassLoader());
        entityManagerFactory.afterPropertiesSet();
    }

    public void releaseLeaveOverResource(PluginWrapper plugin, GenericApplicationContext mainAppCtx) {
        LocalContainerEntityManagerFactoryBean entityManagerFactory = (LocalContainerEntityManagerFactoryBean)mainAppCtx.getBean(LocalContainerEntityManagerFactoryBean.class);
        PluginEntityManagerFactoryBeanRegister.unregisterClassloader(entityManagerFactory, plugin.getPluginClassLoader());
    }
}

