/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypesScanner;
import org.springframework.util.StringUtils;

public class PluginPersistenceManagedTypes
implements PersistenceManagedTypes {
    private final List<String> managedClassNames = Collections.synchronizedList(new ArrayList());
    private final List<String> managedPackages = Collections.synchronizedList(new ArrayList());

    public void registerPackage(ApplicationContext applicationContext) {
        String[] packagesToScan = PluginPersistenceManagedTypes.getPackagesToScan((BeanFactory)applicationContext);
        this.registerPackage(applicationContext, packagesToScan);
    }

    public void registerPackage(ApplicationContext applicationContext, String[] packagesToScan) {
        PersistenceManagedTypes packageTypes = new PersistenceManagedTypesScanner((ResourceLoader)applicationContext).scan(packagesToScan);
        this.managedClassNames.addAll(packageTypes.getManagedClassNames());
        this.managedPackages.addAll(packageTypes.getManagedPackages());
    }

    public void unregisterPackage(ApplicationContext applicationContext) {
        String[] packagesToScan = PluginPersistenceManagedTypes.getPackagesToScan((BeanFactory)applicationContext);
        this.unregisterPackage(applicationContext, packagesToScan);
    }

    public void unregisterPackage(ApplicationContext applicationContext, String[] packagesToScan) {
        PersistenceManagedTypes packageTypes = new PersistenceManagedTypesScanner((ResourceLoader)applicationContext).scan(packagesToScan);
        this.managedClassNames.removeAll(packageTypes.getManagedClassNames());
        this.managedPackages.removeAll(packageTypes.getManagedPackages());
    }

    private static String[] getPackagesToScan(BeanFactory beanFactory) {
        List packages = EntityScanPackages.get((BeanFactory)beanFactory).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
            packages = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public List<String> getManagedPackages() {
        return this.managedPackages;
    }

    @Nullable
    public URL getPersistenceUnitRootUrl() {
        return null;
    }
}

