/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc.agent;

import org.dbflute.optional.OptionalThing;
import org.lastaflute.doc.agent.maven.MavenVersionFinder;
import org.lastaflute.web.response.HtmlResponse;
import org.lastaflute.web.servlet.request.RequestManager;

public class SwaggerAgent {
    protected final RequestManager requestManager;

    public SwaggerAgent(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    public HtmlResponse prepareSwaggerUiResponse(String swaggerJsonUrl) {
        return this.toHtmlResponse(this.buildSwaggerUiUrl(swaggerJsonUrl));
    }

    public String buildSwaggerUiUrl(String swaggerJsonUrl) {
        String requestUrl = this.requestManager.getContextPath() + swaggerJsonUrl;
        return (String)this.findSwaggerUiVersion().map(version -> String.format("../webjars/swagger-ui/%s/index.html?validatorUrl=&url=%s", version, requestUrl)).orElseTranslatingThrow(cause -> new IllegalStateException("Not found the Swagger UI dependency in your classpath.", (Throwable)cause));
    }

    protected OptionalThing<String> findSwaggerUiVersion() {
        return this.createMavenVersionFinder().findVersion("org.webjars", "swagger-ui");
    }

    protected MavenVersionFinder createMavenVersionFinder() {
        return new MavenVersionFinder();
    }

    protected HtmlResponse toHtmlResponse(String swaggerUiUrl) {
        return HtmlResponse.fromRedirectPath((String)swaggerUiUrl);
    }
}

