/*
 * Decompiled with CFR 0.152.
 */
package org.lastaflute.doc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.lastaflute.core.json.engine.GsonJsonEngine;
import org.lastaflute.doc.generator.ActionDocumentGenerator;
import org.lastaflute.doc.generator.DocumentGeneratorFactory;
import org.lastaflute.doc.generator.JobDocumentGenerator;
import org.lastaflute.doc.meta.ActionDocMeta;
import org.lastaflute.doc.reflector.SourceParserReflector;
import org.lastaflute.doc.reflector.SourceParserReflectorFactory;

public class DocumentGenerator {
    protected static final String SRC_DIR = "src/main/java/";
    protected static final int DEPTH = 4;
    protected final List<String> srcDirList;
    protected int depth;
    protected final OptionalThing<SourceParserReflector> sourceParserReflector;
    protected boolean jobDocSuppressed;

    public DocumentGenerator() {
        this.srcDirList = DfCollectionUtil.newArrayList();
        this.srcDirList.add(SRC_DIR);
        String commonDir = "../" + new File(".").getAbsoluteFile().getParentFile().getName().replaceAll("-.*", "-common") + "/" + SRC_DIR;
        if (new File(commonDir).exists()) {
            this.srcDirList.add(commonDir);
        }
        this.depth = 4;
        this.sourceParserReflector = this.createSourceParserReflectorFactory().reflector(this.srcDirList);
    }

    public DocumentGenerator(List<String> srcDirList) {
        this.srcDirList = srcDirList;
        this.depth = 4;
        this.sourceParserReflector = this.createSourceParserReflectorFactory().reflector(srcDirList);
    }

    protected SourceParserReflectorFactory createSourceParserReflectorFactory() {
        return new SourceParserReflectorFactory();
    }

    protected DocumentGeneratorFactory createDocumentGeneratorFactory() {
        return new DocumentGeneratorFactory();
    }

    public void addSrcDir(String srcDir) {
        this.srcDirList.add(srcDir);
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public DocumentGenerator suppressJobDoc() {
        this.jobDocSuppressed = true;
        return this;
    }

    public void saveLastaDocMeta() {
        Map<String, Object> lastaDocDetailMap = this.generateLastaDocDetailMap();
        String json = this.createJsonParser().toJson(lastaDocDetailMap);
        Path path = Paths.get(this.getLastaDocDir(), "analyzed-lastadoc.json");
        Path parentPath = path.getParent();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            try {
                Files.createDirectories(parentPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory: " + parentPath, e);
            }
        }
        try (BufferedWriter bw = Files.newBufferedWriter(path, Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write the json to the file: " + path, e);
        }
    }

    protected Map<String, Object> generateLastaDocDetailMap() {
        List<ActionDocMeta> actionDocMetaList = this.createActionDocumentGenerator().generateActionDocMetaList();
        LinkedHashMap lastaDocDetailMap = DfCollectionUtil.newLinkedHashMap();
        lastaDocDetailMap.put("actionDocMetaList", actionDocMetaList);
        this.createJobDocumentGenerator().ifPresent(jobDocumentGenerator -> lastaDocDetailMap.put("jobDocMetaList", jobDocumentGenerator.generateJobDocMetaList()));
        return lastaDocDetailMap;
    }

    protected ActionDocumentGenerator createActionDocumentGenerator() {
        return this.createDocumentGeneratorFactory().createActionDocumentGenerator(this.srcDirList, this.depth, this.sourceParserReflector);
    }

    protected OptionalThing<JobDocumentGenerator> createJobDocumentGenerator() {
        if (this.jobDocSuppressed) {
            return OptionalThing.empty();
        }
        return this.createDocumentGeneratorFactory().createJobDocumentGenerator(this.srcDirList, this.depth, this.sourceParserReflector);
    }

    protected GsonJsonEngine createJsonParser() {
        return new GsonJsonEngine(builder -> builder.serializeNulls().setPrettyPrinting(), op -> {});
    }

    protected String getLastaDocDir() {
        if (new File("./pom.xml").exists()) {
            return "./target/lastadoc/";
        }
        return "./build/lastadoc/";
    }
}

