/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.List;
import lambdify.aws.client.core.http.AwsClientJsonSerializer;
import lambdify.aws.jackson.JacksonConf;

public class JacksonAwsClientJsonSerializer
implements AwsClientJsonSerializer {
    static ObjectMapper objectMapper = JacksonConf.DEFAULT_INSTANCE;

    public String serialize(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    public byte[] serializeAsBytes(Object object) {
        try {
            return objectMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    public <T> T deserialize(String string, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(string, clazz);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public <T> List<T> deserializeAsList(String string, Class<T> clazz) {
        try {
            CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)objectMapper.readValue(string, (JavaType)collectionType);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public static void objectMapper(ObjectMapper objectMapper) {
        JacksonAwsClientJsonSerializer.objectMapper = objectMapper;
    }
}

