/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core.http;

import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lambdify.aws.client.core.AwsCredentials;
import lambdify.aws.client.core.http.HttpUtils;

public class AuthorizationHeaderAWS4Signer {
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final String SCHEME = "AWS4";
    private static final String ALGORITHM = "HMAC-SHA256";
    private static final String TERMINATOR = "aws4_request";
    private static final String ISO8601BasicFormat = "yyyyMMdd'T'HHmmss'Z'";
    private final String serviceName;
    private final String regionName;
    private final SimpleDateFormat dateTimeFormat;

    public AuthorizationHeaderAWS4Signer(String string, String string2) {
        this.serviceName = string;
        this.regionName = string2;
        this.dateTimeFormat = new SimpleDateFormat(ISO8601BasicFormat);
        this.dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
    }

    public void sign(HttpUtils.HttpRequest httpRequest, AwsCredentials awsCredentials) {
        String string = this.computeSignature(httpRequest, awsCredentials);
        httpRequest.putHeader("Authorization", string);
    }

    public String computeSignature(HttpUtils.HttpRequest httpRequest, AwsCredentials awsCredentials) {
        if (awsCredentials.isTemporaryCredential()) {
            httpRequest.putHeader("x-amz-security-token", awsCredentials.getSessionKey());
        }
        String string = this.dateTimeFormat.format(new Date());
        httpRequest.putHeader("x-amz-date", string);
        String string2 = this.hashPayload(httpRequest.body);
        httpRequest.putHeader("x-amz-content-sha256", string2);
        Map<String, String> map = httpRequest.headers();
        String string3 = AuthorizationHeaderAWS4Signer.getCanonicalizeHeaderNames(httpRequest.headers());
        String string4 = AuthorizationHeaderAWS4Signer.getCanonicalizedHeaderString(map);
        String string5 = AuthorizationHeaderAWS4Signer.getCanonicalizedQueryString(httpRequest.queryParameters());
        String string6 = AuthorizationHeaderAWS4Signer.getCanonicalRequest(httpRequest.endpoint, httpRequest.method, string5, string3, string4, string2);
        String string7 = string.substring(0, 8);
        String string8 = string7 + "/" + this.regionName + "/" + this.serviceName + "/" + TERMINATOR;
        String string9 = this.getStringToSign(string, string8, string6);
        byte[] byArray = (SCHEME + awsCredentials.getSecretKey()).getBytes();
        byte[] byArray2 = this.sign(string7, byArray, "HmacSHA256");
        byte[] byArray3 = this.sign(this.regionName, byArray2, "HmacSHA256");
        byte[] byArray4 = this.sign(this.serviceName, byArray3, "HmacSHA256");
        byte[] byArray5 = this.sign(TERMINATOR, byArray4, "HmacSHA256");
        byte[] byArray6 = this.sign(string9, byArray5, "HmacSHA256");
        String string10 = "Credential=" + awsCredentials.getAccessKey() + "/" + string8;
        String string11 = "SignedHeaders=" + string3;
        String string12 = "Signature=" + this.toHex(byArray6);
        return "AWS4-HMAC-SHA256 " + string10 + ", " + string11 + ", " + string12;
    }

    protected static String getCanonicalizeHeaderNames(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(";");
            }
            stringBuilder.append(string.toLowerCase());
        }
        return stringBuilder.toString();
    }

    protected static String getCanonicalizedHeaderString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(string.toLowerCase().replaceAll("\\s+", " ") + ":" + map.get(string).replaceAll("\\s+", " "));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    protected static String getCanonicalRequest(URL uRL, String string, String string2, String string3, String string4, String string5) {
        return string + "\n" + AuthorizationHeaderAWS4Signer.getCanonicalizedResourcePath(uRL) + "\n" + string2 + "\n" + string4 + "\n" + string3 + "\n" + string5;
    }

    protected static String getCanonicalizedResourcePath(URL uRL) {
        if (uRL == null) {
            return "/";
        }
        String string = uRL.getPath();
        if (string == null || string.isEmpty()) {
            return "/";
        }
        String string2 = HttpUtils.urlEncode(string, true);
        if (string2.startsWith("/")) {
            return string2;
        }
        return "/" + string2;
    }

    public static String getCanonicalizedQueryString(Map<String, String> map) {
        Object object;
        if (map == null || map.isEmpty()) {
            return "";
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> object22 : map.entrySet()) {
            object = object22.getKey();
            String string = object22.getValue();
            treeMap.put(HttpUtils.urlEncode((String)object, false), HttpUtils.urlEncode(string, false));
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuilder.append((String)object.getKey());
            stringBuilder.append("=");
            stringBuilder.append((String)object.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private String getStringToSign(String string, String string2, String string3) {
        return "AWS4-HMAC-SHA256\n" + string + "\n" + string2 + "\n" + this.toHex(this.hash(string3));
    }

    public String hashPayload(byte[] byArray) {
        if (byArray == null) {
            return EMPTY_BODY_SHA256;
        }
        byte[] byArray2 = this.hash(byArray);
        return this.toHex(byArray2);
    }

    private byte[] hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    public byte[] hash(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to compute hash while signing request: " + exception.getMessage(), exception);
        }
    }

    private byte[] sign(String string, byte[] byArray, String string2) {
        try {
            byte[] byArray2 = string.getBytes("UTF-8");
            Mac mac = Mac.getInstance(string2);
            mac.init(new SecretKeySpec(byArray, string2));
            return mac.doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to calculate a request signature: " + exception.getMessage(), exception);
        }
    }

    private String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i]);
            if (string.length() == 1) {
                stringBuilder.append("0");
            } else if (string.length() == 8) {
                string = string.substring(6);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toLowerCase(Locale.getDefault());
    }
}

