/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core;

import java.util.ArrayList;
import java.util.List;
import lambdify.aws.client.core.AwsCredentials;
import lambdify.aws.client.core.LambdaException;

public interface AwsCredentialsProvider {
    public static final String ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY_ID";
    public static final String ALTERNATE_ACCESS_KEY_ENV_VAR = "AWS_ACCESS_KEY";
    public static final String SECRET_KEY_ENV_VAR = "AWS_SECRET_ACCESS_KEY";
    public static final String ALTERNATE_SECRET_KEY_ENV_VAR = "AWS_SECRET_ACCESS_KEY";
    public static final String SESSION_KEY_ENV_VAR = "AWS_SESSION_TOKEN";
    public static final String ACCESS_KEY_SYSTEM_PROPERTY = "aws.accessKeyId";
    public static final String SECRET_KEY_SYSTEM_PROPERTY = "aws.secretKey";
    public static final String SESSION_TOKEN_SYSTEM_PROPERTY = "aws.sessionToken";

    public AwsCredentials getCredentials();

    public static AwsCredentialsProvider environmentCredentials() {
        return new EnvironmentCredentialsProvider();
    }

    public static AwsCredentialsProvider propertiesCredentials() {
        return AwsCredentialsProvider.staticCredentials(System.getProperty(ACCESS_KEY_SYSTEM_PROPERTY), System.getProperty(SECRET_KEY_SYSTEM_PROPERTY), System.getProperty(SESSION_TOKEN_SYSTEM_PROPERTY));
    }

    public static AwsCredentialsProvider staticCredentials(String string, String string2) {
        return AwsCredentialsProvider.staticCredentials(string, string2, null);
    }

    public static AwsCredentialsProvider staticCredentials(String string, String string2, String string3) {
        return new StaticCredentialsProvider(new AwsCredentials.StaticAwsCredentials(string, string2, string3));
    }

    public static AwsCredentialsProviderChain defaultCredentialsChain() {
        return new AwsCredentialsProviderChain();
    }

    public static class AwsCredentialsProviderChain
    implements AwsCredentialsProvider {
        final List<AwsCredentialsProvider> providersLifo = new ArrayList<AwsCredentialsProvider>(){
            {
                this.add(AwsCredentialsProvider.environmentCredentials());
                this.add(AwsCredentialsProvider.propertiesCredentials());
            }
        };

        public void registerProvider(AwsCredentialsProvider awsCredentialsProvider) {
            this.providersLifo.add(0, awsCredentialsProvider);
        }

        @Override
        public AwsCredentials getCredentials() {
            for (AwsCredentialsProvider awsCredentialsProvider : this.providersLifo) {
                AwsCredentials awsCredentials = awsCredentialsProvider.getCredentials();
                if (awsCredentials == null || awsCredentials.isEmpty()) continue;
                return awsCredentials;
            }
            throw new LambdaException("No credentials defined");
        }
    }

    public static class EnvironmentCredentialsProvider
    implements AwsCredentialsProvider {
        @Override
        public AwsCredentials getCredentials() {
            String string;
            String string2 = System.getenv(AwsCredentialsProvider.ACCESS_KEY_ENV_VAR);
            if (string2 == null) {
                string2 = System.getenv(AwsCredentialsProvider.ALTERNATE_ACCESS_KEY_ENV_VAR);
            }
            if ((string = System.getenv("AWS_SECRET_ACCESS_KEY")) == null) {
                string = System.getenv("AWS_SECRET_ACCESS_KEY");
            }
            String string3 = System.getenv(AwsCredentialsProvider.SESSION_KEY_ENV_VAR);
            return new AwsCredentials.StaticAwsCredentials(EnvironmentCredentialsProvider.trim(string2), EnvironmentCredentialsProvider.trim(string), EnvironmentCredentialsProvider.trim(string3));
        }

        static String trim(String string) {
            if (string == null) {
                return null;
            }
            return string.trim();
        }
    }

    public static final class StaticCredentialsProvider
    implements AwsCredentialsProvider {
        private final AwsCredentials credentials;

        public StaticCredentialsProvider(AwsCredentials awsCredentials) {
            this.credentials = awsCredentials;
        }

        @Override
        public AwsCredentials getCredentials() {
            return this.credentials;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StaticCredentialsProvider)) {
                return false;
            }
            StaticCredentialsProvider staticCredentialsProvider = (StaticCredentialsProvider)object;
            AwsCredentials awsCredentials = this.getCredentials();
            AwsCredentials awsCredentials2 = staticCredentialsProvider.getCredentials();
            return !(awsCredentials == null ? awsCredentials2 != null : !awsCredentials.equals(awsCredentials2));
        }

        public int hashCode() {
            int n = 1;
            AwsCredentials awsCredentials = this.getCredentials();
            n = n * 59 + (awsCredentials == null ? 43 : awsCredentials.hashCode());
            return n;
        }

        public String toString() {
            return "AwsCredentialsProvider.StaticCredentialsProvider(credentials=" + this.getCredentials() + ")";
        }
    }
}

