/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core;

import java.net.MalformedURLException;
import java.net.URL;
import lambdify.aws.client.core.AwsCredentialsProvider;
import lambdify.aws.client.core.http.AuthorizationHeaderAWS4Signer;
import lambdify.aws.client.core.http.AwsClientJsonSerializer;
import lambdify.aws.client.core.http.HttpException;
import lambdify.aws.client.core.http.HttpUtils;
import lombok.NonNull;

public abstract class AmazonClient {
    @NonNull
    AwsClientJsonSerializer jsonSerializer;
    @NonNull
    AwsCredentialsProvider provider;
    @NonNull
    AuthorizationHeaderAWS4Signer signer;
    @NonNull
    String host;

    protected <T> T sendJsonRequestAndParseResponse(Class<T> clazz, HttpUtils.HttpRequest httpRequest) {
        HttpUtils.HttpResponse httpResponse = this.sendRequest(httpRequest);
        if (httpResponse.status() == 200) {
            String string = httpResponse.responseAsString();
            return this.jsonSerializer.unserialize(string, clazz);
        }
        throw new AmazonClientException(httpResponse);
    }

    protected HttpUtils.HttpResponse sendRequest(HttpUtils.HttpRequest httpRequest) {
        this.signer.sign(httpRequest, this.provider.getCredentials());
        return HttpUtils.invokeHttpRequest(httpRequest);
    }

    protected URL buildEndpoint(String string) {
        try {
            return new URL("https://" + this.host + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HttpException(malformedURLException);
        }
    }

    protected URL buildEndpoint() {
        return this.buildEndpoint("/");
    }

    @NonNull
    public AwsClientJsonSerializer getJsonSerializer() {
        return this.jsonSerializer;
    }

    @NonNull
    public AwsCredentialsProvider getProvider() {
        return this.provider;
    }

    @NonNull
    public AuthorizationHeaderAWS4Signer getSigner() {
        return this.signer;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public AmazonClient(@NonNull AwsClientJsonSerializer awsClientJsonSerializer, @NonNull AwsCredentialsProvider awsCredentialsProvider, @NonNull AuthorizationHeaderAWS4Signer authorizationHeaderAWS4Signer, @NonNull String string) {
        if (awsClientJsonSerializer == null) {
            throw new NullPointerException("jsonSerializer");
        }
        if (awsCredentialsProvider == null) {
            throw new NullPointerException("provider");
        }
        if (authorizationHeaderAWS4Signer == null) {
            throw new NullPointerException("signer");
        }
        if (string == null) {
            throw new NullPointerException("host");
        }
        this.jsonSerializer = awsClientJsonSerializer;
        this.provider = awsCredentialsProvider;
        this.signer = authorizationHeaderAWS4Signer;
        this.host = string;
    }

    public class AmazonClientException
    extends RuntimeException {
        final HttpUtils.HttpResponse response;

        public AmazonClientException(HttpUtils.HttpResponse httpResponse) {
            super("Request failure", null, true, false);
            this.response = httpResponse;
        }

        public HttpUtils.HttpResponse getResponse() {
            return this.response;
        }
    }
}

