/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lambdify.aws.client.core.http.HttpException;
import lambdify.aws.client.core.http.MapBuilder;
import lombok.NonNull;

public class HttpUtils {
    public static HttpResponse invokeHttpRequest(HttpRequest httpRequest) {
        HttpURLConnection httpURLConnection = HttpUtils.createHttpConnection(httpRequest.endpoint, httpRequest.method, httpRequest.headers);
        try {
            if (httpRequest.body != null) {
                HttpUtils.sendBody(httpURLConnection, httpRequest.body);
            }
            HttpResponse httpResponse = new HttpResponse(httpURLConnection.getResponseCode(), httpURLConnection.getHeaderFields(), HttpUtils.readResponse(httpURLConnection));
            return httpResponse;
        }
        catch (Exception exception) {
            throw new HttpException("Request failed. " + exception.getMessage(), exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private static HttpURLConnection createHttpConnection(URL uRL, String string, Map<String, String> map) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod(string);
            if (map != null) {
                for (String string2 : map.keySet()) {
                    httpURLConnection.setRequestProperty(string2, map.get(string2));
                }
            }
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            return httpURLConnection;
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create connection. " + exception.getMessage(), exception);
        }
    }

    private static void sendBody(HttpURLConnection httpURLConnection, byte[] byArray) throws IOException {
        try (OutputStream outputStream = httpURLConnection.getOutputStream();){
            outputStream.write(byArray);
            outputStream.flush();
        }
    }

    private static byte[] readResponse(HttpURLConnection httpURLConnection) throws IOException {
        InputStream inputStream;
        try {
            inputStream = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            inputStream = httpURLConnection.getErrorStream();
        }
        try {
            if (inputStream != null) {
                byte[] byArray = HttpUtils.readBytes(inputStream);
                return byArray;
            }
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static URL createUrl(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new HttpException(malformedURLException);
        }
    }

    public static String urlEncode(String string) {
        return HttpUtils.urlEncode(string, false);
    }

    public static String urlEncode(String string, boolean bl) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 encoding is not supported.", unsupportedEncodingException);
        }
        if (bl) {
            string2 = string2.replace("%2F", "/");
        }
        return string2;
    }

    public static MapBuilder<String, String> createDefaultAwsHeaders() {
        return MapBuilder.mapOf(String.class).put("content-type", "application/json");
    }

    public static class HttpRequest {
        @NonNull
        Map<String, String> headers = new HashMap<String, String>();
        @NonNull
        URL endpoint;
        @NonNull
        String method;
        @NonNull
        byte[] body;

        public HttpRequest putHeader(String string, String string2) {
            this.headers.put(string.toLowerCase(), string2);
            return this;
        }

        public String host() {
            return this.headers.computeIfAbsent("host", string -> this.computeHost());
        }

        public Map<String, String> headers() {
            this.host();
            return this.headers;
        }

        public HttpRequest body(byte[] byArray) {
            this.body = byArray;
            return this;
        }

        public HttpRequest body(String string) {
            try {
                this.body = string.getBytes("UTF-8");
                return this;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }

        public Map<String, String> queryParameters() {
            String string = this.endpoint.getQuery();
            if (string == null || string.isEmpty()) {
                return Collections.emptyMap();
            }
            String[] stringArray = string.split("&");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
            }
            return hashMap;
        }

        private String computeHost() {
            String string = this.endpoint.getHost();
            int n = this.endpoint.getPort();
            if (n == -1) {
                return string;
            }
            return String.format("%s:%d", string, n);
        }

        public static HttpRequest create(String string, String string2) {
            return new HttpRequest().endpoint(HttpUtils.createUrl(string2)).method(string);
        }

        @NonNull
        public URL endpoint() {
            return this.endpoint;
        }

        @NonNull
        public String method() {
            return this.method;
        }

        @NonNull
        public byte[] body() {
            return this.body;
        }

        public HttpRequest headers(@NonNull Map<String, String> map) {
            if (map == null) {
                throw new NullPointerException("headers");
            }
            this.headers = map;
            return this;
        }

        public HttpRequest endpoint(@NonNull URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("endpoint");
            }
            this.endpoint = uRL;
            return this;
        }

        public HttpRequest method(@NonNull String string) {
            if (string == null) {
                throw new NullPointerException("method");
            }
            this.method = string;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof HttpRequest)) {
                return false;
            }
            HttpRequest httpRequest = (HttpRequest)object;
            if (!httpRequest.canEqual(this)) {
                return false;
            }
            Map<String, String> map = this.headers();
            Map<String, String> map2 = httpRequest.headers();
            if (map == null ? map2 != null : !((Object)map).equals(map2)) {
                return false;
            }
            URL uRL = this.endpoint();
            URL uRL2 = httpRequest.endpoint();
            if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
                return false;
            }
            String string = this.method();
            String string2 = httpRequest.method();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            return Arrays.equals(this.body(), httpRequest.body());
        }

        protected boolean canEqual(Object object) {
            return object instanceof HttpRequest;
        }

        public int hashCode() {
            int n = 1;
            Map<String, String> map = this.headers();
            n = n * 59 + (map == null ? 43 : ((Object)map).hashCode());
            URL uRL = this.endpoint();
            n = n * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
            String string = this.method();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            n = n * 59 + Arrays.hashCode(this.body());
            return n;
        }

        public String toString() {
            return "HttpUtils.HttpRequest(headers=" + this.headers() + ", endpoint=" + this.endpoint() + ", method=" + this.method() + ", body=" + Arrays.toString(this.body()) + ")";
        }

        public HttpRequest() {
            this.headers.put("Accept", "application/json");
        }
    }

    public static final class HttpResponse {
        private final int status;
        private final Map<String, List<String>> headers;
        private final byte[] response;

        public String responseAsString() {
            try {
                return new String(this.response, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException(unsupportedEncodingException);
            }
        }

        public Map<String, String> flatHeaders() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.headers.forEach((string, list) -> {
                String cfr_ignored_0 = (String)hashMap.put((String)string, (String)list.get(0));
            });
            return hashMap;
        }

        public HttpResponse(int n, Map<String, List<String>> map, byte[] byArray) {
            this.status = n;
            this.headers = map;
            this.response = byArray;
        }

        public int status() {
            return this.status;
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public byte[] response() {
            return this.response;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof HttpResponse)) {
                return false;
            }
            HttpResponse httpResponse = (HttpResponse)object;
            if (this.status() != httpResponse.status()) {
                return false;
            }
            Map<String, List<String>> map = this.headers();
            Map<String, List<String>> map2 = httpResponse.headers();
            if (map == null ? map2 != null : !((Object)map).equals(map2)) {
                return false;
            }
            return Arrays.equals(this.response(), httpResponse.response());
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.status();
            Map<String, List<String>> map = this.headers();
            n = n * 59 + (map == null ? 43 : ((Object)map).hashCode());
            n = n * 59 + Arrays.hashCode(this.response());
            return n;
        }

        public String toString() {
            return "HttpUtils.HttpResponse(status=" + this.status() + ", headers=" + this.headers() + ", response=" + Arrays.toString(this.response()) + ")";
        }
    }

    public static interface Methods {
        public static final String POST = "POST";
        public static final String GET = "GET";
        public static final String PUT = "PUT";
        public static final String DELETE = "DELETE";
    }
}

