/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core;

import lambdify.aws.client.core.AwsCredentialsProvider;
import lambdify.aws.client.core.http.AuthorizationHeaderAWS4Signer;
import lambdify.aws.client.core.http.AwsClientJsonSerializer;
import lombok.NonNull;

public abstract class AmazonClientBuilder<BUILDER extends AmazonClientBuilder, CLIENT> {
    @NonNull
    private AwsClientJsonSerializer jsonSerializer = this.getJsonSerializer();
    @NonNull
    private String region = "us-east-1";
    @NonNull
    private AwsCredentialsProvider credentialsProvider = AwsCredentialsProvider.defaultCredentialsChain();
    @NonNull
    private String service;

    private AwsClientJsonSerializer getJsonSerializer() {
        if (this.jsonSerializer == null) {
            this.jsonSerializer = AwsClientJsonSerializer.DEFAULT;
        }
        return this.jsonSerializer;
    }

    public CLIENT build() {
        AuthorizationHeaderAWS4Signer authorizationHeaderAWS4Signer = new AuthorizationHeaderAWS4Signer(this.getService(), this.getRegion());
        return this.buildClient(this.getJsonSerializer(), this.getCredentialsProvider(), authorizationHeaderAWS4Signer, this.getHost());
    }

    protected String getHost() {
        return this.getService() + "." + this.getRegion() + ".amazonaws.com";
    }

    protected abstract CLIENT buildClient(AwsClientJsonSerializer var1, AwsCredentialsProvider var2, AuthorizationHeaderAWS4Signer var3, String var4);

    private BUILDER getBuilder() {
        return (BUILDER)this;
    }

    public BUILDER setJsonSerializer(AwsClientJsonSerializer awsClientJsonSerializer) {
        this.jsonSerializer = awsClientJsonSerializer;
        return this.getBuilder();
    }

    public String getRegion() {
        return this.region;
    }

    public BUILDER setRegion(String string) {
        this.region = string;
        return this.getBuilder();
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public BUILDER setCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
        this.credentialsProvider = awsCredentialsProvider;
        return this.getBuilder();
    }

    public String getService() {
        return this.service;
    }

    public BUILDER setService(String string) {
        this.service = string;
        return this.getBuilder();
    }
}

