/*
 * Decompiled with CFR 0.152.
 */
package lambdify.aws.client.core;

public interface AwsCredentials {
    public String getAccessKey();

    public String getSecretKey();

    public String getSessionKey();

    default public boolean isTemporaryCredential() {
        String string = this.getSessionKey();
        return string != null && !string.isEmpty();
    }

    default public boolean isEmpty() {
        return this.getAccessKey() == null || this.getAccessKey().isEmpty() || this.getSecretKey() == null || this.getSecretKey().isEmpty();
    }

    public static final class StaticAwsCredentials
    implements AwsCredentials {
        private final String accessKey;
        private final String secretKey;
        private final String sessionKey;

        public StaticAwsCredentials(String string, String string2, String string3) {
            this.accessKey = string;
            this.secretKey = string2;
            this.sessionKey = string3;
        }

        @Override
        public String getAccessKey() {
            return this.accessKey;
        }

        @Override
        public String getSecretKey() {
            return this.secretKey;
        }

        @Override
        public String getSessionKey() {
            return this.sessionKey;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof StaticAwsCredentials)) {
                return false;
            }
            StaticAwsCredentials staticAwsCredentials = (StaticAwsCredentials)object;
            String string = this.getAccessKey();
            String string2 = staticAwsCredentials.getAccessKey();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getSecretKey();
            String string4 = staticAwsCredentials.getSecretKey();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getSessionKey();
            String string6 = staticAwsCredentials.getSessionKey();
            return !(string5 == null ? string6 != null : !string5.equals(string6));
        }

        public int hashCode() {
            int n = 1;
            String string = this.getAccessKey();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getSecretKey();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getSessionKey();
            n = n * 59 + (string3 == null ? 43 : string3.hashCode());
            return n;
        }

        public String toString() {
            return "AwsCredentials.StaticAwsCredentials(accessKey=" + this.getAccessKey() + ", secretKey=" + this.getSecretKey() + ", sessionKey=" + this.getSessionKey() + ")";
        }
    }
}

