/*
 * Decompiled with CFR 0.152.
 */
package lambdify.apigateway.apt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lambdify.apigateway.ann.Body;
import lambdify.apigateway.ann.ContentType;
import lambdify.apigateway.ann.Context;
import lambdify.apigateway.ann.HeaderParam;
import lambdify.apigateway.ann.PathParam;
import lambdify.apigateway.ann.QueryParam;
import lambdify.apigateway.ann.Route;
import lambdify.aws.events.apigateway.ProxyRequestEvent;
import lambdify.aws.events.apigateway.ProxyResponseEvent;

public interface Generated {
    public static final AtomicInteger methodCounter = new AtomicInteger(0);

    public static String stringify(Iterable<?> iterable) {
        return Generated.stringify(iterable, ", ");
    }

    public static String stringify(Iterable<?> iterable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object obj : iterable) {
            arrayList.add(obj.toString());
        }
        return String.join((CharSequence)string, arrayList);
    }

    public static final class DefinedRoute {
        private final Object url;
        private final Object method;

        public DefinedRoute(Object object, Object object2) {
            this.url = object;
            this.method = object2;
        }

        public Object getUrl() {
            return this.url;
        }

        public Object getMethod() {
            return this.method;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DefinedRoute)) {
                return false;
            }
            DefinedRoute definedRoute = (DefinedRoute)object;
            Object object2 = this.getUrl();
            Object object3 = definedRoute.getUrl();
            if (object2 == null ? object3 != null : !object2.equals(object3)) {
                return false;
            }
            Object object4 = this.getMethod();
            Object object5 = definedRoute.getMethod();
            return !(object4 == null ? object5 != null : !object4.equals(object5));
        }

        public int hashCode() {
            int n = 1;
            Object object = this.getUrl();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            Object object2 = this.getMethod();
            n = n * 59 + (object2 == null ? 43 : object2.hashCode());
            return n;
        }

        public String toString() {
            return "Generated.DefinedRoute(url=" + this.getUrl() + ", method=" + this.getMethod() + ")";
        }
    }

    public static final class MustacheWrapper {
        private final boolean first;
        private final Object data;

        public MustacheWrapper(boolean bl, Object object) {
            this.first = bl;
            this.data = object;
        }

        public boolean isFirst() {
            return this.first;
        }

        public Object getData() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MustacheWrapper)) {
                return false;
            }
            MustacheWrapper mustacheWrapper = (MustacheWrapper)object;
            if (this.isFirst() != mustacheWrapper.isFirst()) {
                return false;
            }
            Object object2 = this.getData();
            Object object3 = mustacheWrapper.getData();
            return !(object2 == null ? object3 != null : !object2.equals(object3));
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + (this.isFirst() ? 79 : 97);
            Object object = this.getData();
            n = n * 59 + (object == null ? 43 : object.hashCode());
            return n;
        }

        public String toString() {
            return "Generated.MustacheWrapper(first=" + this.isFirst() + ", data=" + this.getData() + ")";
        }
    }

    public static class MustacheIterable
    implements Iterable<MustacheWrapper>,
    Iterator<MustacheWrapper> {
        final List<?> data;
        int cursor = 0;

        @Override
        public Iterator<MustacheWrapper> iterator() {
            this.cursor = 0;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.data.size();
        }

        @Override
        public MustacheWrapper next() {
            return new MustacheWrapper(this.cursor == 0, this.data.get(this.cursor++));
        }

        public MustacheIterable(List<?> list) {
            this.data = list;
        }

        public List<?> getData() {
            return this.data;
        }

        public int getCursor() {
            return this.cursor;
        }

        public MustacheIterable setCursor(int n) {
            this.cursor = n;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof MustacheIterable)) {
                return false;
            }
            MustacheIterable mustacheIterable = (MustacheIterable)object;
            if (!mustacheIterable.canEqual(this)) {
                return false;
            }
            List<?> list = this.getData();
            List<?> list2 = mustacheIterable.getData();
            if (list == null ? list2 != null : !((Object)list).equals(list2)) {
                return false;
            }
            return this.getCursor() == mustacheIterable.getCursor();
        }

        protected boolean canEqual(Object object) {
            return object instanceof MustacheIterable;
        }

        public int hashCode() {
            int n = 1;
            List<?> list = this.getData();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            n = n * 59 + this.getCursor();
            return n;
        }

        public String toString() {
            return "Generated.MustacheIterable(data=" + this.getData() + ", cursor=" + this.getCursor() + ")";
        }
    }

    public static class Annotation {
        Element parent;
        String type;
        Map<String, Object> parameters = new HashMap<String, Object>();

        public Object getValue() {
            return this.parameters.get("value");
        }

        public String toString() {
            return "@" + this.type + "(" + Generated.stringify(this.parameters.entrySet()) + ")";
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Annotation)) {
                return false;
            }
            Annotation annotation = (Annotation)object;
            if (!annotation.canEqual(this)) {
                return false;
            }
            String string = this.getType();
            String string2 = annotation.getType();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            Map<String, Object> map = this.getParameters();
            Map<String, Object> map2 = annotation.getParameters();
            return !(map == null ? map2 != null : !((Object)map).equals(map2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Annotation;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getType();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            Map<String, Object> map = this.getParameters();
            n = n * 59 + (map == null ? 43 : ((Object)map).hashCode());
            return n;
        }

        public Element getParent() {
            return this.parent;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public Annotation setParent(Element element) {
            this.parent = element;
            return this;
        }

        public Annotation setType(String string) {
            this.type = string;
            return this;
        }

        public Annotation setParameters(Map<String, Object> map) {
            this.parameters = map;
            return this;
        }
    }

    public static class Element {
        String name;
        String type;
        String contextualProducer;
        List<Annotation> annotations = new ArrayList<Annotation>();

        public Annotation getPathParameter() {
            return this.getAnnotation(PathParam.class);
        }

        public Annotation getQueryParameter() {
            return this.getAnnotation(QueryParam.class);
        }

        public Annotation getHeaderParameter() {
            return this.getAnnotation(HeaderParam.class);
        }

        public Annotation getContext() {
            return this.getAnnotation(Context.class);
        }

        public boolean getBodyParameter() {
            return !this.isAPIGatewayRequest() && (this.annotations.isEmpty() || this.getAnnotation(Body.class) != null);
        }

        public boolean isAPIGatewayRequest() {
            return ProxyRequestEvent.class.getCanonicalName().equals(this.type);
        }

        protected Annotation getAnnotation(Class<?> clazz) {
            for (Annotation annotation : this.annotations) {
                if (!clazz.getCanonicalName().equals(annotation.type)) continue;
                return annotation;
            }
            return null;
        }

        public String toString() {
            return Generated.stringify(this.annotations) + " " + this.type + " " + this.name;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getContextualProducer() {
            return this.contextualProducer;
        }

        public List<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Element setName(String string) {
            this.name = string;
            return this;
        }

        public Element setType(String string) {
            this.type = string;
            return this;
        }

        public Element setContextualProducer(String string) {
            this.contextualProducer = string;
            return this;
        }

        public Element setAnnotations(List<Annotation> list) {
            this.annotations = list;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Element)) {
                return false;
            }
            Element element = (Element)object;
            if (!element.canEqual(this)) {
                return false;
            }
            String string = this.getName();
            String string2 = element.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getType();
            String string4 = element.getType();
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                return false;
            }
            String string5 = this.getContextualProducer();
            String string6 = element.getContextualProducer();
            if (string5 == null ? string6 != null : !string5.equals(string6)) {
                return false;
            }
            List<Annotation> list = this.getAnnotations();
            List<Annotation> list2 = element.getAnnotations();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Element;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getType();
            n = n * 59 + (string2 == null ? 43 : string2.hashCode());
            String string3 = this.getContextualProducer();
            n = n * 59 + (string3 == null ? 43 : string3.hashCode());
            List<Annotation> list = this.getAnnotations();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }
    }

    public static class Method
    extends Element {
        final int counter = methodCounter.getAndIncrement();
        boolean constructor;
        List<Element> parameters = new ArrayList<Element>();

        public DefinedRoute getRoute() {
            Annotation annotation = this.getAnnotation(Route.class);
            if (annotation == null) {
                return null;
            }
            Map<String, Object> map = annotation.getParameters();
            return new DefinedRoute(map.get("url"), map.get("method"));
        }

        public String getContentType() {
            Annotation annotation = this.getAnnotation(ContentType.class);
            if (annotation != null) {
                return String.valueOf(annotation.getValue());
            }
            return "\"\"";
        }

        public boolean isVoidMethod() {
            return "void".equals(this.type);
        }

        public boolean isReturnsResponse() {
            return ProxyResponseEvent.class.getCanonicalName().equals(this.type);
        }

        public MustacheIterable getParameterIterable() {
            return new MustacheIterable(this.parameters);
        }

        public String getParameterList() {
            return Generated.stringify(this.parameters.stream().map(element -> element.type + " " + element.name).collect(Collectors.toList()));
        }

        public String getArgumentList() {
            return Generated.stringify(this.parameters.stream().map(Element::getName).collect(Collectors.toList()));
        }

        @Override
        public String toString() {
            return Generated.stringify(this.annotations, "\n") + "\n" + this.type + " " + this.name + "(" + Generated.stringify(this.parameters, "\n") + ")";
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Method)) {
                return false;
            }
            Method method = (Method)object;
            if (!method.canEqual(this)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            if (this.getCounter() != method.getCounter()) {
                return false;
            }
            if (this.isConstructor() != method.isConstructor()) {
                return false;
            }
            List<Element> list = this.getParameters();
            List<Element> list2 = method.getParameters();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        @Override
        protected boolean canEqual(Object object) {
            return object instanceof Method;
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            n = n * 59 + this.getCounter();
            n = n * 59 + (this.isConstructor() ? 79 : 97);
            List<Element> list = this.getParameters();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }

        public int getCounter() {
            return this.counter;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public List<Element> getParameters() {
            return this.parameters;
        }

        public Method setConstructor(boolean bl) {
            this.constructor = bl;
            return this;
        }

        public Method setParameters(List<Element> list) {
            this.parameters = list;
            return this;
        }
    }

    public static class Type {
        String canonicalName;
        List<Method> methods = new ArrayList<Method>();

        public String getPackageName() {
            return this.canonicalName.replaceAll("(\\.[A-Z].*)", "");
        }

        public String getSimpleName() {
            return this.canonicalName.replaceAll(".*\\.([^.]+)$", "$1");
        }

        public String getGeneratedSimpleName() {
            return this.getSimpleName() + "LambdaRouter";
        }

        public MustacheIterable getMethodsIterable() {
            return new MustacheIterable(this.methods.subList(1, this.methods.size()));
        }

        public String toString() {
            return "class " + this.canonicalName + "{\n\n" + Generated.stringify(this.methods, "\n\n") + "\n\n}";
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public List<Method> getMethods() {
            return this.methods;
        }

        public Type setCanonicalName(String string) {
            this.canonicalName = string;
            return this;
        }

        public Type setMethods(List<Method> list) {
            this.methods = list;
            return this;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Type)) {
                return false;
            }
            Type type = (Type)object;
            if (!type.canEqual(this)) {
                return false;
            }
            String string = this.getCanonicalName();
            String string2 = type.getCanonicalName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            List<Method> list = this.getMethods();
            List<Method> list2 = type.getMethods();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Type;
        }

        public int hashCode() {
            int n = 1;
            String string = this.getCanonicalName();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            List<Method> list = this.getMethods();
            n = n * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n;
        }
    }
}

