/*
 * Decompiled with CFR 0.152.
 */
package lambdify.apigateway.apt;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import lambdify.apigateway.apt.APT;
import lambdify.aws.events.apigateway.ProxyRequestEvent;

public class ContextualProducersParser {
    static final Function<String, String> FAIL = string -> {
        throw new IllegalArgumentException("No producer defined for type " + string);
    };
    static final String REQ_CANONICAL_NAME = ProxyRequestEvent.class.getCanonicalName();
    static final String MSG_INVALID_ARG = "Invalid %s method. Methods annotated with @Context should be static and should have a single parameter of type " + REQ_CANONICAL_NAME;
    final Map<String, String> producerCanonicalMethodName = new HashMap<String, String>();

    void memorizeMethod(ExecutableElement executableElement) {
        String string = executableElement.getSimpleName().toString();
        boolean bl = executableElement.getModifiers().contains((Object)Modifier.STATIC);
        List<? extends VariableElement> list = executableElement.getParameters();
        String string2 = APT.getCanonicalName(list.get(0));
        if (!bl || list.size() > 1 || !REQ_CANONICAL_NAME.equals(string2)) {
            throw new IllegalArgumentException(String.format(MSG_INVALID_ARG, string));
        }
        String string3 = APT.getCanonicalName(executableElement.getEnclosingElement());
        String string4 = string3 + "." + string;
        String string5 = APT.getCanonicalName(executableElement.getReturnType().toString());
        this.producerCanonicalMethodName.put(string5, string4);
    }

    String getProducerFor(String string) {
        return this.producerCanonicalMethodName.computeIfAbsent(string, FAIL);
    }
}

