/*
 * Decompiled with CFR 0.152.
 */
package lambdify.apigateway.apt;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import lambdify.apigateway.ann.Route;
import lambdify.apigateway.apt.ClassParser;
import lambdify.apigateway.apt.Generated;

@SupportedAnnotationTypes(value={"lambdify.apigateway.ann.*"})
public class RouteProcessor
extends AbstractProcessor {
    static final String TEMPLATE_FILE = "META-INF/generated-class.mustache";
    final ClassParser classParser = new ClassParser();
    final MustacheFactory mustacheFactory = new DefaultMustacheFactory();
    final String content;

    public RouteProcessor() {
        try {
            this.content = this.readTemplate();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalStateException("Failed to read template: " + throwable.getMessage(), throwable);
        }
    }

    private String readTemplate() throws IOException, URISyntaxException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("/META-INF/generated-class.mustache");
        if (uRL == null) {
            uRL = classLoader.getResource(TEMPLATE_FILE);
        }
        if (uRL == null) {
            throw new FileNotFoundException("Could not find META-INF/generated-class.mustache");
        }
        try (InputStream inputStream = uRL.openStream();){
            String string = RouteProcessor.convertStreamToString(inputStream);
            return string;
        }
    }

    private static String convertStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(Route.class);
        if (!set2.isEmpty()) {
            for (Element element : set2) {
                this.classParser.memorizeMethod((ExecutableElement)element);
            }
            this.generateClasses();
        }
        return true;
    }

    private void generateClasses() {
        Filer filer = this.processingEnv.getFiler();
        Collection<Generated.Type> collection = this.classParser.getTypes();
        for (Generated.Type type : collection) {
            try {
                String string = type.getPackageName() + "." + type.getGeneratedSimpleName();
                JavaFileObject javaFileObject = filer.createSourceFile(string, new Element[0]);
                Writer writer = javaFileObject.openWriter();
                Throwable throwable = null;
                try {
                    this.generateClass(type, writer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    private void generateClass(Generated.Type type, Writer writer) throws IOException {
        Mustache mustache = this.mustacheFactory.compile((Reader)new StringReader(this.content), "generated.class");
        mustache.execute(writer, (Object)type);
        writer.flush();
    }
}

