/*
 * Decompiled with CFR 0.152.
 */
package lambdify.apigateway.apt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import lambdify.apigateway.apt.Generated;

public class ClassParser {
    Map<String, Generated.Type> cachedTypes = new HashMap<String, Generated.Type>();

    Collection<Generated.Type> getTypes() {
        ArrayList<Generated.Type> arrayList = new ArrayList<Generated.Type>(this.cachedTypes.values());
        this.cachedTypes = new HashMap<String, Generated.Type>();
        return arrayList;
    }

    void memorizeMethod(ExecutableElement executableElement) {
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        Generated.Type type = this.cachedTypes.computeIfAbsent(typeElement.asType().toString(), string -> this.createTypeFrom((String)string, typeElement));
        type.methods.add(this.createMethod(executableElement));
    }

    private Generated.Type createTypeFrom(String string, TypeElement typeElement) {
        List<? extends Element> list = typeElement.getEnclosedElements();
        Generated.Type type = new Generated.Type().setCanonicalName(string).setMethods(new ArrayList<Generated.Method>());
        for (Element element : list) {
            if (!ElementKind.CONSTRUCTOR.equals((Object)element.getKind())) continue;
            type.methods.add(this.createMethod((ExecutableElement)element));
        }
        return type;
    }

    private Generated.Method createMethod(ExecutableElement executableElement) {
        List<? extends VariableElement> list = executableElement.getParameters();
        ArrayList<Generated.Element> arrayList = new ArrayList<Generated.Element>();
        for (VariableElement object2 : list) {
            arrayList.add(this.createParameter(object2));
        }
        String string = executableElement.getSimpleName().toString();
        Generated.Method method = (Generated.Method)new Generated.Method().setConstructor("<init>".equals(string)).setParameters(arrayList).setType(executableElement.getReturnType().toString()).setName(string);
        return (Generated.Method)method.setAnnotations(this.loadAnnotations(executableElement, method));
    }

    private Generated.Element createParameter(VariableElement variableElement) {
        Generated.Element element = new Generated.Element().setName(variableElement.getSimpleName().toString()).setType(ClassParser.getCanonicalName(variableElement));
        return element.setAnnotations(this.loadAnnotations(variableElement, element));
    }

    private List<Generated.Annotation> loadAnnotations(Element element, Generated.Element element2) {
        ArrayList<Generated.Annotation> arrayList = new ArrayList<Generated.Annotation>();
        List<? extends AnnotationMirror> list = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : list) {
            arrayList.add(this.createAnnotation(annotationMirror).setParent(element2));
        }
        return arrayList;
    }

    private Generated.Annotation createAnnotation(AnnotationMirror annotationMirror) {
        String string = annotationMirror.getAnnotationType().asElement().asType().toString();
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
            hashMap.put(entry.getKey().getSimpleName().toString(), entry.getValue().toString());
        }
        return new Generated.Annotation().setParameters(hashMap).setType(string);
    }

    static String getCanonicalName(Element element) {
        String string = element.asType().toString();
        return ClassParser.getCanonicalName(string);
    }

    static String getCanonicalName(String string) {
        return string.replaceAll("<.*", "");
    }
}

