/*
 * Decompiled with CFR 0.152.
 */
package org.labun.springframework.data.repository.events;

import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.labun.springframework.data.repository.events.EntityInformationProvider;
import org.labun.springframework.data.repository.events.event.AfterCreateEvent;
import org.labun.springframework.data.repository.events.event.AfterUpdateEvent;
import org.labun.springframework.data.repository.events.event.BeforeCreateEvent;
import org.labun.springframework.data.repository.events.event.BeforeUpdateEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class CrudRepositoryOnSaveAspect {
    private final ApplicationEventPublisher eventPublisher;
    private final EntityInformationProvider entityInformationProvider;

    @Autowired
    public CrudRepositoryOnSaveAspect(ApplicationEventPublisher eventPublisher, EntityInformationProvider entityInformationProvider) {
        this.eventPublisher = eventPublisher;
        this.entityInformationProvider = entityInformationProvider;
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.save(..))&& !execution(* org.springframework.data.repository.CrudRepository.save(Iterable))")
    public void saveOne() {
    }

    @Around(value="saveOne() && args(entity) && target(target)")
    public Object onSave(CrudRepository target, Object entity) {
        return this.saveEntity(target, entity);
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.save(Iterable))")
    public void saveIterable() {
    }

    @Around(value="saveIterable() && args(iterable) && target(target)")
    public Iterable<Object> onSave(CrudRepository target, Iterable iterable) {
        return this.saveEntities(target, iterable);
    }

    private Iterable<Object> saveEntities(CrudRepository target, Iterable<?> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).map(entity -> this.saveEntity(target, entity)).collect(Collectors.toList());
    }

    private Object saveEntity(CrudRepository target, Object entity) {
        EntityInformation entityInformation = this.entityInformationProvider.getEntityInformationFor(entity.getClass());
        return entityInformation.isNew(entity) ? this.createEntity(target, entity) : this.updateEntity(target, entity);
    }

    private Object updateEntity(CrudRepository repository, Object entity) {
        this.eventPublisher.publishEvent((ApplicationEvent)new BeforeUpdateEvent(entity));
        Object result = repository.save(entity);
        this.eventPublisher.publishEvent((ApplicationEvent)new AfterUpdateEvent(entity));
        return result;
    }

    private Object createEntity(CrudRepository repository, Object entity) {
        this.eventPublisher.publishEvent((ApplicationEvent)new BeforeCreateEvent(entity));
        Object result = repository.save(entity);
        this.eventPublisher.publishEvent((ApplicationEvent)new AfterCreateEvent(entity));
        return result;
    }
}

