/*
 * Decompiled with CFR 0.152.
 */
package org.labun.springframework.data.repository.events;

import java.io.Serializable;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.labun.springframework.data.repository.events.event.AfterDeleteEvent;
import org.labun.springframework.data.repository.events.event.BeforeDeleteEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class CrudRepositoryOnDeleteAspect {
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    public CrudRepositoryOnDeleteAspect(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.delete(..))&& !execution(* org.springframework.data.repository.CrudRepository.delete(java.io.Serializable))&& !execution(* org.springframework.data.repository.CrudRepository.delete(Iterable))")
    public void deleteOne() {
    }

    @Around(value="deleteOne() && args(entity) && target(target)")
    public void onDeleteOne(CrudRepository target, Object entity) {
        if (entity == null) {
            return;
        }
        this.deleteEntity(target, entity);
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.delete(Iterable))")
    public void deleteIterable() {
    }

    @Around(value="deleteIterable() && args(iterable) && target(target)")
    public void onDeleteIterable(CrudRepository target, Iterable iterable) {
        if (iterable == null) {
            return;
        }
        this.deleteEntities(target, iterable);
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.delete(java.io.Serializable))")
    public void deleteOneById() {
    }

    @Around(value="deleteOneById() && args(id) && target(target)")
    public void onDeleteOneById(CrudRepository target, Serializable id) {
        if (id == null) {
            return;
        }
        this.deleteById(target, id);
    }

    @Pointcut(value="execution(* org.springframework.data.repository.CrudRepository.deleteAll())")
    public void deleteAll() {
    }

    @Around(value="deleteAll() && target(target)")
    public void onDeleteAll(CrudRepository target) {
        target.findAll().forEach(it -> this.deleteEntity(target, it));
    }

    private void deleteById(CrudRepository target, Serializable id) {
        Object entity = target.findOne(id);
        if (entity == null) {
            return;
        }
        this.deleteEntity(target, entity);
    }

    private void deleteEntities(CrudRepository target, Iterable<?> iterable) {
        iterable.forEach(entity -> this.deleteEntity(target, entity));
    }

    private void deleteEntity(CrudRepository target, Object entity) {
        this.eventPublisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(entity));
        target.delete(entity);
        this.eventPublisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(entity));
    }
}

