/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package [=javaPackageBase].it;

import java.net.URI;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

[#if nativeSupported ]
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
[#else]
import org.apache.camel.CamelContext;
[/#if]
import org.jboss.logging.Logger;

@Path("/[=artifactIdBase]")
@ApplicationScoped
public class [=toCapCamelCase(artifactIdBase)]Resource {

    private static final Logger LOG = Logger.getLogger([=toCapCamelCase(artifactIdBase)]Resource.class);

[#if nativeSupported ]
    @Inject
    ProducerTemplate producerTemplate;

    @Inject
    ConsumerTemplate consumerTemplate;

    @Path("/get")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public String get() throws Exception {
        final String message = consumerTemplate.receiveBodyNoWait("[=artifactIdBase]:--fix-me--", String.class);
        LOG.infof("Received from [=artifactIdBase]: %s", message);
        return message;
    }

    @Path("/post")
    @POST
    @Consumes(MediaType.TEXT_PLAIN)
    @Produces(MediaType.TEXT_PLAIN)
    public Response post(String message) throws Exception {
        LOG.infof("Sending to [=artifactIdBase]: %s", message);
        final String response = producerTemplate.requestBody("[=artifactIdBase]:--fix-me--", message, String.class);
        LOG.infof("Got response from [=artifactIdBase]: %s", response);
        return Response
                .created(new URI("https://camel.apache.org/"))
                .entity(response)
                .build();
    }
[#else]
[#list models as m]
    private static final String [=toSnakeCase(m.kind)?upper_case]_[=toSnakeCase(m.name)?upper_case] = "[=m.name]";
[/#list]
    @Inject
    CamelContext context;

[#list models as model]
    @Path("/load/[=model.kind]/[=model.name]")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response load[=toCapCamelCase(model.kind)][=toCapCamelCase(model.name)]() throws Exception {
        /* This is an autogenerated test */
[#if kind == "other" ]
        /* No way to test a Camel artifact of kind "other" */
        return Response.ok().build();
[#else]
[#if kind == "component" ]
[#assign contextMethod = "getComponent"]
[#elseif kind == "language" ]
[#assign contextMethod = "resolveLanguage"]
[#elseif kind == "dataformat" ]
[#assign contextMethod = "createDataFormat"]
[#else]
[#stop "Unexpected Camel artifact kind " + kind ]
[/#if]
[#assign schemeVarName = "[=toSnakeCase(model.kind)?upper_case]_[=toSnakeCase(model.name)?upper_case]"]
        if (context.[=contextMethod]([=schemeVarName]) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", [=schemeVarName]);
        return Response.status(500, [=schemeVarName] + " could not be loaded from the Camel context").build();
[/#if]
    }
[/#list]
[/#if]
}
