/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.camel.maven.prod;

import com.google.common.base.Objects;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.camel.maven.packaging.ComponentDslMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.l2x6.cq.common.CqCommonUtils;
import org.l2x6.cq.common.OnFailure;
import org.l2x6.pom.tuner.MavenSourceTree;
import org.l2x6.pom.tuner.PomTransformer;
import org.l2x6.pom.tuner.PomTunerUtils;
import org.l2x6.pom.tuner.model.Dependency;
import org.l2x6.pom.tuner.model.Ga;
import org.l2x6.pom.tuner.model.Module;
import org.l2x6.pom.tuner.model.Profile;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="camel-prod-excludes", threadSafe=true, requiresProject=false, inheritByDefault=false)
public class CamelProdExcludesMojo
extends AbstractMojo {
    static final String MODULE_COMMENT = "disabled by cq-prod-maven-plugin:camel-prod-excludes";
    static final String DEFAULT_REQUIRED_PRODUCTIZED_CAMEL_ARTIFACTS_TXT = "target/required-productized-camel-artifacts.txt";
    @Parameter(property="cq.basedir", defaultValue="${project.basedir}")
    File basedir;
    @Parameter(defaultValue="utf-8", required=true, property="cq.encoding")
    String encoding;
    Charset charset;
    @Parameter(property="cq.camel-prod-excludes.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="cq.onCheckFailure", defaultValue="FAIL")
    OnFailure onCheckFailure;
    @Parameter(property="cq.simpleElementWhitespace", defaultValue="SPACE")
    PomTransformer.SimpleElementWhitespace simpleElementWhitespace;
    @Parameter(property="cq.additionalProductizedArtifactIds", defaultValue="")
    List<String> additionalProductizedArtifactIds;
    @Parameter(property="cq.requiredProductizedCamelArtifacts", defaultValue="${project.basedir}/target/required-productized-camel-artifacts.txt")
    File requiredProductizedCamelArtifacts;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(property="cq.camelCommunityVersion", defaultValue="${camel-community.version}")
    String camelCommunityVersion;
    Map<String, VersionStyle> versionStylesByPath;
    @Parameter(defaultValue="${settings.localRepository}", readonly=true)
    String localRepository;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    private Predicate<Path> additionalFiles;

    protected boolean isChecking() {
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set includes;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping as requested by the user");
            return;
        }
        this.charset = Charset.forName(this.encoding);
        if (this.additionalProductizedArtifactIds == null) {
            this.additionalProductizedArtifactIds = Collections.emptyList();
        }
        if (this.camelCommunityVersion == null || this.camelCommunityVersion.trim().isEmpty()) {
            this.camelCommunityVersion = "3.11.1";
        }
        this.additionalFiles = path -> false;
        Path basePath = this.basedir.toPath();
        try {
            includes = Files.lines(basePath.resolve(this.requiredProductizedCamelArtifacts.toPath()), this.charset).map(line -> new Ga("org.apache.camel", line.strip())).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.additionalProductizedArtifactIds.stream().map(artifactId -> artifactId.contains(":") ? Ga.of((String)artifactId) : new Ga("org.apache.camel", artifactId)).forEach(includes::add);
        Path workRoot = this.isChecking() ? CqCommonUtils.copyPoms((Path)basePath, (Path)basePath.resolve("target/prod-excludes-work"), this.additionalFiles) : basePath;
        Path rootPomPath = workRoot.resolve("pom.xml");
        new PomTransformer(rootPomPath, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.addOrSetProperty((String)"camel-community.version", (String)this.camelCommunityVersion)});
        MavenSourceTree initialTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
        Predicate profiles = MavenSourceTree.ActiveProfiles.of((String[])new String[0]);
        MavenSourceTree fullTree = initialTree.relinkModules(this.charset, this.simpleElementWhitespace, MODULE_COMMENT);
        Stream.of("dsl/camel-yaml-dsl/camel-yaml-dsl/pom.xml").forEach(relPath -> new PomTransformer(workRoot.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.setTextValue((String)("/" + PomTunerUtils.anyNs((String[])new String[]{"plugin", "version"}) + "[.." + PomTunerUtils.anyNs((String[])new String[]{"groupId"}) + "/text() = 'org.apache.camel']"), (String)"${camel-community.version}")}));
        Path originalFullTreeCopyDir = CqCommonUtils.copyPoms((Path)workRoot, (Path)basePath.resolve("target/originalFullTreeCopy"), this.additionalFiles);
        Path allComponents = Stream.of("core/camel-allcomponents/pom.xml", "catalog/camel-allcomponents/pom.xml").map(originalFullTreeCopyDir::resolve).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalStateException("Could not find allcomponents module; searched in core/camel-allcomponents/pom.xml and catalog/camel-allcomponents/pom.xml"));
        new PomTransformer(allComponents, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.removeDependency((boolean)true, (boolean)true, gavtcs -> !includes.contains(gavtcs.toGa()))});
        Stream.of("dsl/camel-yaml-dsl/camel-yaml-dsl/pom.xml").forEach(relPath -> new PomTransformer(originalFullTreeCopyDir.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.removePlugins(null, (boolean)true, (boolean)true, gavtcs -> gavtcs.getGroupId().equals("org.apache.camel"))}));
        fullTree.getModulesByGa().values().forEach(module -> {
            ArrayList transformations = new ArrayList();
            module.getProfiles().stream().filter(profile -> !profile.getDependencies().isEmpty()).forEach(profile -> transformations.add(PomTransformer.Transformation.removeDependencies((String)profile.getId(), (boolean)true, (boolean)true, gavtcs -> "org.apache.camel".equals(gavtcs.getGroupId()) && ("test".equals(gavtcs.getScope()) || gavtcs.getArtifactId().startsWith("camel-spring")))));
            if (!transformations.isEmpty()) {
                new PomTransformer(originalFullTreeCopyDir.resolve(module.getPomPath()), this.charset, this.simpleElementWhitespace).transform(transformations);
            }
        });
        MavenSourceTree originalFullTreeCopy = MavenSourceTree.of((Path)originalFullTreeCopyDir.resolve("pom.xml"), (Charset)this.charset, Dependency::isVirtual);
        TreeSet expandedIncludes = new TreeSet(originalFullTreeCopy.findRequiredModules((Collection)includes, profiles));
        this.getLog().info((CharSequence)"expandedIncludes:");
        for (Ga ga2 : expandedIncludes) {
            this.getLog().info((CharSequence)(" - " + ga2.getArtifactId()));
        }
        this.versionStylesByPath = new HashMap<String, VersionStyle>();
        fullTree.getModulesByGa().values().stream().forEach(m -> VersionStyle.autodetect(m, this.camelCommunityVersion, this.project.getVersion(), expandedIncludes).ifPresent(vs -> this.versionStylesByPath.put(m.getPomPath(), (VersionStyle)vs)));
        Set excludes = fullTree.complement(expandedIncludes);
        String exclText = excludes.stream().map(ga -> ":" + ga.getArtifactId()).sorted().collect(Collectors.joining("\n"));
        try {
            Files.write(basePath.resolve(".mvn/excludes.txt"), exclText.getBytes(this.charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.handleExcludedTargetDirectories(basePath, fullTree, excludes, profiles);
        this.updateVersions(fullTree, profiles);
        fullTree.unlinkModules(expandedIncludes, profiles, this.charset, this.simpleElementWhitespace, unlinkModules -> PomTransformer.Transformation.commentModules((Collection)unlinkModules, (String)MODULE_COMMENT));
        MavenSourceTree reducedTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
        reducedTree.getModulesByGa().values().forEach(module -> {
            ArrayList transformations = new ArrayList();
            for (Profile profile : module.getProfiles()) {
                if (!profile.getDependencies().isEmpty()) {
                    profile.getDependencies().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant()) && dep.getVersion() != null).forEach(dep -> {
                        Ga ga = new Ga(dep.getGroupId().asConstant(), dep.getArtifactId().asConstant());
                        VersionStyle vs = this.versionStylesByPath.get(module.getPomPath());
                        vs.getTransformation(false, excludes.contains(ga), profile.getId(), ga, dep.getVersion().getRawExpression()).ifPresent(transformations::add);
                    });
                }
                if (profile.getDependencyManagement().isEmpty()) continue;
                profile.getDependencyManagement().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant()) && !"camel-bom".equals(dep.getArtifactId().asConstant())).forEach(dep -> {
                    Ga ga = new Ga(dep.getGroupId().asConstant(), dep.getArtifactId().asConstant());
                    VersionStyle vs = this.versionStylesByPath.get(module.getPomPath());
                    vs.getTransformation(true, excludes.contains(ga), profile.getId(), ga, dep.getVersion().getRawExpression()).ifPresent(transformations::add);
                });
            }
            if (!transformations.isEmpty()) {
                new PomTransformer(workRoot.resolve(module.getPomPath()), this.charset, this.simpleElementWhitespace).transform(transformations);
            }
        });
        Stream.of("parent/pom.xml").forEach(relPath -> new PomTransformer(workRoot.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.setTextValue((String)("/" + PomTunerUtils.anyNs((String[])new String[]{"dependency", "version"}) + "[.." + PomTunerUtils.anyNs((String[])new String[]{"artifactId"}) + "/text() = 'camel-buildtools']"), (String)"${camel-community.version}")}));
        if (this.isChecking() && this.onCheckFailure != OnFailure.IGNORE) {
            MavenSourceTree finalTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
            CqCommonUtils.assertPomsMatch((Path)workRoot, (Path)basePath, finalTree.getModulesByPath().keySet(), this.additionalFiles, (Charset)this.charset, (Path)this.basedir.toPath(), (Path)this.requiredProductizedCamelArtifacts.toPath(), (OnFailure)this.onCheckFailure, arg_0 -> ((Log)this.getLog()).warn(arg_0), (String)"org.l2x6.cq:cq-camel-prod-maven-plugin:camel-prod-excludes");
        }
    }

    void handleExcludedTargetDirectories(Path basePath, MavenSourceTree fullTree, Set<Ga> excludes, Predicate<Profile> profiles) {
        excludes.stream().map(ga -> (Module)fullTree.getModulesByGa().get(ga)).map(Module::getPomPath).map(basePath::resolve).map(Path::getParent).map(absPath -> absPath.resolve("target")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(CqCommonUtils::deleteDirectory);
        this.project.getBasedir();
        excludes.stream().map(ga -> (Module)fullTree.getModulesByGa().get(ga)).filter(CamelProdExcludesMojo::isComponent).forEach(module -> {
            String artifactId = module.getGav().getArtifactId().asConstant();
            Path jarPath = CqCommonUtils.resolveArtifact((Path)Paths.get(this.localRepository, new String[0]), (String)"org.apache.camel", (String)artifactId, (String)this.camelCommunityVersion, (String)"jar", this.repositories, (RepositorySystem)this.repoSystem, (RepositorySystemSession)this.repoSession);
            Path pomFilePath = basePath.resolve(module.getPomPath());
            Path moduleBaseDir = pomFilePath.getParent();
            File outputDir = moduleBaseDir.resolve("target/classes").toFile();
            try (ZipFile zipFile = new ZipFile(jarPath.toFile());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(outputDir, entry.getName());
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    try (FileOutputStream out = new FileOutputStream(entryDestination);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not extract " + jarPath + " to " + outputDir);
            }
            this.getLog().info((CharSequence)("Executing ComponentDslMojo in " + moduleBaseDir));
            File origFile = this.project.getFile();
            this.project.setFile(pomFilePath.toFile());
            String originalBuildDir = this.project.getBuild().getDirectory();
            this.project.getBuild().setDirectory(moduleBaseDir.resolve("target").toString());
            try {
                ComponentDslMojo mojo = new ComponentDslMojo();
                mojo.setLog(this.getLog());
                mojo.setPluginContext(this.getPluginContext());
                mojo.execute(this.project, this.projectHelper, (BuildContext)new org.codehaus.plexus.build.DefaultBuildContext((org.sonatype.plexus.build.incremental.BuildContext)new DefaultBuildContext()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not excute ComponentDslMojo in " + moduleBaseDir, e);
            }
            finally {
                this.project.setFile(origFile);
                this.project.getBuild().setDirectory(originalBuildDir);
            }
        });
    }

    static boolean isComponent(Module module) {
        return "jar".equals(module.getPackaging()) && (module.getPomPath().startsWith("components/") || module.getPomPath().startsWith("core/"));
    }

    void updateVersions(MavenSourceTree fullTree, Predicate<Profile> profiles) {
        Module rootModule = fullTree.getRootModule();
        String expectedVersion = rootModule.getGav().getVersion().asConstant();
        for (Module module : fullTree.getModulesByGa().values()) {
            if (module.getPomPath().equals("pom.xml")) continue;
            String moduleVersion = module.getParentGav().getVersion().asConstant();
            String parentGroupId = module.getParentGav().getGroupId().asConstant();
            String moduleGroupId = module.getGav().getGroupId().asConstant();
            if (expectedVersion.equals(moduleVersion) || !parentGroupId.equals(moduleGroupId)) continue;
            Path pomPath = fullTree.getRootDirectory().resolve(module.getPomPath());
            new PomTransformer(pomPath, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{(document, context) -> context.getContainerElement(new String[]{"project", "parent"}).ifPresent(parent -> parent.addOrSetChildTextElement("version", expectedVersion))});
        }
    }

    void visitPoms(Path src, Consumer<Path> pomConsumer) {
        final TreeSet paths = new TreeSet();
        try {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String dirName = dir.getFileName().toString();
                    if ((dirName.equals("target") || dirName.equals("src")) && Files.isRegularFile(dir.getParent().resolve("pom.xml"), new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("pom.xml")) {
                        paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not visit pom.xml files under " + src, e);
        }
        paths.stream().forEach(pomConsumer);
    }

    public static class VersionStyle {
        private final String camelCommunityVersion;
        private final String camelVersion;
        private final CamelVersionStyle camelVersionStyle;
        private final CamelCommunityVersionStyle camelCommunityVersionStyle;

        static Optional<VersionStyle> autodetect(Module module, String camelCommunityVersion, String camelVersion, Set<Ga> includes) {
            if ("bom/camel-bom/pom.xml".equals(module.getPomPath())) {
                return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.PROJECT_VERSION, CamelCommunityVersionStyle.LITERAL));
            }
            boolean importsCamelBom = ((Profile)module.getProfiles().get(0)).getDependencyManagement().stream().anyMatch(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant()) && "camel-bom".equals(dep.getArtifactId().asConstant()));
            Optional<String> firstManagedCamelArtifact = ((Profile)module.getProfiles().get(0)).getDependencyManagement().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant()) && !"camel-bom".equals(dep.getArtifactId().asConstant())).map(dep -> dep.getVersion().getRawExpression()).findFirst();
            if (importsCamelBom) {
                return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.NONE, CamelCommunityVersionStyle.NONE));
            }
            if (firstManagedCamelArtifact.isPresent()) {
                if (firstManagedCamelArtifact.get().startsWith("$")) {
                    return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.PROJECT_VERSION, CamelCommunityVersionStyle.CAMEL_COMMUNITY_VERSION));
                }
                return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.LITERAL, CamelCommunityVersionStyle.LITERAL));
            }
            Optional<String> firstCamelDependency = ((Profile)module.getProfiles().get(0)).getDependencies().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().getRawExpression()) && dep.getVersion() != null).map(dep -> dep.getVersion().getRawExpression()).findFirst();
            if (firstCamelDependency.isPresent()) {
                if (firstCamelDependency.get().startsWith("$")) {
                    return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.PROJECT_VERSION, CamelCommunityVersionStyle.CAMEL_COMMUNITY_VERSION));
                }
                return Optional.of(new VersionStyle(camelCommunityVersion, camelVersion, CamelVersionStyle.LITERAL, CamelCommunityVersionStyle.LITERAL));
            }
            return Optional.empty();
        }

        public VersionStyle(String camelCommunityVersion, String camelVersion, CamelVersionStyle camelVersionStyle, CamelCommunityVersionStyle camelCommunityVersionStyle) {
            this.camelCommunityVersion = camelCommunityVersion;
            this.camelVersion = camelVersion;
            this.camelVersionStyle = camelVersionStyle;
            this.camelCommunityVersionStyle = camelCommunityVersionStyle;
        }

        public CamelVersionStyle getCamelVersionStyle() {
            return this.camelVersionStyle;
        }

        public CamelCommunityVersionStyle getCamelCommunityVersionStyle() {
            return this.camelCommunityVersionStyle;
        }

        public Optional<PomTransformer.Transformation> getTransformation(boolean isManagement, boolean isCommunity, String profileId, Ga ga, String actualVersion) {
            String expectedVersion;
            String literalVersion = isCommunity ? this.camelCommunityVersion : this.camelVersion;
            String string = expectedVersion = isCommunity ? this.camelCommunityVersionStyle.getExpectedVersion(literalVersion) : this.camelVersionStyle.getExpectedVersion(literalVersion);
            if (Objects.equal((Object)actualVersion, (Object)expectedVersion)) {
                return Optional.empty();
            }
            return Optional.of(isManagement ? PomTransformer.Transformation.setManagedDependencyVersion((String)profileId, (String)expectedVersion, Collections.singleton(ga)) : PomTransformer.Transformation.setDependencyVersion((String)profileId, (String)expectedVersion, Collections.singleton(ga)));
        }
    }

    static enum CamelCommunityVersionStyle implements AnyVersionStyle
    {
        CAMEL_COMMUNITY_VERSION{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return "${camel-community.version}";
            }
        }
        ,
        LITERAL{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return literalVersion;
            }
        }
        ,
        NONE{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return null;
            }
        };

    }

    static enum CamelVersionStyle implements AnyVersionStyle
    {
        PROJECT_VERSION{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return "${project.version}";
            }
        }
        ,
        LITERAL{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return literalVersion;
            }
        }
        ,
        NONE{

            @Override
            public String getExpectedVersion(String literalVersion) {
                return null;
            }
        };

    }

    static interface AnyVersionStyle {
        public String getExpectedVersion(String var1);
    }
}

