/*
 * Decompiled with CFR 0.152.
 */
package org.l2x6.cq.camel.maven.prod;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.camel.maven.packaging.ComponentDslMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.assertj.core.api.Assertions;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.l2x6.cq.common.CqCommonUtils;
import org.l2x6.pom.tuner.MavenSourceTree;
import org.l2x6.pom.tuner.PomTransformer;
import org.l2x6.pom.tuner.PomTunerUtils;
import org.l2x6.pom.tuner.model.Dependency;
import org.l2x6.pom.tuner.model.Ga;
import org.l2x6.pom.tuner.model.Module;
import org.l2x6.pom.tuner.model.Profile;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="camel-prod-excludes", threadSafe=true, requiresProject=false, inheritByDefault=false)
public class CamelProdExcludesMojo
extends AbstractMojo {
    static final String MODULE_COMMENT = "disabled by cq-prod-maven-plugin:camel-prod-excludes";
    static final String DEFAULT_REQUIRED_PRODUCTIZED_CAMEL_ARTIFACTS_TXT = "target/required-productized-camel-artifacts.txt";
    @Parameter(property="cq.basedir", defaultValue="${project.basedir}")
    File basedir;
    @Parameter(defaultValue="utf-8", required=true, property="cq.encoding")
    String encoding;
    Charset charset;
    @Parameter(property="cq.camel-prod-excludes.skip", defaultValue="false")
    boolean skip;
    @Parameter(property="cq.simpleElementWhitespace", defaultValue="SPACE")
    PomTransformer.SimpleElementWhitespace simpleElementWhitespace;
    @Parameter(property="cq.additionalProductizedArtifactIds", defaultValue="")
    List<String> additionalProductizedArtifactIds;
    @Parameter(property="cq.requiredProductizedCamelArtifacts", defaultValue="${project.basedir}/target/required-productized-camel-artifacts.txt")
    File requiredProductizedCamelArtifacts;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(property="cq.camelCommunityVersion", defaultValue="${camel-community.version}")
    String camelCommunityVersion;
    @Parameter(defaultValue="${settings.localRepository}", readonly=true)
    String localRepository;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;

    protected boolean isChecking() {
        return false;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set includes;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping as requested by the user");
            return;
        }
        this.charset = Charset.forName(this.encoding);
        if (this.additionalProductizedArtifactIds == null) {
            this.additionalProductizedArtifactIds = Collections.emptyList();
        }
        if (this.camelCommunityVersion == null || this.camelCommunityVersion.trim().isEmpty()) {
            this.camelCommunityVersion = "3.11.1";
        }
        Path basePath = this.basedir.toPath();
        try {
            includes = Files.lines(basePath.resolve(this.requiredProductizedCamelArtifacts.toPath()), this.charset).map(line -> new Ga("org.apache.camel", line)).collect(Collectors.toCollection(TreeSet::new));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.additionalProductizedArtifactIds.stream().map(artifactId -> new Ga("org.apache.camel", artifactId)).forEach(includes::add);
        Path workRoot = this.isChecking() ? this.copyPoms(basePath, basePath.resolve("target/prod-excludes-work")) : basePath;
        Path rootPomPath = workRoot.resolve("pom.xml");
        new PomTransformer(rootPomPath, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.addOrSetProperty((String)"camel-community.version", (String)this.camelCommunityVersion)});
        MavenSourceTree initialTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
        Predicate profiles = MavenSourceTree.ActiveProfiles.of((String[])new String[0]);
        MavenSourceTree fullTree = initialTree.relinkModules(this.charset, this.simpleElementWhitespace, MODULE_COMMENT);
        Stream.of("dsl/camel-yaml-dsl/camel-yaml-dsl/pom.xml").forEach(relPath -> new PomTransformer(workRoot.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.setTextValue((String)("/" + PomTunerUtils.anyNs((String[])new String[]{"plugin", "version"}) + "[.." + PomTunerUtils.anyNs((String[])new String[]{"groupId"}) + "/text() = 'org.apache.camel']"), (String)"${camel-community.version}")}));
        Path originalFullTreeCopyDir = this.copyPoms(workRoot, basePath.resolve("target/originalFullTreeCopy"));
        new PomTransformer(originalFullTreeCopyDir.resolve("core/camel-allcomponents/pom.xml"), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.removeDependency((boolean)true, (boolean)true, gavtcs -> !includes.contains(gavtcs.toGa()))});
        Stream.of("dsl/camel-yaml-dsl/camel-yaml-dsl/pom.xml").forEach(relPath -> new PomTransformer(originalFullTreeCopyDir.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.removePlugins(null, (boolean)true, (boolean)true, gavtcs -> gavtcs.getGroupId().equals("org.apache.camel"))}));
        fullTree.getModulesByGa().values().forEach(module -> {
            ArrayList transformations = new ArrayList();
            module.getProfiles().stream().filter(profile -> !profile.getDependencies().isEmpty()).forEach(profile -> transformations.add(PomTransformer.Transformation.removeDependencies((String)profile.getId(), (boolean)true, (boolean)true, gavtcs -> "org.apache.camel".equals(gavtcs.getGroupId()) && ("test".equals(gavtcs.getScope()) || gavtcs.getArtifactId().startsWith("camel-spring")))));
            if (!transformations.isEmpty()) {
                new PomTransformer(originalFullTreeCopyDir.resolve(module.getPomPath()), this.charset, this.simpleElementWhitespace).transform(transformations);
            }
        });
        MavenSourceTree originalFullTreeCopy = MavenSourceTree.of((Path)originalFullTreeCopyDir.resolve("pom.xml"), (Charset)this.charset, Dependency::isVirtual);
        TreeSet expandedIncludes = new TreeSet(originalFullTreeCopy.findRequiredModules((Collection)includes, profiles));
        this.getLog().info((CharSequence)"expandedIncludes:");
        for (Ga ga2 : expandedIncludes) {
            this.getLog().info((CharSequence)(" - " + ga2.getArtifactId()));
        }
        Set excludes = fullTree.complement(expandedIncludes);
        String exclText = excludes.stream().map(ga -> ":" + ga.getArtifactId()).sorted().collect(Collectors.joining("\n"));
        try {
            Files.write(basePath.resolve(".mvn/excludes.txt"), exclText.getBytes(this.charset), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.handleExcludedTargetDirectories(basePath, fullTree, excludes, profiles);
        this.updateVersions(fullTree, profiles);
        fullTree.unlinkModules(expandedIncludes, profiles, this.charset, this.simpleElementWhitespace, unlinkModules -> PomTransformer.Transformation.commentModules((Collection)unlinkModules, (String)MODULE_COMMENT));
        MavenSourceTree reducedTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
        reducedTree.getModulesByGa().values().forEach(module -> {
            ArrayList<PomTransformer.Transformation> transformations = new ArrayList<PomTransformer.Transformation>();
            for (Profile profile : module.getProfiles()) {
                Set changeManagedDeps;
                Set changeDeps = profile.getDependencies().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant()) && dep.getVersion() != null).map(dep -> new Ga(dep.getGroupId().asConstant(), dep.getArtifactId().asConstant())).filter(excludes::contains).collect(Collectors.toCollection(HashSet::new));
                if (!changeDeps.isEmpty()) {
                    transformations.add(PomTransformer.Transformation.setDependencyVersion((String)profile.getId(), (String)"${camel-community.version}", (Collection)changeDeps));
                }
                if ((changeManagedDeps = (Set)profile.getDependencyManagement().stream().filter(dep -> "org.apache.camel".equals(dep.getGroupId().asConstant())).map(dep -> new Ga(dep.getGroupId().asConstant(), dep.getArtifactId().asConstant())).filter(excludes::contains).collect(Collectors.toCollection(HashSet::new))).isEmpty()) continue;
                String version = module.getPomPath().equals("bom/camel-bom/pom.xml") ? this.camelCommunityVersion : "${camel-community.version}";
                transformations.add(PomTransformer.Transformation.setManagedDependencyVersion((String)profile.getId(), (String)version, (Collection)excludes));
            }
            if (!transformations.isEmpty()) {
                new PomTransformer(workRoot.resolve(module.getPomPath()), this.charset, this.simpleElementWhitespace).transform(transformations);
            }
        });
        Stream.of("pom.xml", "parent/pom.xml").forEach(relPath -> new PomTransformer(workRoot.resolve((String)relPath), this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{PomTransformer.Transformation.setTextValue((String)("/" + PomTunerUtils.anyNs((String[])new String[]{"dependency", "version"}) + "[.." + PomTunerUtils.anyNs((String[])new String[]{"artifactId"}) + "/text() = 'camel-buildtools']"), (String)"${camel-community.version}")}));
        if (this.isChecking()) {
            MavenSourceTree finalTree = MavenSourceTree.of((Path)rootPomPath, (Charset)this.charset, Dependency::isVirtual);
            this.assertPomsMatch(workRoot, basePath, finalTree.getModulesByPath().keySet());
        }
    }

    void handleExcludedTargetDirectories(Path basePath, MavenSourceTree fullTree, Set<Ga> excludes, Predicate<Profile> profiles) {
        excludes.stream().map(ga -> (Module)fullTree.getModulesByGa().get(ga)).map(Module::getPomPath).map(basePath::resolve).map(Path::getParent).map(absPath -> absPath.resolve("target")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(CqCommonUtils::deleteDirectory);
        this.project.getBasedir();
        excludes.stream().map(ga -> (Module)fullTree.getModulesByGa().get(ga)).filter(CamelProdExcludesMojo::isComponent).forEach(module -> {
            String artifactId = module.getGav().getArtifactId().asConstant();
            Path jarPath = CqCommonUtils.resolveArtifact((Path)Paths.get(this.localRepository, new String[0]), (String)"org.apache.camel", (String)artifactId, (String)this.camelCommunityVersion, (String)"jar", this.repositories, (RepositorySystem)this.repoSystem, (RepositorySystemSession)this.repoSession);
            Path pomFilePath = basePath.resolve(module.getPomPath());
            Path moduleBaseDir = pomFilePath.getParent();
            File outputDir = moduleBaseDir.resolve("target/classes").toFile();
            try (ZipFile zipFile = new ZipFile(jarPath.toFile());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryDestination = new File(outputDir, entry.getName());
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = zipFile.getInputStream(entry);
                    try (FileOutputStream out = new FileOutputStream(entryDestination);){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not extract " + jarPath + " to " + outputDir);
            }
            this.getLog().info((CharSequence)("Executing ComponentDslMojo in " + moduleBaseDir));
            File origFile = this.project.getFile();
            this.project.setFile(pomFilePath.toFile());
            String originalBuildDir = this.project.getBuild().getDirectory();
            this.project.getBuild().setDirectory(moduleBaseDir.resolve("target").toString());
            try {
                ComponentDslMojo mojo = new ComponentDslMojo();
                mojo.setLog(this.getLog());
                mojo.setPluginContext(this.getPluginContext());
                mojo.execute(this.project, this.projectHelper, (BuildContext)new DefaultBuildContext());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not excute ComponentDslMojo in " + moduleBaseDir, e);
            }
            finally {
                this.project.setFile(origFile);
                this.project.getBuild().setDirectory(originalBuildDir);
            }
        });
    }

    static boolean isComponent(Module module) {
        return "jar".equals(module.getPackaging()) && (module.getPomPath().startsWith("components/") || module.getPomPath().startsWith("core/"));
    }

    void updateVersions(MavenSourceTree fullTree, Predicate<Profile> profiles) {
        Module rootModule = fullTree.getRootModule();
        String expectedVersion = rootModule.getGav().getVersion().asConstant();
        for (Module module : fullTree.getModulesByGa().values()) {
            String moduleVersion;
            if (module.getPomPath().equals("pom.xml") || expectedVersion.equals(moduleVersion = module.getParentGav().getVersion().asConstant())) continue;
            Path pomPath = fullTree.getRootDirectory().resolve(module.getPomPath());
            new PomTransformer(pomPath, this.charset, this.simpleElementWhitespace).transform(new PomTransformer.Transformation[]{(document, context) -> context.getContainerElement(new String[]{"project", "parent"}).ifPresent(parent -> parent.addOrSetChildTextElement("version", expectedVersion))});
        }
    }

    private Path copyPoms(Path src, Path dest) {
        CqCommonUtils.ensureDirectoryExistsAndEmpty((Path)dest);
        this.visitPoms(src, file -> {
            Path destPath = dest.resolve(src.relativize((Path)file));
            try {
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                Files.copy(file, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not copy " + file + " to " + destPath, e);
            }
        });
        return dest;
    }

    void assertPomsMatch(Path src, Path dest, Set<String> activeRelativePomPaths) {
        this.visitPoms(src, file -> {
            Path relPomPath = src.relativize((Path)file);
            if (activeRelativePomPaths.contains(PomTunerUtils.toUnixPath((String)relPomPath.toString()))) {
                Path destPath = dest.resolve(relPomPath);
                try {
                    Assertions.assertThat((Path)file).hasSameTextualContentAs(destPath);
                }
                catch (AssertionError e) {
                    Object msg = ((Throwable)((Object)e)).getMessage();
                    String contentAt = "content at line";
                    int offset = ((String)msg).indexOf("content at line");
                    if (offset < 0) {
                        throw new IllegalStateException("Expected to find 'content at line' in the causing exception's message; found: " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
                    }
                    while (((String)msg).charAt(--offset) != '\n') {
                    }
                    msg = "File [" + this.basedir.toPath().relativize(destPath) + "] is not in sync with " + this.requiredProductizedCamelArtifacts + ":\n\n" + ((String)msg).substring(offset) + "\n\n Consider running mvn org.l2x6.cq:cq-prod-maven-plugin:prod-excludes -N\n\n";
                    throw new RuntimeException((String)msg);
                }
            }
        });
    }

    void visitPoms(Path src, Consumer<Path> pomConsumer) {
        final TreeSet paths = new TreeSet();
        try {
            Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String dirName = dir.getFileName().toString();
                    if ((dirName.equals("target") || dirName.equals("src")) && Files.isRegularFile(dir.getParent().resolve("pom.xml"), new LinkOption[0])) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (fileName.equals("pom.xml")) {
                        paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not visit pom.xml files under " + src, e);
        }
        paths.stream().forEach(pomConsumer);
    }
}

