/*
 * Decompiled with CFR 0.152.
 */
package org.korz.log4j2;

import org.apache.logging.log4j.core.pattern.NameAbbreviator;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public class CollapsedNameAbbreviator
extends NameAbbreviator {
    private static final char DEFAULT_DELIMITER = '.';
    private final int max;
    private final char delimiter;

    public CollapsedNameAbbreviator(int max) {
        this(max, '.');
    }

    public CollapsedNameAbbreviator(int max, char delimiter) {
        this.max = max;
        this.delimiter = delimiter;
    }

    public void abbreviate(String original, StringBuilder destination) {
        if (this.max == 0) {
            destination.append(original.substring(original.lastIndexOf(this.delimiter) + 1));
        } else {
            int length = original.length();
            if (length <= this.max) {
                destination.append(original);
            } else {
                int index;
                int lastDelimiterIndex = original.lastIndexOf(this.delimiter);
                int overflow = length - this.max;
                boolean wordBegin = true;
                for (index = 0; index < lastDelimiterIndex; ++index) {
                    char c = original.charAt(index);
                    if (c == this.delimiter) {
                        if (overflow <= 0) break;
                        destination.append(c);
                        wordBegin = true;
                        continue;
                    }
                    if (wordBegin) {
                        destination.append(c);
                        wordBegin = false;
                        continue;
                    }
                    --overflow;
                }
                destination.append(original.substring(index));
            }
        }
    }
}

