/*
 * Decompiled with CFR 0.152.
 */
package org.korz.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.NameAbbreviator;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.korz.log4j2.CollapsedNameAbbreviator;

@Plugin(name="CollapsedLoggerPatternConverter", category="Converter")
@ConverterKeys(value={"lo", "clogger", "collapsedlogger"})
@PerformanceSensitive(value={"allocation"})
public class CollapsedLoggerPatternConverter
extends LogEventPatternConverter {
    private final NameAbbreviator abbreviator;

    public static CollapsedLoggerPatternConverter newInstance(String[] options) {
        return new CollapsedLoggerPatternConverter(options);
    }

    private CollapsedLoggerPatternConverter(String[] options) {
        super("Logger", "logger");
        if (options != null && options.length > 0) {
            int length;
            try {
                length = Integer.parseInt(options[0].trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("length is not an integer", e);
            }
            this.abbreviator = new CollapsedNameAbbreviator(length);
        } else {
            this.abbreviator = NameAbbreviator.getDefaultAbbreviator();
        }
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        this.abbreviator.abbreviate(event.getLoggerName(), toAppendTo);
    }
}

