/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.octicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Octicons implements Ikon {
    ALERT_16("oct-alert-16", '\ue900'),
    ALERT_24("oct-alert-24", '\ue901'),
    ARCHIVE_16("oct-archive-16", '\ue902'),
    ARCHIVE_24("oct-archive-24", '\ue903'),
    ARROW_BOTH_16("oct-arrow-both-16", '\ue904'),
    ARROW_BOTH_24("oct-arrow-both-24", '\ue905'),
    ARROW_DOWN_16("oct-arrow-down-16", '\ue906'),
    ARROW_DOWN_24("oct-arrow-down-24", '\ue907'),
    ARROW_DOWN_LEFT_24("oct-arrow-down-left-24", '\ue908'),
    ARROW_DOWN_RIGHT_24("oct-arrow-down-right-24", '\ue909'),
    ARROW_LEFT_16("oct-arrow-left-16", '\ue90a'),
    ARROW_LEFT_24("oct-arrow-left-24", '\ue90b'),
    ARROW_RIGHT_16("oct-arrow-right-16", '\ue90c'),
    ARROW_RIGHT_24("oct-arrow-right-24", '\ue90d'),
    ARROW_SWITCH_16("oct-arrow-switch-16", '\ue90e'),
    ARROW_SWITCH_24("oct-arrow-switch-24", '\ue90f'),
    ARROW_UP_16("oct-arrow-up-16", '\ue910'),
    ARROW_UP_24("oct-arrow-up-24", '\ue911'),
    ARROW_UP_LEFT_24("oct-arrow-up-left-24", '\ue912'),
    ARROW_UP_RIGHT_24("oct-arrow-up-right-24", '\ue913'),
    BEAKER_16("oct-beaker-16", '\ue914'),
    BEAKER_24("oct-beaker-24", '\ue915'),
    BELL_16("oct-bell-16", '\ue916'),
    BELL_24("oct-bell-24", '\ue917'),
    BELL_FILL_24("oct-bell-fill-24", '\ue918'),
    BELL_SLASH_16("oct-bell-slash-16", '\ue919'),
    BELL_SLASH_24("oct-bell-slash-24", '\ue91a'),
    BOLD_16("oct-bold-16", '\ue91b'),
    BOLD_24("oct-bold-24", '\ue91c'),
    BOOKMARK_16("oct-bookmark-16", '\ue91f'),
    BOOKMARK_24("oct-bookmark-24", '\ue920'),
    BOOKMARK_FILL_24("oct-bookmark-fill-24", '\ue921'),
    BOOKMARK_SLASH_16("oct-bookmark-slash-16", '\ue922'),
    BOOKMARK_SLASH_24("oct-bookmark-slash-24", '\ue923'),
    BOOKMARK_SLASH_FILL_24("oct-bookmark-slash-fill-24", '\ue924'),
    BOOK_16("oct-book-16", '\ue91d'),
    BOOK_24("oct-book-24", '\ue91e'),
    BRIEFCASE_16("oct-briefcase-16", '\ue925'),
    BRIEFCASE_24("oct-briefcase-24", '\ue926'),
    BROADCAST_16("oct-broadcast-16", '\ue927'),
    BROADCAST_24("oct-broadcast-24", '\ue928'),
    BROWSER_16("oct-browser-16", '\ue929'),
    BUG_16("oct-bug-16", '\ue92a'),
    CALENDAR_16("oct-calendar-16", '\ue92b'),
    CALENDAR_24("oct-calendar-24", '\ue92c'),
    CHECKLIST_16("oct-checklist-16", '\ue933'),
    CHECKLIST_24("oct-checklist-24", '\ue934'),
    CHECK_16("oct-check-16", '\ue92d'),
    CHECK_24("oct-check-24", '\ue92e'),
    CHECK_CIRCLE_16("oct-check-circle-16", '\ue92f'),
    CHECK_CIRCLE_24("oct-check-circle-24", '\ue930'),
    CHECK_CIRCLE_FILL_16("oct-check-circle-fill-16", '\ue931'),
    CHECK_CIRCLE_FILL_24("oct-check-circle-fill-24", '\ue932'),
    CHEVRON_DOWN_16("oct-chevron-down-16", '\ue935'),
    CHEVRON_DOWN_24("oct-chevron-down-24", '\ue936'),
    CHEVRON_LEFT_16("oct-chevron-left-16", '\ue937'),
    CHEVRON_LEFT_24("oct-chevron-left-24", '\ue938'),
    CHEVRON_RIGHT_16("oct-chevron-right-16", '\ue939'),
    CHEVRON_RIGHT_24("oct-chevron-right-24", '\ue93a'),
    CHEVRON_UP_16("oct-chevron-up-16", '\ue93b'),
    CHEVRON_UP_24("oct-chevron-up-24", '\ue93c'),
    CIRCLE_16("oct-circle-16", '\ue93d'),
    CIRCLE_24("oct-circle-24", '\ue93e'),
    CIRCLE_SLASH_16("oct-circle-slash-16", '\ue93f'),
    CIRCLE_SLASH_24("oct-circle-slash-24", '\ue940'),
    CLIPPY_16("oct-clippy-16", '\ue941'),
    CLIPPY_24("oct-clippy-24", '\ue942'),
    CLOCK_16("oct-clock-16", '\ue943'),
    CLOCK_24("oct-clock-24", '\ue944'),
    CODE_16("oct-code-16", '\ue945'),
    CODE_24("oct-code-24", '\ue946'),
    CODE_REVIEW_16("oct-code-review-16", '\ue947'),
    CODE_REVIEW_24("oct-code-review-24", '\ue948'),
    CODE_SQUARE_16("oct-code-square-16", '\ue949'),
    CODE_SQUARE_24("oct-code-square-24", '\ue94a'),
    COMMENT_16("oct-comment-16", '\ue94b'),
    COMMENT_24("oct-comment-24", '\ue94c'),
    COMMENT_DISCUSSION_16("oct-comment-discussion-16", '\ue94d'),
    COMMENT_DISCUSSION_24("oct-comment-discussion-24", '\ue94e'),
    COMMIT_24("oct-commit-24", '\ue94f'),
    COPY_24("oct-copy-24", '\ue950'),
    CPU_16("oct-cpu-16", '\ue951'),
    CPU_24("oct-cpu-24", '\ue952'),
    CREDIT_CARD_16("oct-credit-card-16", '\ue953'),
    CREDIT_CARD_24("oct-credit-card-24", '\ue954'),
    CROSS_REFERENCE_16("oct-cross-reference-16", '\ue955'),
    CROSS_REFERENCE_24("oct-cross-reference-24", '\ue956'),
    DASH_16("oct-dash-16", '\ue957'),
    DASH_24("oct-dash-24", '\ue958'),
    DATABASE_16("oct-database-16", '\ue959'),
    DATABASE_24("oct-database-24", '\ue95a'),
    DESKTOP_DOWNLOAD_16("oct-desktop-download-16", '\ue95b'),
    DESKTOP_DOWNLOAD_24("oct-desktop-download-24", '\ue95c'),
    DEVICE_CAMERA_16("oct-device-camera-16", '\ue95d'),
    DEVICE_CAMERA_VIDEO_16("oct-device-camera-video-16", '\ue95e'),
    DEVICE_CAMERA_VIDEO_24("oct-device-camera-video-24", '\ue95f'),
    DEVICE_DESKTOP_16("oct-device-desktop-16", '\ue960'),
    DEVICE_DESKTOP_24("oct-device-desktop-24", '\ue961'),
    DEVICE_MOBILE_16("oct-device-mobile-16", '\ue962'),
    DEVICE_MOBILE_24("oct-device-mobile-24", '\ue963'),
    DIFF_16("oct-diff-16", '\ue964'),
    DIFF_24("oct-diff-24", '\ue965'),
    DIFF_ADDED_16("oct-diff-added-16", '\ue966'),
    DIFF_IGNORED_16("oct-diff-ignored-16", '\ue967'),
    DIFF_MODIFIED_16("oct-diff-modified-16", '\ue968'),
    DIFF_REMOVED_16("oct-diff-removed-16", '\ue969'),
    DIFF_RENAMED_16("oct-diff-renamed-16", '\ue96a'),
    DOT_16("oct-dot-16", '\ue96b'),
    DOT_24("oct-dot-24", '\ue96c'),
    DOT_FILL_16("oct-dot-fill-16", '\ue96d'),
    DOT_FILL_24("oct-dot-fill-24", '\ue96e'),
    DOWNLOAD_16("oct-download-16", '\ue96f'),
    DOWNLOAD_24("oct-download-24", '\ue970'),
    ELLIPSIS_16("oct-ellipsis-16", '\ue971'),
    EYE_16("oct-eye-16", '\ue972'),
    EYE_24("oct-eye-24", '\ue973'),
    EYE_CLOSED_16("oct-eye-closed-16", '\ue974'),
    EYE_CLOSED_24("oct-eye-closed-24", '\ue975'),
    FILE_16("oct-file-16", '\ue976'),
    FILE_24("oct-file-24", '\ue977'),
    FILE_BADGE_16("oct-file-badge-16", '\ue978'),
    FILE_BINARY_16("oct-file-binary-16", '\ue979'),
    FILE_BINARY_24("oct-file-binary-24", '\ue97a'),
    FILE_CODE_16("oct-file-code-16", '\ue97b'),
    FILE_CODE_24("oct-file-code-24", '\ue97c'),
    FILE_DIFF_16("oct-file-diff-16", '\ue97d'),
    FILE_DIFF_24("oct-file-diff-24", '\ue97e'),
    FILE_DIRECTORY_16("oct-file-directory-16", '\ue97f'),
    FILE_DIRECTORY_24("oct-file-directory-24", '\ue980'),
    FILE_DIRECTORY_FILL_24("oct-file-directory-fill-24", '\ue981'),
    FILE_MEDIA_24("oct-file-media-24", '\ue982'),
    FILE_SUBMODULE_16("oct-file-submodule-16", '\ue983'),
    FILE_SUBMODULE_24("oct-file-submodule-24", '\ue984'),
    FILE_SYMLINK_FILE_16("oct-file-symlink-file-16", '\ue985'),
    FILE_SYMLINK_FILE_24("oct-file-symlink-file-24", '\ue986'),
    FILE_ZIP_16("oct-file-zip-16", '\ue987'),
    FILE_ZIP_24("oct-file-zip-24", '\ue988'),
    FILTER_16("oct-filter-16", '\ue989'),
    FILTER_24("oct-filter-24", '\ue98a'),
    FLAME_16("oct-flame-16", '\ue98b'),
    FLAME_24("oct-flame-24", '\ue98c'),
    FOLD_16("oct-fold-16", '\ue98d'),
    FOLD_24("oct-fold-24", '\ue98e'),
    FOLD_DOWN_16("oct-fold-down-16", '\ue98f'),
    FOLD_DOWN_24("oct-fold-down-24", '\ue990'),
    FOLD_UP_16("oct-fold-up-16", '\ue991'),
    FOLD_UP_24("oct-fold-up-24", '\ue992'),
    GEAR_16("oct-gear-16", '\ue993'),
    GEAR_24("oct-gear-24", '\ue994'),
    GIFT_16("oct-gift-16", '\ue995'),
    GIFT_24("oct-gift-24", '\ue996'),
    GIT_BRANCH_16("oct-git-branch-16", '\ue997'),
    GIT_BRANCH_24("oct-git-branch-24", '\ue998'),
    GIT_COMMIT_16("oct-git-commit-16", '\ue999'),
    GIT_COMMIT_24("oct-git-commit-24", '\ue99a'),
    GIT_COMPARE_16("oct-git-compare-16", '\ue99b'),
    GIT_COMPARE_24("oct-git-compare-24", '\ue99c'),
    GIT_FORK_24("oct-git-fork-24", '\ue99d'),
    GIT_MERGE_16("oct-git-merge-16", '\ue99e'),
    GIT_MERGE_24("oct-git-merge-24", '\ue99f'),
    GIT_PULL_REQUEST_16("oct-git-pull-request-16", '\ue9a0'),
    GIT_PULL_REQUEST_24("oct-git-pull-request-24", '\ue9a1'),
    GLOBE_16("oct-globe-16", '\ue9a2'),
    GLOBE_24("oct-globe-24", '\ue9a3'),
    GRABBER_16("oct-grabber-16", '\ue9a4'),
    GRABBER_24("oct-grabber-24", '\ue9a5'),
    GRAPH_16("oct-graph-16", '\ue9a6'),
    GRAPH_24("oct-graph-24", '\ue9a7'),
    HEADING_16("oct-heading-16", '\ue9a8'),
    HEADING_24("oct-heading-24", '\ue9a9'),
    HEART_16("oct-heart-16", '\ue9aa'),
    HEART_24("oct-heart-24", '\ue9ab'),
    HEART_FILL_16("oct-heart-fill-16", '\ue9ac'),
    HEART_FILL_24("oct-heart-fill-24", '\ue9ad'),
    HISTORY_16("oct-history-16", '\ue9ae'),
    HISTORY_24("oct-history-24", '\ue9af'),
    HOME_16("oct-home-16", '\ue9b0'),
    HOME_24("oct-home-24", '\ue9b1'),
    HOME_FILL_24("oct-home-fill-24", '\ue9b2'),
    HORIZONTAL_RULE_16("oct-horizontal-rule-16", '\ue9b3'),
    HORIZONTAL_RULE_24("oct-horizontal-rule-24", '\ue9b4'),
    HOURGLASS_16("oct-hourglass-16", '\ue9b5'),
    HOURGLASS_24("oct-hourglass-24", '\ue9b6'),
    HUBOT_16("oct-hubot-16", '\ue9b7'),
    HUBOT_24("oct-hubot-24", '\ue9b8'),
    IMAGE_16("oct-image-16", '\ue9b9'),
    IMAGE_24("oct-image-24", '\ue9ba'),
    INBOX_16("oct-inbox-16", '\ue9bb'),
    INBOX_24("oct-inbox-24", '\ue9bc'),
    INFINITY_16("oct-infinity-16", '\ue9bd'),
    INFINITY_24("oct-infinity-24", '\ue9be'),
    INFO_16("oct-info-16", '\ue9bf'),
    INFO_24("oct-info-24", '\ue9c0'),
    INSIGHTS_24("oct-insights-24", '\ue9c1'),
    ISSUE_CLOSED_16("oct-issue-closed-16", '\ue9c2'),
    ISSUE_CLOSED_24("oct-issue-closed-24", '\ue9c3'),
    ISSUE_OPENED_16("oct-issue-opened-16", '\ue9c4'),
    ISSUE_OPENED_24("oct-issue-opened-24", '\ue9c5'),
    ISSUE_REOPENED_16("oct-issue-reopened-16", '\ue9c6'),
    ISSUE_REOPENED_24("oct-issue-reopened-24", '\ue9c7'),
    ITALIC_16("oct-italic-16", '\ue9c8'),
    ITALIC_24("oct-italic-24", '\ue9c9'),
    KEBAB_HORIZONTAL_16("oct-kebab-horizontal-16", '\ue9ca'),
    KEBAB_HORIZONTAL_24("oct-kebab-horizontal-24", '\ue9cb'),
    KEY_16("oct-key-16", '\ue9cc'),
    KEY_24("oct-key-24", '\ue9cd'),
    LAW_16("oct-law-16", '\ue9ce'),
    LAW_24("oct-law-24", '\ue9cf'),
    LIGHT_BULB_16("oct-light-bulb-16", '\ue9d0'),
    LIGHT_BULB_24("oct-light-bulb-24", '\ue9d1'),
    LINK_16("oct-link-16", '\ue9d2'),
    LINK_24("oct-link-24", '\ue9d3'),
    LINK_EXTERNAL_16("oct-link-external-16", '\ue9d4'),
    LINK_EXTERNAL_24("oct-link-external-24", '\ue9d5'),
    LIST_ORDERED_16("oct-list-ordered-16", '\ue9d6'),
    LIST_ORDERED_24("oct-list-ordered-24", '\ue9d7'),
    LIST_UNORDERED_16("oct-list-unordered-16", '\ue9d8'),
    LIST_UNORDERED_24("oct-list-unordered-24", '\ue9d9'),
    LOCATION_16("oct-location-16", '\ue9da'),
    LOCATION_24("oct-location-24", '\ue9db'),
    LOCK_16("oct-lock-16", '\ue9dc'),
    LOCK_24("oct-lock-24", '\ue9dd'),
    LOGO_GIST_16("oct-logo-gist-16", '\ue9de'),
    LOGO_GITHUB_16("oct-logo-github-16", '\ue9df'),
    MAIL_16("oct-mail-16", '\ue9e0'),
    MAIL_24("oct-mail-24", '\ue9e1'),
    MARKDOWN_16("oct-markdown-16", '\ue9e3'),
    MARK_GITHUB_16("oct-mark-github-16", '\ue9e2'),
    MEGAPHONE_16("oct-megaphone-16", '\ue9e4'),
    MEGAPHONE_24("oct-megaphone-24", '\ue9e5'),
    MENTION_16("oct-mention-16", '\ue9e6'),
    MENTION_24("oct-mention-24", '\ue9e7'),
    METER_16("oct-meter-16", '\ue9e8'),
    MILESTONE_16("oct-milestone-16", '\ue9e9'),
    MILESTONE_24("oct-milestone-24", '\ue9ea'),
    MIRROR_16("oct-mirror-16", '\ue9eb'),
    MIRROR_24("oct-mirror-24", '\ue9ec'),
    MOON_16("oct-moon-16", '\ue9ed'),
    MOON_24("oct-moon-24", '\ue9ee'),
    MORTAR_BOARD_16("oct-mortar-board-16", '\ue9ef'),
    MORTAR_BOARD_24("oct-mortar-board-24", '\ue9f0'),
    MUTE_16("oct-mute-16", '\ue9f1'),
    MUTE_24("oct-mute-24", '\ue9f2'),
    NORTH_STAR_16("oct-north-star-16", '\ue9f5'),
    NORTH_STAR_24("oct-north-star-24", '\ue9f6'),
    NOTE_16("oct-note-16", '\ue9f7'),
    NOTE_24("oct-note-24", '\ue9f8'),
    NO_ENTRY_16("oct-no-entry-16", '\ue9f3'),
    NO_ENTRY_24("oct-no-entry-24", '\ue9f4'),
    OCTOFACE_16("oct-octoface-16", '\ue9f9'),
    OCTOFACE_24("oct-octoface-24", '\ue9fa'),
    ORGANIZATION_16("oct-organization-16", '\ue9fb'),
    ORGANIZATION_24("oct-organization-24", '\ue9fc'),
    PACKAGE_16("oct-package-16", '\ue9fd'),
    PACKAGE_24("oct-package-24", '\ue9fe'),
    PACKAGE_DEPENDENCIES_16("oct-package-dependencies-16", '\ue9ff'),
    PACKAGE_DEPENDENCIES_24("oct-package-dependencies-24", '\uea00'),
    PACKAGE_DEPENDENTS_16("oct-package-dependents-16", '\uea01'),
    PACKAGE_DEPENDENTS_24("oct-package-dependents-24", '\uea02'),
    PAINTBRUSH_16("oct-paintbrush-16", '\uea03'),
    PAPER_AIRPLANE_16("oct-paper-airplane-16", '\uea04'),
    PAPER_AIRPLANE_24("oct-paper-airplane-24", '\uea05'),
    PENCIL_16("oct-pencil-16", '\uea06'),
    PENCIL_24("oct-pencil-24", '\uea07'),
    PEOPLE_16("oct-people-16", '\uea08'),
    PEOPLE_24("oct-people-24", '\uea09'),
    PERSON_16("oct-person-16", '\uea0a'),
    PERSON_24("oct-person-24", '\uea0b'),
    PIN_16("oct-pin-16", '\uea0c'),
    PIN_24("oct-pin-24", '\uea0d'),
    PLAY_16("oct-play-16", '\uea0e'),
    PLAY_24("oct-play-24", '\uea0f'),
    PLUG_16("oct-plug-16", '\uea10'),
    PLUG_24("oct-plug-24", '\uea11'),
    PLUS_16("oct-plus-16", '\uea12'),
    PLUS_24("oct-plus-24", '\uea13'),
    PLUS_CIRCLE_16("oct-plus-circle-16", '\uea14'),
    PLUS_CIRCLE_24("oct-plus-circle-24", '\uea15'),
    PROJECT_16("oct-project-16", '\uea16'),
    PROJECT_24("oct-project-24", '\uea17'),
    PULSE_16("oct-pulse-16", '\uea18'),
    PULSE_24("oct-pulse-24", '\uea19'),
    QUESTION_16("oct-question-16", '\uea1a'),
    QUESTION_24("oct-question-24", '\uea1b'),
    QUOTE_16("oct-quote-16", '\uea1c'),
    QUOTE_24("oct-quote-24", '\uea1d'),
    REPLY_16("oct-reply-16", '\uea1e'),
    REPLY_24("oct-reply-24", '\uea1f'),
    REPORT_16("oct-report-16", '\uea29'),
    REPORT_24("oct-report-24", '\uea2a'),
    REPO_16("oct-repo-16", '\uea20'),
    REPO_24("oct-repo-24", '\uea21'),
    REPO_CLONE_16("oct-repo-clone-16", '\uea22'),
    REPO_FORKED_16("oct-repo-forked-16", '\uea23'),
    REPO_PULL_16("oct-repo-pull-16", '\uea24'),
    REPO_PUSH_16("oct-repo-push-16", '\uea25'),
    REPO_PUSH_24("oct-repo-push-24", '\uea26'),
    REPO_TEMPLATE_16("oct-repo-template-16", '\uea27'),
    REPO_TEMPLATE_24("oct-repo-template-24", '\uea28'),
    ROCKET_16("oct-rocket-16", '\uea2b'),
    ROCKET_24("oct-rocket-24", '\uea2c'),
    RSS_16("oct-rss-16", '\uea2d'),
    RSS_24("oct-rss-24", '\uea2e'),
    RUBY_16("oct-ruby-16", '\uea2f'),
    RUBY_24("oct-ruby-24", '\uea30'),
    SCREEN_FULL_16("oct-screen-full-16", '\uea31'),
    SCREEN_FULL_24("oct-screen-full-24", '\uea32'),
    SCREEN_NORMAL_16("oct-screen-normal-16", '\uea33'),
    SCREEN_NORMAL_24("oct-screen-normal-24", '\uea34'),
    SEARCH_16("oct-search-16", '\uea35'),
    SEARCH_24("oct-search-24", '\uea36'),
    SERVER_16("oct-server-16", '\uea37'),
    SERVER_24("oct-server-24", '\uea38'),
    SHARE_16("oct-share-16", '\uea39'),
    SHARE_24("oct-share-24", '\uea3a'),
    SHARE_ANDROID_16("oct-share-android-16", '\uea3b'),
    SHARE_ANDROID_24("oct-share-android-24", '\uea3c'),
    SHIELD_16("oct-shield-16", '\uea3d'),
    SHIELD_24("oct-shield-24", '\uea3e'),
    SHIELD_CHECK_16("oct-shield-check-16", '\uea3f'),
    SHIELD_CHECK_24("oct-shield-check-24", '\uea40'),
    SHIELD_LOCK_16("oct-shield-lock-16", '\uea41'),
    SHIELD_LOCK_24("oct-shield-lock-24", '\uea42'),
    SHIELD_X_16("oct-shield-x-16", '\uea43'),
    SHIELD_X_24("oct-shield-x-24", '\uea44'),
    SIGN_IN_16("oct-sign-in-16", '\uea45'),
    SIGN_IN_24("oct-sign-in-24", '\uea46'),
    SIGN_OUT_16("oct-sign-out-16", '\uea47'),
    SIGN_OUT_24("oct-sign-out-24", '\uea48'),
    SKIP_16("oct-skip-16", '\uea49'),
    SKIP_24("oct-skip-24", '\uea4a'),
    SMILEY_16("oct-smiley-16", '\uea4b'),
    SMILEY_24("oct-smiley-24", '\uea4c'),
    SQUARE_16("oct-square-16", '\uea4d'),
    SQUARE_24("oct-square-24", '\uea4e'),
    SQUARE_FILL_16("oct-square-fill-16", '\uea4f'),
    SQUARE_FILL_24("oct-square-fill-24", '\uea50'),
    SQUIRREL_16("oct-squirrel-16", '\uea51'),
    STAR_16("oct-star-16", '\uea52'),
    STAR_24("oct-star-24", '\uea53'),
    STAR_FILL_16("oct-star-fill-16", '\uea54'),
    STAR_FILL_24("oct-star-fill-24", '\uea55'),
    STOPWATCH_16("oct-stopwatch-16", '\uea58'),
    STOPWATCH_24("oct-stopwatch-24", '\uea59'),
    STOP_16("oct-stop-16", '\uea56'),
    STOP_24("oct-stop-24", '\uea57'),
    SUN_16("oct-sun-16", '\uea5a'),
    SUN_24("oct-sun-24", '\uea5b'),
    SYNC_16("oct-sync-16", '\uea5c'),
    SYNC_24("oct-sync-24", '\uea5d'),
    TAB_24("oct-tab-24", '\uea5e'),
    TAG_16("oct-tag-16", '\uea5f'),
    TAG_24("oct-tag-24", '\uea60'),
    TASKLIST_16("oct-tasklist-16", '\uea61'),
    TASKLIST_24("oct-tasklist-24", '\uea62'),
    TELESCOPE_16("oct-telescope-16", '\uea63'),
    TELESCOPE_24("oct-telescope-24", '\uea64'),
    TERMINAL_16("oct-terminal-16", '\uea65'),
    TERMINAL_24("oct-terminal-24", '\uea66'),
    THREE_BARS_16("oct-three-bars-16", '\uea67'),
    THUMBSDOWN_16("oct-thumbsdown-16", '\uea68'),
    THUMBSDOWN_24("oct-thumbsdown-24", '\uea69'),
    THUMBSUP_16("oct-thumbsup-16", '\uea6a'),
    THUMBSUP_24("oct-thumbsup-24", '\uea6b'),
    TOOLS_16("oct-tools-16", '\uea6c'),
    TOOLS_24("oct-tools-24", '\uea6d'),
    TRASHCAN_16("oct-trashcan-16", '\uea6f'),
    TRASH_24("oct-trash-24", '\uea6e'),
    TRIANGLE_DOWN_16("oct-triangle-down-16", '\uea70'),
    TRIANGLE_DOWN_24("oct-triangle-down-24", '\uea71'),
    TRIANGLE_LEFT_16("oct-triangle-left-16", '\uea72'),
    TRIANGLE_LEFT_24("oct-triangle-left-24", '\uea73'),
    TRIANGLE_RIGHT_16("oct-triangle-right-16", '\uea74'),
    TRIANGLE_RIGHT_24("oct-triangle-right-24", '\uea75'),
    TRIANGLE_UP_16("oct-triangle-up-16", '\uea76'),
    TRIANGLE_UP_24("oct-triangle-up-24", '\uea77'),
    TYPOGRAPHY_16("oct-typography-16", '\uea78'),
    TYPOGRAPHY_24("oct-typography-24", '\uea79'),
    UNFOLD_16("oct-unfold-16", '\uea7a'),
    UNFOLD_24("oct-unfold-24", '\uea7b'),
    UNLOCK_16("oct-unlock-16", '\uea7c'),
    UNLOCK_24("oct-unlock-24", '\uea7d'),
    UNMUTE_16("oct-unmute-16", '\uea7e'),
    UNMUTE_24("oct-unmute-24", '\uea7f'),
    UNVERIFIED_16("oct-unverified-16", '\uea80'),
    UNVERIFIED_24("oct-unverified-24", '\uea81'),
    UPLOAD_16("oct-upload-16", '\uea82'),
    UPLOAD_24("oct-upload-24", '\uea83'),
    VERIFIED_16("oct-verified-16", '\uea84'),
    VERIFIED_24("oct-verified-24", '\uea85'),
    VERSIONS_16("oct-versions-16", '\uea86'),
    VERSIONS_24("oct-versions-24", '\uea87'),
    WORKFLOW_16("oct-workflow-16", '\uea88'),
    WORKFLOW_24("oct-workflow-24", '\uea89'),
    X_16("oct-x-16", '\uea8a'),
    X_24("oct-x-24", '\uea8b'),
    X_CIRCLE_16("oct-x-circle-16", '\uea8c'),
    X_CIRCLE_24("oct-x-circle-24", '\uea8d'),
    X_CIRCLE_FILL_16("oct-x-circle-fill-16", '\uea8e'),
    X_CIRCLE_FILL_24("oct-x-circle-fill-24", '\uea8f'),
    ZAP_16("oct-zap-16", '\uea90'),
    ZAP_24("oct-zap-24", '\uea91');

    public static Octicons findByDescription(String description) {
        for (Octicons font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Octicons(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}