/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2019 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.octicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Octicons implements Ikon {
    ALERT("oct-alert", '\uf02d'),
    ARROW_DOWN("oct-arrow-down", '\uf03f'),
    ARROW_LEFT("oct-arrow-left", '\uf040'),
    ARROW_RIGHT("oct-arrow-right", '\uf03e'),
    ARROW_SMALL_DOWN("oct-arrow-small-down", '\uf0a0'),
    ARROW_SMALL_LEFT("oct-arrow-small-left", '\uf0a1'),
    ARROW_SMALL_RIGHT("oct-arrow-small-right", '\uf071'),
    ARROW_SMALL_UP("oct-arrow-small-up", '\uf09f'),
    ARROW_UP("oct-arrow-up", '\uf03d'),
    BEAKER("oct-beaker", '\uf0dd'),
    BELL("oct-bell", '\uf0de'),
    BOLD("oct-bold", '\uf0e2'),
    BOOK("oct-book", '\uf007'),
    BOOKMARK("oct-bookmark", '\uf07b'),
    BRIEFCASE("oct-briefcase", '\uf0d3'),
    BROADCAST("oct-broadcast", '\uf048'),
    BROWSER("oct-browser", '\uf0c5'),
    BUG("oct-bug", '\uf091'),
    CALENDAR("oct-calendar", '\uf068'),
    CHECK("oct-check", '\uf03a'),
    CHECKLIST("oct-checklist", '\uf076'),
    CHEVRON_DOWN("oct-chevron-down", '\uf0a3'),
    CHEVRON_LEFT("oct-chevron-left", '\uf0a4'),
    CHEVRON_RIGHT("oct-chevron-right", '\uf078'),
    CHEVRON_UP("oct-chevron-up", '\uf0a2'),
    CIRCLE_SLASH("oct-circle-slash", '\uf084'),
    CIRCUIT_BOARD("oct-circuit-board", '\uf0d6'),
    CLIPPY("oct-clippy", '\uf035'),
    CLOCK("oct-clock", '\uf046'),
    CLOUD_DOWNLOAD("oct-cloud-download", '\uf00b'),
    CLOUD_UPLOAD("oct-cloud-upload", '\uf00c'),
    CODE("oct-code", '\uf05f'),
    COMMENT("oct-comment", '\uf02b'),
    COMMENT_DISCUSSION("oct-comment-discussion", '\uf04f'),
    CREDIT_CARD("oct-credit-card", '\uf045'),
    DASH("oct-dash", '\uf0ca'),
    DASHBOARD("oct-dashboard", '\uf07d'),
    DATABASE("oct-database", '\uf096'),
    DESKTOP_DOWNLOAD("oct-desktop-download", '\uf0dc'),
    DEVICE_CAMERA("oct-device-camera", '\uf056'),
    DEVICE_CAMERA_VIDEO("oct-device-camera-video", '\uf057'),
    DEVICE_DESKTOP("oct-device-desktop", '\uf27c'),
    DEVICE_MOBILE("oct-device-mobile", '\uf038'),
    DIFF("oct-diff", '\uf04d'),
    DIFF_ADDED("oct-diff-added", '\uf06b'),
    DIFF_IGNORED("oct-diff-ignored", '\uf099'),
    DIFF_MODIFIED("oct-diff-modified", '\uf06d'),
    DIFF_REMOVED("oct-diff-removed", '\uf06c'),
    DIFF_RENAMED("oct-diff-renamed", '\uf06e'),
    ELLIPSES("oct-ellipses", '\uf101'),
    ELLIPSIS("oct-ellipsis", '\uf09a'),
    EYE("oct-eye", '\uf04e'),
    FILE("oct-file", '\uf102'),
    FILE_BINARY("oct-file-binary", '\uf094'),
    FILE_CODE("oct-file-code", '\uf010'),
    FILE_DIRECTORY("oct-file-directory", '\uf016'),
    FILE_MEDIA("oct-file-media", '\uf012'),
    FILE_PDF("oct-file-pdf", '\uf014'),
    FILE_SUBMODULE("oct-file-submodule", '\uf017'),
    FILE_SYMLINK_DIRECTORY("oct-file-symlink-directory", '\uf0b1'),
    FILE_SYMLINK_FILE("oct-file-symlink-file", '\uf0b0'),
    FILE_TEXT("oct-file-text", '\uf011'),
    FILE_ZIP("oct-file-zip", '\uf013'),
    FLAME("oct-flame", '\uf0d2'),
    FOLD("oct-fold", '\uf0cc'),
    GEAR("oct-gear", '\uf02f'),
    GIFT("oct-gift", '\uf042'),
    GIST("oct-gist", '\uf00e'),
    GIST_SECRET("oct-gist-secret", '\uf08c'),
    GIT_BRANCH("oct-git-branch", '\uf020'),
    GIT_COMMIT("oct-git-commit", '\uf01f'),
    GIT_COMPARE("oct-git-compare", '\uf0ac'),
    GIT_MERGE("oct-git-merge", '\uf023'),
    GIT_PULL_REQUEST("oct-git-pull-request", '\uf009'),
    GLOBE("oct-globe", '\uf0b6'),
    GRABBER("oct-grabber", '\uf103'),
    GRAPH("oct-graph", '\uf043'),
    HEART("oct-heart", '\u2665'),
    HISTORY("oct-history", '\uf07e'),
    HOME("oct-home", '\uf08d'),
    HORIZONTAL_RULE("oct-horizontal-rule", '\uf070'),
    HUBOT("oct-hubot", '\uf09d'),
    INBOX("oct-inbox", '\uf0cf'),
    INFO("oct-info", '\uf059'),
    ISSUE_CLOSED("oct-issue-closed", '\uf028'),
    ISSUE_OPENED("oct-issue-opened", '\uf026'),
    ISSUE_REOPENED("oct-issue-reopened", '\uf027'),
    ITALIC("oct-italic", '\uf0e4'),
    JERSEY("oct-jersey", '\uf019'),
    KEY("oct-key", '\uf049'),
    KEYBOARD("oct-keyboard", '\uf00d'),
    LAW("oct-law", '\uf0d8'),
    LIGHT_BULB("oct-light-bulb", '\uf000'),
    LINK("oct-link", '\uf05c'),
    LINK_EXTERNAL("oct-link-external", '\uf07f'),
    LIST_ORDERED("oct-list-ordered", '\uf062'),
    LIST_UNORDERED("oct-list-unordered", '\uf061'),
    LOCATION("oct-location", '\uf060'),
    LOCK("oct-lock", '\uf06a'),
    LOGO_GIST("oct-logo-gist", '\uf0ad'),
    LOGO_GITHUB("oct-logo-github", '\uf092'),
    MAIL("oct-mail", '\uf03b'),
    MAIL_READ("oct-mail-read", '\uf03c'),
    MAIL_REPLY("oct-mail-reply", '\uf051'),
    MARKDOWN("oct-markdown", '\uf0c9'),
    MARK_GITHUB("oct-mark-github", '\uf00a'),
    MEGAPHONE("oct-megaphone", '\uf077'),
    MENTION("oct-mention", '\uf0be'),
    MILESTONE("oct-milestone", '\uf075'),
    MIRROR("oct-mirror", '\uf024'),
    MORTAR_BOARD("oct-mortar-board", '\uf0d7'),
    MUTE("oct-mute", '\uf080'),
    NO_NEWLINE("oct-no-newline", '\uf09c'),
    OCTOFACE("oct-octoface", '\uf008'),
    ORGANIZATION("oct-organization", '\uf037'),
    PACKAGE("oct-package", '\uf0c4'),
    PAINTCAN("oct-paintcan", '\uf0d1'),
    PENCIL("oct-pencil", '\uf058'),
    PERSON("oct-person", '\uf018'),
    PIN("oct-pin", '\uf041'),
    PLUG("oct-plug", '\uf0d4'),
    PLUS("oct-plus", '\uf05d'),
    PLUS_SMALL("oct-plus-small", '\uf104'),
    PRIMITIVE_DOT("oct-primitive-dot", '\uf052'),
    PRIMITIVE_SQUARE("oct-primitive-square", '\uf053'),
    PULSE("oct-pulse", '\uf085'),
    QUESTION("oct-question", '\uf02c'),
    QUOTE("oct-quote", '\uf063'),
    RADIO_TOWER("oct-radio-tower", '\uf030'),
    REPLY("oct-reply", '\uf105'),
    REPO("oct-repo", '\uf001'),
    REPO_CLONE("oct-repo-clone", '\uf04c'),
    REPO_FORCE_PUSH("oct-repo-force-push", '\uf04a'),
    REPO_FORKED("oct-repo-forked", '\uf002'),
    REPO_PULL("oct-repo-pull", '\uf006'),
    REPO_PUSH("oct-repo-push", '\uf005'),
    ROCKET("oct-rocket", '\uf033'),
    RSS("oct-rss", '\uf034'),
    RUBY("oct-ruby", '\uf047'),
    SEARCH("oct-search", '\uf02e'),
    SERVER("oct-server", '\uf097'),
    SETTINGS("oct-settings", '\uf07c'),
    SHIELD("oct-shield", '\uf0e1'),
    SIGN_IN("oct-sign-in", '\uf036'),
    SIGN_OUT("oct-sign-out", '\uf032'),
    SMILEY("oct-smiley", '\uf0e7'),
    SQUIRREL("oct-squirrel", '\uf0b2'),
    STAR("oct-star", '\uf02a'),
    STOP("oct-stop", '\uf08f'),
    SYNC("oct-sync", '\uf087'),
    TAG("oct-tag", '\uf015'),
    TASKLIST("oct-tasklist", '\uf0e5'),
    TELESCOPE("oct-telescope", '\uf088'),
    TERMINAL("oct-terminal", '\uf0c8'),
    TEXT_SIZE("oct-text-size", '\uf0e3'),
    THREE_BARS("oct-three-bars", '\uf05e'),
    THUMBSDOWN("oct-thumbsdown", '\uf0db'),
    THUMBSUP("oct-thumbsup", '\uf0da'),
    TOOLS("oct-tools", '\uf031'),
    TRASHCAN("oct-trashcan", '\uf0d0'),
    TRIANGLE_DOWN("oct-triangle-down", '\uf05b'),
    TRIANGLE_LEFT("oct-triangle-left", '\uf044'),
    TRIANGLE_RIGHT("oct-triangle-right", '\uf05a'),
    TRIANGLE_UP("oct-triangle-up", '\uf0aa'),
    UNFOLD("oct-unfold", '\uf039'),
    UNMUTE("oct-unmute", '\uf0ba'),
    UNVERIFIED("oct-unverified", '\uf0e8'),
    VERIFIED("oct-verified", '\uf0e6'),
    VERSIONS("oct-versions", '\uf064'),
    WATCH("oct-watch", '\uf0e0'),
    X("oct-x", '\uf081'),
    ZAP("oct-zap", '\u26a1');

    public static Octicons findByDescription(String description) {
        for (Octicons font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private char code;

    Octicons(String description, char code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public char getCode() {
        return code;
    }
}