/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2021 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.medicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Medicons implements Ikon {
    ACCESSIBILITY("medicon-accessibility", '\ue643'),
    ACCESSIBILITY_SQUARE("medicon-accessibility-square", '\ue671'),
    ADMINISTRATION("medicon-administration", '\ue624'),
    ADMINISTRATION_SQUARE("medicon-administration-square", '\ue670'),
    ALTERNATIVE_COMPLEMENTARY("medicon-alternative-complementary", '\ue623'),
    ALTERNATIVE_COMPLEMENTARY_SQUARE("medicon-alternative-complementary-square", '\ue66f'),
    AMBULANCE("medicon-ambulance", '\ue622'),
    AMBULANCE_SQUARE("medicon-ambulance-square", '\ue66e'),
    ANESTHESIA("medicon-anesthesia", '\ue621'),
    ANESTHESIA_SQUARE("medicon-anesthesia-square", '\ue66d'),
    BILLING("medicon-billing", '\ue620'),
    BILLING_SQUARE("medicon-billing-square", '\ue66c'),
    CARDIOLOGY("medicon-cardiology", '\ue61f'),
    CARDIOLOGY_SQUARE("medicon-cardiology-square", '\ue66b'),
    CARE_STAFF_AREA("medicon-care-staff-area", '\ue642'),
    CARE_STAFF_AREA_SQUARE("medicon-care-staff-area-square", '\ue68d'),
    CATH_LAB("medicon-cath-lab", '\ue641'),
    CATH_LAB_SQUARE("medicon-cath-lab-square", '\ue68c'),
    CHAPEL("medicon-chapel", '\ue640'),
    CHAPEL_SQUARE("medicon-chapel-square", '\ue68b'),
    COFFEE_SHOP("medicon-coffee-shop", '\ue63f'),
    COFFEE_SHOP_SQUARE("medicon-coffee-shop-square", '\ue68a'),
    DENTAL("medicon-dental", '\ue63e'),
    DENTAL_SQUARE("medicon-dental-square", '\ue689'),
    DERMATOLOGY("medicon-dermatology", '\ue63d'),
    DERMATOLOGY_SQUARE("medicon-dermatology-square", '\ue68f'),
    DIABETES_EDUCATION("medicon-diabetes-education", '\ue644'),
    DIABETES_EDUCATION_SQUARE("medicon-diabetes-education-square", '\ue66a'),
    DRINKING_FOUNTAIN("medicon-drinking-fountain", '\ue61e'),
    DRINKING_FOUNTAIN_SQUARE("medicon-drinking-fountain-square", '\ue669'),
    EAR_NOSE_THROAT("medicon-ear-nose-throat", '\ue61d'),
    EAR_NOSE_THROAT_SQUARE("medicon-ear-nose-throat-square", '\ue668'),
    ELEVATORS("medicon-elevators", '\ue61c'),
    ELEVATORS_SQUARE("medicon-elevators-square", '\ue667'),
    EMERGENCY("medicon-emergency", '\ue61b'),
    EMERGENCY_SQUARE("medicon-emergency-square", '\ue666'),
    FAMILY_PRACTICE("medicon-family-practice", '\ue61a'),
    FAMILY_PRACTICE_SQUARE("medicon-family-practice-square", '\ue665'),
    FIRE_EXTINGUISHER("medicon-fire-extinguisher", '\ue619'),
    FIRE_EXTINGUISHER_SQUARE("medicon-fire-extinguisher-square", '\ue664'),
    FIRST_AID("medicon-first-aid", '\ue63c'),
    FIRST_AID_SQUARE("medicon-first-aid-square", '\ue688'),
    GENETICS("medicon-genetics", '\ue63b'),
    GENETICS_SQUARE("medicon-genetics-square", '\ue687'),
    GIFT_SHOP("medicon-gift-shop", '\ue63a'),
    GIFT_SHOP_SQUARE("medicon-gift-shop-square", '\ue686'),
    HEALTH_EDUCATION("medicon-health-education", '\ue639'),
    HEALTH_EDUCATION_SQUARE("medicon-health-education-square", '\ue685'),
    HEALTH_SERVICES("medicon-health-services", '\ue638'),
    HEALTH_SERVICES_SQUARE("medicon-health-services-square", '\ue684'),
    HEARING_ASSISTANCE("medicon-hearing-assistance", '\ue637'),
    HEARING_ASSISTANCE_SQUARE("medicon-hearing-assistance-square", '\ue683'),
    HOSPITAL("medicon-hospital", '\ue645'),
    HOSPITAL_SQUARE("medicon-hospital-square", '\ue663'),
    IMAGING_ALTERNATIVE_CT("medicon-imaging-alternative-ct", '\ue618'),
    IMAGING_ALTERNATIVE_CT_SQUARE("medicon-imaging-alternative-ct-square", '\ue662'),
    IMAGING_ALTERNATIVE_MRI("medicon-imaging-alternative-mri", '\ue616'),
    IMAGING_ALTERNATIVE_MRI_SQUARE("medicon-imaging-alternative-mri-square", '\ue660'),
    IMAGING_ALTERNATIVE_MRI_TWO("medicon-imaging-alternative-mri-two", '\ue617'),
    IMAGING_ALTERNATIVE_MRI_TWO_SQUARE("medicon-imaging-alternative-mri-two-square", '\ue661'),
    IMAGING_ALTERNATIVE_PET("medicon-imaging-alternative-pet", '\ue615'),
    IMAGING_ALTERNATIVE_PET_SQUARE("medicon-imaging-alternative-pet-square", '\ue65f'),
    IMAGING_ROOT_CATEGORY("medicon-imaging-root-category", '\ue614'),
    IMAGING_ROOT_CATEGORY_SQUARE("medicon-imaging-root-category-square", '\ue65e'),
    IMMUNIZATIONS("medicon-immunizations", '\ue613'),
    IMMUNIZATIONS_SQUARE("medicon-immunizations-square", '\ue65d'),
    INFECTIOUS_DISEASES("medicon-infectious-diseases", '\ue636'),
    INFECTIOUS_DISEASES_SQUARE("medicon-infectious-diseases-square", '\ue682'),
    INFORMATION_US("medicon-information-us", '\ue635'),
    INFORMATION_US_SQUARE("medicon-information-us-square", '\ue681'),
    INPATIENT("medicon-inpatient", '\ue634'),
    INPATIENT_SQUARE("medicon-inpatient-square", '\ue680'),
    INTENSIVE_CARE("medicon-intensive-care", '\ue633'),
    INTENSIVE_CARE_SQUARE("medicon-intensive-care-square", '\ue67f'),
    INTERNAL_MEDICINE("medicon-internal-medicine", '\ue632'),
    INTERNAL_MEDICINE_SQUARE("medicon-internal-medicine-square", '\ue67e'),
    INTERPRETER_SERVICES("medicon-interpreter-services", '\ue631'),
    INTERPRETER_SERVICES_SQUARE("medicon-interpreter-services-square", '\ue67d'),
    KIDNEY("medicon-kidney", '\ue646'),
    KIDNEY_SQUARE("medicon-kidney-square", '\ue65c'),
    LABORATORY("medicon-laboratory", '\ue611'),
    LABORATORY_SQUARE("medicon-laboratory-square", '\ue65a'),
    LABOR_DELIVERY("medicon-labor-delivery", '\ue612'),
    LABOR_DELIVERY_SQUARE("medicon-labor-delivery-square", '\ue65b'),
    MAMMOGRAPHY("medicon-mammography", '\ue610'),
    MAMMOGRAPHY_SQUARE("medicon-mammography-square", '\ue659'),
    MEDICAL_LIBRARY("medicon-medical-library", '\ue60f'),
    MEDICAL_LIBRARY_SQUARE("medicon-medical-library-square", '\ue658'),
    MEDICAL_RECORDS("medicon-medical-records", '\ue60e'),
    MEDICAL_RECORDS_SQUARE("medicon-medical-records-square", '\ue657'),
    MENTAL_HEALTH("medicon-mental-health", '\ue60d'),
    MENTAL_HEALTH_SQUARE("medicon-mental-health-square", '\ue656'),
    MRI_PET("medicon-mri-pet", '\ue630'),
    MRI_PET_SQUARE("medicon-mri-pet-square", '\ue67c'),
    NEUROLOGY("medicon-neurology", '\ue62f'),
    NEUROLOGY_SQUARE("medicon-neurology-square", '\ue67b'),
    NO_SMOKING("medicon-no-smoking", '\ue62e'),
    NO_SMOKING_SQUARE("medicon-no-smoking-square", '\ue67a'),
    NURSERY("medicon-nursery", '\ue62d'),
    NURSERY_SQUARE("medicon-nursery-square", '\ue679'),
    NUTRITION("medicon-nutrition", '\ue62c'),
    NUTRITION_SQUARE("medicon-nutrition-square", '\ue678'),
    ONCOLOGY("medicon-oncology", '\ue62b'),
    ONCOLOGY_SQUARE("medicon-oncology-square", '\ue677'),
    OPHTHALMOLOGY("medicon-ophthalmology", '\ue647'),
    OPHTHALMOLOGY_SQUARE("medicon-ophthalmology-square", '\ue655'),
    OUTPATIENT("medicon-outpatient", '\ue60c'),
    OUTPATIENT_SQUARE("medicon-outpatient-square", '\ue654'),
    PATHOLOGY("medicon-pathology", '\ue60b'),
    PATHOLOGY_SQUARE("medicon-pathology-square", '\ue653'),
    PEDIATRICS("medicon-pediatrics", '\ue60a'),
    PEDIATRICS_SQUARE("medicon-pediatrics-square", '\ue652'),
    PHARMACY("medicon-pharmacy", '\ue609'),
    PHARMACY_SQUARE("medicon-pharmacy-square", '\ue651'),
    PHYSICAL_THERAPY("medicon-physical-therapy", '\ue608'),
    PHYSICAL_THERAPY_SQUARE("medicon-physical-therapy-square", '\ue650'),
    RADIOLOGY("medicon-radiology", '\ue607'),
    RADIOLOGY_SQUARE("medicon-radiology-square", '\ue64f'),
    REGISTRATION("medicon-registration", '\ue62a'),
    REGISTRATION_SQUARE("medicon-registration-square", '\ue68e'),
    RESPIRATORY("medicon-respiratory", '\ue629'),
    RESPIRATORY_SQUARE("medicon-respiratory-square", '\ue676'),
    RESTAURANT("medicon-restaurant", '\ue628'),
    RESTAURANT_SQUARE("medicon-restaurant-square", '\ue675'),
    RESTROOMS("medicon-restrooms", '\ue627'),
    RESTROOMS_SQUARE("medicon-restrooms-square", '\ue674'),
    SMOKING("medicon-smoking", '\ue626'),
    SMOKING_SQUARE("medicon-smoking-square", '\ue673'),
    SOCIAL_SERVICES("medicon-social-services", '\ue625'),
    SOCIAL_SERVICES_SQUARE("medicon-social-services-square", '\ue672'),
    STAIRS("medicon-stairs", '\ue606'),
    STAIRS_SQUARE("medicon-stairs-square", '\ue64e'),
    SURGERY("medicon-surgery", '\ue605'),
    SURGERY_SQUARE("medicon-surgery-square", '\ue64d'),
    TEXT_TELEPHONE("medicon-text-telephone", '\ue604'),
    TEXT_TELEPHONE_SQUARE("medicon-text-telephone-square", '\ue64c'),
    ULTRASOUND("medicon-ultrasound", '\ue603'),
    ULTRASOUND_SQUARE("medicon-ultrasound-square", '\ue64b'),
    VOLUME_CONTROL("medicon-volume-control", '\ue602'),
    VOLUME_CONTROL_SQUARE("medicon-volume-control-square", '\ue64a'),
    WAITING_AREA("medicon-waiting-area", '\ue601'),
    WAITING_AREA_SQUARE("medicon-waiting-area-square", '\ue649'),
    WOMENS_HEALTH("medicon-womens-health", '\ue600'),
    WOMENS_HEALTH_SQUARE("medicon-womens-health-square", '\ue648');

    public static Medicons findByDescription(String description) {
        for (Medicons font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Medicons(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}