/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material implements Ikon {
    GMI_10K("gmi-10k", '\ue951'),
    GMI_10MP("gmi-10mp", '\ue952'),
    GMI_11MP("gmi-11mp", '\ue953'),
    GMI_12MP("gmi-12mp", '\ue954'),
    GMI_13MP("gmi-13mp", '\ue955'),
    GMI_14MP("gmi-14mp", '\ue956'),
    GMI_15MP("gmi-15mp", '\ue957'),
    GMI_16MP("gmi-16mp", '\ue958'),
    GMI_17MP("gmi-17mp", '\ue959'),
    GMI_18MP("gmi-18mp", '\ue95a'),
    GMI_19MP("gmi-19mp", '\ue95b'),
    GMI_1K("gmi-1k", '\ue95c'),
    GMI_1K_PLUS("gmi-1k-plus", '\ue95d'),
    GMI_20MP("gmi-20mp", '\ue95e'),
    GMI_21MP("gmi-21mp", '\ue95f'),
    GMI_22MP("gmi-22mp", '\ue960'),
    GMI_23MP("gmi-23mp", '\ue961'),
    GMI_24MP("gmi-24mp", '\ue962'),
    GMI_2K("gmi-2k", '\ue963'),
    GMI_2K_PLUS("gmi-2k-plus", '\ue964'),
    GMI_2MP("gmi-2mp", '\ue965'),
    GMI_360("gmi-360", '\ue577'),
    GMI_3D_ROTATION("gmi-3d-rotation", '\ue84d'),
    GMI_3K("gmi-3k", '\ue966'),
    GMI_3K_PLUS("gmi-3k-plus", '\ue967'),
    GMI_3MP("gmi-3mp", '\ue968'),
    GMI_4K("gmi-4k", '\ue072'),
    GMI_4K_PLUS("gmi-4k-plus", '\ue969'),
    GMI_4MP("gmi-4mp", '\ue96a'),
    GMI_5K("gmi-5k", '\ue96b'),
    GMI_5K_PLUS("gmi-5k-plus", '\ue96c'),
    GMI_5MP("gmi-5mp", '\ue96d'),
    GMI_6K("gmi-6k", '\ue96e'),
    GMI_6K_PLUS("gmi-6k-plus", '\ue96f'),
    GMI_6MP("gmi-6mp", '\ue970'),
    GMI_7K("gmi-7k", '\ue971'),
    GMI_7K_PLUS("gmi-7k-plus", '\ue972'),
    GMI_7MP("gmi-7mp", '\ue973'),
    GMI_8K("gmi-8k", '\ue974'),
    GMI_8K_PLUS("gmi-8k-plus", '\ue975'),
    GMI_8MP("gmi-8mp", '\ue976'),
    GMI_9K("gmi-9k", '\ue977'),
    GMI_9K_PLUS("gmi-9k-plus", '\ue978'),
    GMI_9MP("gmi-9mp", '\ue979'),
    AC_UNIT("gmi-ac-unit", '\ueb3b'),
    ACCESS_ALARM("gmi-access-alarm", '\ue190'),
    ACCESS_ALARMS("gmi-access-alarms", '\ue191'),
    ACCESS_TIME("gmi-access-time", '\ue192'),
    ACCESSIBILITY("gmi-accessibility", '\ue84e'),
    ACCESSIBILITY_NEW("gmi-accessibility-new", '\ue92c'),
    ACCESSIBLE("gmi-accessible", '\ue914'),
    ACCESSIBLE_FORWARD("gmi-accessible-forward", '\ue934'),
    ACCOUNT_BALANCE("gmi-account-balance", '\ue84f'),
    ACCOUNT_BALANCE_WALLET("gmi-account-balance-wallet", '\ue850'),
    ACCOUNT_BOX("gmi-account-box", '\ue851'),
    ACCOUNT_CIRCLE("gmi-account-circle", '\ue853'),
    ACCOUNT_TREE("gmi-account-tree", '\ue97a'),
    ADB("gmi-adb", '\ue60e'),
    ADD("gmi-add", '\ue145'),
    ADD_A_PHOTO("gmi-add-a-photo", '\ue439'),
    ADD_ALARM("gmi-add-alarm", '\ue193'),
    ADD_ALERT("gmi-add-alert", '\ue003'),
    ADD_BOX("gmi-add-box", '\ue146'),
    ADD_CALL("gmi-add-call", '\ue0e8'),
    ADD_CHART("gmi-add-chart", '\ue97b'),
    ADD_CIRCLE("gmi-add-circle", '\ue147'),
    ADD_CIRCLE_OUTLINE("gmi-add-circle-outline", '\ue148'),
    ADD_COMMENT("gmi-add-comment", '\ue266'),
    ADD_IC_CALL("gmi-add-ic-call", '\ue97c'),
    ADD_LINK("gmi-add-link", '\ue178'),
    ADD_LOCATION("gmi-add-location", '\ue567'),
    ADD_MODERATOR("gmi-add-moderator", '\ue97d'),
    ADD_PHOTO_ALTERNATE("gmi-add-photo-alternate", '\ue43e'),
    ADD_SHOPPING_CART("gmi-add-shopping-cart", '\ue854'),
    ADD_TO_HOME_SCREEN("gmi-add-to-home-screen", '\ue1fe'),
    ADD_TO_PHOTOS("gmi-add-to-photos", '\ue39d'),
    ADD_TO_QUEUE("gmi-add-to-queue", '\ue05c'),
    ADJUST("gmi-adjust", '\ue39e'),
    AIRLINE_SEAT_FLAT("gmi-airline-seat-flat", '\ue630'),
    AIRLINE_SEAT_FLAT_ANGLED("gmi-airline-seat-flat-angled", '\ue631'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("gmi-airline-seat-individual-suite", '\ue632'),
    AIRLINE_SEAT_LEGROOM_EXTRA("gmi-airline-seat-legroom-extra", '\ue633'),
    AIRLINE_SEAT_LEGROOM_NORMAL("gmi-airline-seat-legroom-normal", '\ue634'),
    AIRLINE_SEAT_LEGROOM_REDUCED("gmi-airline-seat-legroom-reduced", '\ue635'),
    AIRLINE_SEAT_RECLINE_EXTRA("gmi-airline-seat-recline-extra", '\ue636'),
    AIRLINE_SEAT_RECLINE_NORMAL("gmi-airline-seat-recline-normal", '\ue637'),
    AIRPLANEMODE_ACTIVE("gmi-airplanemode-active", '\ue195'),
    AIRPLANEMODE_INACTIVE("gmi-airplanemode-inactive", '\ue194'),
    AIRPLANEMODE_OFF("gmi-airplanemode-off", '\ue194'),
    AIRPLANEMODE_ON("gmi-airplanemode-on", '\ue195'),
    AIRPLAY("gmi-airplay", '\ue055'),
    AIRPORT_SHUTTLE("gmi-airport-shuttle", '\ueb3c'),
    ALARM("gmi-alarm", '\ue855'),
    ALARM_ADD("gmi-alarm-add", '\ue856'),
    ALARM_OFF("gmi-alarm-off", '\ue857'),
    ALARM_ON("gmi-alarm-on", '\ue858'),
    ALBUM("gmi-album", '\ue019'),
    ALL_INBOX("gmi-all-inbox", '\ue97f'),
    ALL_INCLUSIVE("gmi-all-inclusive", '\ueb3d'),
    ALL_OUT("gmi-all-out", '\ue90b'),
    ALTERNATE_EMAIL("gmi-alternate-email", '\ue0e6'),
    AMP_STORIES("gmi-amp-stories", '\uea13'),
    ANDROID("gmi-android", '\ue859'),
    ANNOUNCEMENT("gmi-announcement", '\ue85a'),
    APARTMENT("gmi-apartment", '\uea40'),
    APPROVAL("gmi-approval", '\ue982'),
    APPS("gmi-apps", '\ue5c3'),
    ARCHIVE("gmi-archive", '\ue149'),
    ARROW_BACK("gmi-arrow-back", '\ue5c4'),
    ARROW_BACK_IOS("gmi-arrow-back-ios", '\ue5e0'),
    ARROW_DOWNWARD("gmi-arrow-downward", '\ue5db'),
    ARROW_DROP_DOWN("gmi-arrow-drop-down", '\ue5c5'),
    ARROW_DROP_DOWN_CIRCLE("gmi-arrow-drop-down-circle", '\ue5c6'),
    ARROW_DROP_UP("gmi-arrow-drop-up", '\ue5c7'),
    ARROW_FORWARD("gmi-arrow-forward", '\ue5c8'),
    ARROW_FORWARD_IOS("gmi-arrow-forward-ios", '\ue5e1'),
    ARROW_LEFT("gmi-arrow-left", '\ue5de'),
    ARROW_RIGHT("gmi-arrow-right", '\ue5df'),
    ARROW_RIGHT_ALT("gmi-arrow-right-alt", '\ue941'),
    ARROW_UPWARD("gmi-arrow-upward", '\ue5d8'),
    ART_TRACK("gmi-art-track", '\ue060'),
    ASPECT_RATIO("gmi-aspect-ratio", '\ue85b'),
    ASSESSMENT("gmi-assessment", '\ue85c'),
    ASSIGNMENT("gmi-assignment", '\ue85d'),
    ASSIGNMENT_IND("gmi-assignment-ind", '\ue85e'),
    ASSIGNMENT_LATE("gmi-assignment-late", '\ue85f'),
    ASSIGNMENT_RETURN("gmi-assignment-return", '\ue860'),
    ASSIGNMENT_RETURNED("gmi-assignment-returned", '\ue861'),
    ASSIGNMENT_TURNED_IN("gmi-assignment-turned-in", '\ue862'),
    ASSISTANT("gmi-assistant", '\ue39f'),
    ASSISTANT_DIRECTION("gmi-assistant-direction", '\ue988'),
    ASSISTANT_NAVIGATION("gmi-assistant-navigation", '\ue989'),
    ASSISTANT_PHOTO("gmi-assistant-photo", '\ue3a0'),
    ATM("gmi-atm", '\ue573'),
    ATTACH_FILE("gmi-attach-file", '\ue226'),
    ATTACH_MONEY("gmi-attach-money", '\ue227'),
    ATTACHMENT("gmi-attachment", '\ue2bc'),
    ATTRACTIONS("gmi-attractions", '\uea52'),
    AUDIOTRACK("gmi-audiotrack", '\ue3a1'),
    AUTORENEW("gmi-autorenew", '\ue863'),
    AV_TIMER("gmi-av-timer", '\ue01b'),
    BACKSPACE("gmi-backspace", '\ue14a'),
    BACKUP("gmi-backup", '\ue864'),
    BADGE("gmi-badge", '\uea67'),
    BAKERY_DINING("gmi-bakery-dining", '\uea53'),
    BALLOT("gmi-ballot", '\ue172'),
    BAR_CHART("gmi-bar-chart", '\ue26b'),
    BATHTUB("gmi-bathtub", '\uea41'),
    BATTERY_ALERT("gmi-battery-alert", '\ue19c'),
    BATTERY_CHARGING_FULL("gmi-battery-charging-full", '\ue1a3'),
    BATTERY_FULL("gmi-battery-full", '\ue1a4'),
    BATTERY_STD("gmi-battery-std", '\ue1a5'),
    BATTERY_UNKNOWN("gmi-battery-unknown", '\ue1a6'),
    BEACH_ACCESS("gmi-beach-access", '\ueb3e'),
    BEENHERE("gmi-beenhere", '\ue52d'),
    BLOCK("gmi-block", '\ue14b'),
    BLUETOOTH("gmi-bluetooth", '\ue1a7'),
    BLUETOOTH_AUDIO("gmi-bluetooth-audio", '\ue60f'),
    BLUETOOTH_CONNECTED("gmi-bluetooth-connected", '\ue1a8'),
    BLUETOOTH_DISABLED("gmi-bluetooth-disabled", '\ue1a9'),
    BLUETOOTH_SEARCHING("gmi-bluetooth-searching", '\ue1aa'),
    BLUR_CIRCULAR("gmi-blur-circular", '\ue3a2'),
    BLUR_LINEAR("gmi-blur-linear", '\ue3a3'),
    BLUR_OFF("gmi-blur-off", '\ue3a4'),
    BLUR_ON("gmi-blur-on", '\ue3a5'),
    BOLT("gmi-bolt", '\uea0b'),
    BOOK("gmi-book", '\ue865'),
    BOOKMARK("gmi-bookmark", '\ue866'),
    BOOKMARK_BORDER("gmi-bookmark-border", '\ue867'),
    BOOKMARK_OUTLINE("gmi-bookmark-outline", '\ue867'),
    BOOKMARKS("gmi-bookmarks", '\ue98b'),
    BORDER_ALL("gmi-border-all", '\ue228'),
    BORDER_BOTTOM("gmi-border-bottom", '\ue229'),
    BORDER_CLEAR("gmi-border-clear", '\ue22a'),
    BORDER_COLOR("gmi-border-color", '\ue22b'),
    BORDER_HORIZONTAL("gmi-border-horizontal", '\ue22c'),
    BORDER_INNER("gmi-border-inner", '\ue22d'),
    BORDER_LEFT("gmi-border-left", '\ue22e'),
    BORDER_OUTER("gmi-border-outer", '\ue22f'),
    BORDER_RIGHT("gmi-border-right", '\ue230'),
    BORDER_STYLE("gmi-border-style", '\ue231'),
    BORDER_TOP("gmi-border-top", '\ue232'),
    BORDER_VERTICAL("gmi-border-vertical", '\ue233'),
    BRANDING_WATERMARK("gmi-branding-watermark", '\ue06b'),
    BREAKFAST_DINING("gmi-breakfast-dining", '\uea54'),
    BRIGHTNESS_1("gmi-brightness-1", '\ue3a6'),
    BRIGHTNESS_2("gmi-brightness-2", '\ue3a7'),
    BRIGHTNESS_3("gmi-brightness-3", '\ue3a8'),
    BRIGHTNESS_4("gmi-brightness-4", '\ue3a9'),
    BRIGHTNESS_5("gmi-brightness-5", '\ue3aa'),
    BRIGHTNESS_6("gmi-brightness-6", '\ue3ab'),
    BRIGHTNESS_7("gmi-brightness-7", '\ue3ac'),
    BRIGHTNESS_AUTO("gmi-brightness-auto", '\ue1ab'),
    BRIGHTNESS_HIGH("gmi-brightness-high", '\ue1ac'),
    BRIGHTNESS_LOW("gmi-brightness-low", '\ue1ad'),
    BRIGHTNESS_MEDIUM("gmi-brightness-medium", '\ue1ae'),
    BROKEN_IMAGE("gmi-broken-image", '\ue3ad'),
    BRUNCH_DINING("gmi-brunch-dining", '\uea73'),
    BRUSH("gmi-brush", '\ue3ae'),
    BUBBLE_CHART("gmi-bubble-chart", '\ue6dd'),
    BUG_REPORT("gmi-bug-report", '\ue868'),
    BUILD("gmi-build", '\ue869'),
    BURST_MODE("gmi-burst-mode", '\ue43c'),
    BUS_ALERT("gmi-bus-alert", '\ue98f'),
    BUSINESS("gmi-business", '\ue0af'),
    BUSINESS_CENTER("gmi-business-center", '\ueb3f'),
    CACHED("gmi-cached", '\ue86a'),
    CAKE("gmi-cake", '\ue7e9'),
    CALENDAR_TODAY("gmi-calendar-today", '\ue935'),
    CALENDAR_VIEW_DAY("gmi-calendar-view-day", '\ue936'),
    CALL("gmi-call", '\ue0b0'),
    CALL_END("gmi-call-end", '\ue0b1'),
    CALL_MADE("gmi-call-made", '\ue0b2'),
    CALL_MERGE("gmi-call-merge", '\ue0b3'),
    CALL_MISSED("gmi-call-missed", '\ue0b4'),
    CALL_MISSED_OUTGOING("gmi-call-missed-outgoing", '\ue0e4'),
    CALL_RECEIVED("gmi-call-received", '\ue0b5'),
    CALL_SPLIT("gmi-call-split", '\ue0b6'),
    CALL_TO_ACTION("gmi-call-to-action", '\ue06c'),
    CAMERA("gmi-camera", '\ue3af'),
    CAMERA_ALT("gmi-camera-alt", '\ue3b0'),
    CAMERA_ENHANCE("gmi-camera-enhance", '\ue8fc'),
    CAMERA_FRONT("gmi-camera-front", '\ue3b1'),
    CAMERA_REAR("gmi-camera-rear", '\ue3b2'),
    CAMERA_ROLL("gmi-camera-roll", '\ue3b3'),
    CANCEL("gmi-cancel", '\ue5c9'),
    CANCEL_PRESENTATION("gmi-cancel-presentation", '\ue0e9'),
    CANCEL_SCHEDULE_SEND("gmi-cancel-schedule-send", '\uea39'),
    CAR_RENTAL("gmi-car-rental", '\uea55'),
    CAR_REPAIR("gmi-car-repair", '\uea56'),
    CARD_GIFTCARD("gmi-card-giftcard", '\ue8f6'),
    CARD_MEMBERSHIP("gmi-card-membership", '\ue8f7'),
    CARD_TRAVEL("gmi-card-travel", '\ue8f8'),
    CASES("gmi-cases", '\ue992'),
    CASINO("gmi-casino", '\ueb40'),
    CAST("gmi-cast", '\ue307'),
    CAST_CONNECTED("gmi-cast-connected", '\ue308'),
    CATEGORY("gmi-category", '\ue574'),
    CELEBRATION("gmi-celebration", '\uea65'),
    CELL_WIFI("gmi-cell-wifi", '\ue0ec'),
    CENTER_FOCUS_STRONG("gmi-center-focus-strong", '\ue3b4'),
    CENTER_FOCUS_WEAK("gmi-center-focus-weak", '\ue3b5'),
    CHANGE_HISTORY("gmi-change-history", '\ue86b'),
    CHAT("gmi-chat", '\ue0b7'),
    CHAT_BUBBLE("gmi-chat-bubble", '\ue0ca'),
    CHAT_BUBBLE_OUTLINE("gmi-chat-bubble-outline", '\ue0cb'),
    CHECK("gmi-check", '\ue5ca'),
    CHECK_BOX("gmi-check-box", '\ue834'),
    CHECK_BOX_OUTLINE_BLANK("gmi-check-box-outline-blank", '\ue835'),
    CHECK_CIRCLE("gmi-check-circle", '\ue86c'),
    CHECK_CIRCLE_OUTLINE("gmi-check-circle-outline", '\ue92d'),
    CHEVRON_LEFT("gmi-chevron-left", '\ue5cb'),
    CHEVRON_RIGHT("gmi-chevron-right", '\ue5cc'),
    CHILD_CARE("gmi-child-care", '\ueb41'),
    CHILD_FRIENDLY("gmi-child-friendly", '\ueb42'),
    CHROME_READER_MODE("gmi-chrome-reader-mode", '\ue86d'),
    CIRCLE_NOTIFICATIONS("gmi-circle-notifications", '\ue994'),
    CLASS("gmi-class", '\ue86e'),
    CLEAR("gmi-clear", '\ue14c'),
    CLEAR_ALL("gmi-clear-all", '\ue0b8'),
    CLOSE("gmi-close", '\ue5cd'),
    CLOSED_CAPTION("gmi-closed-caption", '\ue01c'),
    CLOSED_CAPTION_OFF("gmi-closed-caption-off", '\ue996'),
    CLOUD("gmi-cloud", '\ue2bd'),
    CLOUD_CIRCLE("gmi-cloud-circle", '\ue2be'),
    CLOUD_DONE("gmi-cloud-done", '\ue2bf'),
    CLOUD_DOWNLOAD("gmi-cloud-download", '\ue2c0'),
    CLOUD_OFF("gmi-cloud-off", '\ue2c1'),
    CLOUD_QUEUE("gmi-cloud-queue", '\ue2c2'),
    CLOUD_UPLOAD("gmi-cloud-upload", '\ue2c3'),
    CODE("gmi-code", '\ue86f'),
    COLLECTIONS("gmi-collections", '\ue3b6'),
    COLLECTIONS_BOOKMARK("gmi-collections-bookmark", '\ue431'),
    COLOR_LENS("gmi-color-lens", '\ue3b7'),
    COLORIZE("gmi-colorize", '\ue3b8'),
    COMMENT("gmi-comment", '\ue0b9'),
    COMMUTE("gmi-commute", '\ue940'),
    COMPARE("gmi-compare", '\ue3b9'),
    COMPARE_ARROWS("gmi-compare-arrows", '\ue915'),
    COMPASS_CALIBRATION("gmi-compass-calibration", '\ue57c'),
    COMPRESS("gmi-compress", '\ue94d'),
    COMPUTER("gmi-computer", '\ue30a'),
    CONFIRMATION_NUM("gmi-confirmation-num", '\ue638'),
    CONFIRMATION_NUMBER("gmi-confirmation-number", '\ue638'),
    CONNECTED_TV("gmi-connected-tv", '\ue998'),
    CONTACT_MAIL("gmi-contact-mail", '\ue0d0'),
    CONTACT_PHONE("gmi-contact-phone", '\ue0cf'),
    CONTACT_SUPPORT("gmi-contact-support", '\ue94c'),
    CONTACTLESS("gmi-contactless", '\uea71'),
    CONTACTS("gmi-contacts", '\ue0ba'),
    CONTENT_COPY("gmi-content-copy", '\ue14d'),
    CONTENT_CUT("gmi-content-cut", '\ue14e'),
    CONTENT_PASTE("gmi-content-paste", '\ue14f'),
    CONTROL_CAMERA("gmi-control-camera", '\ue074'),
    CONTROL_POINT("gmi-control-point", '\ue3ba'),
    CONTROL_POINT_DUPLICATE("gmi-control-point-duplicate", '\ue3bb'),
    COPYRIGHT("gmi-copyright", '\ue90c'),
    CREATE("gmi-create", '\ue150'),
    CREATE_NEW_FOLDER("gmi-create-new-folder", '\ue2cc'),
    CREDIT_CARD("gmi-credit-card", '\ue870'),
    CROP("gmi-crop", '\ue3be'),
    CROP_16_9("gmi-crop-16-9", '\ue3bc'),
    CROP_3_2("gmi-crop-3-2", '\ue3bd'),
    CROP_5_4("gmi-crop-5-4", '\ue3bf'),
    CROP_7_5("gmi-crop-7-5", '\ue3c0'),
    CROP_DIN("gmi-crop-din", '\ue3c1'),
    CROP_FREE("gmi-crop-free", '\ue3c2'),
    CROP_LANDSCAPE("gmi-crop-landscape", '\ue3c3'),
    CROP_ORIGINAL("gmi-crop-original", '\ue3c4'),
    CROP_PORTRAIT("gmi-crop-portrait", '\ue3c5'),
    CROP_ROTATE("gmi-crop-rotate", '\ue437'),
    CROP_SQUARE("gmi-crop-square", '\ue3c6'),
    DANGEROUS("gmi-dangerous", '\ue99a'),
    DASHBOARD("gmi-dashboard", '\ue871'),
    DASHBOARD_CUSTOMIZE("gmi-dashboard-customize", '\ue99b'),
    DATA_USAGE("gmi-data-usage", '\ue1af'),
    DATE_RANGE("gmi-date-range", '\ue916'),
    DECK("gmi-deck", '\uea42'),
    DEHAZE("gmi-dehaze", '\ue3c7'),
    DELETE("gmi-delete", '\ue872'),
    DELETE_FOREVER("gmi-delete-forever", '\ue92b'),
    DELETE_OUTLINE("gmi-delete-outline", '\ue92e'),
    DELETE_SWEEP("gmi-delete-sweep", '\ue16c'),
    DELIVERY_DINING("gmi-delivery-dining", '\uea72'),
    DEPARTURE_BOARD("gmi-departure-board", '\ue576'),
    DESCRIPTION("gmi-description", '\ue873'),
    DESKTOP_ACCESS_DISABLED("gmi-desktop-access-disabled", '\ue99d'),
    DESKTOP_MAC("gmi-desktop-mac", '\ue30b'),
    DESKTOP_WINDOWS("gmi-desktop-windows", '\ue30c'),
    DETAILS("gmi-details", '\ue3c8'),
    DEVELOPER_BOARD("gmi-developer-board", '\ue30d'),
    DEVELOPER_MODE("gmi-developer-mode", '\ue1b0'),
    DEVICE_HUB("gmi-device-hub", '\ue335'),
    DEVICE_THERMOSTAT("gmi-device-thermostat", '\ue1ff'),
    DEVICE_UNKNOWN("gmi-device-unknown", '\ue339'),
    DEVICES("gmi-devices", '\ue1b1'),
    DEVICES_OTHER("gmi-devices-other", '\ue337'),
    DIALER_SIP("gmi-dialer-sip", '\ue0bb'),
    DIALPAD("gmi-dialpad", '\ue0bc'),
    DINNER_DINING("gmi-dinner-dining", '\uea57'),
    DIRECTIONS("gmi-directions", '\ue52e'),
    DIRECTIONS_BIKE("gmi-directions-bike", '\ue52f'),
    DIRECTIONS_BOAT("gmi-directions-boat", '\ue532'),
    DIRECTIONS_BUS("gmi-directions-bus", '\ue530'),
    DIRECTIONS_CAR("gmi-directions-car", '\ue531'),
    DIRECTIONS_FERRY("gmi-directions-ferry", '\ue532'),
    DIRECTIONS_RAILWAY("gmi-directions-railway", '\ue534'),
    DIRECTIONS_RUN("gmi-directions-run", '\ue566'),
    DIRECTIONS_SUBWAY("gmi-directions-subway", '\ue533'),
    DIRECTIONS_TRAIN("gmi-directions-train", '\ue534'),
    DIRECTIONS_TRANSIT("gmi-directions-transit", '\ue535'),
    DIRECTIONS_WALK("gmi-directions-walk", '\ue536'),
    DISC_FULL("gmi-disc-full", '\ue610'),
    DND_FORWARDSLASH("gmi-dnd-forwardslash", '\ue611'),
    DNS("gmi-dns", '\ue875'),
    DO_NOT_DISTURB("gmi-do-not-disturb", '\ue612'),
    DO_NOT_DISTURB_ALT("gmi-do-not-disturb-alt", '\ue611'),
    DO_NOT_DISTURB_OFF("gmi-do-not-disturb-off", '\ue643'),
    DO_NOT_DISTURB_ON("gmi-do-not-disturb-on", '\ue644'),
    DOCK("gmi-dock", '\ue30e'),
    DOMAIN("gmi-domain", '\ue7ee'),
    DOMAIN_DISABLED("gmi-domain-disabled", '\ue0ef'),
    DONE("gmi-done", '\ue876'),
    DONE_ALL("gmi-done-all", '\ue877'),
    DONE_OUTLINE("gmi-done-outline", '\ue92f'),
    DONUT_LARGE("gmi-donut-large", '\ue917'),
    DONUT_SMALL("gmi-donut-small", '\ue918'),
    DOUBLE_ARROW("gmi-double-arrow", '\uea50'),
    DRAFTS("gmi-drafts", '\ue151'),
    DRAG_HANDLE("gmi-drag-handle", '\ue25d'),
    DRAG_INDICATOR("gmi-drag-indicator", '\ue945'),
    DRIVE_ETA("gmi-drive-eta", '\ue613'),
    DRIVE_FILE_MOVE_OUTLINE("gmi-drive-file-move-outline", '\ue9a1'),
    DRIVE_FILE_RENAME_OUTLINE("gmi-drive-file-rename-outline", '\ue9a2'),
    DRIVE_FOLDER_UPLOAD("gmi-drive-folder-upload", '\ue9a3'),
    DRY_CLEANING("gmi-dry-cleaning", '\uea58'),
    DUO("gmi-duo", '\ue9a5'),
    DVR("gmi-dvr", '\ue1b2'),
    DYNAMIC_FEED("gmi-dynamic-feed", '\uea14'),
    ECO("gmi-eco", '\uea35'),
    EDIT("gmi-edit", '\ue3c9'),
    EDIT_ATTRIBUTES("gmi-edit-attributes", '\ue578'),
    EDIT_LOCATION("gmi-edit-location", '\ue568'),
    EDIT_OFF("gmi-edit-off", '\ue950'),
    EJECT("gmi-eject", '\ue8fb'),
    EMAIL("gmi-email", '\ue0be'),
    EMOJI_EMOTIONS("gmi-emoji-emotions", '\uea22'),
    EMOJI_EVENTS("gmi-emoji-events", '\uea23'),
    EMOJI_FLAGS("gmi-emoji-flags", '\uea1a'),
    EMOJI_FOOD_BEVERAGE("gmi-emoji-food-beverage", '\uea1b'),
    EMOJI_NATURE("gmi-emoji-nature", '\uea1c'),
    EMOJI_OBJECTS("gmi-emoji-objects", '\uea24'),
    EMOJI_PEOPLE("gmi-emoji-people", '\uea1d'),
    EMOJI_SYMBOLS("gmi-emoji-symbols", '\uea1e'),
    EMOJI_TRANSPORTATION("gmi-emoji-transportation", '\uea1f'),
    ENHANCE_PHOTO_TRANSLATE("gmi-enhance-photo-translate", '\ue8fc'),
    ENHANCED_ENCRYPTION("gmi-enhanced-encryption", '\ue63f'),
    EQUALIZER("gmi-equalizer", '\ue01d'),
    ERROR("gmi-error", '\ue000'),
    ERROR_OUTLINE("gmi-error-outline", '\ue001'),
    EURO("gmi-euro", '\uea15'),
    EURO_SYMBOL("gmi-euro-symbol", '\ue926'),
    EV_STATION("gmi-ev-station", '\ue56d'),
    EVENT("gmi-event", '\ue878'),
    EVENT_AVAILABLE("gmi-event-available", '\ue614'),
    EVENT_BUSY("gmi-event-busy", '\ue615'),
    EVENT_NOTE("gmi-event-note", '\ue616'),
    EVENT_SEAT("gmi-event-seat", '\ue903'),
    EXIT_TO_APP("gmi-exit-to-app", '\ue879'),
    EXPAND("gmi-expand", '\ue94f'),
    EXPAND_LESS("gmi-expand-less", '\ue5ce'),
    EXPAND_MORE("gmi-expand-more", '\ue5cf'),
    EXPLICIT("gmi-explicit", '\ue01e'),
    EXPLORE("gmi-explore", '\ue87a'),
    EXPLORE_OFF("gmi-explore-off", '\ue9a8'),
    EXPOSURE("gmi-exposure", '\ue3ca'),
    EXPOSURE_MINUS_1("gmi-exposure-minus-1", '\ue3cb'),
    EXPOSURE_MINUS_2("gmi-exposure-minus-2", '\ue3cc'),
    EXPOSURE_NEG_1("gmi-exposure-neg-1", '\ue3cb'),
    EXPOSURE_NEG_2("gmi-exposure-neg-2", '\ue3cc'),
    EXPOSURE_PLUS_1("gmi-exposure-plus-1", '\ue3cd'),
    EXPOSURE_PLUS_2("gmi-exposure-plus-2", '\ue3ce'),
    EXPOSURE_ZERO("gmi-exposure-zero", '\ue3cf'),
    EXTENSION("gmi-extension", '\ue87b'),
    FACE("gmi-face", '\ue87c'),
    FAST_FORWARD("gmi-fast-forward", '\ue01f'),
    FAST_REWIND("gmi-fast-rewind", '\ue020'),
    FASTFOOD("gmi-fastfood", '\ue57a'),
    FAVORITE("gmi-favorite", '\ue87d'),
    FAVORITE_BORDER("gmi-favorite-border", '\ue87e'),
    FAVORITE_OUTLINE("gmi-favorite-outline", '\ue87e'),
    FEATURED_PLAY_LIST("gmi-featured-play-list", '\ue06d'),
    FEATURED_VIDEO("gmi-featured-video", '\ue06e'),
    FEEDBACK("gmi-feedback", '\ue87f'),
    FESTIVAL("gmi-festival", '\uea68'),
    FIBER_DVR("gmi-fiber-dvr", '\ue05d'),
    FIBER_MANUAL_RECORD("gmi-fiber-manual-record", '\ue061'),
    FIBER_NEW("gmi-fiber-new", '\ue05e'),
    FIBER_PIN("gmi-fiber-pin", '\ue06a'),
    FIBER_SMART_RECORD("gmi-fiber-smart-record", '\ue062'),
    FILE_COPY("gmi-file-copy", '\ue173'),
    FILE_DOWNLOAD("gmi-file-download", '\ue2c4'),
    FILE_DOWNLOAD_DONE("gmi-file-download-done", '\ue9aa'),
    FILE_PRESENT("gmi-file-present", '\uea0e'),
    FILE_UPLOAD("gmi-file-upload", '\ue2c6'),
    FILTER("gmi-filter", '\ue3d3'),
    FILTER_1("gmi-filter-1", '\ue3d0'),
    FILTER_2("gmi-filter-2", '\ue3d1'),
    FILTER_3("gmi-filter-3", '\ue3d2'),
    FILTER_4("gmi-filter-4", '\ue3d4'),
    FILTER_5("gmi-filter-5", '\ue3d5'),
    FILTER_6("gmi-filter-6", '\ue3d6'),
    FILTER_7("gmi-filter-7", '\ue3d7'),
    FILTER_8("gmi-filter-8", '\ue3d8'),
    FILTER_9("gmi-filter-9", '\ue3d9'),
    FILTER_9_PLUS("gmi-filter-9-plus", '\ue3da'),
    FILTER_B_AND_W("gmi-filter-b-and-w", '\ue3db'),
    FILTER_CENTER_FOCUS("gmi-filter-center-focus", '\ue3dc'),
    FILTER_DRAMA("gmi-filter-drama", '\ue3dd'),
    FILTER_FRAMES("gmi-filter-frames", '\ue3de'),
    FILTER_HDR("gmi-filter-hdr", '\ue3df'),
    FILTER_LIST("gmi-filter-list", '\ue152'),
    FILTER_LIST_ALT("gmi-filter-list-alt", '\ue94e'),
    FILTER_NONE("gmi-filter-none", '\ue3e0'),
    FILTER_TILT_SHIFT("gmi-filter-tilt-shift", '\ue3e2'),
    FILTER_VINTAGE("gmi-filter-vintage", '\ue3e3'),
    FIND_IN_PAGE("gmi-find-in-page", '\ue880'),
    FIND_REPLACE("gmi-find-replace", '\ue881'),
    FINGERPRINT("gmi-fingerprint", '\ue90d'),
    FIREPLACE("gmi-fireplace", '\uea43'),
    FIRST_PAGE("gmi-first-page", '\ue5dc'),
    FIT_SCREEN("gmi-fit-screen", '\uea10'),
    FITNESS_CENTER("gmi-fitness-center", '\ueb43'),
    FLAG("gmi-flag", '\ue153'),
    FLARE("gmi-flare", '\ue3e4'),
    FLASH_AUTO("gmi-flash-auto", '\ue3e5'),
    FLASH_OFF("gmi-flash-off", '\ue3e6'),
    FLASH_ON("gmi-flash-on", '\ue3e7'),
    FLIGHT("gmi-flight", '\ue539'),
    FLIGHT_LAND("gmi-flight-land", '\ue904'),
    FLIGHT_TAKEOFF("gmi-flight-takeoff", '\ue905'),
    FLIP("gmi-flip", '\ue3e8'),
    FLIP_CAMERA_ANDROID("gmi-flip-camera-android", '\uea37'),
    FLIP_CAMERA_IOS("gmi-flip-camera-ios", '\uea38'),
    FLIP_TO_BACK("gmi-flip-to-back", '\ue882'),
    FLIP_TO_FRONT("gmi-flip-to-front", '\ue883'),
    FOLDER("gmi-folder", '\ue2c7'),
    FOLDER_OPEN("gmi-folder-open", '\ue2c8'),
    FOLDER_SHARED("gmi-folder-shared", '\ue2c9'),
    FOLDER_SPECIAL("gmi-folder-special", '\ue617'),
    FONT_DOWNLOAD("gmi-font-download", '\ue167'),
    FORMAT_ALIGN_CENTER("gmi-format-align-center", '\ue234'),
    FORMAT_ALIGN_JUSTIFY("gmi-format-align-justify", '\ue235'),
    FORMAT_ALIGN_LEFT("gmi-format-align-left", '\ue236'),
    FORMAT_ALIGN_RIGHT("gmi-format-align-right", '\ue237'),
    FORMAT_BOLD("gmi-format-bold", '\ue238'),
    FORMAT_CLEAR("gmi-format-clear", '\ue239'),
    FORMAT_COLOR_FILL("gmi-format-color-fill", '\ue23a'),
    FORMAT_COLOR_RESET("gmi-format-color-reset", '\ue23b'),
    FORMAT_COLOR_TEXT("gmi-format-color-text", '\ue23c'),
    FORMAT_INDENT_DECREASE("gmi-format-indent-decrease", '\ue23d'),
    FORMAT_INDENT_INCREASE("gmi-format-indent-increase", '\ue23e'),
    FORMAT_ITALIC("gmi-format-italic", '\ue23f'),
    FORMAT_LINE_SPACING("gmi-format-line-spacing", '\ue240'),
    FORMAT_LIST_BULLETED("gmi-format-list-bulleted", '\ue241'),
    FORMAT_LIST_NUMBERED("gmi-format-list-numbered", '\ue242'),
    FORMAT_LIST_NUMBERED_RTL("gmi-format-list-numbered-rtl", '\ue267'),
    FORMAT_PAINT("gmi-format-paint", '\ue243'),
    FORMAT_QUOTE("gmi-format-quote", '\ue244'),
    FORMAT_SHAPES("gmi-format-shapes", '\ue25e'),
    FORMAT_SIZE("gmi-format-size", '\ue245'),
    FORMAT_STRIKETHROUGH("gmi-format-strikethrough", '\ue246'),
    FORMAT_TEXTDIRECTION_L_TO_R("gmi-format-textdirection-l-to-r", '\ue247'),
    FORMAT_TEXTDIRECTION_R_TO_L("gmi-format-textdirection-r-to-l", '\ue248'),
    FORMAT_UNDERLINE("gmi-format-underline", '\ue249'),
    FORMAT_UNDERLINED("gmi-format-underlined", '\ue249'),
    FORUM("gmi-forum", '\ue0bf'),
    FORWARD("gmi-forward", '\ue154'),
    FORWARD_10("gmi-forward-10", '\ue056'),
    FORWARD_30("gmi-forward-30", '\ue057'),
    FORWARD_5("gmi-forward-5", '\ue058'),
    FREE_BREAKFAST("gmi-free-breakfast", '\ueb44'),
    FULLSCREEN("gmi-fullscreen", '\ue5d0'),
    FULLSCREEN_EXIT("gmi-fullscreen-exit", '\ue5d1'),
    FUNCTIONS("gmi-functions", '\ue24a'),
    G_TRANSLATE("gmi-g-translate", '\ue927'),
    GAMEPAD("gmi-gamepad", '\ue30f'),
    GAMES("gmi-games", '\ue021'),
    GAVEL("gmi-gavel", '\ue90e'),
    GESTURE("gmi-gesture", '\ue155'),
    GET_APP("gmi-get-app", '\ue884'),
    GIF("gmi-gif", '\ue908'),
    GOAT("gmi-goat", '\udbff'),
    GOLF_COURSE("gmi-golf-course", '\ueb45'),
    GPS_FIXED("gmi-gps-fixed", '\ue1b3'),
    GPS_NOT_FIXED("gmi-gps-not-fixed", '\ue1b4'),
    GPS_OFF("gmi-gps-off", '\ue1b5'),
    GRADE("gmi-grade", '\ue885'),
    GRADIENT("gmi-gradient", '\ue3e9'),
    GRAIN("gmi-grain", '\ue3ea'),
    GRAPHIC_EQ("gmi-graphic-eq", '\ue1b8'),
    GRID_OFF("gmi-grid-off", '\ue3eb'),
    GRID_ON("gmi-grid-on", '\ue3ec'),
    GRID_VIEW("gmi-grid-view", '\ue9b0'),
    GROUP("gmi-group", '\ue7ef'),
    GROUP_ADD("gmi-group-add", '\ue7f0'),
    GROUP_WORK("gmi-group-work", '\ue886'),
    HAIL("gmi-hail", '\ue9b1'),
    HARDWARE("gmi-hardware", '\uea59'),
    HD("gmi-hd", '\ue052'),
    HDR_OFF("gmi-hdr-off", '\ue3ed'),
    HDR_ON("gmi-hdr-on", '\ue3ee'),
    HDR_STRONG("gmi-hdr-strong", '\ue3f1'),
    HDR_WEAK("gmi-hdr-weak", '\ue3f2'),
    HEADSET("gmi-headset", '\ue310'),
    HEADSET_MIC("gmi-headset-mic", '\ue311'),
    HEADSET_OFF("gmi-headset-off", '\ue33a'),
    HEALING("gmi-healing", '\ue3f3'),
    HEARING("gmi-hearing", '\ue023'),
    HEIGHT("gmi-height", '\uea16'),
    HELP("gmi-help", '\ue887'),
    HELP_OUTLINE("gmi-help-outline", '\ue8fd'),
    HIGH_QUALITY("gmi-high-quality", '\ue024'),
    HIGHLIGHT("gmi-highlight", '\ue25f'),
    HIGHLIGHT_OFF("gmi-highlight-off", '\ue888'),
    HIGHLIGHT_REMOVE("gmi-highlight-remove", '\ue888'),
    HISTORY("gmi-history", '\ue889'),
    HOME("gmi-home", '\ue88a'),
    HOME_FILLED("gmi-home-filled", '\ue9b2'),
    HOME_WORK("gmi-home-work", '\uea09'),
    HORIZONTAL_SPLIT("gmi-horizontal-split", '\ue947'),
    HOT_TUB("gmi-hot-tub", '\ueb46'),
    HOTEL("gmi-hotel", '\ue53a'),
    HOURGLASS_EMPTY("gmi-hourglass-empty", '\ue88b'),
    HOURGLASS_FULL("gmi-hourglass-full", '\ue88c'),
    HOUSE("gmi-house", '\uea44'),
    HOW_TO_REG("gmi-how-to-reg", '\ue174'),
    HOW_TO_VOTE("gmi-how-to-vote", '\ue175'),
    HTTP("gmi-http", '\ue902'),
    HTTPS("gmi-https", '\ue88d'),
    ICECREAM("gmi-icecream", '\uea69'),
    IMAGE("gmi-image", '\ue3f4'),
    IMAGE_ASPECT_RATIO("gmi-image-aspect-ratio", '\ue3f5'),
    IMAGE_SEARCH("gmi-image-search", '\ue43f'),
    IMAGESEARCH_ROLLER("gmi-imagesearch-roller", '\ue9b4'),
    IMPORT_CONTACTS("gmi-import-contacts", '\ue0e0'),
    IMPORT_EXPORT("gmi-import-export", '\ue0c3'),
    IMPORTANT_DEVICES("gmi-important-devices", '\ue912'),
    INBOX("gmi-inbox", '\ue156'),
    INDETERMINATE_CHECK_BOX("gmi-indeterminate-check-box", '\ue909'),
    INFO("gmi-info", '\ue88e'),
    INFO_OUTLINE("gmi-info-outline", '\ue88f'),
    INPUT("gmi-input", '\ue890'),
    INSERT_CHART("gmi-insert-chart", '\ue24b'),
    INSERT_CHART_OUTLINED("gmi-insert-chart-outlined", '\ue26a'),
    INSERT_COMMENT("gmi-insert-comment", '\ue24c'),
    INSERT_DRIVE_FILE("gmi-insert-drive-file", '\ue24d'),
    INSERT_EMOTICON("gmi-insert-emoticon", '\ue24e'),
    INSERT_INVITATION("gmi-insert-invitation", '\ue24f'),
    INSERT_LINK("gmi-insert-link", '\ue250'),
    INSERT_PHOTO("gmi-insert-photo", '\ue251'),
    INVENTORY("gmi-inventory", '\ue179'),
    INVERT_COLORS("gmi-invert-colors", '\ue891'),
    INVERT_COLORS_OFF("gmi-invert-colors-off", '\ue0c4'),
    INVERT_COLORS_ON("gmi-invert-colors-on", '\ue891'),
    ISO("gmi-iso", '\ue3f6'),
    KEYBOARD("gmi-keyboard", '\ue312'),
    KEYBOARD_ARROW_DOWN("gmi-keyboard-arrow-down", '\ue313'),
    KEYBOARD_ARROW_LEFT("gmi-keyboard-arrow-left", '\ue314'),
    KEYBOARD_ARROW_RIGHT("gmi-keyboard-arrow-right", '\ue315'),
    KEYBOARD_ARROW_UP("gmi-keyboard-arrow-up", '\ue316'),
    KEYBOARD_BACKSPACE("gmi-keyboard-backspace", '\ue317'),
    KEYBOARD_CAPSLOCK("gmi-keyboard-capslock", '\ue318'),
    KEYBOARD_CONTROL("gmi-keyboard-control", '\ue5d3'),
    KEYBOARD_HIDE("gmi-keyboard-hide", '\ue31a'),
    KEYBOARD_RETURN("gmi-keyboard-return", '\ue31b'),
    KEYBOARD_TAB("gmi-keyboard-tab", '\ue31c'),
    KEYBOARD_VOICE("gmi-keyboard-voice", '\ue31d'),
    KING_BED("gmi-king-bed", '\uea45'),
    KITCHEN("gmi-kitchen", '\ueb47'),
    LABEL("gmi-label", '\ue892'),
    LABEL_IMPORTANT("gmi-label-important", '\ue937'),
    LABEL_IMPORTANT_OUTLINE("gmi-label-important-outline", '\ue948'),
    LABEL_OFF("gmi-label-off", '\ue9b6'),
    LABEL_OUTLINE("gmi-label-outline", '\ue893'),
    LANDSCAPE("gmi-landscape", '\ue3f7'),
    LANGUAGE("gmi-language", '\ue894'),
    LAPTOP("gmi-laptop", '\ue31e'),
    LAPTOP_CHROMEBOOK("gmi-laptop-chromebook", '\ue31f'),
    LAPTOP_MAC("gmi-laptop-mac", '\ue320'),
    LAPTOP_WINDOWS("gmi-laptop-windows", '\ue321'),
    LAST_PAGE("gmi-last-page", '\ue5dd'),
    LAUNCH("gmi-launch", '\ue895'),
    LAYERS("gmi-layers", '\ue53b'),
    LAYERS_CLEAR("gmi-layers-clear", '\ue53c'),
    LEAK_ADD("gmi-leak-add", '\ue3f8'),
    LEAK_REMOVE("gmi-leak-remove", '\ue3f9'),
    LENS("gmi-lens", '\ue3fa'),
    LIBRARY_ADD("gmi-library-add", '\ue02e'),
    LIBRARY_ADD_CHECK("gmi-library-add-check", '\ue9b7'),
    LIBRARY_BOOKS("gmi-library-books", '\ue02f'),
    LIBRARY_MUSIC("gmi-library-music", '\ue030'),
    LIGHTBULB("gmi-lightbulb", '\ue0f0'),
    LIGHTBULB_OUTLINE("gmi-lightbulb-outline", '\ue90f'),
    LINE_STYLE("gmi-line-style", '\ue919'),
    LINE_WEIGHT("gmi-line-weight", '\ue91a'),
    LINEAR_SCALE("gmi-linear-scale", '\ue260'),
    LINK("gmi-link", '\ue157'),
    LINK_OFF("gmi-link-off", '\ue16f'),
    LINKED_CAMERA("gmi-linked-camera", '\ue438'),
    LIQUOR("gmi-liquor", '\uea60'),
    LIST("gmi-list", '\ue896'),
    LIST_ALT("gmi-list-alt", '\ue0ee'),
    LIVE_HELP("gmi-live-help", '\ue0c6'),
    LIVE_TV("gmi-live-tv", '\ue639'),
    LOCAL_ACTIVITY("gmi-local-activity", '\ue53f'),
    LOCAL_AIRPORT("gmi-local-airport", '\ue53d'),
    LOCAL_ATM("gmi-local-atm", '\ue53e'),
    LOCAL_ATTRACTION("gmi-local-attraction", '\ue53f'),
    LOCAL_BAR("gmi-local-bar", '\ue540'),
    LOCAL_CAFE("gmi-local-cafe", '\ue541'),
    LOCAL_CAR_WASH("gmi-local-car-wash", '\ue542'),
    LOCAL_CONVENIENCE_STORE("gmi-local-convenience-store", '\ue543'),
    LOCAL_DINING("gmi-local-dining", '\ue556'),
    LOCAL_DRINK("gmi-local-drink", '\ue544'),
    LOCAL_FLORIST("gmi-local-florist", '\ue545'),
    LOCAL_GAS_STATION("gmi-local-gas-station", '\ue546'),
    LOCAL_GROCERY_STORE("gmi-local-grocery-store", '\ue547'),
    LOCAL_HOSPITAL("gmi-local-hospital", '\ue548'),
    LOCAL_HOTEL("gmi-local-hotel", '\ue549'),
    LOCAL_LAUNDRY_SERVICE("gmi-local-laundry-service", '\ue54a'),
    LOCAL_LIBRARY("gmi-local-library", '\ue54b'),
    LOCAL_MALL("gmi-local-mall", '\ue54c'),
    LOCAL_MOVIES("gmi-local-movies", '\ue54d'),
    LOCAL_OFFER("gmi-local-offer", '\ue54e'),
    LOCAL_PARKING("gmi-local-parking", '\ue54f'),
    LOCAL_PHARMACY("gmi-local-pharmacy", '\ue550'),
    LOCAL_PHONE("gmi-local-phone", '\ue551'),
    LOCAL_PIZZA("gmi-local-pizza", '\ue552'),
    LOCAL_PLAY("gmi-local-play", '\ue553'),
    LOCAL_POST_OFFICE("gmi-local-post-office", '\ue554'),
    LOCAL_PRINT_SHOP("gmi-local-print-shop", '\ue555'),
    LOCAL_PRINTSHOP("gmi-local-printshop", '\ue555'),
    LOCAL_RESTAURANT("gmi-local-restaurant", '\ue556'),
    LOCAL_SEE("gmi-local-see", '\ue557'),
    LOCAL_SHIPPING("gmi-local-shipping", '\ue558'),
    LOCAL_TAXI("gmi-local-taxi", '\ue559'),
    LOCATION_CITY("gmi-location-city", '\ue7f1'),
    LOCATION_DISABLED("gmi-location-disabled", '\ue1b6'),
    LOCATION_HISTORY("gmi-location-history", '\ue55a'),
    LOCATION_OFF("gmi-location-off", '\ue0c7'),
    LOCATION_ON("gmi-location-on", '\ue0c8'),
    LOCATION_SEARCHING("gmi-location-searching", '\ue1b7'),
    LOCK("gmi-lock", '\ue897'),
    LOCK_OPEN("gmi-lock-open", '\ue898'),
    LOCK_OUTLINE("gmi-lock-outline", '\ue899'),
    LOGOUT("gmi-logout", '\ue9ba'),
    LOOKS("gmi-looks", '\ue3fc'),
    LOOKS_3("gmi-looks-3", '\ue3fb'),
    LOOKS_4("gmi-looks-4", '\ue3fd'),
    LOOKS_5("gmi-looks-5", '\ue3fe'),
    LOOKS_6("gmi-looks-6", '\ue3ff'),
    LOOKS_ONE("gmi-looks-one", '\ue400'),
    LOOKS_TWO("gmi-looks-two", '\ue401'),
    LOOP("gmi-loop", '\ue028'),
    LOUPE("gmi-loupe", '\ue402'),
    LOW_PRIORITY("gmi-low-priority", '\ue16d'),
    LOYALTY("gmi-loyalty", '\ue89a'),
    LUNCH_DINING("gmi-lunch-dining", '\uea61'),
    MAIL("gmi-mail", '\ue158'),
    MAIL_OUTLINE("gmi-mail-outline", '\ue0e1'),
    MAP("gmi-map", '\ue55b'),
    MARGIN("gmi-margin", '\ue9bb'),
    MARK_AS_UNREAD("gmi-mark-as-unread", '\ue9bc'),
    MARKUNREAD("gmi-markunread", '\ue159'),
    MARKUNREAD_MAILBOX("gmi-markunread-mailbox", '\ue89b'),
    MAXIMIZE("gmi-maximize", '\ue930'),
    MEETING_ROOM("gmi-meeting-room", '\ueb4f'),
    MEMORY("gmi-memory", '\ue322'),
    MENU("gmi-menu", '\ue5d2'),
    MENU_BOOK("gmi-menu-book", '\uea19'),
    MENU_OPEN("gmi-menu-open", '\ue9bd'),
    MERGE_TYPE("gmi-merge-type", '\ue252'),
    MESSAGE("gmi-message", '\ue0c9'),
    MESSENGER("gmi-messenger", '\ue0ca'),
    MESSENGER_OUTLINE("gmi-messenger-outline", '\ue0cb'),
    MIC("gmi-mic", '\ue029'),
    MIC_NONE("gmi-mic-none", '\ue02a'),
    MIC_OFF("gmi-mic-off", '\ue02b'),
    MINIMIZE("gmi-minimize", '\ue931'),
    MISSED_VIDEO_CALL("gmi-missed-video-call", '\ue073'),
    MMS("gmi-mms", '\ue618'),
    MOBILE_FRIENDLY("gmi-mobile-friendly", '\ue200'),
    MOBILE_OFF("gmi-mobile-off", '\ue201'),
    MOBILE_SCREEN_SHARE("gmi-mobile-screen-share", '\ue0e7'),
    MODE_COMMENT("gmi-mode-comment", '\ue253'),
    MODE_EDIT("gmi-mode-edit", '\ue254'),
    MONETIZATION_ON("gmi-monetization-on", '\ue263'),
    MONEY("gmi-money", '\ue57d'),
    MONEY_OFF("gmi-money-off", '\ue25c'),
    MONOCHROME_PHOTOS("gmi-monochrome-photos", '\ue403'),
    MOOD("gmi-mood", '\ue7f2'),
    MOOD_BAD("gmi-mood-bad", '\ue7f3'),
    MORE("gmi-more", '\ue619'),
    MORE_HORIZ("gmi-more-horiz", '\ue5d3'),
    MORE_VERT("gmi-more-vert", '\ue5d4'),
    MOTORCYCLE("gmi-motorcycle", '\ue91b'),
    MOUSE("gmi-mouse", '\ue323'),
    MOVE_TO_INBOX("gmi-move-to-inbox", '\ue168'),
    MOVIE("gmi-movie", '\ue02c'),
    MOVIE_CREATION("gmi-movie-creation", '\ue404'),
    MOVIE_FILTER("gmi-movie-filter", '\ue43a'),
    MP("gmi-mp", '\ue9c3'),
    MULTILINE_CHART("gmi-multiline-chart", '\ue6df'),
    MULTITRACK_AUDIO("gmi-multitrack-audio", '\ue1b8'),
    MUSEUM("gmi-museum", '\uea36'),
    MUSIC_NOTE("gmi-music-note", '\ue405'),
    MUSIC_OFF("gmi-music-off", '\ue440'),
    MUSIC_VIDEO("gmi-music-video", '\ue063'),
    MY_LIBRARY_ADD("gmi-my-library-add", '\ue02e'),
    MY_LIBRARY_BOOKS("gmi-my-library-books", '\ue02f'),
    MY_LIBRARY_MUSIC("gmi-my-library-music", '\ue030'),
    MY_LOCATION("gmi-my-location", '\ue55c'),
    NATURE("gmi-nature", '\ue406'),
    NATURE_PEOPLE("gmi-nature-people", '\ue407'),
    NAVIGATE_BEFORE("gmi-navigate-before", '\ue408'),
    NAVIGATE_NEXT("gmi-navigate-next", '\ue409'),
    NAVIGATION("gmi-navigation", '\ue55d'),
    NEAR_ME("gmi-near-me", '\ue569'),
    NETWORK_CELL("gmi-network-cell", '\ue1b9'),
    NETWORK_CHECK("gmi-network-check", '\ue640'),
    NETWORK_LOCKED("gmi-network-locked", '\ue61a'),
    NETWORK_WIFI("gmi-network-wifi", '\ue1ba'),
    NEW_RELEASES("gmi-new-releases", '\ue031'),
    NEXT_WEEK("gmi-next-week", '\ue16a'),
    NFC("gmi-nfc", '\ue1bb'),
    NIGHTLIFE("gmi-nightlife", '\uea62'),
    NIGHTS_STAY("gmi-nights-stay", '\uea46'),
    NO_ENCRYPTION("gmi-no-encryption", '\ue641'),
    NO_MEETING_ROOM("gmi-no-meeting-room", '\ueb4e'),
    NO_SIM("gmi-no-sim", '\ue0cc'),
    NOT_INTERESTED("gmi-not-interested", '\ue033'),
    NOT_LISTED_LOCATION("gmi-not-listed-location", '\ue575'),
    NOTE("gmi-note", '\ue06f'),
    NOTE_ADD("gmi-note-add", '\ue89c'),
    NOTES("gmi-notes", '\ue26c'),
    NOTIFICATION_IMPORTANT("gmi-notification-important", '\ue004'),
    NOTIFICATIONS("gmi-notifications", '\ue7f4'),
    NOTIFICATIONS_ACTIVE("gmi-notifications-active", '\ue7f7'),
    NOTIFICATIONS_NONE("gmi-notifications-none", '\ue7f5'),
    NOTIFICATIONS_OFF("gmi-notifications-off", '\ue7f6'),
    NOTIFICATIONS_ON("gmi-notifications-on", '\ue7f7'),
    NOTIFICATIONS_PAUSED("gmi-notifications-paused", '\ue7f8'),
    NOW_WALLPAPER("gmi-now-wallpaper", '\ue1bc'),
    NOW_WIDGETS("gmi-now-widgets", '\ue1bd'),
    OFFLINE_BOLT("gmi-offline-bolt", '\ue932'),
    OFFLINE_PIN("gmi-offline-pin", '\ue90a'),
    OFFLINE_SHARE("gmi-offline-share", '\ue9c5'),
    ONDEMAND_VIDEO("gmi-ondemand-video", '\ue63a'),
    OPACITY("gmi-opacity", '\ue91c'),
    OPEN_IN_BROWSER("gmi-open-in-browser", '\ue89d'),
    OPEN_IN_NEW("gmi-open-in-new", '\ue89e'),
    OPEN_WITH("gmi-open-with", '\ue89f'),
    OUTDOOR_GRILL("gmi-outdoor-grill", '\uea47'),
    OUTLINED_FLAG("gmi-outlined-flag", '\ue16e'),
    PADDING("gmi-padding", '\ue9c8'),
    PAGES("gmi-pages", '\ue7f9'),
    PAGEVIEW("gmi-pageview", '\ue8a0'),
    PALETTE("gmi-palette", '\ue40a'),
    PAN_TOOL("gmi-pan-tool", '\ue925'),
    PANORAMA("gmi-panorama", '\ue40b'),
    PANORAMA_FISH_EYE("gmi-panorama-fish-eye", '\ue40c'),
    PANORAMA_FISHEYE("gmi-panorama-fisheye", '\ue40c'),
    PANORAMA_HORIZONTAL("gmi-panorama-horizontal", '\ue40d'),
    PANORAMA_PHOTOSPHERE("gmi-panorama-photosphere", '\ue9c9'),
    PANORAMA_PHOTOSPHERE_SELECT("gmi-panorama-photosphere-select", '\ue9ca'),
    PANORAMA_VERTICAL("gmi-panorama-vertical", '\ue40e'),
    PANORAMA_WIDE_ANGLE("gmi-panorama-wide-angle", '\ue40f'),
    PARK("gmi-park", '\uea63'),
    PARTY_MODE("gmi-party-mode", '\ue7fa'),
    PAUSE("gmi-pause", '\ue034'),
    PAUSE_CIRCLE_FILLED("gmi-pause-circle-filled", '\ue035'),
    PAUSE_CIRCLE_OUTLINE("gmi-pause-circle-outline", '\ue036'),
    PAUSE_PRESENTATION("gmi-pause-presentation", '\ue0ea'),
    PAYMENT("gmi-payment", '\ue8a1'),
    PEOPLE("gmi-people", '\ue7fb'),
    PEOPLE_ALT("gmi-people-alt", '\uea21'),
    PEOPLE_OUTLINE("gmi-people-outline", '\ue7fc'),
    PERM_CAMERA_MIC("gmi-perm-camera-mic", '\ue8a2'),
    PERM_CONTACT_CAL("gmi-perm-contact-cal", '\ue8a3'),
    PERM_CONTACT_CALENDAR("gmi-perm-contact-calendar", '\ue8a3'),
    PERM_DATA_SETTING("gmi-perm-data-setting", '\ue8a4'),
    PERM_DEVICE_INFO("gmi-perm-device-info", '\ue8a5'),
    PERM_DEVICE_INFORMATION("gmi-perm-device-information", '\ue8a5'),
    PERM_IDENTITY("gmi-perm-identity", '\ue8a6'),
    PERM_MEDIA("gmi-perm-media", '\ue8a7'),
    PERM_PHONE_MSG("gmi-perm-phone-msg", '\ue8a8'),
    PERM_SCAN_WIFI("gmi-perm-scan-wifi", '\ue8a9'),
    PERSON("gmi-person", '\ue7fd'),
    PERSON_ADD("gmi-person-add", '\ue7fe'),
    PERSON_ADD_DISABLED("gmi-person-add-disabled", '\ue9cb'),
    PERSON_OUTLINE("gmi-person-outline", '\ue7ff'),
    PERSON_PIN("gmi-person-pin", '\ue55a'),
    PERSON_PIN_CIRCLE("gmi-person-pin-circle", '\ue56a'),
    PERSONAL_VIDEO("gmi-personal-video", '\ue63b'),
    PETS("gmi-pets", '\ue91d'),
    PHONE("gmi-phone", '\ue0cd'),
    PHONE_ANDROID("gmi-phone-android", '\ue324'),
    PHONE_BLUETOOTH_SPEAKER("gmi-phone-bluetooth-speaker", '\ue61b'),
    PHONE_CALLBACK("gmi-phone-callback", '\ue649'),
    PHONE_DISABLED("gmi-phone-disabled", '\ue9cc'),
    PHONE_ENABLED("gmi-phone-enabled", '\ue9cd'),
    PHONE_FORWARDED("gmi-phone-forwarded", '\ue61c'),
    PHONE_IN_TALK("gmi-phone-in-talk", '\ue61d'),
    PHONE_IPHONE("gmi-phone-iphone", '\ue325'),
    PHONE_LOCKED("gmi-phone-locked", '\ue61e'),
    PHONE_MISSED("gmi-phone-missed", '\ue61f'),
    PHONE_PAUSED("gmi-phone-paused", '\ue620'),
    PHONELINK("gmi-phonelink", '\ue326'),
    PHONELINK_ERASE("gmi-phonelink-erase", '\ue0db'),
    PHONELINK_LOCK("gmi-phonelink-lock", '\ue0dc'),
    PHONELINK_OFF("gmi-phonelink-off", '\ue327'),
    PHONELINK_RING("gmi-phonelink-ring", '\ue0dd'),
    PHONELINK_SETUP("gmi-phonelink-setup", '\ue0de'),
    PHOTO("gmi-photo", '\ue410'),
    PHOTO_ALBUM("gmi-photo-album", '\ue411'),
    PHOTO_CAMERA("gmi-photo-camera", '\ue412'),
    PHOTO_FILTER("gmi-photo-filter", '\ue43b'),
    PHOTO_LIBRARY("gmi-photo-library", '\ue413'),
    PHOTO_SIZE_SELECT_ACTUAL("gmi-photo-size-select-actual", '\ue432'),
    PHOTO_SIZE_SELECT_LARGE("gmi-photo-size-select-large", '\ue433'),
    PHOTO_SIZE_SELECT_SMALL("gmi-photo-size-select-small", '\ue434'),
    PICTURE_AS_PDF("gmi-picture-as-pdf", '\ue415'),
    PICTURE_IN_PICTURE("gmi-picture-in-picture", '\ue8aa'),
    PICTURE_IN_PICTURE_ALT("gmi-picture-in-picture-alt", '\ue911'),
    PIE_CHART("gmi-pie-chart", '\ue6c4'),
    PIE_CHART_OUTLINED("gmi-pie-chart-outlined", '\ue6c5'),
    PIN_DROP("gmi-pin-drop", '\ue55e'),
    PIVOT_TABLE_CHART("gmi-pivot-table-chart", '\ue9ce'),
    PLACE("gmi-place", '\ue55f'),
    PLAY_ARROW("gmi-play-arrow", '\ue037'),
    PLAY_CIRCLE_FILL("gmi-play-circle-fill", '\ue038'),
    PLAY_CIRCLE_FILLED("gmi-play-circle-filled", '\ue038'),
    PLAY_CIRCLE_OUTLINE("gmi-play-circle-outline", '\ue039'),
    PLAY_FOR_WORK("gmi-play-for-work", '\ue906'),
    PLAYLIST_ADD("gmi-playlist-add", '\ue03b'),
    PLAYLIST_ADD_CHECK("gmi-playlist-add-check", '\ue065'),
    PLAYLIST_PLAY("gmi-playlist-play", '\ue05f'),
    PLUS_ONE("gmi-plus-one", '\ue800'),
    POLICY("gmi-policy", '\uea17'),
    POLL("gmi-poll", '\ue801'),
    POLYMER("gmi-polymer", '\ue8ab'),
    POOL("gmi-pool", '\ueb48'),
    PORTABLE_WIFI_OFF("gmi-portable-wifi-off", '\ue0ce'),
    PORTRAIT("gmi-portrait", '\ue416'),
    POST_ADD("gmi-post-add", '\uea20'),
    POWER("gmi-power", '\ue63c'),
    POWER_INPUT("gmi-power-input", '\ue336'),
    POWER_OFF("gmi-power-off", '\ue646'),
    POWER_SETTINGS_NEW("gmi-power-settings-new", '\ue8ac'),
    PREGNANT_WOMAN("gmi-pregnant-woman", '\ue91e'),
    PRESENT_TO_ALL("gmi-present-to-all", '\ue0df'),
    PRINT("gmi-print", '\ue8ad'),
    PRINT_DISABLED("gmi-print-disabled", '\ue9cf'),
    PRIORITY_HIGH("gmi-priority-high", '\ue645'),
    PUBLIC("gmi-public", '\ue80b'),
    PUBLISH("gmi-publish", '\ue255'),
    QUERY_BUILDER("gmi-query-builder", '\ue8ae'),
    QUESTION_ANSWER("gmi-question-answer", '\ue8af'),
    QUEUE("gmi-queue", '\ue03c'),
    QUEUE_MUSIC("gmi-queue-music", '\ue03d'),
    QUEUE_PLAY_NEXT("gmi-queue-play-next", '\ue066'),
    QUICK_CONTACTS_DIALER("gmi-quick-contacts-dialer", '\ue0cf'),
    QUICK_CONTACTS_MAIL("gmi-quick-contacts-mail", '\ue0d0'),
    RADIO("gmi-radio", '\ue03e'),
    RADIO_BUTTON_CHECKED("gmi-radio-button-checked", '\ue837'),
    RADIO_BUTTON_OFF("gmi-radio-button-off", '\ue836'),
    RADIO_BUTTON_ON("gmi-radio-button-on", '\ue837'),
    RADIO_BUTTON_UNCHECKED("gmi-radio-button-unchecked", '\ue836'),
    RAILWAY_ALERT("gmi-railway-alert", '\ue9d1'),
    RAMEN_DINING("gmi-ramen-dining", '\uea64'),
    RATE_REVIEW("gmi-rate-review", '\ue560'),
    RECEIPT("gmi-receipt", '\ue8b0'),
    RECENT_ACTORS("gmi-recent-actors", '\ue03f'),
    RECOMMEND("gmi-recommend", '\ue9d2'),
    RECORD_VOICE_OVER("gmi-record-voice-over", '\ue91f'),
    REDEEM("gmi-redeem", '\ue8b1'),
    REDO("gmi-redo", '\ue15a'),
    REFRESH("gmi-refresh", '\ue5d5'),
    REMOVE("gmi-remove", '\ue15b'),
    REMOVE_CIRCLE("gmi-remove-circle", '\ue15c'),
    REMOVE_CIRCLE_OUTLINE("gmi-remove-circle-outline", '\ue15d'),
    REMOVE_DONE("gmi-remove-done", '\ue9d3'),
    REMOVE_FROM_QUEUE("gmi-remove-from-queue", '\ue067'),
    REMOVE_MODERATOR("gmi-remove-moderator", '\ue9d4'),
    REMOVE_RED_EYE("gmi-remove-red-eye", '\ue417'),
    REMOVE_SHOPPING_CART("gmi-remove-shopping-cart", '\ue928'),
    REORDER("gmi-reorder", '\ue8fe'),
    REPEAT("gmi-repeat", '\ue040'),
    REPEAT_ON("gmi-repeat-on", '\ue9d6'),
    REPEAT_ONE("gmi-repeat-one", '\ue041'),
    REPEAT_ONE_ON("gmi-repeat-one-on", '\ue9d7'),
    REPLAY("gmi-replay", '\ue042'),
    REPLAY_10("gmi-replay-10", '\ue059'),
    REPLAY_30("gmi-replay-30", '\ue05a'),
    REPLAY_5("gmi-replay-5", '\ue05b'),
    REPLAY_CIRCLE_FILLED("gmi-replay-circle-filled", '\ue9d8'),
    REPLY("gmi-reply", '\ue15e'),
    REPLY_ALL("gmi-reply-all", '\ue15f'),
    REPORT("gmi-report", '\ue160'),
    REPORT_OFF("gmi-report-off", '\ue170'),
    REPORT_PROBLEM("gmi-report-problem", '\ue8b2'),
    RESET_TV("gmi-reset-tv", '\ue9d9'),
    RESTAURANT("gmi-restaurant", '\ue56c'),
    RESTAURANT_MENU("gmi-restaurant-menu", '\ue561'),
    RESTORE("gmi-restore", '\ue8b3'),
    RESTORE_FROM_TRASH("gmi-restore-from-trash", '\ue938'),
    RESTORE_PAGE("gmi-restore-page", '\ue929'),
    RING_VOLUME("gmi-ring-volume", '\ue0d1'),
    ROOM("gmi-room", '\ue8b4'),
    ROOM_SERVICE("gmi-room-service", '\ueb49'),
    ROTATE_90_DEGREES_CCW("gmi-rotate-90-degrees-ccw", '\ue418'),
    ROTATE_LEFT("gmi-rotate-left", '\ue419'),
    ROTATE_RIGHT("gmi-rotate-right", '\ue41a'),
    ROUNDED_CORNER("gmi-rounded-corner", '\ue920'),
    ROUTER("gmi-router", '\ue328'),
    ROWING("gmi-rowing", '\ue921'),
    RSS_FEED("gmi-rss-feed", '\ue0e5'),
    RTT("gmi-rtt", '\ue9ad'),
    RV_HOOKUP("gmi-rv-hookup", '\ue642'),
    SATELLITE("gmi-satellite", '\ue562'),
    SAVE("gmi-save", '\ue161'),
    SAVE_ALT("gmi-save-alt", '\ue171'),
    SAVED_SEARCH("gmi-saved-search", '\uea11'),
    SCANNER("gmi-scanner", '\ue329'),
    SCATTER_PLOT("gmi-scatter-plot", '\ue268'),
    SCHEDULE("gmi-schedule", '\ue8b5'),
    SCHEDULE_SEND("gmi-schedule-send", '\uea0a'),
    SCHOOL("gmi-school", '\ue80c'),
    SCORE("gmi-score", '\ue269'),
    SCREEN_LOCK_LANDSCAPE("gmi-screen-lock-landscape", '\ue1be'),
    SCREEN_LOCK_PORTRAIT("gmi-screen-lock-portrait", '\ue1bf'),
    SCREEN_LOCK_ROTATION("gmi-screen-lock-rotation", '\ue1c0'),
    SCREEN_ROTATION("gmi-screen-rotation", '\ue1c1'),
    SCREEN_SHARE("gmi-screen-share", '\ue0e2'),
    SD("gmi-sd", '\ue9dd'),
    SD_CARD("gmi-sd-card", '\ue623'),
    SD_STORAGE("gmi-sd-storage", '\ue1c2'),
    SEARCH("gmi-search", '\ue8b6'),
    SECURITY("gmi-security", '\ue32a'),
    SEGMENT("gmi-segment", '\ue94b'),
    SELECT_ALL("gmi-select-all", '\ue162'),
    SEND("gmi-send", '\ue163'),
    SEND_AND_ARCHIVE("gmi-send-and-archive", '\uea0c'),
    SENTIMENT_DISSATISFIED("gmi-sentiment-dissatisfied", '\ue811'),
    SENTIMENT_NEUTRAL("gmi-sentiment-neutral", '\ue812'),
    SENTIMENT_SATISFIED("gmi-sentiment-satisfied", '\ue813'),
    SENTIMENT_SATISFIED_ALT("gmi-sentiment-satisfied-alt", '\ue0ed'),
    SENTIMENT_VERY_DISSATISFIED("gmi-sentiment-very-dissatisfied", '\ue814'),
    SENTIMENT_VERY_SATISFIED("gmi-sentiment-very-satisfied", '\ue815'),
    SETTINGS("gmi-settings", '\ue8b8'),
    SETTINGS_APPLICATIONS("gmi-settings-applications", '\ue8b9'),
    SETTINGS_BACKUP_RESTORE("gmi-settings-backup-restore", '\ue8ba'),
    SETTINGS_BLUETOOTH("gmi-settings-bluetooth", '\ue8bb'),
    SETTINGS_BRIGHTNESS("gmi-settings-brightness", '\ue8bd'),
    SETTINGS_CELL("gmi-settings-cell", '\ue8bc'),
    SETTINGS_DISPLAY("gmi-settings-display", '\ue8bd'),
    SETTINGS_ETHERNET("gmi-settings-ethernet", '\ue8be'),
    SETTINGS_INPUT_ANTENNA("gmi-settings-input-antenna", '\ue8bf'),
    SETTINGS_INPUT_COMPONENT("gmi-settings-input-component", '\ue8c0'),
    SETTINGS_INPUT_COMPOSITE("gmi-settings-input-composite", '\ue8c1'),
    SETTINGS_INPUT_HDMI("gmi-settings-input-hdmi", '\ue8c2'),
    SETTINGS_INPUT_SVIDEO("gmi-settings-input-svideo", '\ue8c3'),
    SETTINGS_OVERSCAN("gmi-settings-overscan", '\ue8c4'),
    SETTINGS_PHONE("gmi-settings-phone", '\ue8c5'),
    SETTINGS_POWER("gmi-settings-power", '\ue8c6'),
    SETTINGS_REMOTE("gmi-settings-remote", '\ue8c7'),
    SETTINGS_SYSTEM_DAYDREAM("gmi-settings-system-daydream", '\ue1c3'),
    SETTINGS_VOICE("gmi-settings-voice", '\ue8c8'),
    SHARE("gmi-share", '\ue80d'),
    SHIELD("gmi-shield", '\ue9e0'),
    SHOP("gmi-shop", '\ue8c9'),
    SHOP_TWO("gmi-shop-two", '\ue8ca'),
    SHOPPING_BASKET("gmi-shopping-basket", '\ue8cb'),
    SHOPPING_CART("gmi-shopping-cart", '\ue8cc'),
    SHORT_TEXT("gmi-short-text", '\ue261'),
    SHOW_CHART("gmi-show-chart", '\ue6e1'),
    SHUFFLE("gmi-shuffle", '\ue043'),
    SHUFFLE_ON("gmi-shuffle-on", '\ue9e1'),
    SHUTTER_SPEED("gmi-shutter-speed", '\ue43d'),
    SIGNAL_CELLULAR_4_BAR("gmi-signal-cellular-4-bar", '\ue1c8'),
    SIGNAL_CELLULAR_ALT("gmi-signal-cellular-alt", '\ue202'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("gmi-signal-cellular-connected-no-internet-4-bar", '\ue1cd'),
    SIGNAL_CELLULAR_NO_SIM("gmi-signal-cellular-no-sim", '\ue1ce'),
    SIGNAL_CELLULAR_NULL("gmi-signal-cellular-null", '\ue1cf'),
    SIGNAL_CELLULAR_OFF("gmi-signal-cellular-off", '\ue1d0'),
    SIGNAL_WIFI_4_BAR("gmi-signal-wifi-4-bar", '\ue1d8'),
    SIGNAL_WIFI_4_BAR_LOCK("gmi-signal-wifi-4-bar-lock", '\ue1d9'),
    SIGNAL_WIFI_OFF("gmi-signal-wifi-off", '\ue1da'),
    SIM_CARD("gmi-sim-card", '\ue32b'),
    SIM_CARD_ALERT("gmi-sim-card-alert", '\ue624'),
    SINGLE_BED("gmi-single-bed", '\uea48'),
    SKIP_NEXT("gmi-skip-next", '\ue044'),
    SKIP_PREVIOUS("gmi-skip-previous", '\ue045'),
    SLIDESHOW("gmi-slideshow", '\ue41b'),
    SLOW_MOTION_VIDEO("gmi-slow-motion-video", '\ue068'),
    SMARTPHONE("gmi-smartphone", '\ue32c'),
    SMOKE_FREE("gmi-smoke-free", '\ueb4a'),
    SMOKING_ROOMS("gmi-smoking-rooms", '\ueb4b'),
    SMS("gmi-sms", '\ue625'),
    SMS_FAILED("gmi-sms-failed", '\ue626'),
    SNOOZE("gmi-snooze", '\ue046'),
    SORT("gmi-sort", '\ue164'),
    SORT_BY_ALPHA("gmi-sort-by-alpha", '\ue053'),
    SPA("gmi-spa", '\ueb4c'),
    SPACE_BAR("gmi-space-bar", '\ue256'),
    SPEAKER("gmi-speaker", '\ue32d'),
    SPEAKER_GROUP("gmi-speaker-group", '\ue32e'),
    SPEAKER_NOTES("gmi-speaker-notes", '\ue8cd'),
    SPEAKER_NOTES_OFF("gmi-speaker-notes-off", '\ue92a'),
    SPEAKER_PHONE("gmi-speaker-phone", '\ue0d2'),
    SPEED("gmi-speed", '\ue9e4'),
    SPELLCHECK("gmi-spellcheck", '\ue8ce'),
    SPORTS("gmi-sports", '\uea30'),
    SPORTS_BASEBALL("gmi-sports-baseball", '\uea51'),
    SPORTS_BASKETBALL("gmi-sports-basketball", '\uea26'),
    SPORTS_CRICKET("gmi-sports-cricket", '\uea27'),
    SPORTS_ESPORTS("gmi-sports-esports", '\uea28'),
    SPORTS_FOOTBALL("gmi-sports-football", '\uea29'),
    SPORTS_GOLF("gmi-sports-golf", '\uea2a'),
    SPORTS_HANDBALL("gmi-sports-handball", '\uea33'),
    SPORTS_HOCKEY("gmi-sports-hockey", '\uea2b'),
    SPORTS_KABADDI("gmi-sports-kabaddi", '\uea34'),
    SPORTS_MMA("gmi-sports-mma", '\uea2c'),
    SPORTS_MOTORSPORTS("gmi-sports-motorsports", '\uea2d'),
    SPORTS_RUGBY("gmi-sports-rugby", '\uea2e'),
    SPORTS_SOCCER("gmi-sports-soccer", '\uea2f'),
    SPORTS_TENNIS("gmi-sports-tennis", '\uea32'),
    SPORTS_VOLLEYBALL("gmi-sports-volleyball", '\uea31'),
    SQUARE_FOOT("gmi-square-foot", '\uea49'),
    STACKED_BAR_CHART("gmi-stacked-bar-chart", '\ue9e6'),
    STAR("gmi-star", '\ue838'),
    STAR_BORDER("gmi-star-border", '\ue83a'),
    STAR_HALF("gmi-star-half", '\ue839'),
    STAR_OUTLINE("gmi-star-outline", '\ue83a'),
    STARS("gmi-stars", '\ue8d0'),
    STAY_CURRENT_LANDSCAPE("gmi-stay-current-landscape", '\ue0d3'),
    STAY_CURRENT_PORTRAIT("gmi-stay-current-portrait", '\ue0d4'),
    STAY_PRIMARY_LANDSCAPE("gmi-stay-primary-landscape", '\ue0d5'),
    STAY_PRIMARY_PORTRAIT("gmi-stay-primary-portrait", '\ue0d6'),
    STOP("gmi-stop", '\ue047'),
    STOP_SCREEN_SHARE("gmi-stop-screen-share", '\ue0e3'),
    STORAGE("gmi-storage", '\ue1db'),
    STORE("gmi-store", '\ue8d1'),
    STORE_MALL_DIRECTORY("gmi-store-mall-directory", '\ue563'),
    STOREFRONT("gmi-storefront", '\uea12'),
    STRAIGHTEN("gmi-straighten", '\ue41c'),
    STREAM("gmi-stream", '\ue9e9'),
    STREETVIEW("gmi-streetview", '\ue56e'),
    STRIKETHROUGH_S("gmi-strikethrough-s", '\ue257'),
    STYLE("gmi-style", '\ue41d'),
    SUBDIRECTORY_ARROW_LEFT("gmi-subdirectory-arrow-left", '\ue5d9'),
    SUBDIRECTORY_ARROW_RIGHT("gmi-subdirectory-arrow-right", '\ue5da'),
    SUBJECT("gmi-subject", '\ue8d2'),
    SUBSCRIPTIONS("gmi-subscriptions", '\ue064'),
    SUBTITLES("gmi-subtitles", '\ue048'),
    SUBWAY("gmi-subway", '\ue56f'),
    SUPERVISED_USER_CIRCLE("gmi-supervised-user-circle", '\ue939'),
    SUPERVISOR_ACCOUNT("gmi-supervisor-account", '\ue8d3'),
    SURROUND_SOUND("gmi-surround-sound", '\ue049'),
    SWAP_CALLS("gmi-swap-calls", '\ue0d7'),
    SWAP_HORIZ("gmi-swap-horiz", '\ue8d4'),
    SWAP_HORIZONTAL_CIRCLE("gmi-swap-horizontal-circle", '\ue933'),
    SWAP_VERT("gmi-swap-vert", '\ue8d5'),
    SWAP_VERT_CIRCLE("gmi-swap-vert-circle", '\ue8d6'),
    SWAP_VERTICAL_CIRCLE("gmi-swap-vertical-circle", '\ue8d6'),
    SWIPE("gmi-swipe", '\ue9ec'),
    SWITCH_ACCOUNT("gmi-switch-account", '\ue9ed'),
    SWITCH_CAMERA("gmi-switch-camera", '\ue41e'),
    SWITCH_VIDEO("gmi-switch-video", '\ue41f'),
    SYNC("gmi-sync", '\ue627'),
    SYNC_ALT("gmi-sync-alt", '\uea18'),
    SYNC_DISABLED("gmi-sync-disabled", '\ue628'),
    SYNC_PROBLEM("gmi-sync-problem", '\ue629'),
    SYSTEM_UPDATE("gmi-system-update", '\ue62a'),
    SYSTEM_UPDATE_ALT("gmi-system-update-alt", '\ue8d7'),
    SYSTEM_UPDATE_TV("gmi-system-update-tv", '\ue8d7'),
    TAB("gmi-tab", '\ue8d8'),
    TAB_UNSELECTED("gmi-tab-unselected", '\ue8d9'),
    TABLE_CHART("gmi-table-chart", '\ue265'),
    TABLET("gmi-tablet", '\ue32f'),
    TABLET_ANDROID("gmi-tablet-android", '\ue330'),
    TABLET_MAC("gmi-tablet-mac", '\ue331'),
    TAG("gmi-tag", '\ue9ef'),
    TAG_FACES("gmi-tag-faces", '\ue420'),
    TAKEOUT_DINING("gmi-takeout-dining", '\uea74'),
    TAP_AND_PLAY("gmi-tap-and-play", '\ue62b'),
    TERRAIN("gmi-terrain", '\ue564'),
    TEXT_FIELDS("gmi-text-fields", '\ue262'),
    TEXT_FORMAT("gmi-text-format", '\ue165'),
    TEXT_ROTATE_UP("gmi-text-rotate-up", '\ue93a'),
    TEXT_ROTATE_VERTICAL("gmi-text-rotate-vertical", '\ue93b'),
    TEXT_ROTATION_ANGLEDOWN("gmi-text-rotation-angledown", '\ue93c'),
    TEXT_ROTATION_ANGLEUP("gmi-text-rotation-angleup", '\ue93d'),
    TEXT_ROTATION_DOWN("gmi-text-rotation-down", '\ue93e'),
    TEXT_ROTATION_NONE("gmi-text-rotation-none", '\ue93f'),
    TEXTSMS("gmi-textsms", '\ue0d8'),
    TEXTURE("gmi-texture", '\ue421'),
    THEATER_COMEDY("gmi-theater-comedy", '\uea66'),
    THEATERS("gmi-theaters", '\ue8da'),
    THUMB_DOWN("gmi-thumb-down", '\ue8db'),
    THUMB_DOWN_ALT("gmi-thumb-down-alt", '\ue816'),
    THUMB_DOWN_OFF_ALT("gmi-thumb-down-off-alt", '\ue9f2'),
    THUMB_UP("gmi-thumb-up", '\ue8dc'),
    THUMB_UP_ALT("gmi-thumb-up-alt", '\ue817'),
    THUMB_UP_OFF_ALT("gmi-thumb-up-off-alt", '\ue9f3'),
    THUMBS_UP_DOWN("gmi-thumbs-up-down", '\ue8dd'),
    TIME_TO_LEAVE("gmi-time-to-leave", '\ue62c'),
    TIMELAPSE("gmi-timelapse", '\ue422'),
    TIMELINE("gmi-timeline", '\ue922'),
    TIMER("gmi-timer", '\ue425'),
    TIMER_10("gmi-timer_10", '\ue423'),
    TIMER_3("gmi-timer_3", '\ue424'),
    TIMER_OFF("gmi-timer-off", '\ue426'),
    TITLE("gmi-title", '\ue264'),
    TOC("gmi-toc", '\ue8de'),
    TODAY("gmi-today", '\ue8df'),
    TOGGLE_OFF("gmi-toggle-off", '\ue9f5'),
    TOGGLE_ON("gmi-toggle-on", '\ue9f6'),
    TOLL("gmi-toll", '\ue8e0'),
    TONALITY("gmi-tonality", '\ue427'),
    TOUCH_APP("gmi-touch-app", '\ue913'),
    TOYS("gmi-toys", '\ue332'),
    TRACK_CHANGES("gmi-track-changes", '\ue8e1'),
    TRAFFIC("gmi-traffic", '\ue565'),
    TRAIN("gmi-train", '\ue570'),
    TRAM("gmi-tram", '\ue571'),
    TRANSFER_WITHIN_A_STATION("gmi-transfer-within-a-station", '\ue572'),
    TRANSFORM("gmi-transform", '\ue428'),
    TRANSIT_ENTEREXIT("gmi-transit-enterexit", '\ue579'),
    TRANSLATE("gmi-translate", '\ue8e2'),
    TRENDING_DOWN("gmi-trending-down", '\ue8e3'),
    TRENDING_FLAT("gmi-trending-flat", '\ue8e4'),
    TRENDING_NEUTRAL("gmi-trending-neutral", '\ue8e4'),
    TRENDING_UP("gmi-trending-up", '\ue8e5'),
    TRIP_ORIGIN("gmi-trip-origin", '\ue57b'),
    TUNE("gmi-tune", '\ue429'),
    TURNED_IN("gmi-turned-in", '\ue8e6'),
    TURNED_IN_NOT("gmi-turned-in-not", '\ue8e7'),
    TV("gmi-tv", '\ue333'),
    TV_OFF("gmi-tv-off", '\ue647'),
    TWO_WHEELER("gmi-two-wheeler", '\ue9f9'),
    UNARCHIVE("gmi-unarchive", '\ue169'),
    UNDO("gmi-undo", '\ue166'),
    UNFOLD_LESS("gmi-unfold-less", '\ue5d6'),
    UNFOLD_MORE("gmi-unfold-more", '\ue5d7'),
    UNSUBSCRIBE("gmi-unsubscribe", '\ue0eb'),
    UPDATE("gmi-update", '\ue923'),
    UPLOAD_FILE("gmi-upload-file", '\ue9fc'),
    USB("gmi-usb", '\ue1e0'),
    VERIFIED_USER("gmi-verified-user", '\ue8e8'),
    VERTICAL_ALIGN_BOTTOM("gmi-vertical-align-bottom", '\ue258'),
    VERTICAL_ALIGN_CENTER("gmi-vertical-align-center", '\ue259'),
    VERTICAL_ALIGN_TOP("gmi-vertical-align-top", '\ue25a'),
    VERTICAL_SPLIT("gmi-vertical-split", '\ue949'),
    VIBRATION("gmi-vibration", '\ue62d'),
    VIDEO_CALL("gmi-video-call", '\ue070'),
    VIDEO_COLLECTION("gmi-video-collection", '\ue04a'),
    VIDEO_LABEL("gmi-video-label", '\ue071'),
    VIDEO_LIBRARY("gmi-video-library", '\ue04a'),
    VIDEOCAM("gmi-videocam", '\ue04b'),
    VIDEOCAM_OFF("gmi-videocam-off", '\ue04c'),
    VIDEOGAME_ASSET("gmi-videogame-asset", '\ue338'),
    VIEW_AGENDA("gmi-view-agenda", '\ue8e9'),
    VIEW_ARRAY("gmi-view-array", '\ue8ea'),
    VIEW_CAROUSEL("gmi-view-carousel", '\ue8eb'),
    VIEW_COLUMN("gmi-view-column", '\ue8ec'),
    VIEW_COMFORTABLE("gmi-view-comfortable", '\ue42a'),
    VIEW_COMFY("gmi-view-comfy", '\ue42a'),
    VIEW_COMPACT("gmi-view-compact", '\ue42b'),
    VIEW_DAY("gmi-view-day", '\ue8ed'),
    VIEW_HEADLINE("gmi-view-headline", '\ue8ee'),
    VIEW_IN_AR("gmi-view-in-ar", '\ue9fe'),
    VIEW_LIST("gmi-view-list", '\ue8ef'),
    VIEW_MODULE("gmi-view-module", '\ue8f0'),
    VIEW_QUILT("gmi-view-quilt", '\ue8f1'),
    VIEW_STREAM("gmi-view-stream", '\ue8f2'),
    VIEW_WEEK("gmi-view-week", '\ue8f3'),
    VIGNETTE("gmi-vignette", '\ue435'),
    VISIBILITY("gmi-visibility", '\ue8f4'),
    VISIBILITY_OFF("gmi-visibility-off", '\ue8f5'),
    VOICE_CHAT("gmi-voice-chat", '\ue62e'),
    VOICE_OVER_OFF("gmi-voice-over-off", '\ue94a'),
    VOICEMAIL("gmi-voicemail", '\ue0d9'),
    VOLUME_DOWN("gmi-volume-down", '\ue04d'),
    VOLUME_MUTE("gmi-volume-mute", '\ue04e'),
    VOLUME_OFF("gmi-volume-off", '\ue04f'),
    VOLUME_UP("gmi-volume-up", '\ue050'),
    VOLUNTEER_ACTIVISM("gmi-volunteer-activism", '\uea70'),
    VPN_KEY("gmi-vpn-key", '\ue0da'),
    VPN_LOCK("gmi-vpn-lock", '\ue62f'),
    WALLET_GIFTCARD("gmi-wallet-giftcard", '\ue8f6'),
    WALLET_MEMBERSHIP("gmi-wallet-membership", '\ue8f7'),
    WALLET_TRAVEL("gmi-wallet-travel", '\ue8f8'),
    WALLPAPER("gmi-wallpaper", '\ue1bc'),
    WARNING("gmi-warning", '\ue002'),
    WATCH("gmi-watch", '\ue334'),
    WATCH_LATER("gmi-watch-later", '\ue924'),
    WATERFALL_CHART("gmi-waterfall-chart", '\uea00'),
    WAVES("gmi-waves", '\ue176'),
    WB_AUTO("gmi-wb-auto", '\ue42c'),
    WB_CLOUDY("gmi-wb-cloudy", '\ue42d'),
    WB_INCANDESCENT("gmi-wb-incandescent", '\ue42e'),
    WB_IRIDESCENT("gmi-wb-iridescent", '\ue436'),
    WB_SHADE("gmi-wb-shade", '\uea01'),
    WB_SUNNY("gmi-wb-sunny", '\ue430'),
    WB_TWIGHLIGHT("gmi-wb-twighlight", '\uea02'),
    WC("gmi-wc", '\ue63d'),
    WEB("gmi-web", '\ue051'),
    WEB_ASSET("gmi-web-asset", '\ue069'),
    WEEKEND("gmi-weekend", '\ue16b'),
    WHATSHOT("gmi-whatshot", '\ue80e'),
    WHERE_TO_VOTE("gmi-where-to-vote", '\ue177'),
    WIDGETS("gmi-widgets", '\ue1bd'),
    WIFI("gmi-wifi", '\ue63e'),
    WIFI_LOCK("gmi-wifi-lock", '\ue1e1'),
    WIFI_OFF("gmi-wifi-off", '\ue648'),
    WIFI_TETHERING("gmi-wifi-tethering", '\ue1e2'),
    WORK("gmi-work", '\ue8f9'),
    WORK_OFF("gmi-work-off", '\ue942'),
    WORK_OUTLINE("gmi-work-outline", '\ue943'),
    WORKSPACES_FILLED("gmi-workspaces-filled", '\uea0d'),
    WORKSPACES_OUTLINE("gmi-workspaces-outline", '\uea0f'),
    WRAP_TEXT("gmi-wrap-text", '\ue25b'),
    YOUTUBE_SEARCHED_FOR("gmi-youtube-searched-for", '\ue8fa'),
    ZOOM_IN("gmi-zoom-in", '\ue8ff'),
    ZOOM_OUT("gmi-zoom-out", '\ue900'),
    ZOOM_OUT_MAP("gmi-zoom-out-map", '\ue56b');

    public static Material findByDescription(String description) {
        for (Material font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Material(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}