/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2018 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.material;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Material implements Ikon {
    ACCESSIBILITY("gmi-accessibility", '\ue84E'),
    ACCESSIBLE("gmi-accessible", '\ue914'),
    ACCESS_ALARM("gmi-access-alarm", '\ue190'),
    ACCESS_ALARMS("gmi-access-alarms", '\ue191'),
    ACCESS_TIME("gmi-access-time", '\ue192'),
    ACCOUNT_BALANCE("gmi-account-balance", '\ue84F'),
    ACCOUNT_BALANCE_WALLET("gmi-account-balance-wallet", '\ue850'),
    ACCOUNT_BOX("gmi-account-box", '\ue851'),
    ACCOUNT_CIRCLE("gmi-account-circle", '\ue853'),
    AC_UNIT("gmi-ac-unit", '\ueB3B'),
    ADB("gmi-adb", '\ue60E'),
    ADD("gmi-add", '\ue145'),
    ADD_ALARM("gmi-add-alarm", '\ue193'),
    ADD_ALERT("gmi-add-alert", '\ue003'),
    ADD_A_PHOTO("gmi-add-a-photo", '\ue439'),
    ADD_BOX("gmi-add-box", '\ue146'),
    ADD_CIRCLE("gmi-add-circle", '\ue147'),
    ADD_CIRCLE_OUTLINE("gmi-add-circle-outline", '\ue148'),
    ADD_LOCATION("gmi-add-location", '\ue567'),
    ADD_SHOPPING_CART("gmi-add-shopping-cart", '\ue854'),
    ADD_TO_PHOTOS("gmi-add-to-photos", '\ue39D'),
    ADD_TO_QUEUE("gmi-add-to-queue", '\ue05C'),
    ADJUST("gmi-adjust", '\ue39E'),
    AIRLINE_SEAT_FLAT("gmi-airline-seat-flat", '\ue630'),
    AIRLINE_SEAT_FLAT_ANGLED("gmi-airline-seat-flat-angled", '\ue631'),
    AIRLINE_SEAT_INDIVIDUAL_SUITE("gmi-airline-seat-individual-suite", '\ue632'),
    AIRLINE_SEAT_LEGROOM_EXTRA("gmi-airline-seat-legroom-extra", '\ue633'),
    AIRLINE_SEAT_LEGROOM_NORMAL("gmi-airline-seat-legroom-normal", '\ue634'),
    AIRLINE_SEAT_LEGROOM_REDUCED("gmi-airline-seat-legroom-reduced", '\ue635'),
    AIRLINE_SEAT_RECLINE_EXTRA("gmi-airline-seat-recline-extra", '\ue636'),
    AIRLINE_SEAT_RECLINE_NORMAL("gmi-airline-seat-recline-normal", '\ue637'),
    AIRPLANEMODE_ACTIVE("gmi-airplanemode-active", '\ue195'),
    AIRPLANEMODE_INACTIVE("gmi-airplanemode-inactive", '\ue194'),
    AIRPLAY("gmi-airplay", '\ue055'),
    AIRPORT_SHUTTLE("gmi-airport-shuttle", '\ueB3C'),
    ALARM("gmi-alarm", '\ue855'),
    ALARM_ADD("gmi-alarm-add", '\ue856'),
    ALARM_OFF("gmi-alarm-off", '\ue857'),
    ALARM_ON("gmi-alarm-on", '\ue858'),
    ALBUM("gmi-album", '\ue019'),
    ALL_INCLUSIVE("gmi-all-inclusive", '\ueB3D'),
    ALL_OUT("gmi-all-out", '\ue90B'),
    ANDROID("gmi-android", '\ue859'),
    ANNOUNCEMENT("gmi-announcement", '\ue85A'),
    APPS("gmi-apps", '\ue5C3'),
    ARCHIVE("gmi-archive", '\ue149'),
    ARROW_BACK("gmi-arrow-back", '\ue5C4'),
    ARROW_DOWNLOAD("gmi-arrow-download", '\ue5DB'),
    ARROW_DROP_DOWN("gmi-arrow-drop-down", '\ue5C5'),
    ARROW_DROP_DOWN_CIRCLE("gmi-arrow-drop-down-circle", '\ue5C6'),
    ARROW_DROP_UP("gmi-arrow-drop-up", '\ue5C7'),
    ARROW_FORWARD("gmi-arrow-forward", '\ue5C8'),
    ARROW_UPWARD("gmi-arrow-upward", '\ue5D8'),
    ART_TRACK("gmi-art-track", '\ue060'),
    ASPECT_RATIO("gmi-aspect-ratio", '\ue85B'),
    ASSESSMENT("gmi-assessment", '\ue85C'),
    ASSIGNMENT("gmi-assignment", '\ue85D'),
    ASSIGNMENT_IND("gmi-assignment-ind", '\ue85E'),
    ASSIGNMENT_LATE("gmi-assignment-late", '\ue85F'),
    ASSIGNMENT_RETURN("gmi-assignment-return", '\ue860'),
    ASSIGNMENT_RETURNED("gmi-assignment-returned", '\ue861'),
    ASSIGNMENT_TURNED_IN("gmi-assignment-turned-in", '\ue862'),
    ASSISTANT("gmi-assistant", '\ue39F'),
    ASSISTANT_PHOTO("gmi-assistant-photo", '\ue3A0'),
    ATTACHMENT("gmi-attachment", '\ue2BC'),
    ATTACH_FILE("gmi-attach-file", '\ue226'),
    ATTACH_MONEY("gmi-attach-money", '\ue227'),
    AUDIOTRACK("gmi-audiotrack", '\ue3A1'),
    AUTORENEW("gmi-autorenew", '\ue863'),
    AV_TIMER("gmi-av-timer", '\ue01B'),
    BACKSPACE("gmi-backspace", '\ue14A'),
    BACKUP("gmi-backup", '\ue864'),
    BATTERY_ALERT("gmi-battery-alert", '\ue19C'),
    BATTERY_CHARGING_FULL("gmi-battery-charging-full", '\ue1A3'),
    BATTERY_FULL("gmi-battery-full", '\ue1A4'),
    BATTERY_STD("gmi-battery-std", '\ue1A5'),
    BATTERY_UNKNOWN("gmi-battery-unknown", '\ue1A6'),
    BEACH_ACCESS("gmi-beach-access", '\ueB3E'),
    BEENHERE("gmi-beenhere", '\ue52D'),
    BLOCK("gmi-block", '\ue14B'),
    BLUETOOTH("gmi-bluetooth", '\ue1A7'),
    BLUETOOTH_AUDIO("gmi-bluetooth-audio", '\ue60F'),
    BLUETOOTH_CONNECTED("gmi-bluetooth-connected", '\ue1A8'),
    BLUETOOTH_DISABLED("gmi-bluetooth-disabled", '\ue1A9'),
    BLUETOOTH_SEARCHING("gmi-bluetooth-searching", '\ue1AA'),
    BLUR_CIRCULAR("gmi-blur-circular", '\ue3A2'),
    BLUR_LINEAR("gmi-blur-linear", '\ue3A3'),
    BLUR_OFF("gmi-blur-off", '\ue3A4'),
    BLUR_ON("gmi-blur-on", '\ue3A5'),
    BOOK("gmi-book", '\ue865'),
    BOOKMARK("gmi-bookmark", '\ue866'),
    BOOKMARK_BORDER("gmi-bookmark-border", '\ue867'),
    BORDER_ALL("gmi-border-all", '\ue228'),
    BORDER_BOTTOM("gmi-border-bottom", '\ue229'),
    BORDER_CLEAR("gmi-border-clear", '\ue22A'),
    BORDER_COLOR("gmi-border-color", '\ue22B'),
    BORDER_HORIZONTAL("gmi-border-horizontal", '\ue22C'),
    BORDER_INNER("gmi-border-inner", '\ue22D'),
    BORDER_LEFT("gmi-border-left", '\ue22E'),
    BORDER_OUTER("gmi-border-outer", '\ue22F'),
    BORDER_RIGHT("gmi-border-right", '\ue230'),
    BORDER_STYLE("gmi-border-style", '\ue231'),
    BORDER_TOP("gmi-border-top", '\ue232'),
    BORDER_VERTICAL("gmi-border-vertical", '\ue233'),
    BRANDING_WATERMARK("gmi-branding_watermark", '\ue06b'),
    BRIGHTNESS_1("gmi-brightness-1", '\ue3A6'),
    BRIGHTNESS_2("gmi-brightness-2", '\ue3A7'),
    BRIGHTNESS_3("gmi-brightness-3", '\ue3A8'),
    BRIGHTNESS_4("gmi-brightness-4", '\ue3A9'),
    BRIGHTNESS_5("gmi-brightness-5", '\ue3AA'),
    BRIGHTNESS_6("gmi-brightness-6", '\ue3AB'),
    BRIGHTNESS_7("gmi-brightness-7", '\ue3AC'),
    BRIGHTNESS_AUTO("gmi-brightness-auto", '\ue1AB'),
    BRIGHTNESS_HIGH("gmi-brightness-high", '\ue1AC'),
    BRIGHTNESS_LOW("gmi-brightness-low", '\ue1AD'),
    BRIGHTNESS_MEDIUM("gmi-brightness-medium", '\ue1AE'),
    BROKEN_IMAGE("gmi-broken-image", '\ue3AD'),
    BRUSH("gmi-brush", '\ue3AE'),
    BUBBLE_CHART("gmi-bubble-chart", '\ue6dd'),
    BUG_REPORT("gmi-bug-report", '\ue868'),
    BUILD("gmi-build", '\ue869'),
    BURST_MODE("gmi-burst-mode", '\ue43c'),
    BUSINESS("gmi-business", '\ue0AF'),
    BUSINESS_CENTER("gmi-business-center", '\ueB3F'),
    CACHED("gmi-cached", '\ue86A'),
    CAKE("gmi-cake", '\ue7E9'),
    CALL("gmi-call", '\ue0B0'),
    CALL_END("gmi-call-end", '\ue0B1'),
    CALL_MADE("gmi-call-made", '\ue0B2'),
    CALL_MERGE("gmi-call-merge", '\ue0B3'),
    CALL_MISSED("gmi-call-missed", '\ue0B4'),
    CALL_MISSED_OUTGOING("gmi-call-missed-outgoing", '\ue0E4'),
    CALL_RECEIVED("gmi-call-received", '\ue0B5'),
    CALL_SPLIT("gmi-call-split", '\ue0B6'),
    CALL_TO_ACTION("gmi-call-to-action", '\ue06c'),
    CAMERA("gmi-camera", '\ue3AF'),
    CAMERA_ALT("gmi-camera-alt", '\ue3B0'),
    CAMERA_ENHANCE("gmi-camera-enhance", '\ue8FC'),
    CAMERA_FRONT("gmi-camera-front", '\ue3B1'),
    CAMERA_REAR("gmi-camera-rear", '\ue3B2'),
    CAMERA_ROLL("gmi-camera-roll", '\ue3B3'),
    CANCEL("gmi-cancel", '\ue5C9'),
    CARD_GIFTCARD("gmi-card-giftcard", '\ue8F6'),
    CARD_MEMBERSHIP("gmi-card-membership", '\ue8F7'),
    CARD_TRAVEL("gmi-card-travel", '\ue8F8'),
    CASINO("gmi-casino", '\ueB40'),
    CAST("gmi-cast", '\ue307'),
    CAST_CONNECTED("gmi-cast-connected", '\ue308'),
    CENTER_FOCUS_STRONG("gmi-center-focus-strong", '\ue3B4'),
    CENTER_FOCUS_WEAK("gmi-center-focus-weak", '\ue3B5'),
    CHANGE_HISTORY("gmi-change-history", '\ue86B'),
    CHAT("gmi-chat", '\ue0B7'),
    CHAT_BUBBLE("gmi-chat-bubble", '\ue0CA'),
    CHAT_BUBBLE_OUTLINE("gmi-chat-bubble-outline", '\ue0CB'),
    CHECK("gmi-check", '\ue5CA'),
    CHECK_BOX("gmi-check-box", '\ue834'),
    CHECK_BOX_OUTLINE_BLANK("gmi-check-box-outline-blank", '\ue835'),
    CHECK_CIRCLE("gmi-check-circle", '\ue86C'),
    CHEVRON_LEFT("gmi-chevron-left", '\ue5CB'),
    CHEVRON_RIGHT("gmi-chevron-right", '\ue5CC'),
    CHILD_CARE("gmi-child-care", '\ueB41'),
    CHILD_FRIENDLY("gmi-child-friendly", '\ueB42'),
    CHROME_READER_MODE("gmi-chrome-reader-mode", '\ue86D'),
    CLASS("gmi-class", '\ue86E'),
    CLEAR("gmi-clear", '\ue14C'),
    CLEAR_ALL("gmi-clear-all", '\ue0B8'),
    CLOSE("gmi-close", '\ue5CD'),
    CLOSED_CAPTION("gmi-closed-caption", '\ue01C'),
    CLOUD("gmi-cloud", '\ue2BD'),
    CLOUD_CIRCLE("gmi-cloud-circle", '\ue2BE'),
    CLOUD_DONE("gmi-cloud-done", '\ue2BF'),
    CLOUD_DOWNLOAD("gmi-cloud-download", '\ue2C0'),
    CLOUD_OFF("gmi-cloud-off", '\ue2C1'),
    CLOUD_QUEUE("gmi-cloud-queue", '\ue2C2'),
    CLOUD_UPLOAD("gmi-cloud-upload", '\ue2C3'),
    CODE("gmi-code", '\ue86F'),
    COLLECTIONS("gmi-collections", '\ue3B6'),
    COLLECTIONS_BOOKMARK("gmi-collections-bookmark", '\ue431'),
    COLORIZE("gmi-colorize", '\ue3B8'),
    COLOR_LENS("gmi-color-lens", '\ue3B7'),
    COMMENT("gmi-comment", '\ue0B9'),
    COMPARE("gmi-compare", '\ue3B9'),
    COMPARE_ARROWS("gmi-compare-arrows", '\ue915'),
    COMPUTER("gmi-computer", '\ue30A'),
    CONFIRMATION_NUMBER("gmi-confirmation-number", '\ue638'),
    CONTACTS("gmi-contacts", '\ue0BA'),
    CONTACT_MAIL("gmi-contact-mail", '\ue0D0'),
    CONTACT_PHONE("gmi-contact-phone", '\ue0CF'),
    CONTENT_COPY("gmi-content-copy", '\ue14D'),
    CONTENT_CUT("gmi-content-cut", '\ue14E'),
    CONTENT_PASTE("gmi-content-paste", '\ue14F'),
    CONTROL_POINT("gmi-control-point", '\ue3BA'),
    CONTROL_POINT_DUPLICATE("gmi-control-point-duplicate", '\ue3BB'),
    COPYRIGHT("gmi-copyright", '\ue90C'),
    CREATE("gmi-create", '\ue150'),
    CREATE_NEW_FOLDER("gmi-create-new-folder", '\ue2CC'),
    CREDIT_CARD("gmi-credit-card", '\ue870'),
    CROP("gmi-crop", '\ue3BE'),
    CROP_16_9("gmi-crop-16-9", '\ue3BC'),
    CROP_3_2("gmi-crop-3-2", '\ue3BD'),
    CROP_5_4("gmi-crop-5-4", '\ue3BF'),
    CROP_7_5("gmi-crop-7-5", '\ue3C0'),
    CROP_DIN("gmi-crop-din", '\ue3C1'),
    CROP_FREE("gmi-crop-free", '\ue3C2'),
    CROP_LANDSCAPE("gmi-crop-landscape", '\ue3C3'),
    CROP_ORIGINAL("gmi-crop-original", '\ue3C4'),
    CROP_PORTRAIT("gmi-crop-portrait", '\ue3C5'),
    CROP_ROTATE("gmi-crop-rotate", '\ue437'),
    CROP_SQUARE("gmi-crop-square", '\ue3C6'),
    DASHBOARD("gmi-dashboard", '\ue871'),
    DATA_USAGE("gmi-data-usage", '\ue1AF'),
    DATE_RANGE("gmi-date-range", '\ue916'),
    DEHAZE("gmi-dehaze", '\ue3C7'),
    DELETE("gmi-delete", '\ue872'),
    DELETE_FOREVER("gmi-delete-forever", '\ue92b'),
    DELETE_SWEEP("gmi-delete-sweep", '\ue16c'),
    DESCRIPTION("gmi-description", '\ue873'),
    DESKTOP_MAC("gmi-desktop-mac", '\ue30B'),
    DESKTOP_WINDOWS("gmi-desktop-windows", '\ue30C'),
    DETAILS("gmi-details", '\ue3C8'),
    DEVELOPER_BOARD("gmi-developer-board", '\ue30D'),
    DEVELOPER_MODE("gmi-developer-mode", '\ue1B0'),
    DEVICES("gmi-devices", '\ue1B1'),
    DEVICES_OTHER("gmi-devices-other", '\ue337'),
    DEVICE_HUB("gmi-device-hub", '\ue335'),
    DIALER_SIP("gmi-dialer-sip", '\ue0BB'),
    DIALPAD("gmi-dialpad", '\ue0BC'),
    DIRECTIONS("gmi-directions", '\ue52E'),
    DIRECTIONS_BIKE("gmi-directions-bike", '\ue52F'),
    DIRECTIONS_BOAT("gmi-directions-boat", '\ue532'),
    DIRECTIONS_BUS("gmi-directions-bus", '\ue530'),
    DIRECTIONS_CAR("gmi-directions-car", '\ue531'),
    DIRECTIONS_RAILWAY("gmi-directions-railway", '\ue534'),
    DIRECTIONS_RUN("gmi-directions-run", '\ue566'),
    DIRECTIONS_SUBWAY("gmi-directions-subway", '\ue533'),
    DIRECTIONS_TRANSIT("gmi-directions-transit", '\ue535'),
    DIRECTIONS_WALK("gmi-directions-walk", '\ue536'),
    DISC_FULL("gmi-disc-full", '\ue610'),
    DNS("gmi-dns", '\ue875'),
    DOCK("gmi-dock", '\ue30E'),
    DOMAIN("gmi-domain", '\ue7EE'),
    DONE("gmi-done", '\ue876'),
    DONE_ALL("gmi-done-all", '\ue877'),
    DONUT_LARGE("gmi-donut-large", '\ue917'),
    DONUT_SMALL("gmi-donut-small", '\ue918'),
    DO_NOT_DISTURB("gmi-do-not-disturb", '\ue612'),
    DO_NOT_DISTURB_ALT("gmi-do-not-disturb-alt", '\ue611'),
    DO_NOT_DISTURB_OFF("gmi-do-not-disturb-off", '\ue643'),
    DO_NOT_DISTURB_ON("gmi-do-not-disturb-on", '\ue644'),
    DRAFTS("gmi-drafts", '\ue151'),
    DRAG_HANDLE("gmi-drag-handle", '\ue25D'),
    DRIVE_ETA("gmi-drive-eta", '\ue613'),
    DVR("gmi-dvr", '\ue1B2'),
    EDIT("gmi-edit", '\ue3C9'),
    EDIT_LOCATION("gmi-edit-location", '\ue568'),
    EJECT("gmi-eject", '\ue8FB'),
    EMAIL("gmi-email", '\ue0BE'),
    ENHANCED_ENCRYPT("gmi-enhanced-encrypt", '\ue63F'),
    EQUALIZER("gmi-equalizer", '\ue01D'),
    ERROR("gmi-error", '\ue000'),
    ERROR_OUTLINE("gmi-error-outline", '\ue001'),
    EURO_SYMBOL("gmi-euro-symbol", '\ue926'),
    EVENT("gmi-event", '\ue878'),
    EVENT_AVAILABLE("gmi-event-available", '\ue614'),
    EVENT_BUSY("gmi-event-busy", '\ue615'),
    EVENT_NOTE("gmi-event-note", '\ue616'),
    EVENT_SEAT("gmi-event-seat", '\ue903'),
    EV_STATION("gmi-ev-station", '\ue56d'),
    EXIT_TO_APP("gmi-exit-to-app", '\ue879'),
    EXPAND_LESS("gmi-expand-less", '\ue5CE'),
    EXPAND_MORE("gmi-expand-more", '\ue5CF'),
    EXPLICIT("gmi-explicit", '\ue01E'),
    EXPLORE("gmi-explore", '\ue87A'),
    EXPOSURE("gmi-exposure", '\ue3CA'),
    EXPOSURE_NEG_1("gmi-exposure-neg-1", '\ue3CB'),
    EXPOSURE_NEG_2("gmi-exposure-neg-2", '\ue3CC'),
    EXPOSURE_PLUS_1("gmi-exposure-plus-1", '\ue3CD'),
    EXPOSURE_PLUS_2("gmi-exposure-plus-2", '\ue3CE'),
    EXPOSURE_ZERO("gmi-exposure-zero", '\ue3CF'),
    EXTENSION("gmi-extension", '\ue87B'),
    FACE("gmi-face", '\ue87C'),
    FAST_FORWARD("gmi-fast-forward", '\ue01F'),
    FAST_REWIND("gmi-fast-rewind", '\ue020'),
    FAVORITE("gmi-favorite", '\ue87D'),
    FAVORITE_BORDER("gmi-favorite-border", '\ue87E'),
    FEATURED_PLAY_LIST("gmi-featured-play-list", '\ue06d'),
    FEATURED_VIDEO("gmi-featured-video", '\ue06e'),
    FEEDBACK("gmi-feedback", '\ue87F'),
    FIBER_DVR("gmi-fiber-dvr", '\ue05D'),
    FIBER_MANUAL_RECORD("gmi-fiber-manual-record", '\ue061'),
    FIBER_NEW("gmi-fiber-new", '\ue05E'),
    FIBER_PIN("gmi-fiber-pin", '\ue06A'),
    FIBER_SMART_RECORD("gmi-fiber-smart-record", '\ue062'),
    FILE_DOWNLOAD("gmi-file-download", '\ue2C4'),
    FILE_UPLOAD("gmi-file-upload", '\ue2C6'),
    FILTER("gmi-filter", '\ue3D3'),
    FILTER_1("gmi-filter-1", '\ue3D0'),
    FILTER_2("gmi-filter-2", '\ue3D1'),
    FILTER_3("gmi-filter-3", '\ue3D2'),
    FILTER_4("gmi-filter-4", '\ue3D4'),
    FILTER_5("gmi-filter-5", '\ue3D5'),
    FILTER_6("gmi-filter-6", '\ue3D6'),
    FILTER_7("gmi-filter-7", '\ue3D7'),
    FILTER_8("gmi-filter-8", '\ue3D8'),
    FILTER_9("gmi-filter-9", '\ue3D9'),
    FILTER_9_PLUS("gmi-filter-9-plus", '\ue3DA'),
    FILTER_B_AND_W("gmi-filter-b-and-w", '\ue3DB'),
    FILTER_CENTER_FOCUS("gmi-filter-center-focus", '\ue3DC'),
    FILTER_DRAMA("gmi-filter-drama", '\ue3DD'),
    FILTER_FRAMES("gmi-filter-frames", '\ue3DE'),
    FILTER_HDR("gmi-filter-hdr", '\ue3DF'),
    FILTER_LIST("gmi-filter-list", '\ue152'),
    FILTER_NONE("gmi-filter-none", '\ue3E0'),
    FILTER_TILT_SHIFT("gmi-filter-tilt-shift", '\ue3E2'),
    FILTER_VINTAGE("gmi-filter-vintage", '\ue3E3'),
    FIND_IN_PAGE("gmi-find-in-page", '\ue880'),
    FIND_REPLACE("gmi-find-replace", '\ue881'),
    FINGERPRINT("gmi-fingerprint", '\ue90D'),
    FIRST_PAGE("gmi-first-page", '\ue5dc'),
    FITNESS_CENTER("gmi-fitness-center", '\ueB43'),
    FLAG("gmi-flag", '\ue153'),
    FLARE("gmi-flare", '\ue3E4'),
    FLASH_AUTO("gmi-flash-auto", '\ue3E5'),
    FLASH_OFF("gmi-flash-off", '\ue3E6'),
    FLASH_ON("gmi-flash-on", '\ue3E7'),
    FLIGHT("gmi-flight", '\ue539'),
    FLIGHT_LAND("gmi-flight-land", '\ue904'),
    FLIGHT_TAKEOFF("gmi-flight-takeoff", '\ue905'),
    FLIP("gmi-flip", '\ue3E8'),
    FLIP_TO_BACK("gmi-flip-to-back", '\ue882'),
    FLIP_TO_FRONT("gmi-flip-to-front", '\ue883'),
    FOLDER("gmi-folder", '\ue2C7'),
    FOLDER_OPEN("gmi-folder-open", '\ue2C8'),
    FOLDER_SHARED("gmi-folder-shared", '\ue2C9'),
    FOLDER_SPECIAL("gmi-folder-special", '\ue617'),
    FONT_DOWNLOAD("gmi-font-download", '\ue167'),
    FORMAT_ALIGN_CENTER("gmi-format-align-center", '\ue234'),
    FORMAT_ALIGN_JUSTIFY("gmi-format-align-justify", '\ue235'),
    FORMAT_ALIGN_LEFT("gmi-format-align-left", '\ue236'),
    FORMAT_ALIGN_RIGHT("gmi-format-align-right", '\ue237'),
    FORMAT_BOLD("gmi-format-bold", '\ue238'),
    FORMAT_CLEAR("gmi-format-clear", '\ue239'),
    FORMAT_COLOR_FILL("gmi-format-color-fill", '\ue23A'),
    FORMAT_COLOR_RESET("gmi-format-color-reset", '\ue23B'),
    FORMAT_COLOR_TEXT("gmi-format-color-text", '\ue23C'),
    FORMAT_INDENT_DECREASE("gmi-format-indent-decrease", '\ue23D'),
    FORMAT_INDENT_INCREASE("gmi-format-indent-increase", '\ue23E'),
    FORMAT_ITALIC("gmi-format-italic", '\ue23F'),
    FORMAT_LINE_SPACING("gmi-format-line-spacing", '\ue240'),
    FORMAT_LIST_BULLETED("gmi-format-list-bulleted", '\ue241'),
    FORMAT_LIST_NUMBERED("gmi-format-list-numbered", '\ue242'),
    FORMAT_PAINT("gmi-format-paint", '\ue243'),
    FORMAT_QUOTE("gmi-format-quote", '\ue244'),
    FORMAT_SHAPES("gmi-format-shapes", '\ue25E'),
    FORMAT_SIZE("gmi-format-size", '\ue245'),
    FORMAT_STRIKETHROUGH("gmi-format-strikethrough", '\ue246'),
    FORMAT_TEXTDIRECTION_L_TO_R("gmi-format-textdirection-l-to-r", '\ue247'),
    FORMAT_TEXTDIRECTION_R_TO_L("gmi-format-textdirection-r-to-l", '\ue248'),
    FORMAT_UNDERLINED("gmi-format-underlined", '\ue249'),
    FORUM("gmi-forum", '\ue0BF'),
    FORWARD("gmi-forward", '\ue154'),
    FORWARD_10("gmi-forward-10", '\ue056'),
    FORWARD_30("gmi-forward-30", '\ue057'),
    FORWARD_5("gmi-forward-5", '\ue058'),
    FREE_BREAKFAST("gmi-free-breakfast", '\ueB44'),
    FULLSCREEN("gmi-fullscreen", '\ue5D0'),
    FULLSCREEN_EXIT("gmi-fullscreen-exit", '\ue5D1'),
    FUNCTIONS("gmi-functions", '\ue24A'),
    GAMEPAD("gmi-gamepad", '\ue30F'),
    GAMES("gmi-games", '\ue021'),
    GAVEL("gmi-gavel", '\ue90E'),
    GESTURE("gmi-gesture", '\ue155'),
    GET_APP("gmi-get-app", '\ue884'),
    GIF("gmi-gif", '\ue908'),
    GOLF_COURSE("gmi-golf-course", '\ueB45'),
    GPS_FIXED("gmi-gps-fixed", '\ue1B3'),
    GPS_NOT_FIXED("gmi-gps-not-fixed", '\ue1B4'),
    GPS_OFF("gmi-gps-off", '\ue1B5'),
    GRADE("gmi-grade", '\ue885'),
    GRADIENT("gmi-gradient", '\ue3E9'),
    GRAIN("gmi-grain", '\ue3EA'),
    GRAPHIC_EQ("gmi-graphic-eq", '\ue1B8'),
    GRID_OFF("gmi-grid-off", '\ue3EB'),
    GRID_ON("gmi-grid-on", '\ue3EC'),
    GROUP("gmi-group", '\ue7EF'),
    GROUP_ADD("gmi-group-add", '\ue7F0'),
    GROUP_WORK("gmi-group-work", '\ue886'),
    G_TRANSLATE("gmi-g-translate", '\ue927'),
    HD("gmi-hd", '\ue052'),
    HDR_OFF("gmi-hdr-off", '\ue3ED'),
    HDR_ON("gmi-hdr-on", '\ue3EE'),
    HDR_STRONG("gmi-hdr-strong", '\ue3F1'),
    HDR_WEAK("gmi-hdr-weak", '\ue3F2'),
    HEADSET("gmi-headset", '\ue310'),
    HEADSET_MIC("gmi-headset-mic", '\ue311'),
    HEALING("gmi-healing", '\ue3F3'),
    HEARING("gmi-hearing", '\ue023'),
    HELP("gmi-help", '\ue887'),
    HELP_OUTLINE("gmi-help-outline", '\ue8FD'),
    HIGHLIGHT("gmi-highlight", '\ue25F'),
    HIGHLIGHT_OFF("gmi-highlight-off", '\ue888'),
    HIGH_QUALITY("gmi-high-quality", '\ue024'),
    HISTORY("gmi-history", '\ue889'),
    HOME("gmi-home", '\ue88A'),
    HOTEL("gmi-hotel", '\ue53A'),
    HOT_TUB("gmi-hot-tub", '\ueB46'),
    HOURGLASS_EMPTY("gmi-hourglass-empty", '\ue88B'),
    HOURGLASS_FULL("gmi-hourglass-full", '\ue88C'),
    HTTP("gmi-http", '\ue902'),
    HTTPS("gmi-https", '\ue88D'),
    IMAGE("gmi-image", '\ue3F4'),
    IMAGE_ASPECT_RATIO("gmi-image-aspect-ratio", '\ue3F5'),
    IMPORTANT_DEVICES("gmi-important-devices", '\ue912'),
    IMPORT_CONTACTS("gmi-import-contacts", '\ue0E0'),
    IMPORT_EXPORT("gmi-import-export", '\ue0C3'),
    INBOX("gmi-inbox", '\ue156'),
    INDETERMINATE_CHECK_BOX("gmi-indeterminate-check-box", '\ue909'),
    INFO("gmi-info", '\ue88E'),
    INFO_OUTLINE("gmi-info-outline", '\ue88F'),
    INPUT("gmi-input", '\ue890'),
    INSERT_CHART("gmi-insert-chart", '\ue24B'),
    INSERT_COMMENT("gmi-insert-comment", '\ue24C'),
    INSERT_DRIVE_FILE("gmi-insert-drive-file", '\ue24D'),
    INSERT_EMOTICON("gmi-insert-emoticon", '\ue24E'),
    INSERT_INVITATION("gmi-insert-invitation", '\ue24F'),
    INSERT_LINK("gmi-insert-link", '\ue250'),
    INSERT_PHOTO("gmi-insert-photo", '\ue251'),
    INVERT_COLORS("gmi-invert-colors", '\ue891'),
    INVERT_COLORS_OFF("gmi-invert-colors-off", '\ue0C4'),
    ISO("gmi-iso", '\ue3F6'),
    KEYBOARD("gmi-keyboard", '\ue312'),
    KEYBOARD_ARROW_DOWN("gmi-keyboard-arrow-down", '\ue313'),
    KEYBOARD_ARROW_LEFT("gmi-keyboard-arrow-left", '\ue314'),
    KEYBOARD_ARROW_RIGHT("gmi-keyboard-arrow-right", '\ue315'),
    KEYBOARD_ARROW_UP("gmi-keyboard-arrow-up", '\ue316'),
    KEYBOARD_BACKSPACE("gmi-keyboard-backspace", '\ue317'),
    KEYBOARD_CAPSLOCK("gmi-keyboard-capslock", '\ue318'),
    KEYBOARD_HIDE("gmi-keyboard-hide", '\ue31A'),
    KEYBOARD_RETURN("gmi-keyboard-return", '\ue31B'),
    KEYBOARD_TAB("gmi-keyboard-tab", '\ue31C'),
    KEYBOARD_VOICE("gmi-keyboard-voice", '\ue31D'),
    KITCHEN("gmi-kitchen", '\ueB47'),
    LABEL("gmi-label", '\ue892'),
    LABEL_OUTLINE("gmi-label-outline", '\ue893'),
    LANDSCAPE("gmi-landscape", '\ue3F7'),
    LANGUAGE("gmi-language", '\ue894'),
    LAPTOP("gmi-laptop", '\ue31E'),
    LAPTOP_CHROMEBOOK("gmi-laptop-chromebook", '\ue31F'),
    LAPTOP_MAC("gmi-laptop-mac", '\ue320'),
    LAPTOP_WINDOWS("gmi-laptop-windows", '\ue321'),
    LAST_PAGE("gmi-last-page", '\ue5dd'),
    LAUNCH("gmi-launch", '\ue895'),
    LAYERS("gmi-layers", '\ue53B'),
    LAYERS_CLEAR("gmi-layers-clear", '\ue53C'),
    LEAK_ADD("gmi-leak-add", '\ue3F8'),
    LEAK_REMOVE("gmi-leak-remove", '\ue3F9'),
    LENS("gmi-lens", '\ue3FA'),
    LIBRARY_ADD("gmi-library-add", '\ue02E'),
    LIBRARY_BOOKS("gmi-library-books", '\ue02F'),
    LIBRARY_MUSIC("gmi-library-music", '\ue030'),
    LIGHTBULB_OUTLINE("gmi-lightbulb-outline", '\ue90F'),
    LINEAR_SCALE("gmi-linear-scale", '\ue260'),
    LINE_STYLE("gmi-line-style", '\ue919'),
    LINE_WEIGHT("gmi-line-weight", '\ue91A'),
    LINK("gmi-link", '\ue157'),
    LINKED_CAMERA("gmi-linked-camera", '\ue438'),
    LIST("gmi-list", '\ue896'),
    LIVE_HELP("gmi-live-help", '\ue0C6'),
    LIVE_TV("gmi-live-tv", '\ue639'),
    LOCAL_ACTIVITY("gmi-local-activity", '\ue53F'),
    LOCAL_AIRPORT("gmi-local-airport", '\ue53D'),
    LOCAL_ATM("gmi-local-atm", '\ue53E'),
    LOCAL_BAR("gmi-local-bar", '\ue540'),
    LOCAL_CAFE("gmi-local-cafe", '\ue541'),
    LOCAL_CAR_WASH("gmi-local-car-wash", '\ue542'),
    LOCAL_CONVENIENCE_STORE("gmi-local-convenience-store", '\ue543'),
    LOCAL_DINING("gmi-local-dining", '\ue556'),
    LOCAL_DRINK("gmi-local-drink", '\ue544'),
    LOCAL_FLORIST("gmi-local-florist", '\ue545'),
    LOCAL_GAS_STATION("gmi-local-gas-station", '\ue546'),
    LOCAL_GROCERY_STORE("gmi-local-grocery-store", '\ue547'),
    LOCAL_HOSPITAL("gmi-local-hospital", '\ue548'),
    LOCAL_HOTEL("gmi-local-hotel", '\ue549'),
    LOCAL_LAUNDRY_SERVICE("gmi-local-laundry-service", '\ue54A'),
    LOCAL_LIBRARY("gmi-local-library", '\ue54B'),
    LOCAL_MALL("gmi-local-mall", '\ue54C'),
    LOCAL_MOVIES("gmi-local-movies", '\ue54D'),
    LOCAL_OFFER("gmi-local-offer", '\ue54E'),
    LOCAL_PARKING("gmi-local-parking", '\ue54F'),
    LOCAL_PHARMACY("gmi-local-pharmacy", '\ue550'),
    LOCAL_PHONE("gmi-local-phone", '\ue551'),
    LOCAL_PIZZA("gmi-local-pizza", '\ue552'),
    LOCAL_PLAY("gmi-local-play", '\ue553'),
    LOCAL_POST_OFFICE("gmi-local-post-office", '\ue554'),
    LOCAL_PRINTSHOP("gmi-local-printshop", '\ue555'),
    LOCAL_SEE("gmi-local-see", '\ue557'),
    LOCAL_SHIPPING("gmi-local-shipping", '\ue558'),
    LOCAL_TAXI("gmi-local-taxi", '\ue559'),
    LOCATION_CITY("gmi-location-city", '\ue7F1'),
    LOCATION_DISABLED("gmi-location-disabled", '\ue1B6'),
    LOCATION_OFF("gmi-location-off", '\ue0C7'),
    LOCATION_ON("gmi-location-on", '\ue0C8'),
    LOCATION_SEARCHING("gmi-location-searching", '\ue1B7'),
    LOCK("gmi-lock", '\ue897'),
    LOCK_OPEN("gmi-lock-open", '\ue898'),
    LOCK_OUTLINE("gmi-lock-outline", '\ue899'),
    LOOKS("gmi-looks", '\ue3FC'),
    LOOKS_3("gmi-looks-3", '\ue3FB'),
    LOOKS_4("gmi-looks-4", '\ue3FD'),
    LOOKS_5("gmi-looks-5", '\ue3FE'),
    LOOKS_6("gmi-looks-6", '\ue3FF'),
    LOOKS_ONE("gmi-looks-one", '\ue400'),
    LOOKS_TWO("gmi-looks-two", '\ue401'),
    LOOP("gmi-loop", '\ue028'),
    LOUPE("gmi-loupe", '\ue402'),
    LOW_PRIORITY("gmi-low-priority", '\ue16d'),
    LOYALTY("gmi-loyalty", '\ue89A'),
    MAIL("gmi-mail", '\ue158'),
    MAIL_OUTLINE("gmi-mail-outline", '\ue0E1'),
    MAP("gmi-map", '\ue55B'),
    MARKUNREAD("gmi-markunread", '\ue159'),
    MARKUNREAD_MAILBOX("gmi-markunread-mailbox", '\ue89B'),
    MEMORY("gmi-memory", '\ue322'),
    MENU("gmi-menu", '\ue5D2'),
    MERGE_TYPE("gmi-merge-type", '\ue252'),
    MESSAGE("gmi-message", '\ue0C9'),
    MIC("gmi-mic", '\ue029'),
    MIC_NONE("gmi-mic-none", '\ue02A'),
    MIC_OFF("gmi-mic-off", '\ue02B'),
    MMS("gmi-mms", '\ue618'),
    MODE_COMMENT("gmi-mode-comment", '\ue253'),
    MODE_EDIT("gmi-mode-edit", '\ue254'),
    MONETIZATION_ON("gmi-monetization-on", '\ue263'),
    MONEY_OFF("gmi-money-off", '\ue25C'),
    MONOCHROME_PHOTOS("gmi-monochrome-photos", '\ue403'),
    MOOD("gmi-mood", '\ue7F2'),
    MOOD_BAD("gmi-mood-bad", '\ue7F3'),
    MORE("gmi-more", '\ue619'),
    MORE_HORIZ("gmi-more-horiz", '\ue5D3'),
    MORE_VERT("gmi-more-vert", '\ue5D4'),
    MOTORCYCLE("gmi-motorcycle", '\ue91B'),
    MOUSE("gmi-mouse", '\ue323'),
    MOVE_TO_INBOX("gmi-move-to-inbox", '\ue168'),
    MOVIE("gmi-movie", '\ue02C'),
    MOVIE_CREATION("gmi-movie-creation", '\ue404'),
    MOVIE_FILTER("gmi-movie-filter", '\ue43A'),
    MULTILINE_CHART("gmi-multiline-chart", '\ue6df'),
    MUSIC_NOTE("gmi-music-note", '\ue405'),
    MUSIC_VIDEO("gmi-music-video", '\ue063'),
    MY_LOCATION("gmi-my-location", '\ue55C'),
    NATURE("gmi-nature", '\ue406'),
    NATURE_PEOPLE("gmi-nature-people", '\ue407'),
    NAVIGATE_BEFORE("gmi-navigate-before", '\ue408'),
    NAVIGATE_NEXT("gmi-navigate-next", '\ue409'),
    NAVIGATION("gmi-navigation", '\ue55D'),
    NEAR_ME("gmi-near-me", '\ue569'),
    NETWORK_CELL("gmi-network-cell", '\ue1B9'),
    NETWORK_CHECK("gmi-network-check", '\ue640'),
    NETWORK_LOCKED("gmi-network-locked", '\ue61A'),
    NETWORK_WIFI("gmi-network-wifi", '\ue1BA'),
    NEW_RELEASES("gmi-new-releases", '\ue031'),
    NEXT_WEEK("gmi-next-week", '\ue16A'),
    NFC("gmi-nfc", '\ue1BB'),
    NOTE("gmi-featured-note", '\ue06f'),
    NOTE_ADD("gmi-note-add", '\ue89C'),
    NOTIFICATIONS("gmi-notifications", '\ue7F4'),
    NOTIFICATIONS_ACTIVE("gmi-notifications-active", '\ue7F7'),
    NOTIFICATIONS_NONE("gmi-notifications-none", '\ue7F5'),
    NOTIFICATIONS_OFF("gmi-notifications-off", '\ue7F6'),
    NOTIFICATIONS_PAUSED("gmi-notifications-paused", '\ue7F8'),
    NOT_INTERESTED("gmi-not-interested", '\ue033'),
    NO_ENCRYPTION("gmi-no-encryption", '\ue641'),
    NO_SIM("gmi-no-sim", '\ue0CC'),
    OFFLINE_PIN("gmi-offline-pin", '\ue90A'),
    ONDEMAND_VIDEO("gmi-ondemand-video", '\ue63A'),
    OPACITY("gmi-opacity", '\ue91C'),
    OPEN_IN_BROWSER("gmi-open-in-browser", '\ue89D'),
    OPEN_IN_NEW("gmi-open-in-new", '\ue89E'),
    OPEN_WITH("gmi-open-with", '\ue89F'),
    PAGES("gmi-pages", '\ue7F9'),
    PAGEVIEW("gmi-pageview", '\ue8A0'),
    PALETTE("gmi-palette", '\ue40A'),
    PANORAMA("gmi-panorama", '\ue40B'),
    PANORAMA_FISH_EYE("gmi-panorama-fish-eye", '\ue40C'),
    PANORAMA_HORIZONTAL("gmi-panorama-horizontal", '\ue40D'),
    PANORAMA_VERTICAL("gmi-panorama-vertical", '\ue40E'),
    PANORAMA_WIDE_ANGLE("gmi-panorama-wide-angle", '\ue40F'),
    PAN_TOOL("gmi-pan-tool", '\ue925'),
    PARTY_MODE("gmi-party-mode", '\ue7FA'),
    PAUSE("gmi-pause", '\ue034'),
    PAUSE_CIRCLE_FILLED("gmi-pause-circle-filled", '\ue035'),
    PAUSE_CIRCLE_OUTLINE("gmi-pause-circle-outline", '\ue036'),
    PAYMENT("gmi-payment", '\ue8A1'),
    PEOPLE("gmi-people", '\ue7FB'),
    PEOPLE_OUTLINE("gmi-people-outline", '\ue7FC'),
    PERM_CAMERA_MIC("gmi-perm-camera-mic", '\ue8A2'),
    PERM_CONTACT_CALENDAR("gmi-perm-contact-calendar", '\ue8A3'),
    PERM_DATA_SETTING("gmi-perm-data-setting", '\ue8A4'),
    PERM_DEVICE_INFORMATION("gmi-perm-device-information", '\ue8A5'),
    PERM_IDENTITY("gmi-perm-identity", '\ue8A6'),
    PERM_MEDIA("gmi-perm-media", '\ue8A7'),
    PERM_PHONE_MSG("gmi-perm-phone-msg", '\ue8A8'),
    PERM_SCAN_WIFI("gmi-perm-scan-wifi", '\ue8A9'),
    PERSON("gmi-person", '\ue7FD'),
    PERSONAL_VIDEO("gmi-personal-video", '\ue63B'),
    PERSON_ADD("gmi-person-add", '\ue7FE'),
    PERSON_OUTLINE("gmi-person-outline", '\ue7FF'),
    PERSON_PIN("gmi-person-pin", '\ue55A'),
    PERSON_PIN_CIRCLE("gmi-person-pin-circle", '\ue56A'),
    PETS("gmi-pets", '\ue91D'),
    PHONE("gmi-phone", '\ue0CD'),
    PHONELINK("gmi-phonelink", '\ue326'),
    PHONELINK_ERASE("gmi-phonelink-erase", '\ue0DB'),
    PHONELINK_LOCK("gmi-phonelink-lock", '\ue0DC'),
    PHONELINK_OFF("gmi-phonelink-off", '\ue327'),
    PHONELINK_RING("gmi-phonelink-ring", '\ue0DD'),
    PHONELINK_SETUP("gmi-phonelink-setup", '\ue0DE'),
    PHONE_ANDROID("gmi-phone-android", '\ue324'),
    PHONE_BLUETOOTH_SPEAKER("gmi-phone-bluetooth-speaker", '\ue61B'),
    PHONE_FORWARDED("gmi-phone-forwarded", '\ue61C'),
    PHONE_IN_TALK("gmi-phone-in-talk", '\ue61D'),
    PHONE_IPHONE("gmi-phone-iphone", '\ue325'),
    PHONE_LOCKED("gmi-phone-locked", '\ue61E'),
    PHONE_MISSED("gmi-phone-missed", '\ue61F'),
    PHONE_PAUSED("gmi-phone-paused", '\ue620'),
    PHOTO("gmi-photo", '\ue410'),
    PHOTO_ALBUM("gmi-photo-album", '\ue411'),
    PHOTO_CAMERA("gmi-photo-camera", '\ue412'),
    PHOTO_FILTER("gmi-photo-filter", '\ue43B'),
    PHOTO_LIBRARY("gmi-photo-library", '\ue413'),
    PHOTO_SIZE_SELECT_ACTUAL("gmi-photo-size-select-actual", '\ue432'),
    PHOTO_SIZE_SELECT_LARGE("gmi-photo-size-select-large", '\ue433'),
    PHOTO_SIZE_SELECT_SMALL("gmi-photo-size-select-small", '\ue434'),
    PICTURE_AS_PDF("gmi-picture-as-pdf", '\ue415'),
    PICTURE_IN_PICTURE("gmi-picture-in-picture", '\ue8AA'),
    PICTURE_IN_PICTURE_ALT("gmi-picture-in-picture-alt", '\ue911'),
    PIE_CHART("gmi-pie-chart", '\ue6c4'),
    PIE_CHART_OUTLINED("gmi-pie-chart-outlined", '\ue6c5'),
    PIN_DROP("gmi-pin-drop", '\ue55E'),
    PLACE("gmi-place", '\ue55F'),
    PLAYLIST_ADD("gmi-playlist-add", '\ue03B'),
    PLAYLIST_ADD_CHECK("gmi-playlist-add-check", '\ue065'),
    PLAYLIST_PLAY("gmi-playlist-play", '\ue05F'),
    PLAY_ARROW("gmi-play-arrow", '\ue037'),
    PLAY_CIRCLE_FILLED("gmi-play-circle-filled", '\ue038'),
    PLAY_CIRCLE_OUTLINE("gmi-play-circle-outline", '\ue039'),
    PLAY_FOR_WORK("gmi-play-for-work", '\ue906'),
    PLUS_ONE("gmi-plus-one", '\ue800'),
    POLL("gmi-poll", '\ue801'),
    POLYMER("gmi-polymer", '\ue8AB'),
    POOL("gmi-pool", '\ueB48'),
    PORTABLE_WIFI_OFF("gmi-portable-wifi-off", '\ue0CE'),
    PORTRAIT("gmi-portrait", '\ue416'),
    POWER("gmi-power", '\ue63C'),
    POWER_INPUT("gmi-power-input", '\ue336'),
    POWER_SETTINGS_NEW("gmi-power-settings-new", '\ue8AC'),
    PREGNANT_WOMAN("gmi-pregnant-woman", '\ue91E'),
    PRESENT_TO_ALL("gmi-present-to-all", '\ue0DF'),
    PRINT("gmi-print", '\ue8AD'),
    PRIORITY_HIGH("gmi-priority-high", '\ue645'),
    PUBLIC("gmi-public", '\ue80B'),
    PUBLISH("gmi-publish", '\ue255'),
    QUERY_BUILDER("gmi-query-builder", '\ue8AE'),
    QUESTION_ANSWER("gmi-question-answer", '\ue8AF'),
    QUEUE("gmi-queue", '\ue03C'),
    QUEUE_MUSIC("gmi-queue-music", '\ue03D'),
    QUEUE_PLAY_NEXT("gmi-queue-play-next", '\ue066'),
    RADIO("gmi-radio", '\ue03E'),
    RADIO_BUTTON_CHECKED("gmi-radio-button-checked", '\ue837'),
    RADIO_BUTTON_UNCHECKED("gmi-radio-button-unchecked", '\ue836'),
    RATE_REVIEW("gmi-rate-review", '\ue560'),
    RECEIPT("gmi-receipt", '\ue8B0'),
    RECENT_ACTORS("gmi-recent-actors", '\ue03F'),
    RECORD_VOICE_OVER("gmi-record-voice-over", '\ue91F'),
    REDEEM("gmi-redeem", '\ue8B1'),
    REDO("gmi-redo", '\ue15A'),
    REFRESH("gmi-refresh", '\ue5D5'),
    REMOVE("gmi-remove", '\ue15B'),
    REMOVE_CIRCLE("gmi-remove-circle", '\ue15C'),
    REMOVE_CIRCLE_OUTLINE("gmi-remove-circle-outline", '\ue15D'),
    REMOVE_FROM_QUEUE("gmi-remove-from-queue", '\ue067'),
    REMOVE_RED_EYE("gmi-remove-red-eye", '\ue417'),
    REMOVE_SHOPPING("gmi-remove-shopping", '\ue928'),
    REORDER("gmi-reorder", '\ue8FE'),
    REPEAT("gmi-repeat", '\ue040'),
    REPEAT_ONE("gmi-repeat-one", '\ue041'),
    REPLAY("gmi-replay", '\ue042'),
    REPLAY_10("gmi-replay-10", '\ue059'),
    REPLAY_30("gmi-replay-30", '\ue05A'),
    REPLAY_5("gmi-replay-5", '\ue05B'),
    REPLY("gmi-reply", '\ue15E'),
    REPLY_ALL("gmi-reply-all", '\ue15F'),
    REPORT("gmi-report", '\ue160'),
    REPORT_PROBLEM("gmi-report-problem", '\ue8B2'),
    RESTAURANT("gmi-restaurant", '\ue56c'),
    RESTAURANT_MENU("gmi-restaurant-menu", '\ue561'),
    RESTORE("gmi-restore", '\ue8B3'),
    RESTORE_PAGE("gmi-restore-page", '\ue929'),
    RING_VOLUME("gmi-ring-volume", '\ue0D1'),
    ROOM("gmi-room", '\ue8B4'),
    ROOM_SERVICE("gmi-room-service", '\ueB49'),
    ROTATE_90_DEGREES_CCW("gmi-rotate-90-degrees-ccw", '\ue418'),
    ROTATE_LEFT("gmi-rotate-left", '\ue419'),
    ROTATE_RIGHT("gmi-rotate-right", '\ue41A'),
    ROTATION_3D("gmi-rotation-3d", '\ue84D'),
    ROUNDED_CORNER("gmi-rounded-corner", '\ue920'),
    ROUTER("gmi-router", '\ue328'),
    ROWING("gmi-rowing", '\ue921'),
    RSS_FEED("gmi-rss-feed", '\ue0e5'),
    RV_HOOKUP("gmi-rv-hookup", '\ue642'),
    SATELLITE("gmi-satellite", '\ue562'),
    SAVE("gmi-save", '\ue161'),
    SCANNER("gmi-scanner", '\ue329'),
    SCHEDULE("gmi-schedule", '\ue8B5'),
    SCHOOL("gmi-school", '\ue80C'),
    SCREEN_LOCK_LANDSCAPE("gmi-screen-lock-landscape", '\ue1BE'),
    SCREEN_LOCK_PORTRAIT("gmi-screen-lock-portrait", '\ue1BF'),
    SCREEN_LOCK_ROTATION("gmi-screen-lock-rotation", '\ue1C0'),
    SCREEN_ROTATION("gmi-screen-rotation", '\ue1C1'),
    SCREEN_SHARE("gmi-screen-share", '\ue0E2'),
    SD_CARD("gmi-sd-card", '\ue623'),
    SD_STORAGE("gmi-sd-storage", '\ue1C2'),
    SEARCH("gmi-search", '\ue8B6'),
    SECURITY("gmi-security", '\ue32A'),
    SELECT_ALL("gmi-select-all", '\ue162'),
    SEND("gmi-send", '\ue163'),
    SENTIMENT_DISSATISFIED("gmi-sentiment-dissatiSfied", '\ue811'),
    SENTIMENT_NEUTRAL("gmi-sentiment-neutral", '\ue812'),
    SENTIMENT_SATISFIED("gmi-sentiment-satisfied", '\ue813'),
    SENTIMENT_VERY_DISSATISFIED("gmi-sentiment-very-dissatisfied", '\ue814'),
    SENTIMENT_VERY_SATISFIED("gmi-sentiment-very-satisfied", '\ue815'),
    SETTINGS("gmi-settings", '\ue8B8'),
    SETTINGS_APPLICATIONS("gmi-settings-applications", '\ue8B9'),
    SETTINGS_BACKUP_RESTORE("gmi-settings-backup-restore", '\ue8BA'),
    SETTINGS_BLUETOOTH("gmi-settings-bluetooth", '\ue8BB'),
    SETTINGS_BRIGHTNESS("gmi-settings-brightness", '\ue8BD'),
    SETTINGS_CELL("gmi-settings-cell", '\ue8BC'),
    SETTINGS_ETHERNET("gmi-settings-ethernet", '\ue8BE'),
    SETTINGS_INPUT_ANTENNA("gmi-settings-input-antenna", '\ue8BF'),
    SETTINGS_INPUT_COMPONENT("gmi-settings-input-component", '\ue8C0'),
    SETTINGS_INPUT_COMPOSITE("gmi-settings-input-composite", '\ue8C1'),
    SETTINGS_INPUT_HDMI("gmi-settings-input-hdmi", '\ue8C2'),
    SETTINGS_INPUT_SVIDEO("gmi-settings-input-svideo", '\ue8C3'),
    SETTINGS_OVERSCAN("gmi-settings-overscan", '\ue8C4'),
    SETTINGS_PHONE("gmi-settings-phone", '\ue8C5'),
    SETTINGS_POWER("gmi-settings-power", '\ue8C6'),
    SETTINGS_REMOTE("gmi-settings-remote", '\ue8C7'),
    SETTINGS_SYSTEM_DAYDREAM("gmi-settings-system-daydream", '\ue1C3'),
    SETTINGS_VOICE("gmi-settings-voice", '\ue8C8'),
    SHARE("gmi-share", '\ue80D'),
    SHOP("gmi-shop", '\ue8C9'),
    SHOPPING_BASKET("gmi-shopping-basket", '\ue8CB'),
    SHOPPING_CART("gmi-shopping-cart", '\ue8CC'),
    SHOP_TWO("gmi-shop-two", '\ue8CA'),
    SHORT_TEXT("gmi-short-text", '\ue261'),
    SHOW_CHART("gmi-show-chart", '\ue6e1'),
    SHUFFLE("gmi-shuffle", '\ue043'),
    SIGNAL_CELLULAR_4_BAR("gmi-signal-cellular-4-bar", '\ue1C8'),
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR("gmi-signal-cellular-connected-no-internet-4-bar", '\ue1CD'),
    SIGNAL_CELLULAR_NO_SIM("gmi-signal-cellular-no-sim", '\ue1CE'),
    SIGNAL_CELLULAR_NULL("gmi-signal-cellular-null", '\ue1CF'),
    SIGNAL_CELLULAR_OFF("gmi-signal-cellular-off", '\ue1D0'),
    SIGNAL_WIFI_4_BAR("gmi-signal-wifi-4-bar", '\ue1D8'),
    SIGNAL_WIFI_4_BAR_LOCK("gmi-signal-wifi-4-bar-lock", '\ue1D9'),
    SIGNAL_WIFI_OFF("gmi-signal-wifi-off", '\ue1DA'),
    SIM_CARD("gmi-sim-card", '\ue32B'),
    SIM_CARD_ALERT("gmi-sim-card-alert", '\ue624'),
    SKIP_NEXT("gmi-skip-next", '\ue044'),
    SKIP_PREVIOUS("gmi-skip-previous", '\ue045'),
    SLIDESHOW("gmi-slideshow", '\ue41B'),
    SLOW_MOTION_VIDEO("gmi-slow-motion-video", '\ue068'),
    SMARTPHONE("gmi-smartphone", '\ue32C'),
    SMOKE_FREE("gmi-smoke-free", '\ueB4A'),
    SMOKING_ROOMS("gmi-smoking-rooms", '\ueB4B'),
    SMS("gmi-sms", '\ue625'),
    SMS_FAILED("gmi-sms-failed", '\ue626'),
    SNOOZE("gmi-snooze", '\ue046'),
    SORT("gmi-sort", '\ue164'),
    SORT_BY_ALPHA("gmi-sort-by-alpha", '\ue053'),
    SPA("gmi-spa", '\ueB4C'),
    SPACE_BAR("gmi-space-bar", '\ue256'),
    SPEAKER("gmi-speaker", '\ue32D'),
    SPEAKER_GROUP("gmi-speaker-group", '\ue32E'),
    SPEAKER_NOTES("gmi-speaker-notes", '\ue8CD'),
    SPEAKER_NOTES_OFF("gmi-speaker-notes-off", '\ue92A'),
    SPEAKER_PHONE("gmi-speaker-phone", '\ue0D2'),
    SPELLCHECK("gmi-spellcheck", '\ue8CE'),
    STAR("gmi-star", '\ue838'),
    STARS("gmi-stars", '\ue8D0'),
    STAR_BORDER("gmi-star-border", '\ue83A'),
    STAR_HALF("gmi-star-half", '\ue839'),
    STAY_CURRENT_LANDSCAPE("gmi-stay-current-landscape", '\ue0D3'),
    STAY_CURRENT_PORTRAIT("gmi-stay-current-portrait", '\ue0D4'),
    STAY_PRIMARY_LANDSCAPE("gmi-stay-primary-landscape", '\ue0D5'),
    STAY_PRIMARY_PORTRAIT("gmi-stay-primary-portrait", '\ue0D6'),
    STOP("gmi-stop", '\ue047'),
    STOP_SCREEN_SHARE("gmi-stop-screen-share", '\ue0E3'),
    STORAGE("gmi-storage", '\ue1DB'),
    STORE("gmi-store", '\ue8D1'),
    STORE_MALL_DIRECTORY("gmi-store-mall-directory", '\ue563'),
    STRAIGHTEN("gmi-straighten", '\ue41C'),
    STREET_VIEW("gmi-street-view", '\ue56e'),
    STRIKETHROUGH_S("gmi-strikethrough-s", '\ue257'),
    STYLE("gmi-style", '\ue41D'),
    SUBDIRECTORY_ARROW_LEFT("gmi-subdirectory-arrow-left", '\ue5D9'),
    SUBDIRECTORY_ARROW_RIGHT("gmi-subdirectory-arrow-right", '\ue5DA'),
    SUBJECT("gmi-subject", '\ue8D2'),
    SUBSCRIPTIONS("gmi-subscriptions", '\ue064'),
    SUBTITLES("gmi-subtitles", '\ue048'),
    SUBWAY("gmi-subway", '\ue56f'),
    SUPERVISOR_ACCOUNT("gmi-supervisor-account", '\ue8D3'),
    SURROUND_SOUND("gmi-surround-sound", '\ue049'),
    SWAP_CALLS("gmi-swap-calls", '\ue0D7'),
    SWAP_HORIZ("gmi-swap-horiz", '\ue8D4'),
    SWAP_VERT("gmi-swap-vert", '\ue8D5'),
    SWAP_VERTICAL_CIRCLE("gmi-swap-vertical-circle", '\ue8D6'),
    SWITCH_CAMERA("gmi-switch-camera", '\ue41E'),
    SWITCH_VIDEO("gmi-switch-video", '\ue41F'),
    SYNC("gmi-sync", '\ue627'),
    SYNC_DISABLED("gmi-sync-disabled", '\ue628'),
    SYNC_PROBLEM("gmi-sync-problem", '\ue629'),
    SYSTEM_UPDATE("gmi-system-update", '\ue62A'),
    SYSTEM_UPDATE_ALT("gmi-system-update-alt", '\ue8D7'),
    TAB("gmi-tab", '\ue8D8'),
    TABLET("gmi-tablet", '\ue32F'),
    TABLET_ANDROID("gmi-tablet-android", '\ue330'),
    TABLET_MAC("gmi-tablet-mac", '\ue331'),
    TAB_UNSELECTED("gmi-tab-unselected", '\ue8D9'),
    TAG_FACES("gmi-tag-faces", '\ue420'),
    TAP_AND_PLAY("gmi-tap-and-play", '\ue62B'),
    TERRAIN("gmi-terrain", '\ue564'),
    TEXTSMS("gmi-textsms", '\ue0D8'),
    TEXTURE("gmi-texture", '\ue421'),
    TEXT_FIELDS("gmi-text-fields", '\ue262'),
    TEXT_FORMAT("gmi-text-format", '\ue165'),
    THEATERS("gmi-theaters", '\ue8DA'),
    THUMBS_UP_DOWN("gmi-thumbs-up-down", '\ue8DD'),
    THUMB_DOWN("gmi-thumb-down", '\ue8DB'),
    THUMB_UP("gmi-thumb-up", '\ue8DC'),
    TIMELAPSE("gmi-timelapse", '\ue422'),
    TIMELINE("gmi-timeline", '\ue922'),
    TIMER("gmi-timer", '\ue425'),
    TIMER_10("gmi-timer-10", '\ue423'),
    TIMER_3("gmi-timer-3", '\ue424'),
    TIMER_OFF("gmi-timer-off", '\ue426'),
    TIME_TO_LEAVE("gmi-time-to-leave", '\ue62C'),
    TITLE("gmi-title", '\ue264'),
    TOC("gmi-toc", '\ue8DE'),
    TODAY("gmi-today", '\ue8DF'),
    TOLL("gmi-toll", '\ue8E0'),
    TONALITY("gmi-tonality", '\ue427'),
    TOUCH_APP("gmi-touch-app", '\ue913'),
    TOYS("gmi-toys", '\ue332'),
    TRACK_CHANGES("gmi-track-changes", '\ue8E1'),
    TRAFFIC("gmi-traffic", '\ue565'),
    TRAIN("gmi-train", '\ue570'),
    TRAM("gmi-tram", '\ue571'),
    TRANSFER_WITHIN_A_STATION("gmi-transfer-within-a-station", '\ue572'),
    TRANSFORM("gmi-transform", '\ue428'),
    TRANSLATE("gmi-translate", '\ue8E2'),
    TRENDING_DOWN("gmi-trending-down", '\ue8E3'),
    TRENDING_FLAT("gmi-trending-flat", '\ue8E4'),
    TRENDING_UP("gmi-trending-up", '\ue8E5'),
    TUNE("gmi-tune", '\ue429'),
    TURNED_IN("gmi-turned-in", '\ue8E6'),
    TURNED_IN_NOT("gmi-turned-in-not", '\ue8E7'),
    TV("gmi-tv", '\ue333'),
    UNARCHIVE("gmi-unarchive", '\ue169'),
    UNDO("gmi-undo", '\ue166'),
    UNFOLD_LESS("gmi-unfold-less", '\ue5D6'),
    UNFOLD_MORE("gmi-unfold-more", '\ue5D7'),
    UPDATE("gmi-update", '\ue923'),
    USB("gmi-usb", '\ue1E0'),
    VERIFIED_USER("gmi-verified-user", '\ue8E8'),
    VERTICAL_ALIGN_BOTTOM("gmi-vertical-align-bottom", '\ue258'),
    VERTICAL_ALIGN_CENTER("gmi-vertical-align-center", '\ue259'),
    VERTICAL_ALIGN_TOP("gmi-vertical-align-top", '\ue25A'),
    VIBRATION("gmi-vibration", '\ue62D'),
    VIDEOCAM("gmi-videocam", '\ue04B'),
    VIDEOCAM_OFF("gmi-videocam-off", '\ue04C'),
    VIDEOGAME_ASSET("gmi-videogame-asset", '\ue338'),
    VIDEO_CALL("gmi-video-call", '\ue070'),
    VIDEO_LABEL("gmi-video-label", '\ue071'),
    VIDEO_LIBRARY("gmi-video-library", '\ue04A'),
    VIEW_AGENDA("gmi-view-agenda", '\ue8E9'),
    VIEW_ARRAY("gmi-view-array", '\ue8EA'),
    VIEW_CAROUSEL("gmi-view-carousel", '\ue8EB'),
    VIEW_COLUMN("gmi-view-column", '\ue8EC'),
    VIEW_COMFY("gmi-view-comfy", '\ue42A'),
    VIEW_COMPACT("gmi-view-compact", '\ue42B'),
    VIEW_DAY("gmi-view-day", '\ue8ED'),
    VIEW_HEADLINE("gmi-view-headline", '\ue8EE'),
    VIEW_LIST("gmi-view-list", '\ue8EF'),
    VIEW_MODULE("gmi-view-module", '\ue8F0'),
    VIEW_QUILT("gmi-view-quilt", '\ue8F1'),
    VIEW_STREAM("gmi-view-stream", '\ue8F2'),
    VIEW_WEEK("gmi-view-week", '\ue8F3'),
    VIGNETTE("gmi-vignette", '\ue435'),
    VISIBILITY("gmi-visibility", '\ue8F4'),
    VISIBILITY_OFF("gmi-visibility-off", '\ue8F5'),
    VOICEMAIL("gmi-voicemail", '\ue0D9'),
    VOICE_CHAT("gmi-voice-chat", '\ue62E'),
    VOLUME_DOWN("gmi-volume-down", '\ue04D'),
    VOLUME_MUTE("gmi-volume-mute", '\ue04E'),
    VOLUME_OFF("gmi-volume-off", '\ue04F'),
    VOLUME_UP("gmi-volume-up", '\ue050'),
    VPN_KEY("gmi-vpn-key", '\ue0DA'),
    VPN_LOCK("gmi-vpn-lock", '\ue62F'),
    WALLPAPER("gmi-wallpaper", '\ue1BC'),
    WARNING("gmi-warning", '\ue002'),
    WATCH("gmi-watch", '\ue334'),
    WATCH_LATER("gmi-watch-later", '\ue924'),
    WB_AUTO("gmi-wb-auto", '\ue42C'),
    WB_CLOUDY("gmi-wb-cloudy", '\ue42D'),
    WB_INCANDESCENT("gmi-wb-incandescent", '\ue42E'),
    WB_IRIDESCENT("gmi-wb-iridescent", '\ue436'),
    WB_SUNNY("gmi-wb-sunny", '\ue430'),
    WC("gmi-wc", '\ue63D'),
    WEB("gmi-web", '\ue051'),
    WEB_ASSET("gmi-web-asset", '\ue069'),
    WEEKEND("gmi-weekend", '\ue16B'),
    WHATSHOT("gmi-whatshot", '\ue80E'),
    WIDGETS("gmi-widgets", '\ue1BD'),
    WIFI("gmi-wifi", '\ue63E'),
    WIFI_LOCK("gmi-wifi-lock", '\ue1E1'),
    WIFI_TETHERING("gmi-wifi-tethering", '\ue1E2'),
    WORK("gmi-work", '\ue8F9'),
    WRAP_TEXT("gmi-wrap-text", '\ue25B'),
    YOUTUBE_SEARCHED_FOR("gmi-youtube-searched-for", '\ue8FA'),
    ZOOM_IN("gmi-zoom-in", '\ue8FF'),
    ZOOM_OUT("gmi-zoom-out", '\ue900'),
    ZOOM_OUT_MAP("gmi-zoom-out-map", '\ue56B');

    public static Material findByDescription(String description) {
        for (Material font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private char code;

    Material(String description, char code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public char getCode() {
        return code;
    }
}