/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.mapicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Mapicons implements Ikon {
    ABSEILING("map-icon-abseiling", '\ue800'),
    ACCOUNTING("map-icon-accounting", '\ue801'),
    AIRPORT("map-icon-airport", '\ue802'),
    AMUSEMENT_PARK("map-icon-amusement-park", '\ue803'),
    AQUARIUM("map-icon-aquarium", '\ue804'),
    ARCHERY("map-icon-archery", '\ue805'),
    ART_GALLERY("map-icon-art-gallery", '\ue806'),
    ASSISTIVE_LISTENING_SYSTEM("map-icon-assistive-listening-system", '\ue807'),
    ATM("map-icon-atm", '\ue808'),
    AUDIO_DESCRIPTION("map-icon-audio-description", '\ue809'),
    BAKERY("map-icon-bakery", '\ue80a'),
    BANK("map-icon-bank", '\ue80b'),
    BAR("map-icon-bar", '\ue80c'),
    BASEBALL("map-icon-baseball", '\ue80d'),
    BEAUTY_SALON("map-icon-beauty-salon", '\ue80e'),
    BICYCLE_STORE("map-icon-bicycle-store", '\ue80f'),
    BICYCLING("map-icon-bicycling", '\ue810'),
    BOATING("map-icon-boating", '\ue813'),
    BOAT_RAMP("map-icon-boat-ramp", '\ue811'),
    BOAT_TOUR("map-icon-boat-tour", '\ue812'),
    BOOK_STORE("map-icon-book-store", '\ue814'),
    BOWLING_ALLEY("map-icon-bowling-alley", '\ue815'),
    BRAILLE("map-icon-braille", '\ue816'),
    BUS_STATION("map-icon-bus-station", '\ue817'),
    CAFE("map-icon-cafe", '\ue818'),
    CAMPGROUND("map-icon-campground", '\ue819'),
    CANOE("map-icon-canoe", '\ue81a'),
    CAR_DEALER("map-icon-car-dealer", '\ue81b'),
    CAR_RENTAL("map-icon-car-rental", '\ue81c'),
    CAR_REPAIR("map-icon-car-repair", '\ue81d'),
    CAR_WASH("map-icon-car-wash", '\ue81e'),
    CASINO("map-icon-casino", '\ue81f'),
    CEMETERY("map-icon-cemetery", '\ue820'),
    CHAIRLIFT("map-icon-chairlift", '\ue821'),
    CHURCH("map-icon-church", '\ue822'),
    CIRCLE("map-icon-circle", '\ue823'),
    CITY_HALL("map-icon-city-hall", '\ue824'),
    CLIMBING("map-icon-climbing", '\ue825'),
    CLOSED_CAPTIONING("map-icon-closed-captioning", '\ue826'),
    CLOTHING_STORE("map-icon-clothing-store", '\ue827'),
    COMPASS("map-icon-compass", '\ue828'),
    CONVENIENCE_STORE("map-icon-convenience-store", '\ue829'),
    COURTHOUSE("map-icon-courthouse", '\ue82a'),
    CROSSHAIRS("map-icon-crosshairs", '\ue82c'),
    CROSS_COUNTRY_SKIING("map-icon-cross-country-skiing", '\ue82b'),
    DENTIST("map-icon-dentist", '\ue82d'),
    DEPARTMENT_STORE("map-icon-department-store", '\ue82e'),
    DIVING("map-icon-diving", '\ue82f'),
    DOCTOR("map-icon-doctor", '\ue830'),
    ELECTRICIAN("map-icon-electrician", '\ue831'),
    ELECTRONICS_STORE("map-icon-electronics-store", '\ue832'),
    EMBASSY("map-icon-embassy", '\ue833'),
    EXPAND("map-icon-expand", '\ue834'),
    FEMALE("map-icon-female", '\ue835'),
    FINANCE("map-icon-finance", '\ue836'),
    FIRE_STATION("map-icon-fire-station", '\ue837'),
    FISHING("map-icon-fishing", '\ue83a'),
    FISHING_PIER("map-icon-fishing-pier", '\ue839'),
    FISH_CLEANING("map-icon-fish-cleaning", '\ue838'),
    FLORIST("map-icon-florist", '\ue83b'),
    FOOD("map-icon-food", '\ue83c'),
    FULLSCREEN("map-icon-fullscreen", '\ue83d'),
    FUNERAL_HOME("map-icon-funeral-home", '\ue83e'),
    FURNITURE_STORE("map-icon-furniture-store", '\ue83f'),
    GAS_STATION("map-icon-gas-station", '\ue840'),
    GENERAL_CONTRACTOR("map-icon-general-contractor", '\ue841'),
    GOLF("map-icon-golf", '\ue842'),
    GROCERY_OR_SUPERMARKET("map-icon-grocery-or-supermarket", '\ue843'),
    GYM("map-icon-gym", '\ue844'),
    HAIR_CARE("map-icon-hair-care", '\ue845'),
    HANG_GLIDING("map-icon-hang-gliding", '\ue846'),
    HARDWARE_STORE("map-icon-hardware-store", '\ue847'),
    HEALTH("map-icon-health", '\ue848'),
    HINDU_TEMPLE("map-icon-hindu-temple", '\ue849'),
    HORSE_RIDING("map-icon-horse-riding", '\ue84a'),
    HOSPITAL("map-icon-hospital", '\ue84b'),
    ICE_FISHING("map-icon-ice-fishing", '\ue84c'),
    ICE_SKATING("map-icon-ice-skating", '\ue84d'),
    INLINE_SKATING("map-icon-inline-skating", '\ue84e'),
    INSURANCE_AGENCY("map-icon-insurance-agency", '\ue84f'),
    JET_SKIING("map-icon-jet-skiing", '\ue850'),
    JEWELRY_STORE("map-icon-jewelry-store", '\ue851'),
    KAYAKING("map-icon-kayaking", '\ue852'),
    LAUNDRY("map-icon-laundry", '\ue853'),
    LAWYER("map-icon-lawyer", '\ue854'),
    LIBRARY("map-icon-library", '\ue855'),
    LIQUOR_STORE("map-icon-liquor-store", '\ue856'),
    LOCAL_GOVERNMENT("map-icon-local-government", '\ue857'),
    LOCATION_ARROW("map-icon-location-arrow", '\ue858'),
    LOCKSMITH("map-icon-locksmith", '\ue859'),
    LODGING("map-icon-lodging", '\ue85a'),
    LOW_VISION_ACCESS("map-icon-low-vision-access", '\ue85b'),
    MALE("map-icon-male", '\ue85c'),
    MAP_PIN("map-icon-map-pin", '\ue85d'),
    MARINA("map-icon-marina", '\ue85e'),
    MOSQUE("map-icon-mosque", '\ue85f'),
    MOTOBIKE_TRAIL("map-icon-motobike-trail", '\ue860'),
    MOVIE_RENTAL("map-icon-movie-rental", '\ue861'),
    MOVIE_THEATER("map-icon-movie-theater", '\ue862'),
    MOVING_COMPANY("map-icon-moving-company", '\ue863'),
    MUSEUM("map-icon-museum", '\ue864'),
    NATURAL_FEATURE("map-icon-natural-feature", '\ue865'),
    NIGHT_CLUB("map-icon-night-club", '\ue866'),
    OPEN_CAPTIONING("map-icon-open-captioning", '\ue867'),
    PAINTER("map-icon-painter", '\ue868'),
    PARK("map-icon-park", '\ue869'),
    PARKING("map-icon-parking", '\ue86a'),
    PET_STORE("map-icon-pet-store", '\ue86b'),
    PHARMACY("map-icon-pharmacy", '\ue86c'),
    PHYSIOTHERAPIST("map-icon-physiotherapist", '\ue86d'),
    PLACE_OF_WORSHIP("map-icon-place-of-worship", '\ue86e'),
    PLAYGROUND("map-icon-playground", '\ue86f'),
    PLUMBER("map-icon-plumber", '\ue870'),
    POINT_OF_INTEREST("map-icon-point-of-interest", '\ue871'),
    POLICE("map-icon-police", '\ue872'),
    POLITICAL("map-icon-political", '\ue873'),
    POSTAL_CODE("map-icon-postal-code", '\ue877'),
    POSTAL_CODE_PREFIX("map-icon-postal-code-prefix", '\ue876'),
    POST_BOX("map-icon-post-box", '\ue874'),
    POST_OFFICE("map-icon-post-office", '\ue875'),
    RAFTING("map-icon-rafting", '\ue878'),
    REAL_ESTATE_AGENCY("map-icon-real-estate-agency", '\ue879'),
    RESTAURANT("map-icon-restaurant", '\ue87a'),
    ROOFING_CONTRACTOR("map-icon-roofing-contractor", '\ue87b'),
    ROUTE("map-icon-route", '\ue87d'),
    ROUTE_PIN("map-icon-route-pin", '\ue87c'),
    RV_PARK("map-icon-rv-park", '\ue87e'),
    SAILING("map-icon-sailing", '\ue87f'),
    SCHOOL("map-icon-school", '\ue880'),
    SCUBA_DIVING("map-icon-scuba-diving", '\ue881'),
    SEARCH("map-icon-search", '\ue882'),
    SHIELD("map-icon-shield", '\ue883'),
    SHOPPING_MALL("map-icon-shopping-mall", '\ue884'),
    SIGN_LANGUAGE("map-icon-sign-language", '\ue885'),
    SKATEBOARDING("map-icon-skateboarding", '\ue886'),
    SKIING("map-icon-skiing", '\ue888'),
    SKI_JUMPING("map-icon-ski-jumping", '\ue887'),
    SLEDDING("map-icon-sledding", '\ue889'),
    SNOW("map-icon-snow", '\ue88b'),
    SNOWBOARDING("map-icon-snowboarding", '\ue88c'),
    SNOWMOBILE("map-icon-snowmobile", '\ue88d'),
    SNOW_SHOEING("map-icon-snow-shoeing", '\ue88a'),
    SPA("map-icon-spa", '\ue88e'),
    SQUARE("map-icon-square", '\ue891'),
    SQUARE_PIN("map-icon-square-pin", '\ue88f'),
    SQUARE_ROUNDED("map-icon-square-rounded", '\ue890'),
    STADIUM("map-icon-stadium", '\ue892'),
    STORAGE("map-icon-storage", '\ue893'),
    STORE("map-icon-store", '\ue894'),
    SUBWAY_STATION("map-icon-subway-station", '\ue895'),
    SURFING("map-icon-surfing", '\ue896'),
    SWIMMING("map-icon-swimming", '\ue897'),
    SYNAGOGUE("map-icon-synagogue", '\ue898'),
    TAXI_STAND("map-icon-taxi-stand", '\ue899'),
    TENNIS("map-icon-tennis", '\ue89a'),
    TOILET("map-icon-toilet", '\ue89b'),
    TRAIL_WALKING("map-icon-trail-walking", '\ue89c'),
    TRAIN_STATION("map-icon-train-station", '\ue89d'),
    TRANSIT_STATION("map-icon-transit-station", '\ue89e'),
    TRAVEL_AGENCY("map-icon-travel-agency", '\ue89f'),
    UNISEX("map-icon-unisex", '\ue8a0'),
    UNIVERSITY("map-icon-university", '\ue8a1'),
    VETERINARY_CARE("map-icon-veterinary-care", '\ue8a2'),
    VIEWING("map-icon-viewing", '\ue8a3'),
    VOLUME_CONTROL_TELEPHONE("map-icon-volume-control-telephone", '\ue8a4'),
    WALKING("map-icon-walking", '\ue8a5'),
    WATERSKIING("map-icon-waterskiing", '\ue8a6'),
    WHALE_WATCHING("map-icon-whale-watching", '\ue8a7'),
    WHEELCHAIR("map-icon-wheelchair", '\ue8a8'),
    WIND_SURFING("map-icon-wind-surfing", '\ue8a9'),
    ZOO("map-icon-zoo", '\ue8aa'),
    ZOOM_IN("map-icon-zoom-in", '\ue8ac'),
    ZOOM_IN_ALT("map-icon-zoom-in-alt", '\ue8ab'),
    ZOOM_OUT("map-icon-zoom-out", '\ue8ae'),
    ZOOM_OUT_ALT("map-icon-zoom-out-alt", '\ue8ad');

    public static Mapicons findByDescription(String description) {
        for (Mapicons font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Mapicons(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
    }