/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.ligaturesymbols;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum LigatureSymbols implements Ikon {
    ADDSTAR("lsf-addstar", '\ue000'),
    AIM("lsf-aim", '\ue163'),
    ALBUM("lsf-album", '\ue002'),
    ALIGNADJUST("lsf-alignadjust", '\ue003'),
    ALIGNCENTER("lsf-aligncenter", '\ue004'),
    ALIGNLEFT("lsf-alignleft", '\ue005'),
    ALIGNRIGHT("lsf-alignright", '\ue006'),
    AMAZON("lsf-amazon", '\ue007'),
    ANDROID("lsf-android", '\ue008'),
    APP("lsf-app", '\ue009'),
    APPLE("lsf-apple", '\ue00a'),
    ARROWDOWN("lsf-arrowdown", '\ue00b'),
    ARROWLEFT("lsf-arrowleft", '\ue00c'),
    ARROWRIGHT("lsf-arrowright", '\ue00d'),
    ARROWUP("lsf-arrowup", '\ue00e'),
    BACK("lsf-back", '\ue00f'),
    BACKSPACE("lsf-backspace", '\ue010'),
    BAD("lsf-bad", '\ue011'),
    BAG("lsf-bag", '\ue173'),
    BAN("lsf-ban", '\ue012'),
    BARCODE("lsf-barcode", '\ue013'),
    BELL("lsf-bell", '\ue014'),
    BICYCLE("lsf-bicycle", '\ue015'),
    BING("lsf-bing", '\ue164'),
    BLOGGER("lsf-blogger", '\ue165'),
    BOLD("lsf-bold", '\ue01f'),
    BOOK("lsf-book", '\ue020'),
    BOOKMARK("lsf-bookmark", '\ue021'),
    BRUSH("lsf-brush", '\ue022'),
    BUILDING("lsf-building", '\ue023'),
    BUS("lsf-bus", '\ue024'),
    CALENDAR("lsf-calendar", '\ue15e'),
    CAMERA("lsf-camera", '\ue026'),
    CAR("lsf-car", '\ue027'),
    CATEGORY("lsf-category", '\ue028'),
    CHECK("lsf-check", '\ue029'),
    CHECKBOX("lsf-checkbox", '\ue02a'),
    CHECKBOXEMPTY("lsf-checkboxempty", '\ue02b'),
    CHROME("lsf-chrome", '\ue02c'),
    CIRCLE("lsf-circle", '\ue02e'),
    CLEAR("lsf-clear", '\ue02f'),
    CLIP("lsf-clip", '\ue030'),
    CLOUD("lsf-cloud", '\ue031'),
    CODE("lsf-code", '\ue032'),
    COFFEE("lsf-coffee", '\ue146'),
    COLLEGE("lsf-college", '\ue174'),
    COLOR("lsf-color", '\ue033'),
    COMMENT("lsf-comment", '\ue034'),
    COMMENTS("lsf-comments", '\ue035'),
    COMPASS("lsf-compass", '\ue036'),
    CONTRAST("lsf-contrast", '\ue001'),
    COOKPAD("lsf-cookpad", '\ue037'),
    COPY("lsf-copy", '\ue038'),
    CROP("lsf-crop", '\ue039'),
    CROWN("lsf-crown", '\ue03a'),
    CURSOR("lsf-cursor", '\ue166'),
    CUT("lsf-cut", '\ue03b'),
    DAILYCALENDAR("lsf-dailycalendar", '\ue025'),
    DARK("lsf-dark", '\ue147'),
    DASHBOARD("lsf-dashboard", '\ue03c'),
    DELETE("lsf-delete", '\ue12c'),
    DELICIOUS("lsf-delicious", '\ue03d'),
    DIGG("lsf-digg", '\ue167'),
    DOWN("lsf-down", '\ue03e'),
    DRIBBBLE("lsf-dribbble", '\ue03f'),
    DROPBOX("lsf-dropbox", '\ue168'),
    DROPDOWN("lsf-dropdown", '\ue040'),
    EDIT("lsf-edit", '\ue041'),
    EJECT("lsf-eject", '\ue042'),
    EMPHASIS("lsf-emphasis", '\ue152'),
    ERASER("lsf-eraser", '\ue148'),
    ETC("lsf-etc", '\ue043'),
    EVERNOTE("lsf-evernote", '\ue044'),
    EXCHANGE("lsf-exchange", '\ue045'),
    EXTERNAL("lsf-external", '\ue046'),
    FACEBOOK("lsf-facebook", '\ue047'),
    FEMALE("lsf-female", '\ue175'),
    FILE("lsf-file", '\ue048'),
    FIREFOX("lsf-firefox", '\ue049'),
    FLAG("lsf-flag", '\ue04a'),
    FLICKR("lsf-flickr", '\ue04b'),
    FOLDER("lsf-folder", '\ue04c'),
    FORWARD("lsf-forward", '\ue04e'),
    FOURSQUARE("lsf-foursquare", '\ue04d'),
    FRIEND("lsf-friend", '\ue051'),
    FRUSTRATE("lsf-frustrate", '\ue052'),
    FULL("lsf-full", '\ue053'),
    GAME("lsf-game", '\ue054'),
    GEO("lsf-geo", '\ue056'),
    GITHUB("lsf-github", '\ue057'),
    GLOBE("lsf-globe", '\ue058'),
    GOOD("lsf-good", '\ue059'),
    GOOGLE("lsf-google", '\ue05a'),
    GRAB("lsf-grab", '\ue169'),
    GRADATION("lsf-gradation", '\ue149'),
    GRAPH("lsf-graph", '\ue05b'),
    GREE("lsf-gree", '\ue153'),
    GROUP("lsf-group", '\ue05c'),
    GUMROAD("lsf-gumroad", '\ue154'),
    HATENA("lsf-hatena", '\ue05d'),
    HATENABOOKMARK("lsf-hatenabookmark", '\ue161'),
    HEART("lsf-heart", '\ue06e'),
    HEARTEMPTY("lsf-heartempty", '\ue06f'),
    HELP("lsf-help", '\ue070'),
    HOME("lsf-home", '\ue072'),
    HORIZONTAL("lsf-horizontal", '\ue071'),
    IMAGE("lsf-image", '\ue074'),
    INFO("lsf-info", '\ue075'),
    INK("lsf-ink", '\ue14a'),
    INSTAGRAM("lsf-instagram", '\ue155'),
    INSTAPAPER("lsf-instapaper", '\ue076'),
    INTERNETEXPLORER("lsf-internetexplorer", '\ue077'),
    INVERT("lsf-invert", '\ue14b'),
    ITALIC("lsf-italic", '\ue079'),
    KEY("lsf-key", '\ue07c'),
    KEYBOARD("lsf-keyboard", '\ue07d'),
    LAUGH("lsf-laugh", '\ue07f'),
    LEFT("lsf-left", '\ue080'),
    LIGHT("lsf-light", '\ue14c'),
    LINE("lsf-line", '\ue157'),
    LINK("lsf-link", '\ue082'),
    LINKEDIN("lsf-linkedin", '\ue083'),
    LIST("lsf-list", '\ue084'),
    LOCATION("lsf-location", '\ue085'),
    LOCK("lsf-lock", '\ue086'),
    LOGIN("lsf-login", '\ue087'),
    LOGOUT("lsf-logout", '\ue088'),
    MAGIC("lsf-magic", '\ue089'),
    MAIL("lsf-mail", '\ue08a'),
    MALE("lsf-male", '\ue176'),
    MAP("lsf-map", '\ue08b'),
    MEAL("lsf-meal", '\ue08c'),
    MEMO("lsf-memo", '\ue08d'),
    MENU("lsf-menu", '\ue08e'),
    MINUS("lsf-minus", '\ue08f'),
    MIXI("lsf-mixi", '\ue090'),
    MOBAGE("lsf-mobage", '\ue158'),
    MOBILE("lsf-mobile", '\ue078'),
    MOVE("lsf-move", '\ue093'),
    MUSIC("lsf-music", '\ue094'),
    MYSPACE("lsf-myspace", '\ue16a'),
    NEXT("lsf-next", '\ue096'),
    NOTIFY("lsf-notify", '\ue097'),
    OFF("lsf-off", '\ue098'),
    OPERA("lsf-opera", '\ue099'),
    PAINT("lsf-paint", '\ue09b'),
    PAPERBOY("lsf-paperboy", '\ue162'),
    PARAMATER("lsf-paramater", '\ue09c'),
    PAUSE("lsf-pause", '\ue09d'),
    PC("lsf-pc", '\ue09e'),
    PEN("lsf-pen", '\ue09f'),
    PHONE("lsf-phone", '\ue100'),
    PHOTO("lsf-photo", '\ue101'),
    PICASA("lsf-picasa", '\ue102'),
    PIN("lsf-pin", '\ue103'),
    PINTEREST("lsf-pinterest", '\ue104'),
    PLANE("lsf-plane", '\ue105'),
    PLAY("lsf-play", '\ue106'),
    PLAYMEDIA("lsf-playmedia", '\ue107'),
    PLUS("lsf-plus", '\ue108'),
    POINTER("lsf-pointer", '\ue16b'),
    PRESENT("lsf-present", '\ue109'),
    PRINT("lsf-print", '\ue10a'),
    QUOTE("lsf-quote", '\ue10b'),
    READABILITY("lsf-readability", '\ue10c'),
    RECORD("lsf-record", '\ue10d'),
    REFRESH("lsf-refresh", '\ue10e'),
    REFRESHBUTTON("lsf-refreshbutton", '\ue14d'),
    REMOVE("lsf-remove", '\ue10f'),
    REPEAT("lsf-repeat", '\ue110'),
    REPLY("lsf-reply", '\ue111'),
    RIGHT("lsf-right", '\ue112'),
    RSS("lsf-rss", '\ue113'),
    SAFARI("lsf-safari", '\ue114'),
    SAVE("lsf-save", '\ue115'),
    SEARCH("lsf-search", '\ue116'),
    SEPIA("lsf-sepia", '\ue14e'),
    SERVER("lsf-server", '\ue16c'),
    SETTING("lsf-setting", '\ue055'),
    SETUP("lsf-setup", '\ue117'),
    SHARE("lsf-share", '\ue118'),
    SHOPPING("lsf-shopping", '\ue119'),
    SHUFFLE("lsf-shuffle", '\ue11a'),
    SITEMAP("lsf-sitemap", '\ue16d'),
    SKYPE("lsf-skype", '\ue11b'),
    SLEIPNIR("lsf-sleipnir", '\ue11c'),
    SLIDESHARE("lsf-slideshare", '\ue179'),
    SMALL("lsf-small", '\ue11d'),
    SMILE("lsf-smile", '\ue11e'),
    SNS("lsf-sns", '\ue11f'),
    SORT("lsf-sort", '\ue120'),
    SOUNDCLOUD("lsf-soundcloud", '\ue17a'),
    SPA("lsf-spa", '\ue177'),
    STAR("lsf-star", '\ue121'),
    STAREMPTY("lsf-starempty", '\ue122'),
    STOP("lsf-stop", '\ue123'),
    STRIKE("lsf-strike", '\ue159'),
    SURPRISE("lsf-surprise", '\ue124'),
    SYNC("lsf-sync", '\ue125'),
    TABLE("lsf-table", '\ue127'),
    TABS("lsf-tabs", '\ue095'),
    TAG("lsf-tag", '\ue128'),
    TERMINAL("lsf-terminal", '\ue16e'),
    TILE("lsf-tile", '\ue129'),
    TILEMENU("lsf-tilemenu", '\ue12a'),
    TIME("lsf-time", '\ue12b'),
    TROUBLE("lsf-trouble", '\ue12d'),
    TUMBLR("lsf-tumblr", '\ue12e'),
    TWINKLE("lsf-twinkle", '\ue073'),
    TWITTER("lsf-twitter", '\ue12f'),
    UBUNTU("lsf-ubuntu", '\ue17b'),
    UMBRELLA("lsf-umbrella", '\ue178'),
    UNDERLINE("lsf-underline", '\ue132'),
    UNDO("lsf-undo", '\ue133'),
    UNLOCK("lsf-unlock", '\ue134'),
    UP("lsf-up", '\ue135'),
    UPLOAD("lsf-upload", '\ue136'),
    USER("lsf-user", '\ue137'),
    USTREAM("lsf-ustream", '\ue16f'),
    VERTICAL("lsf-vertical", '\ue138'),
    VIDEO("lsf-video", '\ue139'),
    VIEW("lsf-view", '\ue13a'),
    VIMEO("lsf-vimeo", '\ue170'),
    VK("lsf-vk", '\ue17c'),
    VOLUME("lsf-volume", '\ue13b'),
    VOLUMEDOWN("lsf-volumedown", '\ue13c'),
    VOLUMEUP("lsf-volumeup", '\ue13d'),
    WALKING("lsf-walking", '\ue13e'),
    WEB("lsf-web", '\ue13f'),
    WIFI("lsf-wifi", '\ue140'),
    WINDOWS("lsf-windows", '\ue151'),
    WINK("lsf-wink", '\ue081'),
    WORDPRESS("lsf-wordpress", '\ue171'),
    YAHOO("lsf-yahoo", '\ue172'),
    YAPCASIALOGOMARK("lsf-yapcasialogomark", '\ue15c'),
    YELP("lsf-yelp", '\ue17d'),
    YOUTUBE("lsf-youtube", '\ue141'),
    ZOOMIN("lsf-zoomin", '\ue142'),
    ZOOMOUT("lsf-zoomout", '\ue143');

    public static LigatureSymbols findByDescription(String description) {
        for (LigatureSymbols font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private char code;

    LigatureSymbols(String description, char code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public char getCode() {
        return code;
    }
}