/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.feather;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Feather implements Ikon {
  FTH_ACTIVITY("fth-activity", '\ue000'),
  FTH_AIRPLAY("fth-airplay", '\ue001'),
  FTH_ALERT_CIRCLE("fth-alert-circle", '\ue002'),
  FTH_ALERT_OCTAGON("fth-alert-octagon", '\ue003'),
  FTH_ALERT_TRIANGLE("fth-alert-triangle", '\ue004'),
  FTH_ALIGN_CENTER("fth-align-center", '\ue005'),
  FTH_ALIGN_JUSTIFY("fth-align-justify", '\ue006'),
  FTH_ALIGN_LEFT("fth-align-left", '\ue007'),
  FTH_ALIGN_RIGHT("fth-align-right", '\ue008'),
  FTH_ANCHOR("fth-anchor", '\ue009'),
  FTH_APERTURE("fth-aperture", '\ue00a'),
  FTH_ARCHIVE("fth-archive", '\ue00b'),
  FTH_ARROW_DOWN("fth-arrow-down", '\ue00c'),
  FTH_ARROW_DOWN_CIRCLE("fth-arrow-down-circle", '\ue00d'),
  FTH_ARROW_DOWN_LEFT("fth-arrow-down-left", '\ue00e'),
  FTH_ARROW_DOWN_RIGHT("fth-arrow-down-right", '\ue00f'),
  FTH_ARROW_LEFT("fth-arrow-left", '\ue010'),
  FTH_ARROW_LEFT_CIRCLE("fth-arrow-left-circle", '\ue011'),
  FTH_ARROW_RIGHT("fth-arrow-right", '\ue012'),
  FTH_ARROW_RIGHT_CIRCLE("fth-arrow-right-circle", '\ue013'),
  FTH_ARROW_UP("fth-arrow-up", '\ue014'),
  FTH_ARROW_UP_CIRCLE("fth-arrow-up-circle", '\ue015'),
  FTH_ARROW_UP_LEFT("fth-arrow-up-left", '\ue016'),
  FTH_ARROW_UP_RIGHT("fth-arrow-up-right", '\ue017'),
  FTH_AT_SIGN("fth-at-sign", '\ue018'),
  FTH_AWARD("fth-award", '\ue019'),
  FTH_BAR_CHART("fth-bar-chart", '\ue01a'),
  FTH_BAR_CHART_2("fth-bar-chart-2", '\ue01b'),
  FTH_BATTERY("fth-battery", '\ue01c'),
  FTH_BATTERY_CHARGING("fth-battery-charging", '\ue01d'),
  FTH_BELL("fth-bell", '\ue01e'),
  FTH_BELL_OFF("fth-bell-off", '\ue01f'),
  FTH_BLUETOOTH("fth-bluetooth", '\ue020'),
  FTH_BOLD("fth-bold", '\ue021'),
  FTH_BOOK("fth-book", '\ue022'),
  FTH_BOOKMARK("fth-bookmark", '\ue023'),
  FTH_BOOK_OPEN("fth-book-open", '\ue024'),
  FTH_BOX("fth-box", '\ue025'),
  FTH_BRIEFCASE("fth-briefcase", '\ue026'),
  FTH_CALENDAR("fth-calendar", '\ue027'),
  FTH_CAMERA("fth-camera", '\ue028'),
  FTH_CAMERA_OFF("fth-camera-off", '\ue029'),
  FTH_CAST("fth-cast", '\ue02a'),
  FTH_CHECK("fth-check", '\ue02b'),
  FTH_CHECK_CIRCLE("fth-check-circle", '\ue02c'),
  FTH_CHECK_SQUARE("fth-check-square", '\ue02d'),
  FTH_CHEVRONS_DOWN("fth-chevrons-down", '\ue031'),
  FTH_CHEVRONS_LEFT("fth-chevrons-left", '\ue032'),
  FTH_CHEVRONS_RIGHT("fth-chevrons-right", '\ue033'),
  FTH_CHEVRONS_UP("fth-chevrons-up", '\ue034'),
  FTH_CHEVRON_DOWN("fth-chevron-down", '\ue02e'),
  FTH_CHEVRON_LEFT("fth-chevron-left", '\ue02f'),
  FTH_CHEVRON_RIGHT("fth-chevron-right", '\ue030'),
  FTH_CHEVRON_UP("fth-chevron-up", '\ue035'),
  FTH_CHROME("fth-chrome", '\ue036'),
  FTH_CIRCLE("fth-circle", '\ue037'),
  FTH_CLIPBOARD("fth-clipboard", '\ue038'),
  FTH_CLOCK("fth-clock", '\ue039'),
  FTH_CLOUD("fth-cloud", '\ue03a'),
  FTH_CLOUD_DRIZZLE("fth-cloud-drizzle", '\ue03b'),
  FTH_CLOUD_LIGHTNING("fth-cloud-lightning", '\ue03c'),
  FTH_CLOUD_OFF("fth-cloud-off", '\ue03d'),
  FTH_CLOUD_RAIN("fth-cloud-rain", '\ue03e'),
  FTH_CLOUD_SNOW("fth-cloud-snow", '\ue03f'),
  FTH_CODE("fth-code", '\ue040'),
  FTH_CODEPEN("fth-codepen", '\ue041'),
  FTH_CODESANDBOX("fth-codesandbox", '\ue042'),
  FTH_COFFEE("fth-coffee", '\ue043'),
  FTH_COLUMNS("fth-columns", '\ue044'),
  FTH_COMMAND("fth-command", '\ue045'),
  FTH_COMPASS("fth-compass", '\ue046'),
  FTH_COPY("fth-copy", '\ue047'),
  FTH_CORNER_DOWN_LEFT("fth-corner-down-left", '\ue048'),
  FTH_CORNER_DOWN_RIGHT("fth-corner-down-right", '\ue049'),
  FTH_CORNER_LEFT_DOWN("fth-corner-left-down", '\ue04a'),
  FTH_CORNER_LEFT_UP("fth-corner-left-up", '\ue04b'),
  FTH_CORNER_RIGHT_DOWN("fth-corner-right-down", '\ue04c'),
  FTH_CORNER_RIGHT_UP("fth-corner-right-up", '\ue04d'),
  FTH_CORNER_UP_LEFT("fth-corner-up-left", '\ue04e'),
  FTH_CORNER_UP_RIGHT("fth-corner-up-right", '\ue04f'),
  FTH_CPU("fth-cpu", '\ue050'),
  FTH_CREDIT_CARD("fth-credit-card", '\ue051'),
  FTH_CROP("fth-crop", '\ue052'),
  FTH_CROSSHAIR("fth-crosshair", '\ue053'),
  FTH_DATABASE("fth-database", '\ue054'),
  FTH_DELETE("fth-delete", '\ue055'),
  FTH_DISC("fth-disc", '\ue056'),
  FTH_DIVIDE("fth-divide", '\ue057'),
  FTH_DIVIDE_CIRCLE("fth-divide-circle", '\ue058'),
  FTH_DIVIDE_SQUARE("fth-divide-square", '\ue059'),
  FTH_DOLLAR_SIGN("fth-dollar-sign", '\ue05a'),
  FTH_DOWNLOAD("fth-download", '\ue05b'),
  FTH_DOWNLOAD_CLOUD("fth-download-cloud", '\ue05c'),
  FTH_DRIBBBLE("fth-dribbble", '\ue05d'),
  FTH_DROPLET("fth-droplet", '\ue05e'),
  FTH_EDIT("fth-edit", '\ue05f'),
  FTH_EDIT_2("fth-edit-2", '\ue060'),
  FTH_EDIT_3("fth-edit-3", '\ue061'),
  FTH_EXTERNAL_LINK("fth-external-link", '\ue062'),
  FTH_EYE("fth-eye", '\ue063'),
  FTH_EYE_OFF("fth-eye-off", '\ue064'),
  FTH_FACEBOOK("fth-facebook", '\ue065'),
  FTH_FAST_FORWARD("fth-fast-forward", '\ue066'),
  FTH_FEATHER("fth-feather", '\ue067'),
  FTH_FIGMA("fth-figma", '\ue068'),
  FTH_FILE("fth-file", '\ue069'),
  FTH_FILE_MINUS("fth-file-minus", '\ue06a'),
  FTH_FILE_PLUS("fth-file-plus", '\ue06b'),
  FTH_FILE_TEXT("fth-file-text", '\ue06c'),
  FTH_FILM("fth-film", '\ue06d'),
  FTH_FILTER("fth-filter", '\ue06e'),
  FTH_FLAG("fth-flag", '\ue06f'),
  FTH_FOLDER("fth-folder", '\ue070'),
  FTH_FOLDER_MINUS("fth-folder-minus", '\ue071'),
  FTH_FOLDER_PLUS("fth-folder-plus", '\ue072'),
  FTH_FRAMER("fth-framer", '\ue073'),
  FTH_FROWN("fth-frown", '\ue074'),
  FTH_GIFT("fth-gift", '\ue075'),
  FTH_GITHUB("fth-github", '\ue078'),
  FTH_GITLAB("fth-gitlab", '\ue079'),
  FTH_GIT_BRANCH("fth-git-branch", '\ue076'),
  FTH_GIT_COMMIT("fth-git-commit", '\ue077'),
  FTH_GIT_MERGE("fth-git-merge", '\ue07a'),
  FTH_GIT_PULL_REQUEST("fth-git-pull-request", '\ue07b'),
  FTH_GLOBE("fth-globe", '\ue07c'),
  FTH_GRID("fth-grid", '\ue07d'),
  FTH_HARD_DRIVE("fth-hard-drive", '\ue07e'),
  FTH_HASH("fth-hash", '\ue07f'),
  FTH_HEADPHONES("fth-headphones", '\ue080'),
  FTH_HEART("fth-heart", '\ue081'),
  FTH_HELP_CIRCLE("fth-help-circle", '\ue082'),
  FTH_HEXAGON("fth-hexagon", '\ue083'),
  FTH_HOME("fth-home", '\ue084'),
  FTH_IMAGE("fth-image", '\ue085'),
  FTH_INBOX("fth-inbox", '\ue086'),
  FTH_INFO("fth-info", '\ue087'),
  FTH_INSTAGRAM("fth-instagram", '\ue088'),
  FTH_ITALIC("fth-italic", '\ue089'),
  FTH_KEY("fth-key", '\ue08a'),
  FTH_LAYERS("fth-layers", '\ue08b'),
  FTH_LAYOUT("fth-layout", '\ue08c'),
  FTH_LIFE_BUOY("fth-life-buoy", '\ue08d'),
  FTH_LINK("fth-link", '\ue08e'),
  FTH_LINKEDIN("fth-linkedin", '\ue090'),
  FTH_LINK_2("fth-link-2", '\ue08f'),
  FTH_LIST("fth-list", '\ue091'),
  FTH_LOADER("fth-loader", '\ue092'),
  FTH_LOCK("fth-lock", '\ue093'),
  FTH_LOG_IN("fth-log-in", '\ue094'),
  FTH_LOG_OUT("fth-log-out", '\ue095'),
  FTH_MAIL("fth-mail", '\ue096'),
  FTH_MAP("fth-map", '\ue097'),
  FTH_MAP_PIN("fth-map-pin", '\ue098'),
  FTH_MAXIMIZE("fth-maximize", '\ue099'),
  FTH_MAXIMIZE_2("fth-maximize-2", '\ue09a'),
  FTH_MEH("fth-meh", '\ue09b'),
  FTH_MENU("fth-menu", '\ue09c'),
  FTH_MESSAGE_CIRCLE("fth-message-circle", '\ue09d'),
  FTH_MESSAGE_SQUARE("fth-message-square", '\ue09e'),
  FTH_MIC("fth-mic", '\ue09f'),
  FTH_MIC_OFF("fth-mic-off", '\ue0a0'),
  FTH_MINIMIZE("fth-minimize", '\ue0a1'),
  FTH_MINIMIZE_2("fth-minimize-2", '\ue0a2'),
  FTH_MINUS("fth-minus", '\ue0a3'),
  FTH_MINUS_CIRCLE("fth-minus-circle", '\ue0a4'),
  FTH_MINUS_SQUARE("fth-minus-square", '\ue0a5'),
  FTH_MONITOR("fth-monitor", '\ue0a6'),
  FTH_MOON("fth-moon", '\ue0a7'),
  FTH_MORE_HORIZONTAL("fth-more-horizontal", '\ue0a8'),
  FTH_MORE_VERTICAL("fth-more-vertical", '\ue0a9'),
  FTH_MOUSE_POINTER("fth-mouse-pointer", '\ue0aa'),
  FTH_MOVE("fth-move", '\ue0ab'),
  FTH_MUSIC("fth-music", '\ue0ac'),
  FTH_NAVIGATION("fth-navigation", '\ue0ad'),
  FTH_NAVIGATION_2("fth-navigation-2", '\ue0ae'),
  FTH_OCTAGON("fth-octagon", '\ue0af'),
  FTH_PACKAGE("fth-package", '\ue0b0'),
  FTH_PAPERCLIP("fth-paperclip", '\ue0b1'),
  FTH_PAUSE("fth-pause", '\ue0b2'),
  FTH_PAUSE_CIRCLE("fth-pause-circle", '\ue0b3'),
  FTH_PEN_TOOL("fth-pen-tool", '\ue0b4'),
  FTH_PERCENT("fth-percent", '\ue0b5'),
  FTH_PHONE("fth-phone", '\ue0b6'),
  FTH_PHONE_CALL("fth-phone-call", '\ue0b7'),
  FTH_PHONE_FORWARDED("fth-phone-forwarded", '\ue0b8'),
  FTH_PHONE_INCOMING("fth-phone-incoming", '\ue0b9'),
  FTH_PHONE_MISSED("fth-phone-missed", '\ue0ba'),
  FTH_PHONE_OFF("fth-phone-off", '\ue0bb'),
  FTH_PHONE_OUTGOING("fth-phone-outgoing", '\ue0bc'),
  FTH_PIE_CHART("fth-pie-chart", '\ue0bd'),
  FTH_PLAY("fth-play", '\ue0be'),
  FTH_PLAY_CIRCLE("fth-play-circle", '\ue0bf'),
  FTH_PLUS("fth-plus", '\ue0c0'),
  FTH_PLUS_CIRCLE("fth-plus-circle", '\ue0c1'),
  FTH_PLUS_SQUARE("fth-plus-square", '\ue0c2'),
  FTH_POCKET("fth-pocket", '\ue0c3'),
  FTH_POWER("fth-power", '\ue0c4'),
  FTH_PRINTER("fth-printer", '\ue0c5'),
  FTH_RADIO("fth-radio", '\ue0c6'),
  FTH_REFRESH_CCW("fth-refresh-ccw", '\ue0c7'),
  FTH_REFRESH_CW("fth-refresh-cw", '\ue0c8'),
  FTH_REPEAT("fth-repeat", '\ue0c9'),
  FTH_REWIND("fth-rewind", '\ue0ca'),
  FTH_ROTATE_CCW("fth-rotate-ccw", '\ue0cb'),
  FTH_ROTATE_CW("fth-rotate-cw", '\ue0cc'),
  FTH_RSS("fth-rss", '\ue0cd'),
  FTH_SAVE("fth-save", '\ue0ce'),
  FTH_SCISSORS("fth-scissors", '\ue0cf'),
  FTH_SEARCH("fth-search", '\ue0d0'),
  FTH_SEND("fth-send", '\ue0d1'),
  FTH_SERVER("fth-server", '\ue0d2'),
  FTH_SETTINGS("fth-settings", '\ue0d3'),
  FTH_SHARE("fth-share", '\ue0d4'),
  FTH_SHARE_2("fth-share-2", '\ue0d5'),
  FTH_SHIELD("fth-shield", '\ue0d6'),
  FTH_SHIELD_OFF("fth-shield-off", '\ue0d7'),
  FTH_SHOPPING_BAG("fth-shopping-bag", '\ue0d8'),
  FTH_SHOPPING_CART("fth-shopping-cart", '\ue0d9'),
  FTH_SHUFFLE("fth-shuffle", '\ue0da'),
  FTH_SIDEBAR("fth-sidebar", '\ue0db'),
  FTH_SKIP_BACK("fth-skip-back", '\ue0dc'),
  FTH_SKIP_FORWARD("fth-skip-forward", '\ue0dd'),
  FTH_SLACK("fth-slack", '\ue0de'),
  FTH_SLASH("fth-slash", '\ue0df'),
  FTH_SLIDERS("fth-sliders", '\ue0e0'),
  FTH_SMARTPHONE("fth-smartphone", '\ue0e1'),
  FTH_SMILE("fth-smile", '\ue0e2'),
  FTH_SPEAKER("fth-speaker", '\ue0e3'),
  FTH_SQUARE("fth-square", '\ue0e4'),
  FTH_STAR("fth-star", '\ue0e5'),
  FTH_STOP_CIRCLE("fth-stop-circle", '\ue0e6'),
  FTH_SUN("fth-sun", '\ue0e7'),
  FTH_SUNRISE("fth-sunrise", '\ue0e8'),
  FTH_SUNSET("fth-sunset", '\ue0e9'),
  FTH_TABLET("fth-tablet", '\ue0ea'),
  FTH_TAG("fth-tag", '\ue0eb'),
  FTH_TARGET("fth-target", '\ue0ec'),
  FTH_TERMINAL("fth-terminal", '\ue0ed'),
  FTH_THERMOMETER("fth-thermometer", '\ue0ee'),
  FTH_THUMBS_DOWN("fth-thumbs-down", '\ue0ef'),
  FTH_THUMBS_UP("fth-thumbs-up", '\ue0f0'),
  FTH_TOGGLE_LEFT("fth-toggle-left", '\ue0f1'),
  FTH_TOGGLE_RIGHT("fth-toggle-right", '\ue0f2'),
  FTH_TOOL("fth-tool", '\ue0f3'),
  FTH_TRASH("fth-trash", '\ue0f4'),
  FTH_TRASH_2("fth-trash-2", '\ue0f5'),
  FTH_TRELLO("fth-trello", '\ue0f6'),
  FTH_TRENDING_DOWN("fth-trending-down", '\ue0f7'),
  FTH_TRENDING_UP("fth-trending-up", '\ue0f8'),
  FTH_TRIANGLE("fth-triangle", '\ue0f9'),
  FTH_TRUCK("fth-truck", '\ue0fa'),
  FTH_TV("fth-tv", '\ue0fb'),
  FTH_TWITCH("fth-twitch", '\ue0fc'),
  FTH_TWITTER("fth-twitter", '\ue0fd'),
  FTH_TYPE("fth-type", '\ue0fe'),
  FTH_UMBRELLA("fth-umbrella", '\ue0ff'),
  FTH_UNDERLINE("fth-underline", '\ue100'),
  FTH_UNLOCK("fth-unlock", '\ue101'),
  FTH_UPLOAD("fth-upload", '\ue102'),
  FTH_UPLOAD_CLOUD("fth-upload-cloud", '\ue103'),
  FTH_USER("fth-user", '\ue104'),
  FTH_USERS("fth-users", '\ue108'),
  FTH_USER_CHECK("fth-user-check", '\ue105'),
  FTH_USER_MINUS("fth-user-minus", '\ue106'),
  FTH_USER_PLUS("fth-user-plus", '\ue107'),
  FTH_USER_X("fth-user-x", '\ue109'),
  FTH_VIDEO("fth-video", '\ue10a'),
  FTH_VIDEO_OFF("fth-video-off", '\ue10b'),
  FTH_VOICEMAIL("fth-voicemail", '\ue10c'),
  FTH_VOLUME("fth-volume", '\ue10d'),
  FTH_VOLUME_1("fth-volume-1", '\ue10e'),
  FTH_VOLUME_2("fth-volume-2", '\ue10f'),
  FTH_VOLUME_X("fth-volume-x", '\ue110'),
  FTH_WATCH("fth-watch", '\ue111'),
  FTH_WIFI("fth-wifi", '\ue112'),
  FTH_WIFI_OFF("fth-wifi-off", '\ue113'),
  FTH_WIND("fth-wind", '\ue114'),
  FTH_X("fth-x", '\ue115'),
  FTH_X_CIRCLE("fth-x-circle", '\ue116'),
  FTH_X_OCTAGON("fth-x-octagon", '\ue117'),
  FTH_X_SQUARE("fth-x-square", '\ue118'),
  FTH_YOUTUBE("fth-youtube", '\ue119'),
  FTH_ZAP("fth-zap", '\ue11a'),
  FTH_ZAP_OFF("fth-zap-off", '\ue11b'),
  FTH_ZOOM_IN("fth-zoom-in", '\ue11c'),
  FTH_ZOOM_OUT("fth-zoom-out", '\ue11d');

    public static Feather findByDescription(String description) {
        for (Feather font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private char code;

    Feather(String description, char code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public char getCode() {
        return code;
    }
}
