/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.feather;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Feather implements Ikon {
    ACTIVITY("fth-activity", '\ue000'),
    AIRPLAY("fth-airplay", '\ue001'),
    ALERT_CIRCLE("fth-alert-circle", '\ue002'),
    ALERT_OCTAGON("fth-alert-octagon", '\ue003'),
    ALERT_TRIANGLE("fth-alert-triangle", '\ue004'),
    ALIGN_CENTER("fth-align-center", '\ue005'),
    ALIGN_JUSTIFY("fth-align-justify", '\ue006'),
    ALIGN_LEFT("fth-align-left", '\ue007'),
    ALIGN_RIGHT("fth-align-right", '\ue008'),
    ANCHOR("fth-anchor", '\ue009'),
    APERTURE("fth-aperture", '\ue00a'),
    ARCHIVE("fth-archive", '\ue00b'),
    ARROW_DOWN("fth-arrow-down", '\ue00c'),
    ARROW_DOWN_CIRCLE("fth-arrow-down-circle", '\ue00d'),
    ARROW_DOWN_LEFT("fth-arrow-down-left", '\ue00e'),
    ARROW_DOWN_RIGHT("fth-arrow-down-right", '\ue00f'),
    ARROW_LEFT("fth-arrow-left", '\ue010'),
    ARROW_LEFT_CIRCLE("fth-arrow-left-circle", '\ue011'),
    ARROW_RIGHT("fth-arrow-right", '\ue012'),
    ARROW_RIGHT_CIRCLE("fth-arrow-right-circle", '\ue013'),
    ARROW_UP("fth-arrow-up", '\ue014'),
    ARROW_UP_CIRCLE("fth-arrow-up-circle", '\ue015'),
    ARROW_UP_LEFT("fth-arrow-up-left", '\ue016'),
    ARROW_UP_RIGHT("fth-arrow-up-right", '\ue017'),
    AT_SIGN("fth-at-sign", '\ue018'),
    AWARD("fth-award", '\ue019'),
    BAR_CHART("fth-bar-chart", '\ue01a'),
    BAR_CHART_2("fth-bar-chart-2", '\ue01b'),
    BATTERY("fth-battery", '\ue01c'),
    BATTERY_CHARGING("fth-battery-charging", '\ue01d'),
    BELL("fth-bell", '\ue01e'),
    BELL_OFF("fth-bell-off", '\ue01f'),
    BLUETOOTH("fth-bluetooth", '\ue020'),
    BOLD("fth-bold", '\ue021'),
    BOOK("fth-book", '\ue022'),
    BOOKMARK("fth-bookmark", '\ue023'),
    BOOK_OPEN("fth-book-open", '\ue024'),
    BOX("fth-box", '\ue025'),
    BRIEFCASE("fth-briefcase", '\ue026'),
    CALENDAR("fth-calendar", '\ue027'),
    CAMERA("fth-camera", '\ue028'),
    CAMERA_OFF("fth-camera-off", '\ue029'),
    CAST("fth-cast", '\ue02a'),
    CHECK("fth-check", '\ue02b'),
    CHECK_CIRCLE("fth-check-circle", '\ue02c'),
    CHECK_SQUARE("fth-check-square", '\ue02d'),
    CHEVRONS_DOWN("fth-chevrons-down", '\ue031'),
    CHEVRONS_LEFT("fth-chevrons-left", '\ue032'),
    CHEVRONS_RIGHT("fth-chevrons-right", '\ue033'),
    CHEVRONS_UP("fth-chevrons-up", '\ue034'),
    CHEVRON_DOWN("fth-chevron-down", '\ue02e'),
    CHEVRON_LEFT("fth-chevron-left", '\ue02f'),
    CHEVRON_RIGHT("fth-chevron-right", '\ue030'),
    CHEVRON_UP("fth-chevron-up", '\ue035'),
    CHROME("fth-chrome", '\ue036'),
    CIRCLE("fth-circle", '\ue037'),
    CLIPBOARD("fth-clipboard", '\ue038'),
    CLOCK("fth-clock", '\ue039'),
    CLOUD("fth-cloud", '\ue03a'),
    CLOUD_DRIZZLE("fth-cloud-drizzle", '\ue03b'),
    CLOUD_LIGHTNING("fth-cloud-lightning", '\ue03c'),
    CLOUD_OFF("fth-cloud-off", '\ue03d'),
    CLOUD_RAIN("fth-cloud-rain", '\ue03e'),
    CLOUD_SNOW("fth-cloud-snow", '\ue03f'),
    CODE("fth-code", '\ue040'),
    CODEPEN("fth-codepen", '\ue041'),
    CODESANDBOX("fth-codesandbox", '\ue042'),
    COFFEE("fth-coffee", '\ue043'),
    COLUMNS("fth-columns", '\ue044'),
    COMMAND("fth-command", '\ue045'),
    COMPASS("fth-compass", '\ue046'),
    COPY("fth-copy", '\ue047'),
    CORNER_DOWN_LEFT("fth-corner-down-left", '\ue048'),
    CORNER_DOWN_RIGHT("fth-corner-down-right", '\ue049'),
    CORNER_LEFT_DOWN("fth-corner-left-down", '\ue04a'),
    CORNER_LEFT_UP("fth-corner-left-up", '\ue04b'),
    CORNER_RIGHT_DOWN("fth-corner-right-down", '\ue04c'),
    CORNER_RIGHT_UP("fth-corner-right-up", '\ue04d'),
    CORNER_UP_LEFT("fth-corner-up-left", '\ue04e'),
    CORNER_UP_RIGHT("fth-corner-up-right", '\ue04f'),
    CPU("fth-cpu", '\ue050'),
    CREDIT_CARD("fth-credit-card", '\ue051'),
    CROP("fth-crop", '\ue052'),
    CROSSHAIR("fth-crosshair", '\ue053'),
    DATABASE("fth-database", '\ue054'),
    DELETE("fth-delete", '\ue055'),
    DISC("fth-disc", '\ue056'),
    DIVIDE("fth-divide", '\ue057'),
    DIVIDE_CIRCLE("fth-divide-circle", '\ue058'),
    DIVIDE_SQUARE("fth-divide-square", '\ue059'),
    DOLLAR_SIGN("fth-dollar-sign", '\ue05a'),
    DOWNLOAD("fth-download", '\ue05b'),
    DOWNLOAD_CLOUD("fth-download-cloud", '\ue05c'),
    DRIBBBLE("fth-dribbble", '\ue05d'),
    DROPLET("fth-droplet", '\ue05e'),
    EDIT("fth-edit", '\ue05f'),
    EDIT_2("fth-edit-2", '\ue060'),
    EDIT_3("fth-edit-3", '\ue061'),
    EXTERNAL_LINK("fth-external-link", '\ue062'),
    EYE("fth-eye", '\ue063'),
    EYE_OFF("fth-eye-off", '\ue064'),
    FACEBOOK("fth-facebook", '\ue065'),
    FAST_FORWARD("fth-fast-forward", '\ue066'),
    FEATHER("fth-feather", '\ue067'),
    FIGMA("fth-figma", '\ue068'),
    FILE("fth-file", '\ue069'),
    FILE_MINUS("fth-file-minus", '\ue06a'),
    FILE_PLUS("fth-file-plus", '\ue06b'),
    FILE_TEXT("fth-file-text", '\ue06c'),
    FILM("fth-film", '\ue06d'),
    FILTER("fth-filter", '\ue06e'),
    FLAG("fth-flag", '\ue06f'),
    FOLDER("fth-folder", '\ue070'),
    FOLDER_MINUS("fth-folder-minus", '\ue071'),
    FOLDER_PLUS("fth-folder-plus", '\ue072'),
    FRAMER("fth-framer", '\ue073'),
    FROWN("fth-frown", '\ue074'),
    GIFT("fth-gift", '\ue075'),
    GITHUB("fth-github", '\ue078'),
    GITLAB("fth-gitlab", '\ue079'),
    GIT_BRANCH("fth-git-branch", '\ue076'),
    GIT_COMMIT("fth-git-commit", '\ue077'),
    GIT_MERGE("fth-git-merge", '\ue07a'),
    GIT_PULL_REQUEST("fth-git-pull-request", '\ue07b'),
    GLOBE("fth-globe", '\ue07c'),
    GRID("fth-grid", '\ue07d'),
    HARD_DRIVE("fth-hard-drive", '\ue07e'),
    HASH("fth-hash", '\ue07f'),
    HEADPHONES("fth-headphones", '\ue080'),
    HEART("fth-heart", '\ue081'),
    HELP_CIRCLE("fth-help-circle", '\ue082'),
    HEXAGON("fth-hexagon", '\ue083'),
    HOME("fth-home", '\ue084'),
    IMAGE("fth-image", '\ue085'),
    INBOX("fth-inbox", '\ue086'),
    INFO("fth-info", '\ue087'),
    INSTAGRAM("fth-instagram", '\ue088'),
    ITALIC("fth-italic", '\ue089'),
    KEY("fth-key", '\ue08a'),
    LAYERS("fth-layers", '\ue08b'),
    LAYOUT("fth-layout", '\ue08c'),
    LIFE_BUOY("fth-life-buoy", '\ue08d'),
    LINK("fth-link", '\ue08e'),
    LINKEDIN("fth-linkedin", '\ue090'),
    LINK_2("fth-link-2", '\ue08f'),
    LIST("fth-list", '\ue091'),
    LOADER("fth-loader", '\ue092'),
    LOCK("fth-lock", '\ue093'),
    LOG_IN("fth-log-in", '\ue094'),
    LOG_OUT("fth-log-out", '\ue095'),
    MAIL("fth-mail", '\ue096'),
    MAP("fth-map", '\ue097'),
    MAP_PIN("fth-map-pin", '\ue098'),
    MAXIMIZE("fth-maximize", '\ue099'),
    MAXIMIZE_2("fth-maximize-2", '\ue09a'),
    MEH("fth-meh", '\ue09b'),
    MENU("fth-menu", '\ue09c'),
    MESSAGE_CIRCLE("fth-message-circle", '\ue09d'),
    MESSAGE_SQUARE("fth-message-square", '\ue09e'),
    MIC("fth-mic", '\ue09f'),
    MIC_OFF("fth-mic-off", '\ue0a0'),
    MINIMIZE("fth-minimize", '\ue0a1'),
    MINIMIZE_2("fth-minimize-2", '\ue0a2'),
    MINUS("fth-minus", '\ue0a3'),
    MINUS_CIRCLE("fth-minus-circle", '\ue0a4'),
    MINUS_SQUARE("fth-minus-square", '\ue0a5'),
    MONITOR("fth-monitor", '\ue0a6'),
    MOON("fth-moon", '\ue0a7'),
    MORE_HORIZONTAL("fth-more-horizontal", '\ue0a8'),
    MORE_VERTICAL("fth-more-vertical", '\ue0a9'),
    MOUSE_POINTER("fth-mouse-pointer", '\ue0aa'),
    MOVE("fth-move", '\ue0ab'),
    MUSIC("fth-music", '\ue0ac'),
    NAVIGATION("fth-navigation", '\ue0ad'),
    NAVIGATION_2("fth-navigation-2", '\ue0ae'),
    OCTAGON("fth-octagon", '\ue0af'),
    PACKAGE("fth-package", '\ue0b0'),
    PAPERCLIP("fth-paperclip", '\ue0b1'),
    PAUSE("fth-pause", '\ue0b2'),
    PAUSE_CIRCLE("fth-pause-circle", '\ue0b3'),
    PEN_TOOL("fth-pen-tool", '\ue0b4'),
    PERCENT("fth-percent", '\ue0b5'),
    PHONE("fth-phone", '\ue0b6'),
    PHONE_CALL("fth-phone-call", '\ue0b7'),
    PHONE_FORWARDED("fth-phone-forwarded", '\ue0b8'),
    PHONE_INCOMING("fth-phone-incoming", '\ue0b9'),
    PHONE_MISSED("fth-phone-missed", '\ue0ba'),
    PHONE_OFF("fth-phone-off", '\ue0bb'),
    PHONE_OUTGOING("fth-phone-outgoing", '\ue0bc'),
    PIE_CHART("fth-pie-chart", '\ue0bd'),
    PLAY("fth-play", '\ue0be'),
    PLAY_CIRCLE("fth-play-circle", '\ue0bf'),
    PLUS("fth-plus", '\ue0c0'),
    PLUS_CIRCLE("fth-plus-circle", '\ue0c1'),
    PLUS_SQUARE("fth-plus-square", '\ue0c2'),
    POCKET("fth-pocket", '\ue0c3'),
    POWER("fth-power", '\ue0c4'),
    PRINTER("fth-printer", '\ue0c5'),
    RADIO("fth-radio", '\ue0c6'),
    REFRESH_CCW("fth-refresh-ccw", '\ue0c7'),
    REFRESH_CW("fth-refresh-cw", '\ue0c8'),
    REPEAT("fth-repeat", '\ue0c9'),
    REWIND("fth-rewind", '\ue0ca'),
    ROTATE_CCW("fth-rotate-ccw", '\ue0cb'),
    ROTATE_CW("fth-rotate-cw", '\ue0cc'),
    RSS("fth-rss", '\ue0cd'),
    SAVE("fth-save", '\ue0ce'),
    SCISSORS("fth-scissors", '\ue0cf'),
    SEARCH("fth-search", '\ue0d0'),
    SEND("fth-send", '\ue0d1'),
    SERVER("fth-server", '\ue0d2'),
    SETTINGS("fth-settings", '\ue0d3'),
    SHARE("fth-share", '\ue0d4'),
    SHARE_2("fth-share-2", '\ue0d5'),
    SHIELD("fth-shield", '\ue0d6'),
    SHIELD_OFF("fth-shield-off", '\ue0d7'),
    SHOPPING_BAG("fth-shopping-bag", '\ue0d8'),
    SHOPPING_CART("fth-shopping-cart", '\ue0d9'),
    SHUFFLE("fth-shuffle", '\ue0da'),
    SIDEBAR("fth-sidebar", '\ue0db'),
    SKIP_BACK("fth-skip-back", '\ue0dc'),
    SKIP_FORWARD("fth-skip-forward", '\ue0dd'),
    SLACK("fth-slack", '\ue0de'),
    SLASH("fth-slash", '\ue0df'),
    SLIDERS("fth-sliders", '\ue0e0'),
    SMARTPHONE("fth-smartphone", '\ue0e1'),
    SMILE("fth-smile", '\ue0e2'),
    SPEAKER("fth-speaker", '\ue0e3'),
    SQUARE("fth-square", '\ue0e4'),
    STAR("fth-star", '\ue0e5'),
    STOP_CIRCLE("fth-stop-circle", '\ue0e6'),
    SUN("fth-sun", '\ue0e7'),
    SUNRISE("fth-sunrise", '\ue0e8'),
    SUNSET("fth-sunset", '\ue0e9'),
    TABLET("fth-tablet", '\ue0ea'),
    TAG("fth-tag", '\ue0eb'),
    TARGET("fth-target", '\ue0ec'),
    TERMINAL("fth-terminal", '\ue0ed'),
    THERMOMETER("fth-thermometer", '\ue0ee'),
    THUMBS_DOWN("fth-thumbs-down", '\ue0ef'),
    THUMBS_UP("fth-thumbs-up", '\ue0f0'),
    TOGGLE_LEFT("fth-toggle-left", '\ue0f1'),
    TOGGLE_RIGHT("fth-toggle-right", '\ue0f2'),
    TOOL("fth-tool", '\ue0f3'),
    TRASH("fth-trash", '\ue0f4'),
    TRASH_2("fth-trash-2", '\ue0f5'),
    TRELLO("fth-trello", '\ue0f6'),
    TRENDING_DOWN("fth-trending-down", '\ue0f7'),
    TRENDING_UP("fth-trending-up", '\ue0f8'),
    TRIANGLE("fth-triangle", '\ue0f9'),
    TRUCK("fth-truck", '\ue0fa'),
    TV("fth-tv", '\ue0fb'),
    TWITCH("fth-twitch", '\ue0fc'),
    TWITTER("fth-twitter", '\ue0fd'),
    TYPE("fth-type", '\ue0fe'),
    UMBRELLA("fth-umbrella", '\ue0ff'),
    UNDERLINE("fth-underline", '\ue100'),
    UNLOCK("fth-unlock", '\ue101'),
    UPLOAD("fth-upload", '\ue102'),
    UPLOAD_CLOUD("fth-upload-cloud", '\ue103'),
    USER("fth-user", '\ue104'),
    USERS("fth-users", '\ue108'),
    USER_CHECK("fth-user-check", '\ue105'),
    USER_MINUS("fth-user-minus", '\ue106'),
    USER_PLUS("fth-user-plus", '\ue107'),
    USER_X("fth-user-x", '\ue109'),
    VIDEO("fth-video", '\ue10a'),
    VIDEO_OFF("fth-video-off", '\ue10b'),
    VOICEMAIL("fth-voicemail", '\ue10c'),
    VOLUME("fth-volume", '\ue10d'),
    VOLUME_1("fth-volume-1", '\ue10e'),
    VOLUME_2("fth-volume-2", '\ue10f'),
    VOLUME_X("fth-volume-x", '\ue110'),
    WATCH("fth-watch", '\ue111'),
    WIFI("fth-wifi", '\ue112'),
    WIFI_OFF("fth-wifi-off", '\ue113'),
    WIND("fth-wind", '\ue114'),
    X("fth-x", '\ue115'),
    X_CIRCLE("fth-x-circle", '\ue116'),
    X_OCTAGON("fth-x-octagon", '\ue117'),
    X_SQUARE("fth-x-square", '\ue118'),
    YOUTUBE("fth-youtube", '\ue119'),
    ZAP("fth-zap", '\ue11a'),
    ZAP_OFF("fth-zap-off", '\ue11b'),
    ZOOM_IN("fth-zoom-in", '\ue11c'),
    ZOOM_OUT("fth-zoom-out", '\ue11d');

    public static Feather findByDescription(String description) {
        for (Feather font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    Feather(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}
