/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2019 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.feather;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum Feather implements Ikon {
    // latest is e129
    FTH_AIR_PLAY("fth-air-play", '\ue016'),
    FTH_ALIGN_CENTER("fth-align-center", '\ue028'),
    FTH_ALIGN_JUSTIFY("fth-align-justify", '\ue026'),
    FTH_ALIGN_LEFT("fth-align-left", '\ue027'),
    FTH_ALIGN_RIGHT("fth-align-right", '\ue029'),
    FTH_ALT("fth-alt", '\ue088'),
    FTH_ANCHOR("fth-anchor", '\ue077'),
    FTH_ARCHIVE("fth-archive", '\ue121'),
    FTH_ARROW_DOWN("fth-arrow-down", '\ue097'),
    FTH_ARROW_LEFT("fth-arrow-left", '\ue094'),
    FTH_ARROW_RIGHT("fth-arrow-right", '\ue095'),
    FTH_ARROW_UP("fth-arrow-up", '\ue096'),
    FTH_BAG("fth-bag", '\ue106'),
    FTH_BAN("fth-ban", '\ue107'),
    FTH_BAR_GRAPH("fth-bar-graph", '\ue090'),
    FTH_BAR_GRAPH_2("fth-bar-graph-2", '\ue091'),
    FTH_BATTERY("fth-battery", '\ue073'),
    FTH_BELL("fth-bell", '\ue006'),
    FTH_BOOK("fth-book", '\ue030'),
    FTH_BOX("fth-box", '\ue079'),
    FTH_BRIEFCASE("fth-briefcase", '\ue075'),
    FTH_CAMERA("fth-camera", '\ue017'),
    FTH_CHECK("fth-check", '\ue116'),
    FTH_CIRCLE_CHECK("fth-circle-check", '\ue042'),
    FTH_CIRCLE_CROSS("fth-circle-cross", '\ue043'),
    FTH_CIRCLE_MINUS("fth-circle-minus", '\ue041'),
    FTH_CIRCLE_PLUS("fth-circle-plus", '\ue040'),
    FTH_CLIPBOARD("fth-clipboard", '\ue013'),
    FTH_CLOCK("fth-clock", '\ue014'),
    FTH_CLOUD("fth-cloud", '\ue065'),
    FTH_CLOUD_DOWNLOAD("fth-cloud-download", '\ue067'),
    FTH_CLOUD_UPLOAD("fth-cloud-upload", '\ue066'),
    FTH_COG("fth-cog", '\ue023'),
    FTH_COLUMNS("fth-columns", '\ue104'),
    FTH_COMMAND("fth-command", '\ue087'),
    FTH_CONTENT_LEFT("fth-content-left", '\ue101'),
    FTH_CONTENT_RIGHT("fth-content-right", '\ue100'),
    FTH_CONTRACT("fth-contract", '\ue111'),
    FTH_CROSS("fth-cross", '\ue117'),
    FTH_DELETE("fth-delete", '\ue119'),
    FTH_DISC("fth-disc", '\ue019'),
    FTH_DOWNLOAD("fth-download", '\ue069'),
    FTH_DROP("fth-drop", '\ue063'),
    FTH_ELLIPSIS("fth-ellipsis", '\ue129'),
    FTH_ESC("fth-esc", '\ue089'),
    FTH_EXPAND("fth-expand", '\ue110'),
    FTH_EYE("fth-eye", '\ue000'),
    FTH_FAST_FORWARD("fth-fast-forward", '\ue055'),
    FTH_FILE("fth-file", '\ue124'),
    FTH_FILE_ADD("fth-file-add", '\ue125'),
    FTH_FILE_SUBTRACT("fth-file-subtract", '\ue126'),
    FTH_FLAG("fth-flag", '\ue108'),
    FTH_FOLDER("fth-folder", '\ue059'),
    FTH_GLOBE("fth-globe", '\ue078'),
    FTH_GRID("fth-grid", '\ue102'),
    FTH_GRID_2("fth-grid-2", '\ue103'),
    FTH_HEAD("fth-head", '\ue074'),
    FTH_HEART("fth-heart", '\ue024'),
    FTH_HELP("fth-help", '\ue127'),
    FTH_IMAGE("fth-image", '\ue010'),
    FTH_INBOX("fth-inbox", '\ue122'),
    FTH_LAYERS("fth-layers", '\ue031'),
    FTH_LAYOUT("fth-layout", '\ue004'),
    FTH_LINK("fth-link", '\ue005'),
    FTH_LOADER("fth-loader", '\ue105'),
    FTH_LOCATION("fth-location", '\ue070'),
    FTH_LOCATION_2("fth-location-2", '\ue071'),
    FTH_LOCK("fth-lock", '\ue007'),
    FTH_MAIL("fth-mail", '\ue002'),
    FTH_MAP("fth-map", '\ue072'),
    FTH_MARQUEE("fth-marquee", '\ue082'),
    FTH_MARQUEE_MINUS("fth-marquee-minus", '\ue084'),
    FTH_MARQUEE_PLUS("fth-marquee-plus", '\ue083'),
    FTH_MAXIMIZE("fth-maximize", '\ue112'),
    FTH_MENU("fth-menu", '\ue120'),
    FTH_MICROPHONE("fth-microphone", '\ue048'),
    FTH_MINIMIZE("fth-minimize", '\ue113'),
    FTH_MINUS("fth-minus", '\ue115'),
    FTH_MONITOR("fth-monitor", '\ue021'),
    FTH_MOON("fth-moon", '\ue061'),
    FTH_MOVE("fth-move", '\ue118'),
    FTH_MUTE("fth-mute", '\ue099'),
    FTH_OPEN("fth-open", '\ue128'),
    FTH_OUTBOX("fth-outbox", '\ue123'),
    FTH_PAPER("fth-paper", '\ue034'),
    FTH_PAPER_CLIP("fth-paper-clip", '\ue001'),
    FTH_PAPER_STACK("fth-paper-stack", '\ue035'),
    FTH_PARAGRAPH("fth-paragraph", '\ue025'),
    FTH_PAUSE("fth-pause", '\ue053'),
    FTH_PIE_GRAPH("fth-pie-graph", '\ue092'),
    FTH_PLAY("fth-play", '\ue052'),
    FTH_PLUS("fth-plus", '\ue114'),
    FTH_POWER("fth-power", '\ue086'),
    FTH_PRINTER("fth-printer", '\ue020'),
    FTH_RECORD("fth-record", '\ue049'),
    FTH_RELOAD("fth-reload", '\ue080'),
    FTH_REPEAT("fth-repeat", '\ue058'),
    FTH_REPLY("fth-reply", '\ue039'),
    FTH_REWIND("fth-rewind", '\ue051'),
    FTH_RIBBON("fth-ribbon", '\ue009'),
    FTH_SEARCH("fth-search", '\ue036'),
    FTH_SERVER("fth-server", '\ue022'),
    FTH_SHARE("fth-share", '\ue081'),
    FTH_SHUFFLE("fth-shuffle", '\ue057'),
    FTH_SIGNAL("fth-signal", '\ue011'),
    FTH_SKIP_BACK("fth-skip-back", '\ue050'),
    FTH_SKIP_FORWARD("fth-skip-forward", '\ue056'),
    FTH_SPEECH_BUBBLE("fth-speech-bubble", '\ue076'),
    FTH_SQUARE_CHECK("fth-square-check", '\ue046'),
    FTH_SQUARE_CROSS("fth-square-cross", '\ue047'),
    FTH_SQUARE_MINUS("fth-square-minus", '\ue045'),
    FTH_SQUARE_PLUS("fth-square-plus", '\ue044'),
    FTH_STACK("fth-stack", '\ue032'),
    FTH_STACK_2("fth-stack-2", '\ue033'),
    FTH_STAR("fth-star", '\ue093'),
    FTH_STOP("fth-stop", '\ue054'),
    FTH_SUN("fth-sun", '\ue064'),
    FTH_TAG("fth-tag", '\ue085'),
    FTH_TARGET("fth-target", '\ue012'),
    FTH_THERMOMETER("fth-thermometer", '\ue062'),
    FTH_TOGGLE("fth-toggle", '\ue003'),
    FTH_TRASH("fth-trash", '\ue109'),
    FTH_UMBRELLA("fth-umbrella", '\ue060'),
    FTH_UNLOCK("fth-unlock", '\ue008'),
    FTH_UPLOAD("fth-upload", '\ue068'),
    FTH_VIDEO("fth-video", '\ue018'),
    FTH_VOLUME("fth-volume", '\ue098'),
    FTH_WATCH("fth-watch", '\ue015'),
    FTH_ZOOM_IN("fth-zoom-in", '\ue037'),
    FTH_ZOOM_OUT("fth-zoom-out", '\ue038');

    public static Feather findByDescription(String description) {
        for (Feather font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private char code;

    Feather(String description, char code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public char getCode() {
        return code;
    }
}