/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.boxicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum BoxiconsSolid implements Ikon {
    ADD_TO_QUEUE("bxs-add-to-queue", '\uebee'),
    ADJUST("bxs-adjust", '\uebef'),
    ADJUST_ALT("bxs-adjust-alt", '\uebf0'),
    ALARM("bxs-alarm", '\uebf1'),
    ALARM_ADD("bxs-alarm-add", '\uebf2'),
    ALARM_EXCLAMATION("bxs-alarm-exclamation", '\uebf3'),
    ALARM_OFF("bxs-alarm-off", '\uebf4'),
    ALARM_SNOOZE("bxs-alarm-snooze", '\uebf5'),
    ALBUM("bxs-album", '\uebf6'),
    AMBULANCE("bxs-ambulance", '\uebf7'),
    ANALYSE("bxs-analyse", '\uebf8'),
    ANGRY("bxs-angry", '\uebf9'),
    ARCH("bxs-arch", '\uebfa'),
    ARCHIVE("bxs-archive", '\uebfb'),
    ARCHIVE_IN("bxs-archive-in", '\uebfc'),
    ARCHIVE_OUT("bxs-archive-out", '\uebfd'),
    AREA("bxs-area", '\uebfe'),
    ARROW_FROM_BOTTOM("bxs-arrow-from-bottom", '\uebff'),
    ARROW_FROM_LEFT("bxs-arrow-from-left", '\uec00'),
    ARROW_FROM_RIGHT("bxs-arrow-from-right", '\uec01'),
    ARROW_FROM_TOP("bxs-arrow-from-top", '\uec02'),
    ARROW_TO_BOTTOM("bxs-arrow-to-bottom", '\uec03'),
    ARROW_TO_LEFT("bxs-arrow-to-left", '\uec04'),
    ARROW_TO_RIGHT("bxs-arrow-to-right", '\uec05'),
    ARROW_TO_TOP("bxs-arrow-to-top", '\uec06'),
    AWARD("bxs-award", '\uec07'),
    BABY_CARRIAGE("bxs-baby-carriage", '\uec08'),
    BACKPACK("bxs-backpack", '\uec09'),
    BADGE("bxs-badge", '\uec0a'),
    BADGE_CHECK("bxs-badge-check", '\uec0b'),
    BADGE_DOLLAR("bxs-badge-dollar", '\uec0c'),
    BALL("bxs-ball", '\uec0d'),
    BAND_AID("bxs-band-aid", '\uec0e'),
    BANK("bxs-bank", '\uec0f'),
    BARCODE("bxs-barcode", '\uec12'),
    BAR_CHART_ALT_2("bxs-bar-chart-alt-2", '\uec10'),
    BAR_CHART_SQUARE("bxs-bar-chart-square", '\uec11'),
    BASEBALL("bxs-baseball", '\uec13'),
    BASKET("bxs-basket", '\uec14'),
    BASKETBALL("bxs-basketball", '\uec15'),
    BATH("bxs-bath", '\uec16'),
    BATTERY("bxs-battery", '\uec17'),
    BATTERY_CHARGING("bxs-battery-charging", '\uec18'),
    BATTERY_FULL("bxs-battery-full", '\uec19'),
    BATTERY_LOW("bxs-battery-low", '\uec1a'),
    BED("bxs-bed", '\uec1b'),
    BEEN_HERE("bxs-been-here", '\uec1c'),
    BEER("bxs-beer", '\uec1d'),
    BELL("bxs-bell", '\uec1e'),
    BELL_MINUS("bxs-bell-minus", '\uec1f'),
    BELL_OFF("bxs-bell-off", '\uec20'),
    BELL_PLUS("bxs-bell-plus", '\uec21'),
    BELL_RING("bxs-bell-ring", '\uec22'),
    BIBLE("bxs-bible", '\uec23'),
    BINOCULARS("bxs-binoculars", '\uec24'),
    BLANKET("bxs-blanket", '\uec25'),
    BOLT("bxs-bolt", '\uec26'),
    BOLT_CIRCLE("bxs-bolt-circle", '\uec27'),
    BOMB("bxs-bomb", '\uec28'),
    BONE("bxs-bone", '\uec29'),
    BONG("bxs-bong", '\uec2a'),
    BOOK("bxs-book", '\uec2b'),
    BOOKMARK("bxs-bookmark", '\uec31'),
    BOOKMARKS("bxs-bookmarks", '\uec38'),
    BOOKMARK_ALT("bxs-bookmark-alt", '\uec32'),
    BOOKMARK_ALT_MINUS("bxs-bookmark-alt-minus", '\uec33'),
    BOOKMARK_ALT_PLUS("bxs-bookmark-alt-plus", '\uec34'),
    BOOKMARK_HEART("bxs-bookmark-heart", '\uec35'),
    BOOKMARK_MINUS("bxs-bookmark-minus", '\uec36'),
    BOOKMARK_PLUS("bxs-bookmark-plus", '\uec37'),
    BOOKMARK_STAR("bxs-bookmark-star", '\uec39'),
    BOOK_ADD("bxs-book-add", '\uec2c'),
    BOOK_ALT("bxs-book-alt", '\uec2d'),
    BOOK_BOOKMARK("bxs-book-bookmark", '\uec2e'),
    BOOK_CONTENT("bxs-book-content", '\uec2f'),
    BOOK_HEART("bxs-book-heart", '\uec30'),
    BOOK_OPEN("bxs-book-open", '\uec3a'),
    BOOK_READER("bxs-book-reader", '\uec3b'),
    BOT("bxs-bot", '\uec3c'),
    BOWLING_BALL("bxs-bowling-ball", '\uec3d'),
    BOX("bxs-box", '\uec3e'),
    BRAIN("bxs-brain", '\uec3f'),
    BRIEFCASE("bxs-briefcase", '\uec40'),
    BRIEFCASE_ALT("bxs-briefcase-alt", '\uec41'),
    BRIEFCASE_ALT_2("bxs-briefcase-alt-2", '\uec42'),
    BRIGHTNESS("bxs-brightness", '\uec43'),
    BRIGHTNESS_HALF("bxs-brightness-half", '\uec44'),
    BRUSH("bxs-brush", '\uec45'),
    BRUSH_ALT("bxs-brush-alt", '\uec46'),
    BUG("bxs-bug", '\uec47'),
    BUG_ALT("bxs-bug-alt", '\uec48'),
    BUILDING("bxs-building", '\uec49'),
    BUILDINGS("bxs-buildings", '\uec4b'),
    BUILDING_HOUSE("bxs-building-house", '\uec4a'),
    BULB("bxs-bulb", '\uec4c'),
    BULLSEYE("bxs-bullseye", '\uec4d'),
    BUOY("bxs-buoy", '\uec4e'),
    BUS("bxs-bus", '\uec4f'),
    BUSINESS("bxs-business", '\uec50'),
    BUS_SCHOOL("bxs-bus-school", '\uec51'),
    CABINET("bxs-cabinet", '\uec52'),
    CAKE("bxs-cake", '\uec53'),
    CALCULATOR("bxs-calculator", '\uec54'),
    CALENDAR("bxs-calendar", '\uec55'),
    CALENDAR_ALT("bxs-calendar-alt", '\uec56'),
    CALENDAR_CHECK("bxs-calendar-check", '\uec57'),
    CALENDAR_EDIT("bxs-calendar-edit", '\uec58'),
    CALENDAR_EVENT("bxs-calendar-event", '\uec59'),
    CALENDAR_EXCLAMATION("bxs-calendar-exclamation", '\uec5a'),
    CALENDAR_HEART("bxs-calendar-heart", '\uec5b'),
    CALENDAR_MINUS("bxs-calendar-minus", '\uec5c'),
    CALENDAR_PLUS("bxs-calendar-plus", '\uec5d'),
    CALENDAR_STAR("bxs-calendar-star", '\uec5e'),
    CALENDAR_WEEK("bxs-calendar-week", '\uec5f'),
    CALENDAR_X("bxs-calendar-x", '\uec60'),
    CAMERA("bxs-camera", '\uec61'),
    CAMERA_HOME("bxs-camera-home", '\uec62'),
    CAMERA_MOVIE("bxs-camera-movie", '\uec63'),
    CAMERA_OFF("bxs-camera-off", '\uec64'),
    CAMERA_PLUS("bxs-camera-plus", '\uec65'),
    CAPSULE("bxs-capsule", '\uec66'),
    CAPTIONS("bxs-captions", '\uec67'),
    CAR("bxs-car", '\uec68'),
    CARD("bxs-card", '\uec6b'),
    CARET_DOWN_CIRCLE("bxs-caret-down-circle", '\uec6c'),
    CARET_DOWN_SQUARE("bxs-caret-down-square", '\uec6d'),
    CARET_LEFT_CIRCLE("bxs-caret-left-circle", '\uec6e'),
    CARET_LEFT_SQUARE("bxs-caret-left-square", '\uec6f'),
    CARET_RIGHT_CIRCLE("bxs-caret-right-circle", '\uec70'),
    CARET_RIGHT_SQUARE("bxs-caret-right-square", '\uec71'),
    CARET_UP_CIRCLE("bxs-caret-up-circle", '\uec72'),
    CARET_UP_SQUARE("bxs-caret-up-square", '\uec73'),
    CAROUSEL("bxs-carousel", '\uec76'),
    CART("bxs-cart", '\uec77'),
    CART_ADD("bxs-cart-add", '\uec78'),
    CART_ALT("bxs-cart-alt", '\uec79'),
    CART_DOWNLOAD("bxs-cart-download", '\uec7a'),
    CAR_BATTERY("bxs-car-battery", '\uec69'),
    CAR_CRASH("bxs-car-crash", '\uec6a'),
    CAR_GARAGE("bxs-car-garage", '\uec74'),
    CAR_MECHANIC("bxs-car-mechanic", '\uec75'),
    CAR_WASH("bxs-car-wash", '\uec7b'),
    CATEGORY("bxs-category", '\uec7c'),
    CATEGORY_ALT("bxs-category-alt", '\uec7d'),
    CCTV("bxs-cctv", '\uec7e'),
    CERTIFICATION("bxs-certification", '\uec7f'),
    CHALKBOARD("bxs-chalkboard", '\uec80'),
    CHART("bxs-chart", '\uec81'),
    CHAT("bxs-chat", '\uec82'),
    CHECKBOX("bxs-checkbox", '\uec83'),
    CHECKBOX_CHECKED("bxs-checkbox-checked", '\uec84'),
    CHECK_CIRCLE("bxs-check-circle", '\uec85'),
    CHECK_SHIELD("bxs-check-shield", '\uec86'),
    CHECK_SQUARE("bxs-check-square", '\uec87'),
    CHESS("bxs-chess", '\uec88'),
    CHEVRONS_DOWN("bxs-chevrons-down", '\uec92'),
    CHEVRONS_LEFT("bxs-chevrons-left", '\uec93'),
    CHEVRONS_RIGHT("bxs-chevrons-right", '\uec94'),
    CHEVRONS_UP("bxs-chevrons-up", '\uec95'),
    CHEVRON_DOWN("bxs-chevron-down", '\uec89'),
    CHEVRON_DOWN_CIRCLE("bxs-chevron-down-circle", '\uec8a'),
    CHEVRON_DOWN_SQUARE("bxs-chevron-down-square", '\uec8b'),
    CHEVRON_LEFT("bxs-chevron-left", '\uec8c'),
    CHEVRON_LEFT_CIRCLE("bxs-chevron-left-circle", '\uec8d'),
    CHEVRON_LEFT_SQUARE("bxs-chevron-left-square", '\uec8e'),
    CHEVRON_RIGHT("bxs-chevron-right", '\uec8f'),
    CHEVRON_RIGHT_CIRCLE("bxs-chevron-right-circle", '\uec90'),
    CHEVRON_RIGHT_SQUARE("bxs-chevron-right-square", '\uec91'),
    CHEVRON_UP("bxs-chevron-up", '\uec96'),
    CHEVRON_UP_CIRCLE("bxs-chevron-up-circle", '\uec97'),
    CHEVRON_UP_SQUARE("bxs-chevron-up-square", '\uec98'),
    CHIP("bxs-chip", '\uec99'),
    CHURCH("bxs-church", '\uec9a'),
    CIRCLE("bxs-circle", '\uec9b'),
    CITY("bxs-city", '\uec9c'),
    CLINIC("bxs-clinic", '\uec9d'),
    CLOUD("bxs-cloud", '\uec9e'),
    CLOUD_DOWNLOAD("bxs-cloud-download", '\uec9f'),
    CLOUD_LIGHTNING("bxs-cloud-lightning", '\ueca0'),
    CLOUD_RAIN("bxs-cloud-rain", '\ueca1'),
    CLOUD_UPLOAD("bxs-cloud-upload", '\ueca2'),
    COFFEE("bxs-coffee", '\ueca3'),
    COFFEE_ALT("bxs-coffee-alt", '\ueca4'),
    COFFEE_TOGO("bxs-coffee-togo", '\ueca5'),
    COG("bxs-cog", '\ueca6'),
    COIN("bxs-coin", '\ueca7'),
    COIN_STACK("bxs-coin-stack", '\ueca8'),
    COLLECTION("bxs-collection", '\ueca9'),
    COLOR_FILL("bxs-color-fill", '\uecaa'),
    COMMENT("bxs-comment", '\uecab'),
    COMMENT_ADD("bxs-comment-add", '\uecac'),
    COMMENT_CHECK("bxs-comment-check", '\uecad'),
    COMMENT_DETAIL("bxs-comment-detail", '\uecae'),
    COMMENT_DOTS("bxs-comment-dots", '\uecaf'),
    COMMENT_EDIT("bxs-comment-edit", '\uecb0'),
    COMMENT_ERROR("bxs-comment-error", '\uecb1'),
    COMMENT_MINUS("bxs-comment-minus", '\uecb2'),
    COMMENT_X("bxs-comment-x", '\uecb3'),
    COMPASS("bxs-compass", '\uecb4'),
    COMPONENT("bxs-component", '\uecb5'),
    CONFUSED("bxs-confused", '\uecb6'),
    CONTACT("bxs-contact", '\uecb7'),
    CONVERSATION("bxs-conversation", '\uecb8'),
    COOKIE("bxs-cookie", '\uecb9'),
    COOL("bxs-cool", '\uecba'),
    COPY("bxs-copy", '\uecbb'),
    COPYRIGHT("bxs-copyright", '\uecbd'),
    COPY_ALT("bxs-copy-alt", '\uecbc'),
    COUPON("bxs-coupon", '\uecbe'),
    CREDIT_CARD("bxs-credit-card", '\uecbf'),
    CREDIT_CARD_ALT("bxs-credit-card-alt", '\uecc0'),
    CREDIT_CARD_FRONT("bxs-credit-card-front", '\uecc1'),
    CROP("bxs-crop", '\uecc2'),
    CROWN("bxs-crown", '\uecc3'),
    CUBE("bxs-cube", '\uecc4'),
    CUBE_ALT("bxs-cube-alt", '\uecc5'),
    CUBOID("bxs-cuboid", '\uecc6'),
    CUSTOMIZE("bxs-customize", '\uecc7'),
    CYLINDER("bxs-cylinder", '\uecc8'),
    DASHBOARD("bxs-dashboard", '\uecc9'),
    DATA("bxs-data", '\uecca'),
    DETAIL("bxs-detail", '\ueccb'),
    DEVICES("bxs-devices", '\ueccc'),
    DIAMOND("bxs-diamond", '\ueccd'),
    DICE_1("bxs-dice-1", '\uecce'),
    DICE_2("bxs-dice-2", '\ueccf'),
    DICE_3("bxs-dice-3", '\uecd0'),
    DICE_4("bxs-dice-4", '\uecd1'),
    DICE_5("bxs-dice-5", '\uecd2'),
    DICE_6("bxs-dice-6", '\uecd3'),
    DIRECTIONS("bxs-directions", '\uecd6'),
    DIRECTION_LEFT("bxs-direction-left", '\uecd4'),
    DIRECTION_RIGHT("bxs-direction-right", '\uecd5'),
    DISC("bxs-disc", '\uecd7'),
    DISCOUNT("bxs-discount", '\uecd8'),
    DISH("bxs-dish", '\uecd9'),
    DISLIKE("bxs-dislike", '\uecda'),
    DIZZY("bxs-dizzy", '\uecdb'),
    DOCK_BOTTOM("bxs-dock-bottom", '\uecdc'),
    DOCK_LEFT("bxs-dock-left", '\uecdd'),
    DOCK_RIGHT("bxs-dock-right", '\uecde'),
    DOCK_TOP("bxs-dock-top", '\uecdf'),
    DOLLAR_CIRCLE("bxs-dollar-circle", '\uece0'),
    DONATE_BLOOD("bxs-donate-blood", '\uece1'),
    DONATE_HEART("bxs-donate-heart", '\uece2'),
    DOOR_OPEN("bxs-door-open", '\uece3'),
    DOUGHNUT_CHART("bxs-doughnut-chart", '\uece4'),
    DOWNLOAD("bxs-download", '\uece9'),
    DOWNVOTE("bxs-downvote", '\uecea'),
    DOWN_ARROW("bxs-down-arrow", '\uece5'),
    DOWN_ARROW_ALT("bxs-down-arrow-alt", '\uece6'),
    DOWN_ARROW_CIRCLE("bxs-down-arrow-circle", '\uece7'),
    DOWN_ARROW_SQUARE("bxs-down-arrow-square", '\uece8'),
    DRINK("bxs-drink", '\ueceb'),
    DROPLET("bxs-droplet", '\uecec'),
    DROPLET_HALF("bxs-droplet-half", '\ueced'),
    DRYER("bxs-dryer", '\uecee'),
    DUPLICATE("bxs-duplicate", '\uecef'),
    EDIT("bxs-edit", '\uecf0'),
    EDIT_ALT("bxs-edit-alt", '\uecf1'),
    EDIT_LOCATION("bxs-edit-location", '\uecf2'),
    EJECT("bxs-eject", '\uecf3'),
    ENVELOPE("bxs-envelope", '\uecf4'),
    ENVELOPE_OPEN("bxs-envelope-open", '\uecf5'),
    ERASER("bxs-eraser", '\uecf6'),
    ERROR("bxs-error", '\uecf7'),
    ERROR_ALT("bxs-error-alt", '\uecf8'),
    ERROR_CIRCLE("bxs-error-circle", '\uecf9'),
    EV_STATION("bxs-ev-station", '\uecfa'),
    EXIT("bxs-exit", '\uecfb'),
    EXTENSION("bxs-extension", '\uecfc'),
    EYEDROPPER("bxs-eyedropper", '\uecfd'),
    FACE("bxs-face", '\uecfe'),
    FACE_MASK("bxs-face-mask", '\uecff'),
    FACTORY("bxs-factory", '\ued00'),
    FAST_FORWARD_CIRCLE("bxs-fast-forward-circle", '\ued01'),
    FILE("bxs-file", '\ued02'),
    FILE_ARCHIVE("bxs-file-archive", '\ued03'),
    FILE_BLANK("bxs-file-blank", '\ued04'),
    FILE_CSS("bxs-file-css", '\ued05'),
    FILE_DOC("bxs-file-doc", '\ued06'),
    FILE_EXPORT("bxs-file-export", '\ued07'),
    FILE_FIND("bxs-file-find", '\ued08'),
    FILE_GIF("bxs-file-gif", '\ued09'),
    FILE_HTML("bxs-file-html", '\ued0a'),
    FILE_IMAGE("bxs-file-image", '\ued0b'),
    FILE_IMPORT("bxs-file-import", '\ued0c'),
    FILE_JPG("bxs-file-jpg", '\ued0d'),
    FILE_JS("bxs-file-js", '\ued0e'),
    FILE_JSON("bxs-file-json", '\ued0f'),
    FILE_MD("bxs-file-md", '\ued10'),
    FILE_PDF("bxs-file-pdf", '\ued11'),
    FILE_PLUS("bxs-file-plus", '\ued12'),
    FILE_PNG("bxs-file-png", '\ued13'),
    FILE_TXT("bxs-file-txt", '\ued14'),
    FILM("bxs-film", '\ued15'),
    FILTER_ALT("bxs-filter-alt", '\ued16'),
    FIRST_AID("bxs-first-aid", '\ued17'),
    FLAG("bxs-flag", '\ued18'),
    FLAG_ALT("bxs-flag-alt", '\ued19'),
    FLAG_CHECKERED("bxs-flag-checkered", '\ued1a'),
    FLAME("bxs-flame", '\ued1b'),
    FLASK("bxs-flask", '\ued1c'),
    FLORIST("bxs-florist", '\ued1d'),
    FOLDER("bxs-folder", '\ued1e'),
    FOLDER_MINUS("bxs-folder-minus", '\ued1f'),
    FOLDER_OPEN("bxs-folder-open", '\ued20'),
    FOLDER_PLUS("bxs-folder-plus", '\ued21'),
    FOOD_MENU("bxs-food-menu", '\ued22'),
    FRIDGE("bxs-fridge", '\ued23'),
    GAME("bxs-game", '\ued24'),
    GAS_PUMP("bxs-gas-pump", '\ued25'),
    GHOST("bxs-ghost", '\ued26'),
    GIFT("bxs-gift", '\ued27'),
    GRADUATION("bxs-graduation", '\ued28'),
    GRID("bxs-grid", '\ued29'),
    GRID_ALT("bxs-grid-alt", '\ued2a'),
    GROUP("bxs-group", '\ued2b'),
    GUITAR_AMP("bxs-guitar-amp", '\ued2c'),
    HAND_DOWN("bxs-hand-down", '\ued2d'),
    HAND_LEFT("bxs-hand-left", '\ued2e'),
    HAND_RIGHT("bxs-hand-right", '\ued2f'),
    HAND_UP("bxs-hand-up", '\ued30'),
    HAPPY("bxs-happy", '\ued31'),
    HAPPY_ALT("bxs-happy-alt", '\ued32'),
    HAPPY_BEAMING("bxs-happy-beaming", '\ued33'),
    HAPPY_HEART_EYES("bxs-happy-heart-eyes", '\ued34'),
    HDD("bxs-hdd", '\ued35'),
    HEART("bxs-heart", '\ued36'),
    HEART_CIRCLE("bxs-heart-circle", '\ued37'),
    HEART_SQUARE("bxs-heart-square", '\ued38'),
    HELP_CIRCLE("bxs-help-circle", '\ued39'),
    HIDE("bxs-hide", '\ued3a'),
    HOME("bxs-home", '\ued3b'),
    HOME_CIRCLE("bxs-home-circle", '\ued3c'),
    HOME_HEART("bxs-home-heart", '\ued3d'),
    HOME_SMILE("bxs-home-smile", '\ued3e'),
    HOT("bxs-hot", '\ued3f'),
    HOTEL("bxs-hotel", '\ued40'),
    HOURGLASS("bxs-hourglass", '\ued41'),
    HOURGLASS_BOTTOM("bxs-hourglass-bottom", '\ued42'),
    HOURGLASS_TOP("bxs-hourglass-top", '\ued43'),
    ID_CARD("bxs-id-card", '\ued44'),
    IMAGE("bxs-image", '\ued45'),
    IMAGE_ADD("bxs-image-add", '\ued46'),
    IMAGE_ALT("bxs-image-alt", '\ued47'),
    INBOX("bxs-inbox", '\ued48'),
    INFO_CIRCLE("bxs-info-circle", '\ued49'),
    INFO_SQUARE("bxs-info-square", '\ued4a'),
    INSTITUTION("bxs-institution", '\ued4b'),
    JOYSTICK("bxs-joystick", '\ued4c'),
    JOYSTICK_ALT("bxs-joystick-alt", '\ued4d'),
    JOYSTICK_BUTTON("bxs-joystick-button", '\ued4e'),
    KEY("bxs-key", '\ued4f'),
    KEYBOARD("bxs-keyboard", '\ued50'),
    LABEL("bxs-label", '\ued51'),
    LANDMARK("bxs-landmark", '\ued52'),
    LANDSCAPE("bxs-landscape", '\ued53'),
    LAUGH("bxs-laugh", '\ued54'),
    LAYER("bxs-layer", '\ued55'),
    LAYER_MINUS("bxs-layer-minus", '\ued56'),
    LAYER_PLUS("bxs-layer-plus", '\ued57'),
    LAYOUT("bxs-layout", '\ued58'),
    LEFT_ARROW("bxs-left-arrow", '\ued59'),
    LEFT_ARROW_ALT("bxs-left-arrow-alt", '\ued5a'),
    LEFT_ARROW_CIRCLE("bxs-left-arrow-circle", '\ued5b'),
    LEFT_ARROW_SQUARE("bxs-left-arrow-square", '\ued5c'),
    LEFT_DOWN_ARROW_CIRCLE("bxs-left-down-arrow-circle", '\ued5d'),
    LEFT_TOP_ARROW_CIRCLE("bxs-left-top-arrow-circle", '\ued5e'),
    LIKE("bxs-like", '\ued5f'),
    LOCATION_PLUS("bxs-location-plus", '\ued60'),
    LOCK("bxs-lock", '\ued61'),
    LOCK_ALT("bxs-lock-alt", '\ued62'),
    LOCK_OPEN("bxs-lock-open", '\ued63'),
    LOCK_OPEN_ALT("bxs-lock-open-alt", '\ued64'),
    LOG_IN("bxs-log-in", '\ued65'),
    LOG_IN_CIRCLE("bxs-log-in-circle", '\ued66'),
    LOG_OUT("bxs-log-out", '\ued67'),
    LOG_OUT_CIRCLE("bxs-log-out-circle", '\ued68'),
    LOW_VISION("bxs-low-vision", '\ued69'),
    MAGIC_WAND("bxs-magic-wand", '\ued6a'),
    MAGNET("bxs-magnet", '\ued6b'),
    MAP("bxs-map", '\ued6c'),
    MAP_ALT("bxs-map-alt", '\ued6d'),
    MAP_PIN("bxs-map-pin", '\ued6e'),
    MASK("bxs-mask", '\ued6f'),
    MEDAL("bxs-medal", '\ued70'),
    MEGAPHONE("bxs-megaphone", '\ued71'),
    MEH("bxs-meh", '\ued72'),
    MEH_ALT("bxs-meh-alt", '\ued73'),
    MEH_BLANK("bxs-meh-blank", '\ued74'),
    MEMORY_CARD("bxs-memory-card", '\ued75'),
    MESSAGE("bxs-message", '\ued76'),
    MESSAGE_ADD("bxs-message-add", '\ued77'),
    MESSAGE_ALT("bxs-message-alt", '\ued78'),
    MESSAGE_ALT_ADD("bxs-message-alt-add", '\ued79'),
    MESSAGE_ALT_CHECK("bxs-message-alt-check", '\ued7a'),
    MESSAGE_ALT_DETAIL("bxs-message-alt-detail", '\ued7b'),
    MESSAGE_ALT_DOTS("bxs-message-alt-dots", '\ued7c'),
    MESSAGE_ALT_EDIT("bxs-message-alt-edit", '\ued7d'),
    MESSAGE_ALT_ERROR("bxs-message-alt-error", '\ued7e'),
    MESSAGE_ALT_MINUS("bxs-message-alt-minus", '\ued7f'),
    MESSAGE_ALT_X("bxs-message-alt-x", '\ued80'),
    MESSAGE_CHECK("bxs-message-check", '\ued81'),
    MESSAGE_DETAIL("bxs-message-detail", '\ued82'),
    MESSAGE_DOTS("bxs-message-dots", '\ued83'),
    MESSAGE_EDIT("bxs-message-edit", '\ued84'),
    MESSAGE_ERROR("bxs-message-error", '\ued85'),
    MESSAGE_MINUS("bxs-message-minus", '\ued86'),
    MESSAGE_ROUNDED("bxs-message-rounded", '\ued87'),
    MESSAGE_ROUNDED_ADD("bxs-message-rounded-add", '\ued88'),
    MESSAGE_ROUNDED_CHECK("bxs-message-rounded-check", '\ued89'),
    MESSAGE_ROUNDED_DETAIL("bxs-message-rounded-detail", '\ued8a'),
    MESSAGE_ROUNDED_DOTS("bxs-message-rounded-dots", '\ued8b'),
    MESSAGE_ROUNDED_EDIT("bxs-message-rounded-edit", '\ued8c'),
    MESSAGE_ROUNDED_ERROR("bxs-message-rounded-error", '\ued8d'),
    MESSAGE_ROUNDED_MINUS("bxs-message-rounded-minus", '\ued8e'),
    MESSAGE_ROUNDED_X("bxs-message-rounded-x", '\ued8f'),
    MESSAGE_SQUARE("bxs-message-square", '\ued90'),
    MESSAGE_SQUARE_ADD("bxs-message-square-add", '\ued91'),
    MESSAGE_SQUARE_CHECK("bxs-message-square-check", '\ued92'),
    MESSAGE_SQUARE_DETAIL("bxs-message-square-detail", '\ued93'),
    MESSAGE_SQUARE_DOTS("bxs-message-square-dots", '\ued94'),
    MESSAGE_SQUARE_EDIT("bxs-message-square-edit", '\ued95'),
    MESSAGE_SQUARE_ERROR("bxs-message-square-error", '\ued96'),
    MESSAGE_SQUARE_MINUS("bxs-message-square-minus", '\ued97'),
    MESSAGE_SQUARE_X("bxs-message-square-x", '\ued98'),
    MESSAGE_X("bxs-message-x", '\ued99'),
    METEOR("bxs-meteor", '\ued9a'),
    MICROCHIP("bxs-microchip", '\ued9b'),
    MICROPHONE("bxs-microphone", '\ued9c'),
    MICROPHONE_ALT("bxs-microphone-alt", '\ued9d'),
    MICROPHONE_OFF("bxs-microphone-off", '\ued9e'),
    MINUS_CIRCLE("bxs-minus-circle", '\ued9f'),
    MINUS_SQUARE("bxs-minus-square", '\ueda0'),
    MOBILE("bxs-mobile", '\ueda1'),
    MOBILE_VIBRATION("bxs-mobile-vibration", '\ueda2'),
    MOON("bxs-moon", '\ueda3'),
    MOUSE("bxs-mouse", '\ueda4'),
    MOUSE_ALT("bxs-mouse-alt", '\ueda5'),
    MOVIE("bxs-movie", '\ueda6'),
    MOVIE_PLAY("bxs-movie-play", '\ueda7'),
    MUSIC("bxs-music", '\ueda8'),
    NAVIGATION("bxs-navigation", '\ueda9'),
    NETWORK_CHART("bxs-network-chart", '\uedaa'),
    NEWS("bxs-news", '\uedab'),
    NOTE("bxs-note", '\uedad'),
    NOTEPAD("bxs-notepad", '\uedae'),
    NOTIFICATION("bxs-notification", '\uedaf'),
    NOTIFICATION_OFF("bxs-notification-off", '\uedb0'),
    NO_ENTRY("bxs-no-entry", '\uedac'),
    OFFER("bxs-offer", '\uedb1'),
    PACKAGE("bxs-package", '\uedb2'),
    PAINT("bxs-paint", '\uedb3'),
    PAINT_ROLL("bxs-paint-roll", '\uedb4'),
    PALETTE("bxs-palette", '\uedb5'),
    PAPER_PLANE("bxs-paper-plane", '\uedb6'),
    PARKING("bxs-parking", '\uedb7'),
    PASTE("bxs-paste", '\uedb8'),
    PEN("bxs-pen", '\uedb9'),
    PENCIL("bxs-pencil", '\uedba'),
    PHONE("bxs-phone", '\uedbb'),
    PHONE_CALL("bxs-phone-call", '\uedbc'),
    PHONE_INCOMING("bxs-phone-incoming", '\uedbd'),
    PHONE_OUTGOING("bxs-phone-outgoing", '\uedbe'),
    PHOTO_ALBUM("bxs-photo-album", '\uedbf'),
    PIANO("bxs-piano", '\uedc0'),
    PIE_CHART("bxs-pie-chart", '\uedc1'),
    PIE_CHART_ALT("bxs-pie-chart-alt", '\uedc2'),
    PIE_CHART_ALT_2("bxs-pie-chart-alt-2", '\uedc3'),
    PIN("bxs-pin", '\uedc4'),
    PIZZA("bxs-pizza", '\uedc5'),
    PLANE("bxs-plane", '\uedc6'),
    PLANET("bxs-planet", '\uedc9'),
    PLANE_ALT("bxs-plane-alt", '\uedc7'),
    PLANE_LAND("bxs-plane-land", '\uedc8'),
    PLANE_TAKE_OFF("bxs-plane-take-off", '\uedca'),
    PLAYLIST("bxs-playlist", '\uedcb'),
    PLUG("bxs-plug", '\uedcc'),
    PLUS_CIRCLE("bxs-plus-circle", '\uedcd'),
    PLUS_SQUARE("bxs-plus-square", '\uedce'),
    POINTER("bxs-pointer", '\uedcf'),
    POLYGON("bxs-polygon", '\uedd0'),
    PRINTER("bxs-printer", '\uedd1'),
    PURCHASE_TAG("bxs-purchase-tag", '\uedd2'),
    PURCHASE_TAG_ALT("bxs-purchase-tag-alt", '\uedd3'),
    PYRAMID("bxs-pyramid", '\uedd4'),
    QUOTE_ALT_LEFT("bxs-quote-alt-left", '\uedd5'),
    QUOTE_ALT_RIGHT("bxs-quote-alt-right", '\uedd6'),
    QUOTE_LEFT("bxs-quote-left", '\uedd7'),
    QUOTE_RIGHT("bxs-quote-right", '\uedd8'),
    QUOTE_SINGLE_LEFT("bxs-quote-single-left", '\uedd9'),
    QUOTE_SINGLE_RIGHT("bxs-quote-single-right", '\uedda'),
    RADIATION("bxs-radiation", '\ueddb'),
    RADIO("bxs-radio", '\ueddc'),
    RECEIPT("bxs-receipt", '\ueddd'),
    RECTANGLE("bxs-rectangle", '\uedde'),
    RENAME("bxs-rename", '\ueddf'),
    REPORT("bxs-report", '\uede0'),
    REWIND_CIRCLE("bxs-rewind-circle", '\uede1'),
    RIGHT_ARROW("bxs-right-arrow", '\uede2'),
    RIGHT_ARROW_ALT("bxs-right-arrow-alt", '\uede3'),
    RIGHT_ARROW_CIRCLE("bxs-right-arrow-circle", '\uede4'),
    RIGHT_ARROW_SQUARE("bxs-right-arrow-square", '\uede5'),
    RIGHT_DOWN_ARROW_CIRCLE("bxs-right-down-arrow-circle", '\uede6'),
    RIGHT_TOP_ARROW_CIRCLE("bxs-right-top-arrow-circle", '\uede7'),
    ROCKET("bxs-rocket", '\uede8'),
    RULER("bxs-ruler", '\uede9'),
    SAD("bxs-sad", '\uedea'),
    SAVE("bxs-save", '\uedeb'),
    SCHOOL("bxs-school", '\uedec'),
    SEARCH("bxs-search", '\ueded'),
    SEARCH_ALT_2("bxs-search-alt-2", '\uedee'),
    SELECT_MULTIPLE("bxs-select-multiple", '\uedef'),
    SEND("bxs-send", '\uedf0'),
    SERVER("bxs-server", '\uedf1'),
    SHAPES("bxs-shapes", '\uedf2'),
    SHARE("bxs-share", '\uedf3'),
    SHARE_ALT("bxs-share-alt", '\uedf4'),
    SHIELD("bxs-shield", '\uedf5'),
    SHIELD_ALT_2("bxs-shield-alt-2", '\uedf6'),
    SHIELD_X("bxs-shield-x", '\uedf7'),
    SHIP("bxs-ship", '\uedf8'),
    SHOCKED("bxs-shocked", '\uedf9'),
    SHOPPING_BAG("bxs-shopping-bag", '\uedfa'),
    SHOPPING_BAGS("bxs-shopping-bags", '\uedfc'),
    SHOPPING_BAG_ALT("bxs-shopping-bag-alt", '\uedfb'),
    SHOW("bxs-show", '\uedfd'),
    SKIP_NEXT_CIRCLE("bxs-skip-next-circle", '\uedfe'),
    SKIP_PREVIOUS_CIRCLE("bxs-skip-previous-circle", '\uedff'),
    SKULL("bxs-skull", '\uee00'),
    SLEEPY("bxs-sleepy", '\uee01'),
    SLIDESHOW("bxs-slideshow", '\uee02'),
    SMILE("bxs-smile", '\uee03'),
    SORT_ALT("bxs-sort-alt", '\uee04'),
    SPA("bxs-spa", '\uee05'),
    SPRAY_CAN("bxs-spray-can", '\uee06'),
    SPREADSHEET("bxs-spreadsheet", '\uee07'),
    SQUARE("bxs-square", '\uee08'),
    SQUARE_ROUNDED("bxs-square-rounded", '\uee09'),
    STAR("bxs-star", '\uee0a'),
    STAR_HALF("bxs-star-half", '\uee0b'),
    STICKER("bxs-sticker", '\uee0c'),
    STOPWATCH("bxs-stopwatch", '\uee0d'),
    STORE("bxs-store", '\uee0e'),
    STORE_ALT("bxs-store-alt", '\uee0f'),
    SUN("bxs-sun", '\uee10'),
    TACHOMETER("bxs-tachometer", '\uee11'),
    TAG("bxs-tag", '\uee12'),
    TAG_ALT("bxs-tag-alt", '\uee13'),
    TAG_X("bxs-tag-x", '\uee14'),
    TAXI("bxs-taxi", '\uee15'),
    TENNIS_BALL("bxs-tennis-ball", '\uee16'),
    TERMINAL("bxs-terminal", '\uee17'),
    THERMOMETER("bxs-thermometer", '\uee18'),
    TIME("bxs-time", '\uee19'),
    TIMER("bxs-timer", '\uee1b'),
    TIME_FIVE("bxs-time-five", '\uee1a'),
    TIRED("bxs-tired", '\uee1c'),
    TOGGLE_LEFT("bxs-toggle-left", '\uee1d'),
    TOGGLE_RIGHT("bxs-toggle-right", '\uee1e'),
    TONE("bxs-tone", '\uee1f'),
    TORCH("bxs-torch", '\uee20'),
    TO_TOP("bxs-to-top", '\uee21'),
    TRAFFIC("bxs-traffic", '\uee22'),
    TRAFFIC_BARRIER("bxs-traffic-barrier", '\uee23'),
    TRAFFIC_CONE("bxs-traffic-cone", '\uee24'),
    TRAIN("bxs-train", '\uee25'),
    TRASH("bxs-trash", '\uee26'),
    TRASH_ALT("bxs-trash-alt", '\uee27'),
    TREE("bxs-tree", '\uee28'),
    TROPHY("bxs-trophy", '\uee29'),
    TRUCK("bxs-truck", '\uee2a'),
    TV("bxs-tv", '\uee2c'),
    T_SHIRT("bxs-t-shirt", '\uee2b'),
    UPSIDE_DOWN("bxs-upside-down", '\uee31'),
    UPVOTE("bxs-upvote", '\uee32'),
    UP_ARROW("bxs-up-arrow", '\uee2d'),
    UP_ARROW_ALT("bxs-up-arrow-alt", '\uee2e'),
    UP_ARROW_CIRCLE("bxs-up-arrow-circle", '\uee2f'),
    UP_ARROW_SQUARE("bxs-up-arrow-square", '\uee30'),
    USER("bxs-user", '\uee33'),
    USER_ACCOUNT("bxs-user-account", '\uee34'),
    USER_BADGE("bxs-user-badge", '\uee35'),
    USER_CHECK("bxs-user-check", '\uee36'),
    USER_CIRCLE("bxs-user-circle", '\uee37'),
    USER_DETAIL("bxs-user-detail", '\uee38'),
    USER_MINUS("bxs-user-minus", '\uee39'),
    USER_PIN("bxs-user-pin", '\uee3a'),
    USER_PLUS("bxs-user-plus", '\uee3b'),
    USER_RECTANGLE("bxs-user-rectangle", '\uee3c'),
    USER_VOICE("bxs-user-voice", '\uee3d'),
    USER_X("bxs-user-x", '\uee3e'),
    VECTOR("bxs-vector", '\uee3f'),
    VIAL("bxs-vial", '\uee40'),
    VIDEO("bxs-video", '\uee41'),
    VIDEOS("bxs-videos", '\uee45'),
    VIDEO_OFF("bxs-video-off", '\uee42'),
    VIDEO_PLUS("bxs-video-plus", '\uee43'),
    VIDEO_RECORDING("bxs-video-recording", '\uee44'),
    VIRUS("bxs-virus", '\uee46'),
    VIRUS_BLOCK("bxs-virus-block", '\uee47'),
    VOLUME("bxs-volume", '\uee48'),
    VOLUME_FULL("bxs-volume-full", '\uee49'),
    VOLUME_LOW("bxs-volume-low", '\uee4a'),
    VOLUME_MUTE("bxs-volume-mute", '\uee4b'),
    WALLET("bxs-wallet", '\uee4c'),
    WALLET_ALT("bxs-wallet-alt", '\uee4d'),
    WASHER("bxs-washer", '\uee4e'),
    WATCH("bxs-watch", '\uee4f'),
    WATCH_ALT("bxs-watch-alt", '\uee50'),
    WEBCAM("bxs-webcam", '\uee51'),
    WIDGET("bxs-widget", '\uee52'),
    WINDOW_ALT("bxs-window-alt", '\uee53'),
    WINE("bxs-wine", '\uee54'),
    WINK_SMILE("bxs-wink-smile", '\uee55'),
    WINK_TONGUE("bxs-wink-tongue", '\uee56'),
    WRENCH("bxs-wrench", '\uee57'),
    X_CIRCLE("bxs-x-circle", '\uee58'),
    X_SQUARE("bxs-x-square", '\uee59'),
    YIN_YANG("bxs-yin-yang", '\uee5a'),
    ZAP("bxs-zap", '\uee5b'),
    ZOOM_IN("bxs-zoom-in", '\uee5c'),
    ZOOM_OUT("bxs-zoom-out", '\uee5d');

    public static BoxiconsSolid findByDescription(String description) {
        for (BoxiconsSolid font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    BoxiconsSolid(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}