/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.boxicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum BoxiconsRegular implements Ikon {
    ABACUS("bx-abacus", '\ue900'),
    ACCESSIBILITY("bx-accessibility", '\ue901'),
    ADD_TO_QUEUE("bx-add-to-queue", '\ue902'),
    ADJUST("bx-adjust", '\ue903'),
    ALARM("bx-alarm", '\ue904'),
    ALARM_ADD("bx-alarm-add", '\ue905'),
    ALARM_EXCLAMATION("bx-alarm-exclamation", '\ue906'),
    ALARM_OFF("bx-alarm-off", '\ue907'),
    ALARM_SNOOZE("bx-alarm-snooze", '\ue908'),
    ALBUM("bx-album", '\ue909'),
    ALIGN_JUSTIFY("bx-align-justify", '\ue90a'),
    ALIGN_LEFT("bx-align-left", '\ue90b'),
    ALIGN_MIDDLE("bx-align-middle", '\ue90c'),
    ALIGN_RIGHT("bx-align-right", '\ue90d'),
    ANALYSE("bx-analyse", '\ue90e'),
    ANCHOR("bx-anchor", '\ue90f'),
    ANGRY("bx-angry", '\ue910'),
    APERTURE("bx-aperture", '\ue911'),
    ARCH("bx-arch", '\ue912'),
    ARCHIVE("bx-archive", '\ue913'),
    ARCHIVE_IN("bx-archive-in", '\ue914'),
    ARCHIVE_OUT("bx-archive-out", '\ue915'),
    AREA("bx-area", '\ue916'),
    ARROW_BACK("bx-arrow-back", '\ue917'),
    ARROW_FROM_BOTTOM("bx-arrow-from-bottom", '\ue918'),
    ARROW_FROM_LEFT("bx-arrow-from-left", '\ue919'),
    ARROW_FROM_RIGHT("bx-arrow-from-right", '\ue91a'),
    ARROW_FROM_TOP("bx-arrow-from-top", '\ue91b'),
    ARROW_TO_BOTTOM("bx-arrow-to-bottom", '\ue91c'),
    ARROW_TO_LEFT("bx-arrow-to-left", '\ue91d'),
    ARROW_TO_RIGHT("bx-arrow-to-right", '\ue91e'),
    ARROW_TO_TOP("bx-arrow-to-top", '\ue91f'),
    AT("bx-at", '\ue920'),
    ATOM("bx-atom", '\ue921'),
    AWARD("bx-award", '\ue922'),
    BADGE("bx-badge", '\ue923'),
    BADGE_CHECK("bx-badge-check", '\ue924'),
    BALL("bx-ball", '\ue925'),
    BAND_AID("bx-band-aid", '\ue926'),
    BARCODE("bx-barcode", '\ue92b'),
    BARCODE_READER("bx-barcode-reader", '\ue92c'),
    BAR_CHART("bx-bar-chart", '\ue927'),
    BAR_CHART_ALT("bx-bar-chart-alt", '\ue928'),
    BAR_CHART_ALT_2("bx-bar-chart-alt-2", '\ue929'),
    BAR_CHART_SQUARE("bx-bar-chart-square", '\ue92a'),
    BASEBALL("bx-baseball", '\ue92d'),
    BASKET("bx-basket", '\ue92e'),
    BASKETBALL("bx-basketball", '\ue92f'),
    BATH("bx-bath", '\ue930'),
    BATTERY("bx-battery", '\ue931'),
    BED("bx-bed", '\ue932'),
    BEEN_HERE("bx-been-here", '\ue933'),
    BEER("bx-beer", '\ue934'),
    BELL("bx-bell", '\ue935'),
    BELL_MINUS("bx-bell-minus", '\ue936'),
    BELL_OFF("bx-bell-off", '\ue937'),
    BELL_PLUS("bx-bell-plus", '\ue938'),
    BIBLE("bx-bible", '\ue939'),
    BITCOIN("bx-bitcoin", '\ue93a'),
    BLANKET("bx-blanket", '\ue93b'),
    BLOCK("bx-block", '\ue93c'),
    BLUETOOTH("bx-bluetooth", '\ue93d'),
    BODY("bx-body", '\ue93e'),
    BOLD("bx-bold", '\ue93f'),
    BOLT_CIRCLE("bx-bolt-circle", '\ue940'),
    BOMB("bx-bomb", '\ue941'),
    BONE("bx-bone", '\ue942'),
    BONG("bx-bong", '\ue943'),
    BOOK("bx-book", '\ue944'),
    BOOKMARK("bx-bookmark", '\ue94a'),
    BOOKMARKS("bx-bookmarks", '\ue951'),
    BOOKMARK_ALT("bx-bookmark-alt", '\ue94b'),
    BOOKMARK_ALT_MINUS("bx-bookmark-alt-minus", '\ue94c'),
    BOOKMARK_ALT_PLUS("bx-bookmark-alt-plus", '\ue94d'),
    BOOKMARK_HEART("bx-bookmark-heart", '\ue94e'),
    BOOKMARK_MINUS("bx-bookmark-minus", '\ue94f'),
    BOOKMARK_PLUS("bx-bookmark-plus", '\ue950'),
    BOOK_ADD("bx-book-add", '\ue945'),
    BOOK_ALT("bx-book-alt", '\ue946'),
    BOOK_BOOKMARK("bx-book-bookmark", '\ue947'),
    BOOK_CONTENT("bx-book-content", '\ue948'),
    BOOK_HEART("bx-book-heart", '\ue949'),
    BOOK_OPEN("bx-book-open", '\ue952'),
    BOOK_READER("bx-book-reader", '\ue953'),
    BORDER_ALL("bx-border-all", '\ue954'),
    BORDER_BOTTOM("bx-border-bottom", '\ue955'),
    BORDER_INNER("bx-border-inner", '\ue956'),
    BORDER_LEFT("bx-border-left", '\ue957'),
    BORDER_NONE("bx-border-none", '\ue958'),
    BORDER_OUTER("bx-border-outer", '\ue959'),
    BORDER_RADIUS("bx-border-radius", '\ue95a'),
    BORDER_RIGHT("bx-border-right", '\ue95b'),
    BORDER_TOP("bx-border-top", '\ue95c'),
    BOT("bx-bot", '\ue95d'),
    BOWLING_BALL("bx-bowling-ball", '\ue95e'),
    BOX("bx-box", '\ue95f'),
    BRACKET("bx-bracket", '\ue960'),
    BRAILLE("bx-braille", '\ue961'),
    BRAIN("bx-brain", '\ue962'),
    BRIEFCASE("bx-briefcase", '\ue963'),
    BRIEFCASE_ALT("bx-briefcase-alt", '\ue964'),
    BRIEFCASE_ALT_2("bx-briefcase-alt-2", '\ue965'),
    BRIGHTNESS("bx-brightness", '\ue966'),
    BRIGHTNESS_HALF("bx-brightness-half", '\ue967'),
    BROADCAST("bx-broadcast", '\ue968'),
    BRUSH("bx-brush", '\ue969'),
    BRUSH_ALT("bx-brush-alt", '\ue96a'),
    BUG("bx-bug", '\ue96b'),
    BUG_ALT("bx-bug-alt", '\ue96c'),
    BUILDING("bx-building", '\ue96d'),
    BUILDINGS("bx-buildings", '\ue96f'),
    BUILDING_HOUSE("bx-building-house", '\ue96e'),
    BULB("bx-bulb", '\ue970'),
    BULLSEYE("bx-bullseye", '\ue971'),
    BUOY("bx-buoy", '\ue972'),
    BUS("bx-bus", '\ue973'),
    BUS_SCHOOL("bx-bus-school", '\ue974'),
    CABINET("bx-cabinet", '\ue975'),
    CAKE("bx-cake", '\ue976'),
    CALCULATOR("bx-calculator", '\ue977'),
    CALENDAR("bx-calendar", '\ue978'),
    CALENDAR_ALT("bx-calendar-alt", '\ue979'),
    CALENDAR_CHECK("bx-calendar-check", '\ue97a'),
    CALENDAR_EDIT("bx-calendar-edit", '\ue97b'),
    CALENDAR_EVENT("bx-calendar-event", '\ue97c'),
    CALENDAR_EXCLAMATION("bx-calendar-exclamation", '\ue97d'),
    CALENDAR_HEART("bx-calendar-heart", '\ue97e'),
    CALENDAR_MINUS("bx-calendar-minus", '\ue97f'),
    CALENDAR_PLUS("bx-calendar-plus", '\ue980'),
    CALENDAR_STAR("bx-calendar-star", '\ue981'),
    CALENDAR_WEEK("bx-calendar-week", '\ue982'),
    CALENDAR_X("bx-calendar-x", '\ue983'),
    CAMERA("bx-camera", '\ue984'),
    CAMERA_HOME("bx-camera-home", '\ue985'),
    CAMERA_MOVIE("bx-camera-movie", '\ue986'),
    CAMERA_OFF("bx-camera-off", '\ue987'),
    CAPSULE("bx-capsule", '\ue988'),
    CAPTIONS("bx-captions", '\ue989'),
    CAR("bx-car", '\ue98a'),
    CARD("bx-card", '\ue98b'),
    CARET_DOWN("bx-caret-down", '\ue98c'),
    CARET_DOWN_CIRCLE("bx-caret-down-circle", '\ue98d'),
    CARET_DOWN_SQUARE("bx-caret-down-square", '\ue98e'),
    CARET_LEFT("bx-caret-left", '\ue98f'),
    CARET_LEFT_CIRCLE("bx-caret-left-circle", '\ue990'),
    CARET_LEFT_SQUARE("bx-caret-left-square", '\ue991'),
    CARET_RIGHT("bx-caret-right", '\ue992'),
    CARET_RIGHT_CIRCLE("bx-caret-right-circle", '\ue993'),
    CARET_RIGHT_SQUARE("bx-caret-right-square", '\ue994'),
    CARET_UP("bx-caret-up", '\ue995'),
    CARET_UP_CIRCLE("bx-caret-up-circle", '\ue996'),
    CARET_UP_SQUARE("bx-caret-up-square", '\ue997'),
    CAROUSEL("bx-carousel", '\ue998'),
    CART("bx-cart", '\ue999'),
    CART_ALT("bx-cart-alt", '\ue99a'),
    CAST("bx-cast", '\ue99b'),
    CATEGORY("bx-category", '\ue99c'),
    CATEGORY_ALT("bx-category-alt", '\ue99d'),
    CCTV("bx-cctv", '\ue99e'),
    CERTIFICATION("bx-certification", '\ue99f'),
    CHAIR("bx-chair", '\ue9a0'),
    CHALKBOARD("bx-chalkboard", '\ue9a1'),
    CHART("bx-chart", '\ue9a2'),
    CHAT("bx-chat", '\ue9a3'),
    CHECK("bx-check", '\ue9a4'),
    CHECKBOX("bx-checkbox", '\ue9a5'),
    CHECKBOX_CHECKED("bx-checkbox-checked", '\ue9a6'),
    CHECKBOX_SQUARE("bx-checkbox-square", '\ue9a7'),
    CHECK_CIRCLE("bx-check-circle", '\ue9a8'),
    CHECK_DOUBLE("bx-check-double", '\ue9a9'),
    CHECK_SHIELD("bx-check-shield", '\ue9aa'),
    CHECK_SQUARE("bx-check-square", '\ue9ab'),
    CHEVRONS_DOWN("bx-chevrons-down", '\ue9b5'),
    CHEVRONS_LEFT("bx-chevrons-left", '\ue9b6'),
    CHEVRONS_RIGHT("bx-chevrons-right", '\ue9b7'),
    CHEVRONS_UP("bx-chevrons-up", '\ue9b8'),
    CHEVRON_DOWN("bx-chevron-down", '\ue9ac'),
    CHEVRON_DOWN_CIRCLE("bx-chevron-down-circle", '\ue9ad'),
    CHEVRON_DOWN_SQUARE("bx-chevron-down-square", '\ue9ae'),
    CHEVRON_LEFT("bx-chevron-left", '\ue9af'),
    CHEVRON_LEFT_CIRCLE("bx-chevron-left-circle", '\ue9b0'),
    CHEVRON_LEFT_SQUARE("bx-chevron-left-square", '\ue9b1'),
    CHEVRON_RIGHT("bx-chevron-right", '\ue9b2'),
    CHEVRON_RIGHT_CIRCLE("bx-chevron-right-circle", '\ue9b3'),
    CHEVRON_RIGHT_SQUARE("bx-chevron-right-square", '\ue9b4'),
    CHEVRON_UP("bx-chevron-up", '\ue9b9'),
    CHEVRON_UP_CIRCLE("bx-chevron-up-circle", '\ue9ba'),
    CHEVRON_UP_SQUARE("bx-chevron-up-square", '\ue9bb'),
    CHIP("bx-chip", '\ue9bc'),
    CHURCH("bx-church", '\ue9bd'),
    CIRCLE("bx-circle", '\ue9be'),
    CLINIC("bx-clinic", '\ue9bf'),
    CLIPBOARD("bx-clipboard", '\ue9c0'),
    CLOSET("bx-closet", '\ue9c1'),
    CLOUD("bx-cloud", '\ue9c2'),
    CLOUD_DOWNLOAD("bx-cloud-download", '\ue9c3'),
    CLOUD_DRIZZLE("bx-cloud-drizzle", '\ue9c4'),
    CLOUD_LIGHTNING("bx-cloud-lightning", '\ue9c5'),
    CLOUD_LIGHT_RAIN("bx-cloud-light-rain", '\ue9c6'),
    CLOUD_RAIN("bx-cloud-rain", '\ue9c7'),
    CLOUD_SNOW("bx-cloud-snow", '\ue9c8'),
    CLOUD_UPLOAD("bx-cloud-upload", '\ue9c9'),
    CODE("bx-code", '\ue9ca'),
    CODE_ALT("bx-code-alt", '\ue9cb'),
    CODE_BLOCK("bx-code-block", '\ue9cc'),
    CODE_CURLY("bx-code-curly", '\ue9cd'),
    COFFEE("bx-coffee", '\ue9ce'),
    COFFEE_TOGO("bx-coffee-togo", '\ue9cf'),
    COG("bx-cog", '\ue9d0'),
    COIN("bx-coin", '\ue9d1'),
    COIN_STACK("bx-coin-stack", '\ue9d2'),
    COLLAPSE("bx-collapse", '\ue9d3'),
    COLLECTION("bx-collection", '\ue9d4'),
    COLOR_FILL("bx-color-fill", '\ue9d5'),
    COLUMNS("bx-columns", '\ue9d6'),
    COMMAND("bx-command", '\ue9d7'),
    COMMENT("bx-comment", '\ue9d8'),
    COMMENT_ADD("bx-comment-add", '\ue9d9'),
    COMMENT_CHECK("bx-comment-check", '\ue9da'),
    COMMENT_DETAIL("bx-comment-detail", '\ue9db'),
    COMMENT_DOTS("bx-comment-dots", '\ue9dc'),
    COMMENT_EDIT("bx-comment-edit", '\ue9dd'),
    COMMENT_ERROR("bx-comment-error", '\ue9de'),
    COMMENT_MINUS("bx-comment-minus", '\ue9df'),
    COMMENT_X("bx-comment-x", '\ue9e0'),
    COMPASS("bx-compass", '\ue9e1'),
    CONFUSED("bx-confused", '\ue9e2'),
    CONVERSATION("bx-conversation", '\ue9e3'),
    COOKIE("bx-cookie", '\ue9e4'),
    COOL("bx-cool", '\ue9e5'),
    COPY("bx-copy", '\ue9e6'),
    COPYRIGHT("bx-copyright", '\ue9e8'),
    COPY_ALT("bx-copy-alt", '\ue9e7'),
    CREDIT_CARD("bx-credit-card", '\ue9e9'),
    CREDIT_CARD_ALT("bx-credit-card-alt", '\ue9ea'),
    CREDIT_CARD_FRONT("bx-credit-card-front", '\ue9eb'),
    CROP("bx-crop", '\ue9ec'),
    CROSSHAIR("bx-crosshair", '\ue9ed'),
    CROWN("bx-crown", '\ue9ee'),
    CUBE("bx-cube", '\ue9ef'),
    CUBE_ALT("bx-cube-alt", '\ue9f0'),
    CUBOID("bx-cuboid", '\ue9f1'),
    CURRENT_LOCATION("bx-current-location", '\ue9f2'),
    CUSTOMIZE("bx-customize", '\ue9f3'),
    CUT("bx-cut", '\ue9f4'),
    CYCLING("bx-cycling", '\ue9f5'),
    CYLINDER("bx-cylinder", '\ue9f6'),
    DATA("bx-data", '\ue9f7'),
    DESKTOP("bx-desktop", '\ue9f8'),
    DETAIL("bx-detail", '\ue9f9'),
    DEVICES("bx-devices", '\ue9fa'),
    DIALPAD("bx-dialpad", '\ue9fb'),
    DIALPAD_ALT("bx-dialpad-alt", '\ue9fc'),
    DIAMOND("bx-diamond", '\ue9fd'),
    DICE_1("bx-dice-1", '\ue9fe'),
    DICE_2("bx-dice-2", '\ue9ff'),
    DICE_3("bx-dice-3", '\uea00'),
    DICE_4("bx-dice-4", '\uea01'),
    DICE_5("bx-dice-5", '\uea02'),
    DICE_6("bx-dice-6", '\uea03'),
    DIRECTIONS("bx-directions", '\uea04'),
    DISC("bx-disc", '\uea05'),
    DISH("bx-dish", '\uea06'),
    DISLIKE("bx-dislike", '\uea07'),
    DIZZY("bx-dizzy", '\uea08'),
    DNA("bx-dna", '\uea09'),
    DOCK_BOTTOM("bx-dock-bottom", '\uea0a'),
    DOCK_LEFT("bx-dock-left", '\uea0b'),
    DOCK_RIGHT("bx-dock-right", '\uea0c'),
    DOCK_TOP("bx-dock-top", '\uea0d'),
    DOLLAR("bx-dollar", '\uea0e'),
    DOLLAR_CIRCLE("bx-dollar-circle", '\uea0f'),
    DONATE_BLOOD("bx-donate-blood", '\uea10'),
    DONATE_HEART("bx-donate-heart", '\uea11'),
    DOOR_OPEN("bx-door-open", '\uea12'),
    DOTS_HORIZONTAL("bx-dots-horizontal", '\uea13'),
    DOTS_HORIZONTAL_ROUNDED("bx-dots-horizontal-rounded", '\uea14'),
    DOTS_VERTICAL("bx-dots-vertical", '\uea15'),
    DOTS_VERTICAL_ROUNDED("bx-dots-vertical-rounded", '\uea16'),
    DOUGHNUT_CHART("bx-doughnut-chart", '\uea17'),
    DOWNLOAD("bx-download", '\uea1b'),
    DOWNVOTE("bx-downvote", '\uea1c'),
    DOWN_ARROW("bx-down-arrow", '\uea18'),
    DOWN_ARROW_ALT("bx-down-arrow-alt", '\uea19'),
    DOWN_ARROW_CIRCLE("bx-down-arrow-circle", '\uea1a'),
    DRINK("bx-drink", '\uea1d'),
    DROPLET("bx-droplet", '\uea1e'),
    DUMBBELL("bx-dumbbell", '\uea1f'),
    DUPLICATE("bx-duplicate", '\uea20'),
    EDIT("bx-edit", '\uea21'),
    EDIT_ALT("bx-edit-alt", '\uea22'),
    ENVELOPE("bx-envelope", '\uea23'),
    ENVELOPE_OPEN("bx-envelope-open", '\uea24'),
    EQUALIZER("bx-equalizer", '\uea25'),
    ERASER("bx-eraser", '\uea26'),
    ERROR("bx-error", '\uea27'),
    ERROR_ALT("bx-error-alt", '\uea28'),
    ERROR_CIRCLE("bx-error-circle", '\uea29'),
    EURO("bx-euro", '\uea2a'),
    EXCLUDE("bx-exclude", '\uea2b'),
    EXIT("bx-exit", '\uea2c'),
    EXIT_FULLSCREEN("bx-exit-fullscreen", '\uea2d'),
    EXPAND("bx-expand", '\uea2e'),
    EXPAND_ALT("bx-expand-alt", '\uea2f'),
    EXPORT("bx-export", '\uea30'),
    EXTENSION("bx-extension", '\uea31'),
    FACE("bx-face", '\uea32'),
    FAST_FORWARD("bx-fast-forward", '\uea33'),
    FAST_FORWARD_CIRCLE("bx-fast-forward-circle", '\uea34'),
    FEMALE("bx-female", '\uea35'),
    FEMALE_SIGN("bx-female-sign", '\uea36'),
    FILE("bx-file", '\uea37'),
    FILE_BLANK("bx-file-blank", '\uea38'),
    FILE_FIND("bx-file-find", '\uea39'),
    FILM("bx-film", '\uea3a'),
    FILTER("bx-filter", '\uea3b'),
    FILTER_ALT("bx-filter-alt", '\uea3c'),
    FINGERPRINT("bx-fingerprint", '\uea3d'),
    FIRST_AID("bx-first-aid", '\uea3e'),
    FIRST_PAGE("bx-first-page", '\uea3f'),
    FLAG("bx-flag", '\uea40'),
    FOLDER("bx-folder", '\uea41'),
    FOLDER_MINUS("bx-folder-minus", '\uea42'),
    FOLDER_OPEN("bx-folder-open", '\uea43'),
    FOLDER_PLUS("bx-folder-plus", '\uea44'),
    FONT("bx-font", '\uea45'),
    FONT_COLOR("bx-font-color", '\uea46'),
    FONT_FAMILY("bx-font-family", '\uea47'),
    FONT_SIZE("bx-font-size", '\uea48'),
    FOOD_MENU("bx-food-menu", '\uea49'),
    FOOD_TAG("bx-food-tag", '\uea4a'),
    FOOTBALL("bx-football", '\uea4b'),
    FRIDGE("bx-fridge", '\uea4c'),
    FULLSCREEN("bx-fullscreen", '\uea4d'),
    GAME("bx-game", '\uea4e'),
    GAS_PUMP("bx-gas-pump", '\uea4f'),
    GHOST("bx-ghost", '\uea50'),
    GIFT("bx-gift", '\uea51'),
    GIT_BRANCH("bx-git-branch", '\uea52'),
    GIT_COMMIT("bx-git-commit", '\uea53'),
    GIT_COMPARE("bx-git-compare", '\uea54'),
    GIT_MERGE("bx-git-merge", '\uea55'),
    GIT_PULL_REQUEST("bx-git-pull-request", '\uea56'),
    GIT_REPO_FORKED("bx-git-repo-forked", '\uea57'),
    GLASSES("bx-glasses", '\uea58'),
    GLASSES_ALT("bx-glasses-alt", '\uea59'),
    GLOBE("bx-globe", '\uea5a'),
    GLOBE_ALT("bx-globe-alt", '\uea5b'),
    GRID("bx-grid", '\uea5c'),
    GRID_ALT("bx-grid-alt", '\uea5d'),
    GRID_HORIZONTAL("bx-grid-horizontal", '\uea5e'),
    GRID_SMALL("bx-grid-small", '\uea5f'),
    GRID_VERTICAL("bx-grid-vertical", '\uea60'),
    GROUP("bx-group", '\uea61'),
    HANDICAP("bx-handicap", '\uea62'),
    HAPPY("bx-happy", '\uea63'),
    HAPPY_ALT("bx-happy-alt", '\uea64'),
    HAPPY_BEAMING("bx-happy-beaming", '\uea65'),
    HAPPY_HEART_EYES("bx-happy-heart-eyes", '\uea66'),
    HASH("bx-hash", '\uea67'),
    HDD("bx-hdd", '\uea68'),
    HEADING("bx-heading", '\uea69'),
    HEADPHONE("bx-headphone", '\uea6a'),
    HEALTH("bx-health", '\uea6b'),
    HEART("bx-heart", '\uea6c'),
    HEART_CIRCLE("bx-heart-circle", '\uea6d'),
    HEART_SQUARE("bx-heart-square", '\uea6e'),
    HELP_CIRCLE("bx-help-circle", '\uea6f'),
    HIDE("bx-hide", '\uea70'),
    HIGHLIGHT("bx-highlight", '\uea71'),
    HISTORY("bx-history", '\uea72'),
    HIVE("bx-hive", '\uea73'),
    HOME("bx-home", '\uea74'),
    HOME_ALT("bx-home-alt", '\uea75'),
    HOME_CIRCLE("bx-home-circle", '\uea76'),
    HOME_HEART("bx-home-heart", '\uea77'),
    HOME_SMILE("bx-home-smile", '\uea78'),
    HORIZONTAL_CENTER("bx-horizontal-center", '\uea79'),
    HOTEL("bx-hotel", '\uea7a'),
    HOURGLASS("bx-hourglass", '\uea7b'),
    ID_CARD("bx-id-card", '\uea7c'),
    IMAGE("bx-image", '\uea7d'),
    IMAGES("bx-images", '\uea80'),
    IMAGE_ADD("bx-image-add", '\uea7e'),
    IMAGE_ALT("bx-image-alt", '\uea7f'),
    IMPORT("bx-import", '\uea81'),
    INFINITE("bx-infinite", '\uea82'),
    INFO_CIRCLE("bx-info-circle", '\uea83'),
    INFO_SQUARE("bx-info-square", '\uea84'),
    INTERSECT("bx-intersect", '\uea85'),
    ITALIC("bx-italic", '\uea86'),
    JOYSTICK("bx-joystick", '\uea87'),
    JOYSTICK_ALT("bx-joystick-alt", '\uea88'),
    JOYSTICK_BUTTON("bx-joystick-button", '\uea89'),
    KEY("bx-key", '\uea8a'),
    LABEL("bx-label", '\uea8b'),
    LANDSCAPE("bx-landscape", '\uea8c'),
    LAPTOP("bx-laptop", '\uea8d'),
    LAST_PAGE("bx-last-page", '\uea8e'),
    LAUGH("bx-laugh", '\uea8f'),
    LAYER("bx-layer", '\uea90'),
    LAYER_MINUS("bx-layer-minus", '\uea91'),
    LAYER_PLUS("bx-layer-plus", '\uea92'),
    LAYOUT("bx-layout", '\uea93'),
    LEFT_ARROW("bx-left-arrow", '\uea94'),
    LEFT_ARROW_ALT("bx-left-arrow-alt", '\uea95'),
    LEFT_ARROW_CIRCLE("bx-left-arrow-circle", '\uea96'),
    LEFT_DOWN_ARROW_CIRCLE("bx-left-down-arrow-circle", '\uea97'),
    LEFT_INDENT("bx-left-indent", '\uea98'),
    LEFT_TOP_ARROW_CIRCLE("bx-left-top-arrow-circle", '\uea99'),
    LIBRARY("bx-library", '\uea9a'),
    LIKE("bx-like", '\uea9b'),
    LINE_CHART("bx-line-chart", '\uea9c'),
    LINE_CHART_DOWN("bx-line-chart-down", '\uea9d'),
    LINK("bx-link", '\uea9e'),
    LINK_ALT("bx-link-alt", '\uea9f'),
    LINK_EXTERNAL("bx-link-external", '\ueaa0'),
    LIRA("bx-lira", '\ueaa1'),
    LIST_CHECK("bx-list-check", '\ueaa2'),
    LIST_MINUS("bx-list-minus", '\ueaa3'),
    LIST_OL("bx-list-ol", '\ueaa4'),
    LIST_PLUS("bx-list-plus", '\ueaa5'),
    LIST_UL("bx-list-ul", '\ueaa6'),
    LOADER("bx-loader", '\ueaa7'),
    LOADER_ALT("bx-loader-alt", '\ueaa8'),
    LOADER_CIRCLE("bx-loader-circle", '\ueaa9'),
    LOCATION_PLUS("bx-location-plus", '\ueaaa'),
    LOCK("bx-lock", '\ueaab'),
    LOCK_ALT("bx-lock-alt", '\ueaac'),
    LOCK_OPEN("bx-lock-open", '\ueaad'),
    LOCK_OPEN_ALT("bx-lock-open-alt", '\ueaae'),
    LOG_IN("bx-log-in", '\ueaaf'),
    LOG_IN_CIRCLE("bx-log-in-circle", '\ueab0'),
    LOG_OUT("bx-log-out", '\ueab1'),
    LOG_OUT_CIRCLE("bx-log-out-circle", '\ueab2'),
    LOW_VISION("bx-low-vision", '\ueab3'),
    MAGNET("bx-magnet", '\ueab4'),
    MAIL_SEND("bx-mail-send", '\ueab5'),
    MALE("bx-male", '\ueab6'),
    MALE_SIGN("bx-male-sign", '\ueab7'),
    MAP("bx-map", '\ueab8'),
    MAP_ALT("bx-map-alt", '\ueab9'),
    MAP_PIN("bx-map-pin", '\ueaba'),
    MASK("bx-mask", '\ueabb'),
    MEDAL("bx-medal", '\ueabc'),
    MEH("bx-meh", '\ueabd'),
    MEH_ALT("bx-meh-alt", '\ueabe'),
    MEH_BLANK("bx-meh-blank", '\ueabf'),
    MEMORY_CARD("bx-memory-card", '\ueac0'),
    MENU("bx-menu", '\ueac1'),
    MENU_ALT_LEFT("bx-menu-alt-left", '\ueac2'),
    MENU_ALT_RIGHT("bx-menu-alt-right", '\ueac3'),
    MERGE("bx-merge", '\ueac4'),
    MESSAGE("bx-message", '\ueac5'),
    MESSAGE_ADD("bx-message-add", '\ueac6'),
    MESSAGE_ALT("bx-message-alt", '\ueac7'),
    MESSAGE_ALT_ADD("bx-message-alt-add", '\ueac8'),
    MESSAGE_ALT_CHECK("bx-message-alt-check", '\ueac9'),
    MESSAGE_ALT_DETAIL("bx-message-alt-detail", '\ueaca'),
    MESSAGE_ALT_DOTS("bx-message-alt-dots", '\ueacb'),
    MESSAGE_ALT_EDIT("bx-message-alt-edit", '\ueacc'),
    MESSAGE_ALT_ERROR("bx-message-alt-error", '\ueacd'),
    MESSAGE_ALT_MINUS("bx-message-alt-minus", '\ueace'),
    MESSAGE_ALT_X("bx-message-alt-x", '\ueacf'),
    MESSAGE_CHECK("bx-message-check", '\uead0'),
    MESSAGE_DETAIL("bx-message-detail", '\uead1'),
    MESSAGE_DOTS("bx-message-dots", '\uead2'),
    MESSAGE_EDIT("bx-message-edit", '\uead3'),
    MESSAGE_ERROR("bx-message-error", '\uead4'),
    MESSAGE_MINUS("bx-message-minus", '\uead5'),
    MESSAGE_ROUNDED("bx-message-rounded", '\uead6'),
    MESSAGE_ROUNDED_ADD("bx-message-rounded-add", '\uead7'),
    MESSAGE_ROUNDED_CHECK("bx-message-rounded-check", '\uead8'),
    MESSAGE_ROUNDED_DETAIL("bx-message-rounded-detail", '\uead9'),
    MESSAGE_ROUNDED_DOTS("bx-message-rounded-dots", '\ueada'),
    MESSAGE_ROUNDED_EDIT("bx-message-rounded-edit", '\ueadb'),
    MESSAGE_ROUNDED_ERROR("bx-message-rounded-error", '\ueadc'),
    MESSAGE_ROUNDED_MINUS("bx-message-rounded-minus", '\ueadd'),
    MESSAGE_ROUNDED_X("bx-message-rounded-x", '\ueade'),
    MESSAGE_SQUARE("bx-message-square", '\ueadf'),
    MESSAGE_SQUARE_ADD("bx-message-square-add", '\ueae0'),
    MESSAGE_SQUARE_CHECK("bx-message-square-check", '\ueae1'),
    MESSAGE_SQUARE_DETAIL("bx-message-square-detail", '\ueae2'),
    MESSAGE_SQUARE_DOTS("bx-message-square-dots", '\ueae3'),
    MESSAGE_SQUARE_EDIT("bx-message-square-edit", '\ueae4'),
    MESSAGE_SQUARE_ERROR("bx-message-square-error", '\ueae5'),
    MESSAGE_SQUARE_MINUS("bx-message-square-minus", '\ueae6'),
    MESSAGE_SQUARE_X("bx-message-square-x", '\ueae7'),
    MESSAGE_X("bx-message-x", '\ueae8'),
    METEOR("bx-meteor", '\ueae9'),
    MICROCHIP("bx-microchip", '\ueaea'),
    MICROPHONE("bx-microphone", '\ueaeb'),
    MICROPHONE_OFF("bx-microphone-off", '\ueaec'),
    MINUS("bx-minus", '\ueaed'),
    MINUS_BACK("bx-minus-back", '\ueaee'),
    MINUS_CIRCLE("bx-minus-circle", '\ueaef'),
    MINUS_FRONT("bx-minus-front", '\ueaf0'),
    MOBILE("bx-mobile", '\ueaf1'),
    MOBILE_ALT("bx-mobile-alt", '\ueaf2'),
    MOBILE_LANDSCAPE("bx-mobile-landscape", '\ueaf3'),
    MOBILE_VIBRATION("bx-mobile-vibration", '\ueaf4'),
    MONEY("bx-money", '\ueaf5'),
    MOON("bx-moon", '\ueaf6'),
    MOUSE("bx-mouse", '\ueaf7'),
    MOUSE_ALT("bx-mouse-alt", '\ueaf8'),
    MOVE("bx-move", '\ueaf9'),
    MOVE_HORIZONTAL("bx-move-horizontal", '\ueafa'),
    MOVE_VERTICAL("bx-move-vertical", '\ueafb'),
    MOVIE("bx-movie", '\ueafc'),
    MOVIE_PLAY("bx-movie-play", '\ueafd'),
    MUSIC("bx-music", '\ueafe'),
    NAVIGATION("bx-navigation", '\ueaff'),
    NETWORK_CHART("bx-network-chart", '\ueb00'),
    NEWS("bx-news", '\ueb01'),
    NOTE("bx-note", '\ueb03'),
    NOTEPAD("bx-notepad", '\ueb04'),
    NOTIFICATION("bx-notification", '\ueb05'),
    NOTIFICATION_OFF("bx-notification-off", '\ueb06'),
    NO_ENTRY("bx-no-entry", '\ueb02'),
    OUTLINE("bx-outline", '\ueb07'),
    PACKAGE("bx-package", '\ueb08'),
    PAINT("bx-paint", '\ueb09'),
    PAINT_ROLL("bx-paint-roll", '\ueb0a'),
    PALETTE("bx-palette", '\ueb0b'),
    PAPERCLIP("bx-paperclip", '\ueb0c'),
    PAPER_PLANE("bx-paper-plane", '\ueb0d'),
    PARAGRAPH("bx-paragraph", '\ueb0e'),
    PASTE("bx-paste", '\ueb0f'),
    PAUSE("bx-pause", '\ueb10'),
    PAUSE_CIRCLE("bx-pause-circle", '\ueb11'),
    PEN("bx-pen", '\ueb12'),
    PENCIL("bx-pencil", '\ueb13'),
    PHONE("bx-phone", '\ueb14'),
    PHONE_CALL("bx-phone-call", '\ueb15'),
    PHONE_INCOMING("bx-phone-incoming", '\ueb16'),
    PHONE_OUTGOING("bx-phone-outgoing", '\ueb17'),
    PHOTO_ALBUM("bx-photo-album", '\ueb18'),
    PIE_CHART("bx-pie-chart", '\ueb19'),
    PIE_CHART_ALT("bx-pie-chart-alt", '\ueb1a'),
    PIE_CHART_ALT_2("bx-pie-chart-alt-2", '\ueb1b'),
    PIN("bx-pin", '\ueb1c'),
    PLANET("bx-planet", '\ueb1d'),
    PLAY("bx-play", '\ueb1e'),
    PLAY_CIRCLE("bx-play-circle", '\ueb1f'),
    PLUG("bx-plug", '\ueb20'),
    PLUS("bx-plus", '\ueb21'),
    PLUS_CIRCLE("bx-plus-circle", '\ueb22'),
    PLUS_MEDICAL("bx-plus-medical", '\ueb23'),
    POINTER("bx-pointer", '\ueb24'),
    POLL("bx-poll", '\ueb25'),
    POLYGON("bx-polygon", '\ueb26'),
    POUND("bx-pound", '\ueb27'),
    POWER_OFF("bx-power-off", '\ueb28'),
    PRINTER("bx-printer", '\ueb29'),
    PULSE("bx-pulse", '\ueb2a'),
    PURCHASE_TAG("bx-purchase-tag", '\ueb2b'),
    PURCHASE_TAG_ALT("bx-purchase-tag-alt", '\ueb2c'),
    PYRAMID("bx-pyramid", '\ueb2d'),
    QUESTION_MARK("bx-question-mark", '\ueb2e'),
    RADAR("bx-radar", '\ueb2f'),
    RADIO("bx-radio", '\ueb30'),
    RADIO_CIRCLE("bx-radio-circle", '\ueb31'),
    RADIO_CIRCLE_MARKED("bx-radio-circle-marked", '\ueb32'),
    RECEIPT("bx-receipt", '\ueb33'),
    RECTANGLE("bx-rectangle", '\ueb34'),
    RECYCLE("bx-recycle", '\ueb35'),
    REDO("bx-redo", '\ueb36'),
    REFRESH("bx-refresh", '\ueb37'),
    RENAME("bx-rename", '\ueb38'),
    REPEAT("bx-repeat", '\ueb39'),
    REPLY("bx-reply", '\ueb3a'),
    REPLY_ALL("bx-reply-all", '\ueb3b'),
    REPOST("bx-repost", '\ueb3c'),
    RESET("bx-reset", '\ueb3d'),
    RESTAURANT("bx-restaurant", '\ueb3e'),
    REVISION("bx-revision", '\ueb3f'),
    REWIND("bx-rewind", '\ueb40'),
    REWIND_CIRCLE("bx-rewind-circle", '\ueb41'),
    RIGHT_ARROW("bx-right-arrow", '\ueb42'),
    RIGHT_ARROW_ALT("bx-right-arrow-alt", '\ueb43'),
    RIGHT_ARROW_CIRCLE("bx-right-arrow-circle", '\ueb44'),
    RIGHT_DOWN_ARROW_CIRCLE("bx-right-down-arrow-circle", '\ueb45'),
    RIGHT_INDENT("bx-right-indent", '\ueb46'),
    RIGHT_TOP_ARROW_CIRCLE("bx-right-top-arrow-circle", '\ueb47'),
    ROCKET("bx-rocket", '\ueb48'),
    ROTATE_LEFT("bx-rotate-left", '\ueb49'),
    ROTATE_RIGHT("bx-rotate-right", '\ueb4a'),
    RSS("bx-rss", '\ueb4b'),
    RUBLE("bx-ruble", '\ueb4c'),
    RULER("bx-ruler", '\ueb4d'),
    RUN("bx-run", '\ueb4e'),
    RUPEE("bx-rupee", '\ueb4f'),
    SAD("bx-sad", '\ueb50'),
    SAVE("bx-save", '\ueb51'),
    SCAN("bx-scan", '\ueb52'),
    SCREENSHOT("bx-screenshot", '\ueb53'),
    SEARCH("bx-search", '\ueb54'),
    SEARCH_ALT("bx-search-alt", '\ueb55'),
    SEARCH_ALT_2("bx-search-alt-2", '\ueb56'),
    SELECTION("bx-selection", '\ueb57'),
    SELECT_MULTIPLE("bx-select-multiple", '\ueb58'),
    SEND("bx-send", '\ueb59'),
    SERVER("bx-server", '\ueb5a'),
    SHAPE_CIRCLE("bx-shape-circle", '\ueb5b'),
    SHAPE_POLYGON("bx-shape-polygon", '\ueb5c'),
    SHAPE_SQUARE("bx-shape-square", '\ueb5d'),
    SHAPE_TRIANGLE("bx-shape-triangle", '\ueb5e'),
    SHARE("bx-share", '\ueb5f'),
    SHARE_ALT("bx-share-alt", '\ueb60'),
    SHEKEL("bx-shekel", '\ueb61'),
    SHIELD("bx-shield", '\ueb62'),
    SHIELD_ALT("bx-shield-alt", '\ueb63'),
    SHIELD_ALT_2("bx-shield-alt-2", '\ueb64'),
    SHIELD_QUARTER("bx-shield-quarter", '\ueb65'),
    SHIELD_X("bx-shield-x", '\ueb66'),
    SHOCKED("bx-shocked", '\ueb67'),
    SHOPPING_BAG("bx-shopping-bag", '\ueb68'),
    SHOW("bx-show", '\ueb69'),
    SHOW_ALT("bx-show-alt", '\ueb6a'),
    SHUFFLE("bx-shuffle", '\ueb6b'),
    SIDEBAR("bx-sidebar", '\ueb6c'),
    SITEMAP("bx-sitemap", '\ueb6d'),
    SKIP_NEXT("bx-skip-next", '\ueb6e'),
    SKIP_NEXT_CIRCLE("bx-skip-next-circle", '\ueb6f'),
    SKIP_PREVIOUS("bx-skip-previous", '\ueb70'),
    SKIP_PREVIOUS_CIRCLE("bx-skip-previous-circle", '\ueb71'),
    SLEEPY("bx-sleepy", '\ueb72'),
    SLIDER("bx-slider", '\ueb73'),
    SLIDER_ALT("bx-slider-alt", '\ueb74'),
    SLIDESHOW("bx-slideshow", '\ueb75'),
    SMILE("bx-smile", '\ueb76'),
    SORT("bx-sort", '\ueb77'),
    SORT_ALT_2("bx-sort-alt-2", '\ueb78'),
    SORT_A_Z("bx-sort-a-z", '\ueb79'),
    SORT_DOWN("bx-sort-down", '\ueb7a'),
    SORT_UP("bx-sort-up", '\ueb7b'),
    SORT_Z_A("bx-sort-z-a", '\ueb7c'),
    SPA("bx-spa", '\ueb7d'),
    SPACE_BAR("bx-space-bar", '\ueb7e'),
    SPRAY_CAN("bx-spray-can", '\ueb7f'),
    SPREADSHEET("bx-spreadsheet", '\ueb80'),
    SQUARE("bx-square", '\ueb81'),
    SQUARE_ROUNDED("bx-square-rounded", '\ueb82'),
    STAR("bx-star", '\ueb83'),
    STATION("bx-station", '\ueb84'),
    STATS("bx-stats", '\ueb85'),
    STICKER("bx-sticker", '\ueb86'),
    STOP("bx-stop", '\ueb87'),
    STOPWATCH("bx-stopwatch", '\ueb89'),
    STOP_CIRCLE("bx-stop-circle", '\ueb88'),
    STORE("bx-store", '\ueb8a'),
    STORE_ALT("bx-store-alt", '\ueb8b'),
    STREET_VIEW("bx-street-view", '\ueb8c'),
    STRIKETHROUGH("bx-strikethrough", '\ueb8d'),
    SUBDIRECTORY_LEFT("bx-subdirectory-left", '\ueb8e'),
    SUBDIRECTORY_RIGHT("bx-subdirectory-right", '\ueb8f'),
    SUN("bx-sun", '\ueb90'),
    SUPPORT("bx-support", '\ueb91'),
    SWIM("bx-swim", '\ueb92'),
    SYNC("bx-sync", '\ueb93'),
    TAB("bx-tab", '\ueb94'),
    TABLE("bx-table", '\ueb95'),
    TACHOMETER("bx-tachometer", '\ueb96'),
    TAG("bx-tag", '\ueb97'),
    TAG_ALT("bx-tag-alt", '\ueb98'),
    TARGET_LOCK("bx-target-lock", '\ueb99'),
    TASK("bx-task", '\ueb9a'),
    TASK_X("bx-task-x", '\ueb9b'),
    TAXI("bx-taxi", '\ueb9c'),
    TENNIS_BALL("bx-tennis-ball", '\ueb9d'),
    TERMINAL("bx-terminal", '\ueb9e'),
    TEST_TUBE("bx-test-tube", '\ueb9f'),
    TEXT("bx-text", '\ueba0'),
    TIME("bx-time", '\ueba1'),
    TIMER("bx-timer", '\ueba3'),
    TIME_FIVE("bx-time-five", '\ueba2'),
    TIRED("bx-tired", '\ueba4'),
    TOGGLE_LEFT("bx-toggle-left", '\ueba5'),
    TOGGLE_RIGHT("bx-toggle-right", '\ueba6'),
    TONE("bx-tone", '\ueba7'),
    TRAFFIC_CONE("bx-traffic-cone", '\ueba8'),
    TRAIN("bx-train", '\ueba9'),
    TRANSFER("bx-transfer", '\uebaa'),
    TRANSFER_ALT("bx-transfer-alt", '\uebab'),
    TRASH("bx-trash", '\uebac'),
    TRASH_ALT("bx-trash-alt", '\uebad'),
    TRENDING_DOWN("bx-trending-down", '\uebae'),
    TRENDING_UP("bx-trending-up", '\uebaf'),
    TRIM("bx-trim", '\uebb0'),
    TRIP("bx-trip", '\uebb1'),
    TROPHY("bx-trophy", '\uebb2'),
    TV("bx-tv", '\uebb3'),
    UNDERLINE("bx-underline", '\uebb4'),
    UNDO("bx-undo", '\uebb5'),
    UNITE("bx-unite", '\uebb6'),
    UNLINK("bx-unlink", '\uebb7'),
    UPLOAD("bx-upload", '\uebbb'),
    UPSIDE_DOWN("bx-upside-down", '\uebbc'),
    UPVOTE("bx-upvote", '\uebbd'),
    UP_ARROW("bx-up-arrow", '\uebb8'),
    UP_ARROW_ALT("bx-up-arrow-alt", '\uebb9'),
    UP_ARROW_CIRCLE("bx-up-arrow-circle", '\uebba'),
    USB("bx-usb", '\uebbe'),
    USER("bx-user", '\uebbf'),
    USER_CHECK("bx-user-check", '\uebc0'),
    USER_CIRCLE("bx-user-circle", '\uebc1'),
    USER_MINUS("bx-user-minus", '\uebc2'),
    USER_PIN("bx-user-pin", '\uebc3'),
    USER_PLUS("bx-user-plus", '\uebc4'),
    USER_VOICE("bx-user-voice", '\uebc5'),
    USER_X("bx-user-x", '\uebc6'),
    VECTOR("bx-vector", '\uebc7'),
    VERTICAL_CENTER("bx-vertical-center", '\uebc8'),
    VIAL("bx-vial", '\uebc9'),
    VIDEO("bx-video", '\uebca'),
    VIDEO_OFF("bx-video-off", '\uebcb'),
    VIDEO_PLUS("bx-video-plus", '\uebcc'),
    VIDEO_RECORDING("bx-video-recording", '\uebcd'),
    VOICEMAIL("bx-voicemail", '\uebce'),
    VOLUME("bx-volume", '\uebcf'),
    VOLUME_FULL("bx-volume-full", '\uebd0'),
    VOLUME_LOW("bx-volume-low", '\uebd1'),
    VOLUME_MUTE("bx-volume-mute", '\uebd2'),
    WALK("bx-walk", '\uebd3'),
    WALLET("bx-wallet", '\uebd4'),
    WALLET_ALT("bx-wallet-alt", '\uebd5'),
    WATER("bx-water", '\uebd6'),
    WEBCAM("bx-webcam", '\uebd7'),
    WIFI("bx-wifi", '\uebd8'),
    WIFI_0("bx-wifi-0", '\uebd9'),
    WIFI_1("bx-wifi-1", '\uebda'),
    WIFI_2("bx-wifi-2", '\uebdb'),
    WIFI_OFF("bx-wifi-off", '\uebdc'),
    WIND("bx-wind", '\uebdd'),
    WINDOW("bx-window", '\uebde'),
    WINDOWS("bx-windows", '\uebe2'),
    WINDOW_ALT("bx-window-alt", '\uebdf'),
    WINDOW_CLOSE("bx-window-close", '\uebe0'),
    WINDOW_OPEN("bx-window-open", '\uebe1'),
    WINE("bx-wine", '\uebe3'),
    WINK_SMILE("bx-wink-smile", '\uebe4'),
    WINK_TONGUE("bx-wink-tongue", '\uebe5'),
    WON("bx-won", '\uebe6'),
    WORLD("bx-world", '\uebe7'),
    WRENCH("bx-wrench", '\uebe8'),
    X("bx-x", '\uebe9'),
    X_CIRCLE("bx-x-circle", '\uebea'),
    YEN("bx-yen", '\uebeb'),
    ZOOM_IN("bx-zoom-in", '\uebec'),
    ZOOM_OUT("bx-zoom-out", '\uebed');

    public static BoxiconsRegular findByDescription(String description) {
        for (BoxiconsRegular font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    BoxiconsRegular(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}