/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2015-2020 Andres Almiray
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kordamp.ikonli.boxicons;

import org.kordamp.ikonli.Ikon;

/**
 * @author Andres Almiray
 */
public enum BoxiconsLogos implements Ikon {
    ADOBE("bxl-adobe", '\uee5f'),
    AIRBNB("bxl-airbnb", '\uee60'),
    ALGOLIA("bxl-algolia", '\uee61'),
    AMAZON("bxl-amazon", '\uee62'),
    ANDROID("bxl-android", '\uee63'),
    ANGULAR("bxl-angular", '\uee64'),
    APPLE("bxl-apple", '\uee65'),
    AUDIBLE("bxl-audible", '\uee66'),
    BAIDU("bxl-baidu", '\uee67'),
    BEHANCE("bxl-behance", '\uee68'),
    BING("bxl-bing", '\uee69'),
    BITCOIN("bxl-bitcoin", '\uee6a'),
    BLENDER("bxl-blender", '\uee6b'),
    BLOGGER("bxl-blogger", '\uee6c'),
    BOOTSTRAP("bxl-bootstrap", '\uee6d'),
    BOX_500PX("bxl-500px", '\uee5e'),
    CHROME("bxl-chrome", '\uee6e'),
    CODEPEN("bxl-codepen", '\uee6f'),
    CREATIVE_COMMONS("bxl-creative-commons", '\uee71'),
    CSS3("bxl-css3", '\uee72'),
    C_PLUS_PLUS("bxl-c-plus-plus", '\uee70'),
    DAILYMOTION("bxl-dailymotion", '\uee73'),
    DEVIANTART("bxl-deviantart", '\uee74'),
    DEV_TO("bxl-dev-to", '\uee75'),
    DIGG("bxl-digg", '\uee76'),
    DIGITALOCEAN("bxl-digitalocean", '\uee77'),
    DISCORD("bxl-discord", '\uee78'),
    DISCOURSE("bxl-discourse", '\uee79'),
    DJANGO("bxl-django", '\uee7a'),
    DRIBBBLE("bxl-dribbble", '\uee7b'),
    DROPBOX("bxl-dropbox", '\uee7c'),
    DRUPAL("bxl-drupal", '\uee7d'),
    EBAY("bxl-ebay", '\uee7e'),
    EDGE("bxl-edge", '\uee7f'),
    ETSY("bxl-etsy", '\uee80'),
    FACEBOOK("bxl-facebook", '\uee81'),
    FACEBOOK_CIRCLE("bxl-facebook-circle", '\uee82'),
    FACEBOOK_SQUARE("bxl-facebook-square", '\uee83'),
    FIGMA("bxl-figma", '\uee84'),
    FIREBASE("bxl-firebase", '\uee85'),
    FIREFOX("bxl-firefox", '\uee86'),
    FLICKR("bxl-flickr", '\uee87'),
    FLICKR_SQUARE("bxl-flickr-square", '\uee88'),
    FOURSQUARE("bxl-foursquare", '\uee89'),
    GIT("bxl-git", '\uee8a'),
    GITHUB("bxl-github", '\uee8b'),
    GITLAB("bxl-gitlab", '\uee8c'),
    GOOGLE("bxl-google", '\uee8d'),
    GOOGLE_CLOUD("bxl-google-cloud", '\uee8e'),
    GOOGLE_PLUS("bxl-google-plus", '\uee8f'),
    GOOGLE_PLUS_CIRCLE("bxl-google-plus-circle", '\uee90'),
    HTML5("bxl-html5", '\uee91'),
    IMDB("bxl-imdb", '\uee92'),
    INSTAGRAM("bxl-instagram", '\uee93'),
    INSTAGRAM_ALT("bxl-instagram-alt", '\uee94'),
    INTERNET_EXPLORER("bxl-internet-explorer", '\uee95'),
    INVISION("bxl-invision", '\uee96'),
    JAVASCRIPT("bxl-javascript", '\uee97'),
    JOOMLA("bxl-joomla", '\uee98'),
    JQUERY("bxl-jquery", '\uee99'),
    JSFIDDLE("bxl-jsfiddle", '\uee9a'),
    KICKSTARTER("bxl-kickstarter", '\uee9b'),
    KUBERNETES("bxl-kubernetes", '\uee9c'),
    LESS("bxl-less", '\uee9d'),
    LINKEDIN("bxl-linkedin", '\uee9e'),
    LINKEDIN_SQUARE("bxl-linkedin-square", '\uee9f'),
    MAGENTO("bxl-magento", '\ueea0'),
    MAILCHIMP("bxl-mailchimp", '\ueea1'),
    MARKDOWN("bxl-markdown", '\ueea2'),
    MASTERCARD("bxl-mastercard", '\ueea3'),
    MEDIUM("bxl-medium", '\ueea4'),
    MEDIUM_OLD("bxl-medium-old", '\ueea5'),
    MEDIUM_SQUARE("bxl-medium-square", '\ueea6'),
    MESSENGER("bxl-messenger", '\ueea7'),
    MICROSOFT("bxl-microsoft", '\ueea8'),
    MICROSOFT_TEAMS("bxl-microsoft-teams", '\ueea9'),
    NODEJS("bxl-nodejs", '\ueeaa'),
    OK_RU("bxl-ok-ru", '\ueeab'),
    OPERA("bxl-opera", '\ueeac'),
    PATREON("bxl-patreon", '\ueead'),
    PAYPAL("bxl-paypal", '\ueeae'),
    PERISCOPE("bxl-periscope", '\ueeaf'),
    PINTEREST("bxl-pinterest", '\ueeb0'),
    PINTEREST_ALT("bxl-pinterest-alt", '\ueeb1'),
    PLAY_STORE("bxl-play-store", '\ueeb2'),
    POCKET("bxl-pocket", '\ueeb3'),
    PRODUCT_HUNT("bxl-product-hunt", '\ueeb4'),
    PYTHON("bxl-python", '\ueeb5'),
    QUORA("bxl-quora", '\ueeb6'),
    REACT("bxl-react", '\ueeb7'),
    REDBUBBLE("bxl-redbubble", '\ueeb8'),
    REDDIT("bxl-reddit", '\ueeb9'),
    REDUX("bxl-redux", '\ueeba'),
    SASS("bxl-sass", '\ueebb'),
    SHOPIFY("bxl-shopify", '\ueebc'),
    SKYPE("bxl-skype", '\ueebd'),
    SLACK("bxl-slack", '\ueebe'),
    SLACK_OLD("bxl-slack-old", '\ueebf'),
    SNAPCHAT("bxl-snapchat", '\ueec0'),
    SOUNDCLOUD("bxl-soundcloud", '\ueec1'),
    SPOTIFY("bxl-spotify", '\ueec2'),
    SPRING_BOOT("bxl-spring-boot", '\ueec3'),
    SQUARESPACE("bxl-squarespace", '\ueec4'),
    STACK_OVERFLOW("bxl-stack-overflow", '\ueec5'),
    STRIPE("bxl-stripe", '\ueec6'),
    TELEGRAM("bxl-telegram", '\ueec7'),
    TRELLO("bxl-trello", '\ueec8'),
    TUMBLR("bxl-tumblr", '\ueec9'),
    TUX("bxl-tux", '\ueeca'),
    TWITCH("bxl-twitch", '\ueecb'),
    TWITTER("bxl-twitter", '\ueecc'),
    UNSPLASH("bxl-unsplash", '\ueecd'),
    VIMEO("bxl-vimeo", '\ueece'),
    VISA("bxl-visa", '\ueecf'),
    VK("bxl-vk", '\ueed0'),
    VUEJS("bxl-vuejs", '\ueed1'),
    WHATSAPP("bxl-whatsapp", '\ueed2'),
    WHATSAPP_SQUARE("bxl-whatsapp-square", '\ueed3'),
    WIKIPEDIA("bxl-wikipedia", '\ueed4'),
    WINDOWS("bxl-windows", '\ueed5'),
    WIX("bxl-wix", '\ueed6'),
    WORDPRESS("bxl-wordpress", '\ueed7'),
    YAHOO("bxl-yahoo", '\ueed8'),
    YELP("bxl-yelp", '\ueed9'),
    YOUTUBE("bxl-youtube", '\ueeda'),
    ZOOM("bxl-zoom", '\ueedb');

    public static BoxiconsLogos findByDescription(String description) {
        for (BoxiconsLogos font : values()) {
            if (font.getDescription().equals(description)) {
                return font;
            }
        }
        throw new IllegalArgumentException("Icon description '" + description + "' is invalid!");
    }

    private String description;
    private int code;

    BoxiconsLogos(String description, int code) {
        this.description = description;
        this.code = code;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public int getCode() {
        return code;
    }
}