/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.spring.data.sqlite;

import java.io.Serializable;
import org.komamitsu.spring.data.sqlite.SqliteJdbcRepositoryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactoryBean;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

class SqliteJdbcRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends JdbcRepositoryFactoryBean<T, S, ID> {
    private JdbcConverter converter;
    private DataAccessStrategy dataAccessStrategy;
    private RelationalMappingContext context;
    private Dialect dialect;
    private ApplicationEventPublisher publisher;
    private NamedParameterJdbcOperations operations;

    public SqliteJdbcRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        return new SqliteJdbcRepositoryFactory(this.dataAccessStrategy, this.context, this.converter, this.dialect, this.publisher, this.operations);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        super.setApplicationEventPublisher(publisher);
        this.publisher = publisher;
    }

    @Autowired
    public void setMappingContext(RelationalMappingContext mappingContext) {
        Assert.notNull((Object)mappingContext, (String)"MappingContext must not be null");
        super.setMappingContext(mappingContext);
        this.context = mappingContext;
    }

    @Autowired
    public void setDialect(Dialect dialect) {
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        super.setDialect(dialect);
        this.dialect = dialect;
    }

    @Autowired
    public void setDataAccessStrategy(DataAccessStrategy dataAccessStrategy) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        super.setDataAccessStrategy(dataAccessStrategy);
        this.dataAccessStrategy = dataAccessStrategy;
    }

    @Autowired
    public void setJdbcOperations(NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        super.setJdbcOperations(operations);
        this.operations = operations;
    }

    @Autowired
    public void setConverter(JdbcConverter converter) {
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        super.setConverter(converter);
        this.converter = converter;
    }
}

