/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.spring.data.sqlite;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;

public class SqliteDialect
extends AbstractDialect {
    public static final SqliteDialect INSTANCE = new SqliteDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        public String getOffset(long offset) {
            throw new UnsupportedOperationException("Only OFFSET isn't supported");
        }

        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private final LockClause LOCK_CLAUSE = new LockClause(){

        public String getLock(LockOptions lockOptions) {
            throw new UnsupportedOperationException("Pessimistic lock isn't supported");
        }

        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    };

    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    public LockClause lock() {
        return this.LOCK_CLAUSE;
    }

    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.create((IdentifierProcessing.Quoting)IdentifierProcessing.Quoting.ANSI, (IdentifierProcessing.LetterCasing)IdentifierProcessing.LetterCasing.LOWER_CASE);
    }
}

