/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.msgpack.jackson.dataformat;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.databind.DeserializationContext;
import org.komamitsu.thirdparty.jackson.databind.SerializerProvider;
import org.komamitsu.thirdparty.jackson.databind.deser.std.StdDeserializer;
import org.komamitsu.thirdparty.jackson.databind.module.SimpleModule;
import org.komamitsu.thirdparty.jackson.databind.ser.std.StdSerializer;
import org.komamitsu.thirdparty.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

public class TimestampExtensionModule {
    public static final byte EXT_TYPE = -1;
    public static final SimpleModule INSTANCE = new SimpleModule("msgpack-ext-timestamp");

    private TimestampExtensionModule() {
    }

    static {
        INSTANCE.addSerializer(Instant.class, new InstantSerializer(Instant.class));
        INSTANCE.addDeserializer(Instant.class, new InstantDeserializer(Instant.class));
    }

    private static class InstantDeserializer
    extends StdDeserializer<Instant> {
        protected InstantDeserializer(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Instant deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            MessagePackExtensionType messagePackExtensionType = jsonParser.readValueAs(MessagePackExtensionType.class);
            if (messagePackExtensionType.getType() != -1) {
                throw new RuntimeException(String.format("Unexpected extension type (0x%X) for Instant object", messagePackExtensionType.getType()));
            }
            try (MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(messagePackExtensionType.getData());){
                Instant instant = messageUnpacker.unpackTimestamp(new ExtensionTypeHeader(-1, messagePackExtensionType.getData().length));
                return instant;
            }
        }
    }

    private static class InstantSerializer
    extends StdSerializer<Instant> {
        protected InstantSerializer(Class<Instant> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(Instant instant, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (Closeable closeable = MessagePack.newDefaultPacker(byteArrayOutputStream);){
                ((MessagePacker)closeable).packTimestamp(instant);
            }
            closeable = MessagePack.newDefaultUnpacker(byteArrayOutputStream.toByteArray());
            var6_6 = null;
            try {
                ExtensionTypeHeader extensionTypeHeader = ((MessageUnpacker)closeable).unpackExtensionTypeHeader();
                byte[] byArray = ((MessageUnpacker)closeable).readPayload(extensionTypeHeader.getLength());
                MessagePackExtensionType messagePackExtensionType = new MessagePackExtensionType(-1, byArray);
                jsonGenerator.writeObject(messagePackExtensionType);
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var6_6 != null) {
                        try {
                            ((MessageUnpacker)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        ((MessageUnpacker)closeable).close();
                    }
                }
            }
        }
    }
}

