/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.recordformat.recordaccessor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.komamitsu.fluency.recordformat.recordaccessor.RecordAccessor;
import org.komamitsu.thirdparty.jackson.databind.ObjectMapper;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;

public class MessagePackRecordAccessor
implements RecordAccessor {
    private static final StringValue KEY_TIME = ValueFactory.newString("time");
    private MapValueBytes mapValueBytes;

    public MessagePackRecordAccessor(ByteBuffer byteBuffer) {
        this.mapValueBytes = new MapValueBytes(byteBuffer);
    }

    @Override
    public String getAsString(String key) {
        Value value = this.mapValueBytes.map().get(ValueFactory.newString(key));
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public void setTimestamp(long timestamp) {
        int mapSize = this.mapValueBytes.map().size();
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(this.mapValueBytes.byteArray().length + 16);){
            try (MessagePacker packer = MessagePack.newDefaultPacker(output);){
                if (this.mapValueBytes.map().containsKey(KEY_TIME)) {
                    packer.packMapHeader(mapSize);
                } else {
                    packer.packMapHeader(mapSize + 1);
                    KEY_TIME.writeTo(packer);
                    packer.packLong(timestamp);
                }
                for (Map.Entry<Value, Value> entry : this.mapValueBytes.map().entrySet()) {
                    packer.packValue(entry.getKey());
                    packer.packValue(entry.getValue());
                }
            }
            this.mapValueBytes = new MapValueBytes(ByteBuffer.wrap(output.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to upsert `time` field", e);
        }
    }

    @Override
    public byte[] toMessagePack(ObjectMapper objectMapperForMessagePack) {
        return this.mapValueBytes.byteArray();
    }

    @Override
    public String toJson(ObjectMapper objectMapperForJson) {
        return ValueFactory.newMap(this.mapValueBytes.map()).toJson();
    }

    private static class MapValueBytes {
        private final byte[] byteArray;
        private final Map<Value, Value> map;

        MapValueBytes(ByteBuffer byteBuffer) {
            byte[] mapValueBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(mapValueBytes);
            try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(mapValueBytes);){
                this.map = unpacker.unpackValue().asMapValue().map();
                this.byteArray = mapValueBytes;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid MessagePack ByteBuffer", e);
            }
        }

        byte[] byteArray() {
            return this.byteArray;
        }

        Map<Value, Value> map() {
            return this.map;
        }
    }
}

