/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.databind.SerializerProvider;
import org.komamitsu.thirdparty.jackson.databind.annotation.JsonSerialize;
import org.komamitsu.thirdparty.jackson.databind.ser.std.StdSerializer;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.MessagePackGenerator;

@JsonSerialize(using=Serializer.class)
public class EventTime {
    private final long seconds;
    private final long nanoseconds;

    public EventTime(long seconds, long nanoseconds) {
        if (seconds >> 32 != 0L) {
            throw new IllegalArgumentException("`seconds` should be a 32-bit value");
        }
        if (nanoseconds >> 32 != 0L) {
            throw new IllegalArgumentException("`nanoseconds` should be a 32-bit value");
        }
        this.seconds = seconds;
        this.nanoseconds = nanoseconds;
    }

    public static EventTime fromEpoch(long epochSeconds) {
        return new EventTime(epochSeconds, 0L);
    }

    public static EventTime fromEpoch(long epochSeconds, long nanoseconds) {
        return new EventTime(epochSeconds, nanoseconds);
    }

    public static EventTime fromEpochMilli(long epochMillisecond) {
        return new EventTime(epochMillisecond / 1000L, epochMillisecond % 1000L * 1000000L);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoseconds() {
        return this.nanoseconds;
    }

    @Deprecated
    public long getNanoSeconds() {
        return this.nanoseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventTime)) {
            return false;
        }
        EventTime eventTime = (EventTime)o;
        if (this.seconds != eventTime.seconds) {
            return false;
        }
        return this.nanoseconds == eventTime.nanoseconds;
    }

    public int hashCode() {
        int result = (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + (int)(this.nanoseconds ^ this.nanoseconds >>> 32);
        return result;
    }

    public String toString() {
        return "EventTime{seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + '}';
    }

    public static class Serializer
    extends StdSerializer<EventTime> {
        public Serializer() {
            super(EventTime.class);
        }

        protected Serializer(Class<EventTime> t) {
            super(t);
        }

        @Override
        public void serialize(EventTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (!(gen instanceof MessagePackGenerator)) {
                throw new IllegalStateException("This class should be serialized by MessagePackGenerator, but `gen` is " + gen.getClass());
            }
            MessagePackGenerator messagePackGenerator = (MessagePackGenerator)gen;
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt((int)value.seconds).putInt((int)value.nanoseconds);
            messagePackGenerator.writeExtensionType(new MessagePackExtensionType(0, buffer.array()));
        }
    }
}

