/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import org.komamitsu.thirdparty.jackson.core.Base64Variant;
import org.komamitsu.thirdparty.jackson.core.JsonLocation;
import org.komamitsu.thirdparty.jackson.core.JsonParseException;
import org.komamitsu.thirdparty.jackson.core.JsonParser;
import org.komamitsu.thirdparty.jackson.core.JsonProcessingException;
import org.komamitsu.thirdparty.jackson.core.JsonStreamContext;
import org.komamitsu.thirdparty.jackson.core.JsonToken;
import org.komamitsu.thirdparty.jackson.core.ObjectCodec;
import org.komamitsu.thirdparty.jackson.core.Version;
import org.komamitsu.thirdparty.jackson.core.base.ParserMinimalBase;
import org.komamitsu.thirdparty.jackson.core.io.IOContext;
import org.komamitsu.thirdparty.jackson.core.io.JsonEOFException;
import org.komamitsu.thirdparty.jackson.core.json.DupDetector;
import org.komamitsu.thirdparty.jackson.core.json.JsonReadContext;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.InputStreamBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;
import org.msgpack.jackson.dataformat.ExtensionTypeCustomDeserializers;
import org.msgpack.jackson.dataformat.MessagePackExtensionType;
import org.msgpack.jackson.dataformat.Tuple;
import org.msgpack.value.ValueType;

public class MessagePackParser
extends ParserMinimalBase {
    private static final ThreadLocal<Tuple<Object, MessageUnpacker>> messageUnpackerHolder = new ThreadLocal();
    private final MessageUnpacker messageUnpacker;
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private ObjectCodec codec;
    private JsonReadContext parsingContext;
    private final LinkedList<StackItem> stack = new LinkedList();
    private boolean isClosed;
    private long tokenPosition;
    private long currentPosition;
    private final IOContext ioContext;
    private ExtensionTypeCustomDeserializers extTypeCustomDesers;
    private Type type;
    private int intValue;
    private long longValue;
    private double doubleValue;
    private byte[] bytesValue;
    private String stringValue;
    private BigInteger biValue;
    private MessagePackExtensionType extensionTypeValue;
    private boolean reuseResourceInParser;

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, InputStream inputStream) throws IOException {
        this(iOContext, n, objectCodec, inputStream, true);
    }

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, InputStream inputStream, boolean bl) throws IOException {
        this(iOContext, n, new InputStreamBufferInput(inputStream), objectCodec, inputStream, bl);
    }

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, byte[] byArray) throws IOException {
        this(iOContext, n, objectCodec, byArray, true);
    }

    public MessagePackParser(IOContext iOContext, int n, ObjectCodec objectCodec, byte[] byArray, boolean bl) throws IOException {
        this(iOContext, n, new ArrayBufferInput(byArray), objectCodec, byArray, bl);
    }

    private MessagePackParser(IOContext iOContext, int n, MessageBufferInput messageBufferInput, ObjectCodec objectCodec, Object object, boolean bl) throws IOException {
        super(n);
        MessageUnpacker messageUnpacker;
        this.codec = objectCodec;
        this.ioContext = iOContext;
        DupDetector dupDetector = JsonParser.Feature.STRICT_DUPLICATE_DETECTION.enabledIn(n) ? DupDetector.rootDetector(this) : null;
        this.parsingContext = JsonReadContext.createRootContext(dupDetector);
        this.reuseResourceInParser = bl;
        if (!bl) {
            this.messageUnpacker = MessagePack.newDefaultUnpacker(messageBufferInput);
            return;
        }
        this.messageUnpacker = null;
        Tuple<Object, MessageUnpacker> tuple = messageUnpackerHolder.get();
        if (tuple == null) {
            messageUnpacker = MessagePack.newDefaultUnpacker(messageBufferInput);
        } else {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE) || tuple.first() != object) {
                tuple.second().reset(messageBufferInput);
            }
            messageUnpacker = tuple.second();
        }
        messageUnpackerHolder.set(new Tuple<Object, MessageUnpacker>(object, messageUnpacker));
    }

    public void setExtensionTypeCustomDeserializers(ExtensionTypeCustomDeserializers extensionTypeCustomDeserializers) {
        this.extTypeCustomDesers = extensionTypeCustomDeserializers;
    }

    @Override
    public ObjectCodec getCodec() {
        return this.codec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this.codec = objectCodec;
    }

    @Override
    public Version version() {
        return null;
    }

    @Override
    public JsonToken nextToken() throws IOException, JsonParseException {
        MessageUnpacker messageUnpacker = this.getMessageUnpacker();
        this.tokenPosition = messageUnpacker.getTotalReadBytes();
        JsonToken jsonToken = null;
        if ((this.parsingContext.inObject() || this.parsingContext.inArray()) && this.stack.getFirst().isEmpty()) {
            this.stack.pop();
            this._currToken = this.parsingContext.inObject() ? JsonToken.END_OBJECT : JsonToken.END_ARRAY;
            this.parsingContext = this.parsingContext.getParent();
            return this._currToken;
        }
        if (!messageUnpacker.hasNext()) {
            throw new JsonEOFException((JsonParser)this, null, "Unexpected EOF");
        }
        MessageFormat messageFormat = messageUnpacker.getNextFormat();
        ValueType valueType = messageUnpacker.getNextFormat().getValueType();
        StackItem stackItem = null;
        switch (valueType) {
            case NIL: {
                messageUnpacker.unpackNil();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case BOOLEAN: {
                boolean bl = messageUnpacker.unpackBoolean();
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(Boolean.toString(bl));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
                break;
            }
            case INTEGER: {
                Number number;
                switch (messageFormat) {
                    case UINT64: {
                        BigInteger bigInteger = messageUnpacker.unpackBigInteger();
                        if (0 <= bigInteger.compareTo(LONG_MIN) && bigInteger.compareTo(LONG_MAX) <= 0) {
                            this.type = Type.LONG;
                            this.longValue = bigInteger.longValue();
                            number = this.longValue;
                            break;
                        }
                        this.type = Type.BIG_INT;
                        number = this.biValue = bigInteger;
                        break;
                    }
                    default: {
                        long l = messageUnpacker.unpackLong();
                        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
                            this.type = Type.INT;
                            this.intValue = (int)l;
                            number = this.intValue;
                            break;
                        }
                        this.type = Type.LONG;
                        this.longValue = l;
                        number = this.longValue;
                    }
                }
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(String.valueOf(number));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_INT;
                break;
            }
            case FLOAT: {
                this.type = Type.DOUBLE;
                this.doubleValue = messageUnpacker.unpackDouble();
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(String.valueOf(this.doubleValue));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_NUMBER_FLOAT;
                break;
            }
            case STRING: {
                this.type = Type.STRING;
                this.stringValue = messageUnpacker.unpackString();
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(this.stringValue);
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case BINARY: {
                this.type = Type.BYTES;
                int n = messageUnpacker.unpackBinaryHeader();
                this.bytesValue = messageUnpacker.readPayload(n);
                if (this.parsingContext.inObject() && this._currToken != JsonToken.FIELD_NAME) {
                    this.parsingContext.setCurrentName(new String(this.bytesValue, MessagePack.UTF8));
                    jsonToken = JsonToken.FIELD_NAME;
                    break;
                }
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            case ARRAY: {
                stackItem = new StackItemForArray(messageUnpacker.unpackArrayHeader());
                break;
            }
            case MAP: {
                stackItem = new StackItemForObject(messageUnpacker.unpackMapHeader());
                break;
            }
            case EXTENSION: {
                this.type = Type.EXT;
                ExtensionTypeHeader extensionTypeHeader = messageUnpacker.unpackExtensionTypeHeader();
                this.extensionTypeValue = new MessagePackExtensionType(extensionTypeHeader.getType(), messageUnpacker.readPayload(extensionTypeHeader.getLength()));
                jsonToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                break;
            }
            default: {
                throw new IllegalStateException("Shouldn't reach here");
            }
        }
        this.currentPosition = messageUnpacker.getTotalReadBytes();
        if (this.parsingContext.inObject() && jsonToken != JsonToken.FIELD_NAME || this.parsingContext.inArray()) {
            this.stack.getFirst().consume();
        }
        if (stackItem != null) {
            this.stack.push(stackItem);
            if (stackItem instanceof StackItemForArray) {
                jsonToken = JsonToken.START_ARRAY;
                this.parsingContext = this.parsingContext.createChildArrayContext(-1, -1);
            } else if (stackItem instanceof StackItemForObject) {
                jsonToken = JsonToken.START_OBJECT;
                this.parsingContext = this.parsingContext.createChildObjectContext(-1, -1);
            }
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    @Override
    protected void _handleEOF() throws JsonParseException {
    }

    @Override
    public String getText() throws IOException, JsonParseException {
        switch (this.type) {
            case STRING: {
                return this.stringValue;
            }
            case BYTES: {
                return new String(this.bytesValue, MessagePack.UTF8);
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public char[] getTextCharacters() throws IOException, JsonParseException {
        return this.getText().toCharArray();
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public int getTextLength() throws IOException, JsonParseException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException {
        switch (this.type) {
            case BYTES: {
                return this.bytesValue;
            }
            case STRING: {
                return this.stringValue.getBytes(MessagePack.UTF8);
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public Number getNumberValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public int getIntValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return (int)this.longValue;
            }
            case DOUBLE: {
                return (int)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.intValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public long getLongValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return (long)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.longValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return BigInteger.valueOf(this.intValue);
            }
            case LONG: {
                return BigInteger.valueOf(this.longValue);
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.doubleValue);
            }
            case BIG_INT: {
                return this.biValue;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public float getFloatValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return (float)this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.floatValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public double getDoubleValue() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return this.intValue;
            }
            case LONG: {
                return this.longValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case BIG_INT: {
                return this.biValue.doubleValue();
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        switch (this.type) {
            case INT: {
                return BigDecimal.valueOf(this.intValue);
            }
            case LONG: {
                return BigDecimal.valueOf(this.longValue);
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.doubleValue);
            }
            case BIG_INT: {
                return new BigDecimal(this.biValue);
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public Object getEmbeddedObject() throws IOException, JsonParseException {
        switch (this.type) {
            case BYTES: {
                return this.bytesValue;
            }
            case EXT: {
                ExtensionTypeCustomDeserializers.Deser deser;
                if (this.extTypeCustomDesers != null && (deser = this.extTypeCustomDesers.getDeser(this.extensionTypeValue.getType())) != null) {
                    return deser.deserialize(this.extensionTypeValue.getData());
                }
                return this.extensionTypeValue;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        switch (this.type) {
            case INT: {
                return JsonParser.NumberType.INT;
            }
            case LONG: {
                return JsonParser.NumberType.LONG;
            }
            case DOUBLE: {
                return JsonParser.NumberType.DOUBLE;
            }
            case BIG_INT: {
                return JsonParser.NumberType.BIG_INTEGER;
            }
        }
        throw new IllegalStateException("Invalid type=" + (Object)((Object)this.type));
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                MessageUnpacker messageUnpacker = this.getMessageUnpacker();
                messageUnpacker.close();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this.parsingContext;
    }

    @Override
    public JsonLocation getTokenLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.tokenPosition, -1L, -1, (int)this.tokenPosition);
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return new JsonLocation(this.ioContext.getSourceReference(), this.currentPosition, -1L, -1, (int)this.currentPosition);
    }

    @Override
    public void overrideCurrentName(String string) {
        try {
            if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
                JsonReadContext jsonReadContext = this.parsingContext.getParent();
                jsonReadContext.setCurrentName(string);
            } else {
                this.parsingContext.setCurrentName(string);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalStateException(jsonProcessingException);
        }
    }

    @Override
    public String getCurrentName() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            JsonReadContext jsonReadContext = this.parsingContext.getParent();
            return jsonReadContext.getCurrentName();
        }
        return this.parsingContext.getCurrentName();
    }

    private MessageUnpacker getMessageUnpacker() {
        if (!this.reuseResourceInParser) {
            return this.messageUnpacker;
        }
        Tuple<Object, MessageUnpacker> tuple = messageUnpackerHolder.get();
        if (tuple == null) {
            throw new IllegalStateException("messageUnpacker is null");
        }
        return tuple.second();
    }

    private static class StackItemForArray
    extends StackItem {
        StackItemForArray(long l) {
            super(l);
        }
    }

    private static class StackItemForObject
    extends StackItem {
        StackItemForObject(long l) {
            super(l);
        }
    }

    private static abstract class StackItem {
        private long numOfElements;

        protected StackItem(long l) {
            this.numOfElements = l;
        }

        public void consume() {
            --this.numOfElements;
        }

        public boolean isEmpty() {
            return this.numOfElements == 0L;
        }
    }

    private static enum Type {
        INT,
        LONG,
        DOUBLE,
        STRING,
        BYTES,
        BIG_INT,
        EXT;

    }
}

