/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.recordformat;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.recordformat.RecordFormatter;
import org.komamitsu.thirdparty.jackson.databind.Module;
import org.komamitsu.thirdparty.jackson.databind.ObjectMapper;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordFormatter
implements RecordFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRecordFormatter.class);
    protected final ObjectMapper objectMapperForMessagePack = new ObjectMapper(new MessagePackFactory());
    protected final RecordFormatter.Config config;

    public AbstractRecordFormatter(RecordFormatter.Config config) {
        this.config = config;
        this.registerObjectMapperModules(this.objectMapperForMessagePack);
    }

    @Override
    public abstract byte[] format(String var1, Object var2, Map<String, Object> var3);

    @Override
    public abstract byte[] formatFromMessagePack(String var1, Object var2, byte[] var3, int var4, int var5);

    @Override
    public abstract byte[] formatFromMessagePack(String var1, Object var2, ByteBuffer var3);

    @Override
    public abstract String formatName();

    protected long getEpoch(Object timestamp) {
        if (timestamp instanceof EventTime) {
            return ((EventTime)timestamp).getSeconds();
        }
        if (timestamp instanceof Number) {
            return ((Number)timestamp).longValue();
        }
        LOG.warn("Invalid timestamp. Using current time: timestamp={}", timestamp);
        return System.currentTimeMillis() / 1000L;
    }

    protected void registerObjectMapperModules(ObjectMapper objectMapper) {
        List<Module> jacksonModules = this.config.getJacksonModules();
        for (Module module : jacksonModules) {
            objectMapper.registerModule(module);
        }
    }
}

