/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Max;
import org.komamitsu.fluency.validation.annotation.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flusher
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    protected final Buffer buffer;
    protected final Ingester ingester;
    private final AtomicBoolean isTerminated = new AtomicBoolean();
    private final Config config;
    private final BlockingQueue<Boolean> eventQueue = new LinkedBlockingQueue<Boolean>();
    private final ExecutorService executorService = ExecutorServiceUtils.newSingleThreadDaemonExecutor();

    public Flusher(Config config, Buffer buffer, Ingester ingester) {
        config.validateValues();
        this.config = config;
        this.buffer = buffer;
        this.ingester = ingester;
        this.executorService.execute(this::runLoop);
    }

    private void runLoop() {
        Boolean wakeup = null;
        do {
            try {
                wakeup = this.eventQueue.poll(this.config.getFlushIntervalMillis(), TimeUnit.MILLISECONDS);
                boolean force = wakeup != null;
                this.buffer.flush(this.ingester, force);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                LOG.error("Failed to flush", e);
            }
        } while (!this.executorService.isShutdown());
        if (wakeup == null) {
            try {
                this.buffer.flush(this.ingester, true);
            }
            catch (Throwable e) {
                LOG.error("Failed to flush", e);
            }
        }
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void flush() {
        try {
            this.eventQueue.put(true);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to force flushing buffer", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void flushBufferQuietly() {
        LOG.trace("Flushing the buffer");
        try {
            this.flush();
        }
        catch (Throwable e) {
            LOG.error("Failed to call flush()", e);
        }
    }

    private void finishExecutorQuietly() {
        LOG.trace("Finishing the executor");
        ExecutorServiceUtils.finishExecutorService(this.executorService, this.config.getWaitUntilBufferFlushed());
    }

    private void closeBufferQuietly() {
        LOG.trace("Closing the buffer");
        try {
            this.buffer.close();
        }
        catch (Throwable e) {
            LOG.warn("Failed to close the buffer", e);
        }
        this.isTerminated.set(true);
    }

    private void closeIngesterQuietly() {
        LOG.trace("Closing the ingester");
        try {
            this.ingester.close();
        }
        catch (Throwable e) {
            LOG.error("Failed to close the ingester", e);
        }
    }

    @Override
    public void close() {
        this.flushBufferQuietly();
        this.finishExecutorQuietly();
        this.closeBufferQuietly();
        this.closeIngesterQuietly();
    }

    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    public Ingester getIngester() {
        return this.ingester;
    }

    public int getFlushIntervalMillis() {
        return this.config.getFlushIntervalMillis();
    }

    public int getWaitUntilBufferFlushed() {
        return this.config.getWaitUntilBufferFlushed();
    }

    public int getWaitUntilTerminated() {
        return this.config.getWaitUntilTerminated();
    }

    public String toString() {
        return "Flusher{isTerminated=" + this.isTerminated + ", buffer=" + this.buffer + ", ingester=" + this.ingester + ", config=" + this.config + '}';
    }

    public static class Config
    implements Validatable {
        @Min(value=20L)
        @Max(value=2000L)
        private int flushIntervalMillis = 600;
        @Min(value=1L)
        private int waitUntilBufferFlushed = 60;
        @Min(value=1L)
        private int waitUntilTerminated = 60;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public void setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
        }

        public int getWaitUntilBufferFlushed() {
            return this.waitUntilBufferFlushed;
        }

        public void setWaitUntilBufferFlushed(int waitUntilBufferFlushed) {
            this.waitUntilBufferFlushed = waitUntilBufferFlushed;
        }

        public int getWaitUntilTerminated() {
            return this.waitUntilTerminated;
        }

        public void setWaitUntilTerminated(int waitUntilTerminated) {
            this.waitUntilTerminated = waitUntilTerminated;
        }

        void validateValues() {
            this.validate();
        }

        public String toString() {
            return "Config{flushIntervalMillis=" + this.flushIntervalMillis + ", waitUntilBufferFlushed=" + this.waitUntilBufferFlushed + ", waitUntilTerminated=" + this.waitUntilTerminated + '}';
        }
    }
}

