/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind.jsontype.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.komamitsu.thirdparty.jackson.annotation.JsonTypeInfo;
import org.komamitsu.thirdparty.jackson.databind.DatabindContext;
import org.komamitsu.thirdparty.jackson.databind.DeserializationContext;
import org.komamitsu.thirdparty.jackson.databind.JavaType;
import org.komamitsu.thirdparty.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.komamitsu.thirdparty.jackson.databind.type.TypeFactory;
import org.komamitsu.thirdparty.jackson.databind.util.ClassUtil;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    private static final String JAVA_UTIL_PKG = "java.util.";

    public ClassNameIdResolver(JavaType baseType, TypeFactory typeFactory) {
        super(baseType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> type, String name) {
    }

    @Override
    public String idFromValue(Object value) {
        return this._idFrom(value, value.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        return this._idFrom(value, type, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        return this._typeFromId(id, context);
    }

    protected JavaType _typeFromId(String id, DatabindContext ctxt) throws IOException {
        Class<?> cls;
        TypeFactory tf = ctxt.getTypeFactory();
        if (id.indexOf(60) > 0) {
            JavaType t = tf.constructFromCanonical(id);
            if (!t.isTypeOrSubTypeOf(this._baseType.getRawClass())) {
                throw new IllegalArgumentException(String.format("Class %s not subtype of %s", t.getRawClass().getName(), this._baseType));
            }
            return t;
        }
        try {
            cls = tf.findClass(id);
        }
        catch (ClassNotFoundException e) {
            if (ctxt instanceof DeserializationContext) {
                DeserializationContext dctxt = (DeserializationContext)ctxt;
                return dctxt.handleUnknownTypeId(this._baseType, id, this, "no such class found");
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type id '" + id + "' (for id type 'Id.class'): " + e.getMessage(), e);
        }
        return tf.constructSpecializedType(this._baseType, cls);
    }

    protected String _idFrom(Object value, Class<?> cls, TypeFactory typeFactory) {
        Class<?> staticType;
        Class<?> outer;
        String str;
        if (Enum.class.isAssignableFrom(cls) && !cls.isEnum()) {
            cls = cls.getSuperclass();
        }
        if ((str = cls.getName()).startsWith(JAVA_UTIL_PKG)) {
            if (value instanceof EnumSet) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumSet)value);
                str = typeFactory.constructCollectionType(EnumSet.class, enumClass).toCanonical();
            } else if (value instanceof EnumMap) {
                Class<? extends Enum<?>> enumClass = ClassUtil.findEnumType((EnumMap)value);
                Class<Object> valueClass = Object.class;
                str = typeFactory.constructMapType(EnumMap.class, enumClass, valueClass).toCanonical();
            } else {
                String suffix = str.substring(JAVA_UTIL_PKG.length());
                if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "List")) {
                    str = ArrayList.class.getName();
                } else if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "Map")) {
                    str = HashMap.class.getName();
                } else if (ClassNameIdResolver.isJavaUtilCollectionClass(suffix, "Set")) {
                    str = HashSet.class.getName();
                }
            }
        } else if (str.indexOf(36) >= 0 && (outer = ClassUtil.getOuterClass(cls)) != null && ClassUtil.getOuterClass(staticType = this._baseType.getRawClass()) == null) {
            cls = this._baseType.getRawClass();
            str = cls.getName();
        }
        return str;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }

    private static boolean isJavaUtilCollectionClass(String clz, String type) {
        if (clz.startsWith("Collections$")) {
            return clz.indexOf(type) > 0 && !clz.contains("Unmodifiable");
        }
        if (clz.startsWith("Arrays$")) {
            return clz.indexOf(type) > 0;
        }
        return false;
    }
}

