/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jackson.dataformat;

import java.io.IOException;
import java.util.Arrays;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.core.JsonProcessingException;
import org.komamitsu.thirdparty.jackson.databind.JsonSerializer;
import org.komamitsu.thirdparty.jackson.databind.SerializerProvider;
import org.komamitsu.thirdparty.jackson.databind.annotation.JsonSerialize;
import org.msgpack.jackson.dataformat.MessagePackGenerator;

@JsonSerialize(using=Serializer.class)
public class MessagePackExtensionType {
    private final byte type;
    private final byte[] data;

    public MessagePackExtensionType(byte by, byte[] byArray) {
        this.type = by;
        this.data = byArray;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MessagePackExtensionType)) {
            return false;
        }
        MessagePackExtensionType messagePackExtensionType = (MessagePackExtensionType)object;
        if (this.type != messagePackExtensionType.type) {
            return false;
        }
        return Arrays.equals(this.data, messagePackExtensionType.data);
    }

    public int hashCode() {
        int n = this.type;
        n = 31 * n + Arrays.hashCode(this.data);
        return n;
    }

    public static class Serializer
    extends JsonSerializer<MessagePackExtensionType> {
        @Override
        public void serialize(MessagePackExtensionType messagePackExtensionType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
            if (!(jsonGenerator instanceof MessagePackGenerator)) {
                throw new IllegalStateException("'gen' is expected to be MessagePackGenerator but it's " + jsonGenerator.getClass());
            }
            MessagePackGenerator messagePackGenerator = (MessagePackGenerator)jsonGenerator;
            messagePackGenerator.writeExtensionType(messagePackExtensionType);
        }
    }
}

