/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.databind.JavaType;
import org.komamitsu.thirdparty.jackson.databind.JsonMappingException;
import org.komamitsu.thirdparty.jackson.databind.JsonNode;
import org.komamitsu.thirdparty.jackson.databind.SerializerProvider;
import org.komamitsu.thirdparty.jackson.databind.annotation.JacksonStdImpl;
import org.komamitsu.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.komamitsu.thirdparty.jackson.databind.jsontype.TypeSerializer;
import org.komamitsu.thirdparty.jackson.databind.ser.std.StdSerializer;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return str.isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, provider);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

