/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.komamitsu.fluency.validation.annotation.DecimalMax;
import org.komamitsu.fluency.validation.annotation.DecimalMin;
import org.komamitsu.fluency.validation.annotation.Max;
import org.komamitsu.fluency.validation.annotation.Min;

public interface Validatable {
    default public void validate() {
        for (Class<?> klass = this.getClass(); klass != Object.class; klass = klass.getSuperclass()) {
            block3: for (Field field : klass.getDeclaredFields()) {
                for (ValidationList.Validation validation : ValidationList.VALIDATIONS) {
                    Object value;
                    Class<? extends Annotation> annotationClass = validation.annotationClass;
                    if (!field.isAnnotationPresent(annotationClass)) continue;
                    Annotation annotation = field.getAnnotation(annotationClass);
                    try {
                        field.setAccessible(true);
                        value = field.get(this);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(String.format("Failed to get a value from field (%s)", field), e);
                    }
                    if (value == null) continue block3;
                    if (!(value instanceof Number)) {
                        throw new IllegalArgumentException(String.format("This field has (%s), but actual field is (%s)", annotation, value.getClass()));
                    }
                    if (validation.isValid.apply(annotation, (Number)value).booleanValue()) continue;
                    throw new IllegalArgumentException(String.format(validation.messageTemplate, field, value));
                }
            }
        }
    }

    public static class ValidationList {
        private static final Validation VALIDATION_MAX = new Validation(Max.class, (annotation, actual) -> {
            Max maxAnnotation = (Max)annotation;
            if (maxAnnotation.inclusive()) {
                return maxAnnotation.value() >= actual.longValue();
            }
            return maxAnnotation.value() > actual.longValue();
        }, "This field (%s) is more than (%s)");
        private static final Validation VALIDATION_MIN = new Validation(Min.class, (annotation, actual) -> {
            Min minAnnotation = (Min)annotation;
            if (minAnnotation.inclusive()) {
                return minAnnotation.value() <= actual.longValue();
            }
            return minAnnotation.value() < actual.longValue();
        }, "This field (%s) is less than (%s)");
        private static final Validation VALIDATION_DECIMAL_MAX = new Validation(DecimalMax.class, (annotation, actual) -> {
            DecimalMax maxAnnotation = (DecimalMax)annotation;
            BigDecimal limitValue = new BigDecimal(maxAnnotation.value());
            BigDecimal actualValue = new BigDecimal(actual.toString());
            if (maxAnnotation.inclusive()) {
                return limitValue.compareTo(actualValue) >= 0;
            }
            return limitValue.compareTo(actualValue) > 0;
        }, "This field (%s) is more than (%s)");
        private static final Validation VALIDATION_DECIMAL_MIN = new Validation(DecimalMin.class, (annotation, actual) -> {
            DecimalMin maxAnnotation = (DecimalMin)annotation;
            BigDecimal limitValue = new BigDecimal(maxAnnotation.value());
            BigDecimal actualValue = new BigDecimal(actual.toString());
            if (maxAnnotation.inclusive()) {
                return limitValue.compareTo(actualValue) <= 0;
            }
            return limitValue.compareTo(actualValue) < 0;
        }, "This field (%s) is less than (%s)");
        private static final List<Validation> VALIDATIONS = Arrays.asList(VALIDATION_MAX, VALIDATION_MIN, VALIDATION_DECIMAL_MAX, VALIDATION_DECIMAL_MIN);

        private static class Validation {
            Class<? extends Annotation> annotationClass;
            BiFunction<Annotation, Number, Boolean> isValid;
            String messageTemplate;

            Validation(Class<? extends Annotation> annotationClass, BiFunction<Annotation, Number, Boolean> isValid, String messageTemplate) {
                this.annotationClass = annotationClass;
                this.isValid = isValid;
                this.messageTemplate = messageTemplate;
            }
        }
    }
}

