/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.thirdparty.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.komamitsu.thirdparty.jackson.core.JsonGenerator;
import org.komamitsu.thirdparty.jackson.databind.SerializerProvider;
import org.komamitsu.thirdparty.jackson.databind.ser.std.StdScalarSerializer;
import org.komamitsu.thirdparty.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }
}

